<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class BannerController extends Controller
{
    //
    public function landingBanners(float $lat, float $lng)
    {
        if (Auth::User()->usertype != "Admin" and Auth::User()->usertype != "Sub_Admin") {
            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('dashboard');
        }

        $banners = BannerController::query()
            ->active()
            ->byLocationAndCost($lat, $lng, 50) // 50km radius; remove if not needed
            ->limit(3)
            ->get();

        return response()->json($banners);
    }
}
