<?php

namespace App\Console\Commands;

use App\Factories\OTPServiceFactory;
use Illuminate\Console\Command;

class TestOTPService extends Command
{
    /**
     * The name and signature of the console command.
     */
    protected $signature = 'otp:test {provider?}';

    /**
     * The console command description.
     */
    protected $description = 'Test OTP service configuration and connection';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $provider = $this->argument('provider') ?? OTPServiceFactory::getCurrentProvider();

        $this->info("Testing OTP Service - Provider: {$provider}");

        try {
            // Test service creation
            $service = OTPServiceFactory::create();
            $this->info('✓ Service created successfully');

            // Test connection
            $this->info('Testing connection...');
            $connectionResult = $service->testConnection();

            if ($connectionResult['success']) {
                $this->info('✓ Connection test successful');
                $this->info($connectionResult['message']);
            } else {
                $this->error('✗ Connection test failed');
                $this->error($connectionResult['message']);
                return Command::FAILURE;
            }

            // Test OTP generation
            $this->info('Testing OTP generation...');
            $otpResult = $service->sendVerificationOtp('+919344853263'); // Test phone number

            if ($otpResult['success']) {
                $this->info('✓ OTP generation test successful');
                $this->info("Generated OTP: {$otpResult['otp']}");
                $this->info("Message ID: {$otpResult['message_id']}");
            } else {
                $this->warn('⚠ OTP generation test failed (this is expected for test numbers)');
                $this->warn($otpResult['message']);
            }

            $this->info('✓ All tests completed successfully');
            return Command::SUCCESS;

        } catch (\Exception $e) {
            $this->error('✗ Test failed: ' . $e->getMessage());
            return Command::FAILURE;
        }
    }
}
