<?php

namespace App\Contracts;

interface OTPServiceInterface
{
    /**
     * Send OTP to the specified phone number
     *
     * @param string $phoneNumber
     * @param string|null $message Custom message (optional)
     * @return array ['success' => bool, 'message' => string, 'otp' => string|null, 'message_id' => string|null]
     */
    public function sendOtp(string $phoneNumber, string $message = null): array;

    /**
     * Send custom message to phone number
     *
     * @param string $phoneNumber
     * @param string $message
     * @return array ['success' => bool, 'message' => string, 'message_id' => string|null]
     */
    public function sendMessage(string $phoneNumber, string $message): array;

    /**
     * Send verification OTP with auto-generated code
     *
     * @param string $phoneNumber
     * @return array ['success' => bool, 'otp' => string, 'message_id' => string|null]
     */
    public function sendVerificationOtp(string $phoneNumber): array;

    /**
     * Test the service connection
     *
     * @return array ['success' => bool, 'message' => string]
     */
    public function testConnection(): array;
}
