<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\User;
use App\SubscriptionPlan;

class CustomPlanRequest extends Model
{
    protected $table = 'custom_plan_requests';

    protected $fillable = [
        'user_id',
        'property_posts_requested',
        'ads_posts_requested',
        'notes',
        'payment_preference',
        'status',
        'approved_property_limit',
        'approved_ads_limit',
        'approved_price',
        'approved_validity_days',
        'admin_notes',
        'approved_by',
        'approved_at',
        'generated_plan_id',
        'payment_link',
        'payment_gateway',
        'payment_id',
        'paid_at',
        'activated_at',
    ];

    protected $casts = [
        'approved_at' => 'datetime',
        'paid_at' => 'datetime',
        'activated_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function plan(): BelongsTo
    {
        return $this->belongsTo(SubscriptionPlan::class, 'generated_plan_id');
    }
}
