<?php

namespace App\Http\Controllers\Admin;

use Auth;
use App\Models\User;
use App\Models\BusinessType;
use App\Favourite;
use App\PostRatings;
use App\Reports;
use App\SubscriptionPlan;
use App\Transactions;

use Illuminate\Http\Request;
use Session;
use Intervention\Image\Facades\Image; 
use App\Exports\UsersExport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Str; 

class UsersController extends MainAdminController
{ 
    public function list()    { 
        return $this->listByType('all');
    }
    
    public function listByType($type = 'all')
    {
        if(Auth::User()->usertype!="Admin" AND Auth::User()->usertype!="Sub_Admin")
        {
           Session::flash('flash_message', trans('words.access_denied'));
            return redirect('dashboard');            
        } 

        $page_title = trans('words.users');
        $query = User::where('usertype', '=', 'User');
        
        // Filter by business type if specified
        if($type != 'all') {
            $businessType = BusinessType::where('slug', $type)->first();
            if($businessType) {
                $query->where('business_type', $businessType->id);
                $page_title .= ' - ' . $businessType->name;
            }
        }

        if(isset($_GET['s']))
        {
            $keyword = $_GET['s'];  
            $user_list = $query->where(function($q) use ($keyword) {
                $q->where("name", "LIKE", "%$keyword%")
                  ->orWhere("email", "LIKE", "%$keyword%");
            })->orderBy('id','DESC')->paginate(10);

            $user_list->appends(\Request::only('s'))->links();
        }         
        else
        {          
            $user_list = $query->orderBy('id','DESC')->paginate(10);
        }
         
        $business_types = BusinessType::where('is_active', true)->orderBy('name')->get();
        return view('admin.pages.users.list',compact('page_title', 'user_list', 'business_types', 'type'));
    } 
     
    public function add()    { 
        
        if(Auth::User()->usertype!="Admin" AND Auth::User()->usertype!="Sub_Admin")
        {
            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('dashboard');            
        }

        $page_title = trans('words.add_user');
        $plan_list = SubscriptionPlan::where('status','1')->orderby('id')->get();
        $business_types = BusinessType::where('is_active', true)->orderBy('name')->get();
           
        return view('admin.pages.users.addedit', compact('page_title', 'plan_list', 'business_types'));
    }
    
    public function addnew(Request $request)
    { 
    	 
    	$data =  \Request::except(array('_token')) ;
	    
	    $inputs = $request->all();
	    
	    if(!empty($inputs['id']))
	    {
			$rule=array(
		        'name' => 'required',
		        'email' => 'required|email|max:255|unique:users,email,'.$inputs['id'],
                'user_image' => 'mimes:jpg,jpeg,gif,png',
                'business_type' => 'nullable|exists:business_types,id'
		   		 );
			
		}
		else
		{
			$rule=array(
		        'name' => 'required',
		        'email' => 'nullable|email|max:255|unique:users,email',
		        'password' => 'nullable|min:8|max:15',
		        'phone' => 'required',
                'user_image' => 'mimes:jpg,jpeg,gif,png',
                'business_type' => 'nullable|exists:business_types,id'
		   		 );
		}
	    
	   	 $validator = \Validator::make($data,$rule);
 
        if ($validator->fails())
        {
                return redirect()->back()->withErrors($validator->messages());
        } 
	      
		if(!empty($inputs['id'])){           
            $user = User::findOrFail($inputs['id']);
        }else{
            $user = new User;
        }
		
        $icon = $request->file('user_image');        
                 
        if($icon){
           
            $tmpFilePath = public_path('/upload/');

            $hardPath =  Str::slug($inputs['name'], '-').'-'.md5(time());

            $img = Image::make($icon);

            $img->fit(250, 250)->save($tmpFilePath.$hardPath.'-b.jpg');
          
            $user->user_image = $hardPath.'-b.jpg';
        }  
		
        //Get Plan info 
        $plan_id=$inputs['subscription_plan'];
        $plan_info = SubscriptionPlan::where('id',$plan_id)->where('status','1')->first();        
        $plan_days=$plan_info->plan_days;
        
		$user->name = $inputs['name'];		 
		$user->email = $inputs['email'];
        $user->business_type = $inputs['business_type'] ?? null;
        
        if($inputs['password'])
        {
            $user->password= bcrypt($inputs['password']); 
        }        
        $user->phone = $inputs['phone'];
        
        if(empty($inputs['id']))
        {
            if($inputs['subscription_plan']!="")
            {
                $user->exp_date = strtotime(date('m/d/Y', strtotime("+$plan_days days")));

            }
            else
            {
                if($inputs['exp_date']!="")
                {
                    $user->exp_date = strtotime($inputs['exp_date']);
                }
                else
                {
                    $user->exp_date = null;
                }
            }
        }
        else
        {   
            if($inputs['exp_date']!="")
            {
                $user->exp_date = strtotime($inputs['exp_date']);
            }
            else
            {
                $user->exp_date = null;
            }
        }
         

        $user->plan_id = $plan_id;
         
        $user->status = $inputs['status'];
	    $user->save(); 
		
		if(!empty($inputs['id'])){

            Session::flash('flash_message', trans('words.successfully_updated'));
            return \Redirect::back();

        }else{

            Session::flash('flash_message', trans('words.added'));
            return \Redirect::back();

        }		     
         
    }     
    
    public function edit($id)    
    {     
    	if(Auth::User()->usertype!="Admin" AND Auth::User()->usertype!="Sub_Admin")
        {
            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('dashboard');
            
        }		
    	  $page_title=trans('words.edit_user');

          $user = User::findOrFail($id);
          $plan_list = SubscriptionPlan::where('status','1')->orderby('id')->get();
          $business_types = BusinessType::where('is_active', true)->orderBy('name')->get();
            
          return view('admin.pages.users.addedit', compact('page_title', 'user', 'plan_list', 'business_types'));
        
    }	 
    
    public function delete($id)
    {
    	
    	if(Auth::User()->usertype!="Admin" AND Auth::User()->usertype!="Sub_Admin")
        {
            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('dashboard');
            
        }
        
        $fav_obj = Favourite::where('user_id',$id)->delete();
        $rate_obj = PostRatings::where('user_id',$id)->delete();
        $rep_obj = Reports::where('user_id',$id)->delete();

        $user = User::findOrFail($id);         
		$user->delete();
		
        Session::flash('flash_message', trans('words.deleted'));

        return redirect()->back();

    }    


     
    public function user_export()    
    {
        if(Auth::User()->usertype!="Admin"){

            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('admin/dashboard');
            
        }

          return Excel::download(new UsersExport, 'users.xlsx');

    }

    public function show($id)
    {
        if(Auth::User()->usertype!="Admin" AND Auth::User()->usertype!="Sub_Admin")
        {
            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('admin/dashboard');            
        }

        $page_title = 'User Details';
        $user = User::findOrFail($id);

        // Current plan and usage
        $plan = $user->plan_id ? SubscriptionPlan::find($user->plan_id) : null;
        $property_total = \App\Property::where('user_id', $user->id)->count();
        $property_limit = $plan ? (int)$plan->plan_property_limit : 0;
        $properties_used = $property_total;
        $properties_left = $plan ? max(0, $property_limit - $properties_used) : 0;
        $ads_limit = $plan && property_exists($plan, 'plan_ads_limit') ? $plan->plan_ads_limit : null;
        $ads_used = null; // Placeholder if ads entity is added later
        $ads_left = $ads_limit !== null ? max(0, $ads_limit - (int)($ads_used ?: 0)) : null;
        $expiry_date = $user->exp_date ? date('F,  d, Y', $user->exp_date) : null;

        // Transactions
        $transactions = Transactions::where('user_id', $user->id)->orderByDesc('id')->paginate(15);

        return view('admin.pages.users.show', compact(
            'page_title', 'user', 'plan', 'property_limit', 'properties_used', 'properties_left',
            'ads_limit', 'ads_used', 'ads_left', 'expiry_date', 'transactions'
        ));
    }
    
    //Sub Admin
    public function admin_list()    { 
         
        if(Auth::User()->usertype!="Admin"){

            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('admin/dashboard');            
        } 

        $page_title=trans('words.admin_list');

        if(isset($_GET['s']))
        {
            $keyword = $_GET['s'];  
            $user_list = User::where("usertype", "!=","User")->where('id', '!=', 1)->where("name", "LIKE","%$keyword%")->where("email", "LIKE","%$keyword%")->orderBy('id','DESC')->paginate(10);

            $user_list->appends(\Request::only('s'))->links();
        }        
        else
        {
          
            $user_list = User::where('usertype', '!=', 'User')->where('id', '!=', 1)->orderBy('id','DESC')->paginate(10);
        }
         
        return view('admin.pages.users.admin_list',compact('page_title','user_list'));
    } 

    public function admin_add(){ 
        
        if(Auth::User()->usertype!="Admin"){

            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('admin/dashboard');            
        }

        $page_title=trans('words.add_admin');
           
        return view('admin.pages.users.addedit_admin',compact('page_title'));
    }
    
    public function admin_addnew(Request $request)
    { 
         
        $data =  \Request::except(array('_token')) ;
        
        $inputs = $request->all();
        
        if(!empty($inputs['id']))
        {
            $rule=array(
                'name' => 'required',
                'email' => 'nullable|email|max:255|unique:users,email,'.$inputs['id'],
                'user_image' => 'mimes:jpg,jpeg,gif,png' 
                 );
            
        }
        else
        {
            $rule=array(
                'name' => 'required',
                'email' => 'nullable|email|max:255|unique:users,email',
                'password' => 'nullable|min:8|max:15',
                'user_image' => 'mimes:jpg,jpeg,gif,png'
                 );
        }
        
        
        
         $validator = \Validator::make($data,$rule);
 
        if ($validator->fails())
        {
                return redirect()->back()->withErrors($validator->messages());
        } 
          
        if(!empty($inputs['id'])){
           
            $user = User::findOrFail($inputs['id']);

        }else{

            $user = new User;

        }
        
        $icon = $request->file('user_image');        
                 
        if($icon){
            $tmpFilePath = public_path('/upload/');

            $hardPath =  Str::slug($inputs['name'], '-').'-'.md5(time());

            $img = Image::make($icon);

            $img->fit(250, 250)->save($tmpFilePath.$hardPath.'-b.jpg');
           
            $user->user_image = $hardPath.'-b.jpg';
        }         
         
        $user->usertype = $inputs['usertype'];
        $user->name = $inputs['name'];       
        $user->email = $inputs['email'];
        
        if($inputs['password'])
        {
            $user->password= bcrypt($inputs['password']); 
        }        
        $user->phone = $inputs['phone'];
        $user->status = $inputs['status'];
        $user->save(); 
        
        if(!empty($inputs['id'])){

            Session::flash('flash_message', trans('words.successfully_updated'));
            return \Redirect::back();
            
        }else{

            Session::flash('flash_message', trans('words.added'));
            return \Redirect::back();
        }                    
         
    }

    public function admin_edit($id)    
    {     
          if(Auth::User()->usertype!="Admin"){

            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('admin/dashboard');            
        }       
          $page_title=trans('words.edit_admin');

          $user = User::findOrFail($id);
            
          return view('admin.pages.users.addedit_admin',compact('page_title','user'));        
    }

    public function admin_delete($id)
    {
        
        if(Auth::User()->usertype!="Admin"){

            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('admin/dashboard');            
        }
        
        if($id!=1)
        {
            $fav_obj = Favourite::where('user_id',$id)->delete();
            $rate_obj = PostRatings::where('user_id',$id)->delete();
            $rep_obj = Reports::where('user_id',$id)->delete();

            $user = User::findOrFail($id);         
            $user->delete();
        } 
          
        Session::flash('flash_message', trans('words.deleted'));
        return redirect()->back();

    }     

    public function createPayment(Request $request)
    {
        if(Auth::User()->usertype!="Admin" AND Auth::User()->usertype!="Sub_Admin") {
            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('admin/dashboard');
        }

        $request->validate([
            'user_id' => 'required|exists:users,id',
            'plan_id' => 'nullable|exists:subscription_plan,id',
            'payment_amount' => 'required|numeric|min:0',
            'gateway' => 'required|string',
            'payment_id' => 'required|string|unique:transaction,payment_id',
            'transaction_type' => 'required|string',
            'payment_status' => 'required|in:pending,completed,failed,refunded',
            'description' => 'nullable|string',
            'notes' => 'nullable|string'
        ]);

        $user = User::findOrFail($request->user_id);
        $plan = $request->plan_id ? SubscriptionPlan::findOrFail($request->plan_id) : null;

        // Create payment transaction
        $payment = new Transactions();
        $payment->user_id = $request->user_id;
        $payment->email = $user->email ?? '';
        $payment->plan_id = $request->plan_id;
        $payment->payment_amount = $request->payment_amount;
        $payment->gateway = $request->gateway;
        $payment->payment_id = $request->payment_id;
        $payment->transaction_type = $request->transaction_type;
        $payment->description = $request->description ?: ($plan ? "Payment for {$plan->plan_name}" : "Custom payment");
        $payment->currency = getcong('currency_code') ?: 'USD';
        $payment->original_amount = $request->payment_amount;
        $payment->payment_status = $request->payment_status;
        $payment->reference_id = 'USR_' . $request->user_id . '_' . time();
        $payment->payment_date = now();
        $payment->ip_address = $request->ip();
        $payment->notes = $request->notes;
        $payment->date = time();
        $payment->save();

        // Update user subscription if payment is completed and plan is selected
        if ($request->payment_status == 'completed' && $plan) {
            $plan_days = $plan->plan_days;
            
            // If user has existing plan, extend from current expiry, otherwise from today
            if ($user->exp_date && $user->exp_date > time()) {
                $user->exp_date = strtotime("+$plan_days days", $user->exp_date);
            } else {
                $user->exp_date = strtotime("+$plan_days days");
            }
            
            $user->plan_id = $request->plan_id;
            $user->save();
        }

        Session::flash('flash_message', 'Payment transaction created successfully');
        return redirect()->back();
    }	
}
