<?php

namespace App\Http\Controllers;

use Auth;
use App\User; 
use App\Transactions;
use App\SubscriptionPlan;
use App\CustomPlanRequest;
use App\Property;
use Carbon\Carbon;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;
use Razorpay\Api\Api;

class RazorpayController extends Controller
{
    
    public function get_order_id(Request $request)
    {
        $input = $request->all();
 
        $razor_key = getPaymentGatewayInfo(3,'razorpay_key');
        $razor_secret = getPaymentGatewayInfo(3,'razorpay_secret'); 
 
        $user_id=Auth::user()->id;  
 
         $api = new Api($razor_key, $razor_secret);

         $plan_id = Session::get('plan_id');
         $plan_info = SubscriptionPlan::where('id',$plan_id)->first();
         
         $plan_name=$plan_info->plan_name;
         $plan_amount= $plan_info->plan_price*100;            
        
         $currency_code='INR';

          
         if(Session::get('razorpay_order_id'))
         {
             
            $orderId = Session::get('razorpay_order_id'); 
         }
         else
         {
            $order  = $api->order->create(array('receipt' => 'user_rcptid_'.$user_id, 'amount' => $plan_amount, 'currency' => $currency_code)); // Creates order
            $orderId = $order['id']; 
             
            Session::put('razorpay_order_id', $orderId);
         }

        echo $orderId; 
        exit;
    }
  
    public function payment_success(Request $request)
    {
        $razor_key = getPaymentGatewayInfo(3,'razorpay_key');
        $razor_secret = getPaymentGatewayInfo(3,'razorpay_secret');   

    	$plan_id = Session::get('plan_id');

        $plan_info = SubscriptionPlan::where('id',$plan_id)->where('status','1')->first();
        $plan_name=$plan_info->plan_name;
        $plan_amount=$plan_info->plan_price;

       
        $currency_code=getcong('currency_code')?getcong('currency_code'):'USD';

        $input = $request->all();

        $razorpay_payment_id=$input['razorpay_payment_id'];
 
        $user_id=Auth::user()->id;
           
        $user = User::findOrFail($user_id);

        // If this is a custom plan payment, activate CPR with carry-over
        $cprId = Session::get('custom_plan_request_id');
        $handledByCpr = false;
        if ($cprId) {
            $cpr = CustomPlanRequest::find($cprId);
            if ($cpr && $cpr->user_id === $user->id && (int)$cpr->generated_plan_id === (int)$plan_id) {
                // Compute carry-over remaining from ALL previous activated CPR cycles
                $plan = SubscriptionPlan::find($plan_id);
                $carryOverTotal = 0;
                $priorCprs = CustomPlanRequest::where('user_id', $user->id)
                    ->where(function($q){
                        $q->whereIn('status', ['activated','ACTIVATED'])
                          ->orWhereNotNull('activated_at');
                    })
                    ->where('id', '!=', $cpr->id)
                    ->orderBy('activated_at')
                    ->orderBy('id')
                    ->get();
                foreach ($priorCprs as $index => $pc) {
                    if (empty($pc->activated_at)) { continue; }
                    $start = $pc->activated_at;
                    // Next activation window end: next CPR activation or now()
                    if (isset($priorCprs[$index+1]) && !empty($priorCprs[$index+1]->activated_at)) {
                        $end = $priorCprs[$index+1]->activated_at;
                    } else {
                        $end = now();
                    }
                    $limit = (int)($pc->approved_property_limit ?? $pc->property_posts_requested ?? 0);
                    if ($limit <= 0) { continue; }
                    $used = Property::where('user_id', $user->id)
                        ->whereNotNull('approved_at')
                        ->where('approved_at', '>=', $start)
                        ->where('approved_at', '<', $end)
                        ->count();
                    $carryOverTotal += max(0, $limit - $used);
                }
                if ($plan && $carryOverTotal > 0) {
                    $plan->plan_property_limit = (int)$plan->plan_property_limit + $carryOverTotal;
                    $plan->save();
                }

                // Assign plan to user
                $user->plan_id = $plan_id;                    
                $user->start_date = strtotime(date('m/d/Y'));
                $user->plan_amount = $plan_amount;       
                $user->save();

                // Update CPR to activated
                $cpr->status = 'activated';
                $cpr->payment_gateway = 'Razorpay';
                $cpr->payment_id = $razorpay_payment_id;
                $cpr->paid_at = now();
                $cpr->activated_at = now();
                $cpr->save();

                $handledByCpr = true;
            }
        }

        // Non-custom or fallback path: assign plan directly (no CPR context)
        if (!$handledByCpr) {
            $user->plan_id = $plan_id;                    
            $user->start_date = strtotime(date('m/d/Y'));             
            $user->plan_amount = $plan_amount;       
            $user->save();
        }

         
        $payment_trans = new Transactions;

        $payment_trans->user_id = Auth::user()->id;
        $payment_trans->email = Auth::user()->email;
        $payment_trans->plan_id = $plan_id;
        $payment_trans->gateway = 'Razorpay';
        $payment_trans->payment_amount = $plan_amount;
        $payment_trans->payment_id = $razorpay_payment_id;
  
        $payment_trans->date = strtotime(date('m/d/Y H:i:s'));                    
        $payment_trans->save();
  
        Session::flash('plan_id',Session::get('plan_id'));
        Session::flash('razorpay_order_id',Session::get('razorpay_order_id'));
        // Clear session pointers after success to avoid carrying over to the next checkout
        Session::forget('custom_plan_request_id');
        Session::forget('razorpay_order_id');
        Session::forget('plan_id');
        
         //Subscription Create Email
        $user_full_name=$user->name;

        $data_email = array(
            'name' => $user_full_name
             );    

         
            try{

                \Mail::send('emails.subscription_created', $data_email, function($message) use ($user,$user_full_name){
                $message->to($user->email, $user_full_name)
                    ->from(getcong('site_email'), getcong('site_name')) 
                    ->subject('Subscription Created');
                });                
            
            }catch (\Throwable $e) {
             
                \Log::info($e->getMessage());  
                           
            }


        Session::flash('success',trans('words.payment_success'));
        return redirect('dashboard');

    }
             
    
}
