<?php

namespace App\Http\Controllers;

use Auth;
use App\User;
use App\Type;
use App\Location;
use App\Property;
use App\PropertyGallery;
use App\Favourite; 
use App\SubscriptionPlan;
use Carbon\Carbon;

use Illuminate\Http\Request;
use Session;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Str; 

class UserPropertyController extends Controller
{ 
    public function list()
    {  

        if(Auth::User()->usertype!="User")
        { 
            return redirect('admin/property');            
        }

        $user_id = Auth::User()->id;

        $user_info = User::find($user_id);

        $property_list = $user_info->userproperty()->orderby('id','DESC')->paginate(12);
 
        $page_title=trans('words.property_text');

           
        return view('pages.user.property_list',compact('page_title','property_list'));
    }

    public function add()    
    {      
        
         
        if(Auth::User()->usertype!="User")
        { 
            return redirect('admin/property/add');            
        }

          // No-expiry flow: only require an active plan (no expiry checks)
        if(Auth::User()->usertype == "User")
        {
            $user_id = Auth::User()->id;
            $user_info = User::findOrFail($user_id);
            $user_plan_id = (int) $user_info->plan_id;

            if ($user_plan_id === 0) {
                Session::flash('error_flash_message', trans('words.select_plan'));
                return redirect('pricing');
            }
        }

        //Check Limit
        $user_id = Auth::User()->id;
        $user_plan_id = Auth::User()->plan_id;

        $plan_info = SubscriptionPlan::find($user_plan_id);
        if (!$plan_info) {
            Session::flash('error_flash_message', trans('words.select_plan'));
            return redirect('pricing');
        }

        // Start with plan's property limit, then override with active Custom Plan Request if applicable
        $plan_listing_limit = $plan_info->plan_property_limit;
        $activeCpr = \App\CustomPlanRequest::where('user_id', $user_id)
            ->where(function($q){
                $q->whereIn('status', ['activated','ACTIVATED'])
                  ->orWhereNotNull('activated_at');
            })
            ->orderByDesc('activated_at')
            ->orderByDesc('id')
            ->first();
        if ($activeCpr) {
            if (!is_null($activeCpr->approved_property_limit)) {
                $plan_listing_limit = (int) $activeCpr->approved_property_limit;
            } elseif (!is_null($activeCpr->property_posts_requested)) {
                $plan_listing_limit = (int) $activeCpr->property_posts_requested;
            }
        }

        // Activation baseline (for counting used posts): CPR activated_at > user's start_date
        $activationStart = null;
        if ($activeCpr && !empty($activeCpr->activated_at)) {
            $activationStart = $activeCpr->activated_at; // Carbon via casts
        } else {
            $userRec = User::findOrFail($user_id);
            if (!empty($userRec->start_date)) {
                $activationStart = Carbon::createFromTimestamp($userRec->start_date);
            }
        }

        // Count properties since activation start (if available), otherwise total
        // Approved in cycle
        $approved_since_activation = Property::where('user_id', $user_id)
            ->whereNotNull('approved_at')
            ->when($activationStart, function ($q) use ($activationStart) {
                $q->where('approved_at', '>=', $activationStart);
            })
            ->count();
        // Pending created in cycle (requires created_at)
        $pending_since_activation = Property::where('user_id', $user_id)
            ->whereNull('approved_at')
            ->when($activationStart, function ($q) use ($activationStart) {
                $q->whereNotNull('created_at')->where('created_at', '>=', $activationStart);
            })
            ->count();
        $used_since_activation = $approved_since_activation + $pending_since_activation;

        if($plan_listing_limit && $used_since_activation >= $plan_listing_limit)
        {
            Session::flash('error_flash_message', trans('words.limit_reached'));

            return redirect('dashboard');
        }

          $page_title=trans('words.add_property');

          $type_list = Type::orderBy('type_name')->get();

          // Load locations with their cities to enable location -> city filtering on the form
          $locations = Location::with('cities')->orderBy('name')->get();
          
          return view('pages.user.property_addedit',compact('page_title','type_list','locations'));
        
    }

    public function edit($post_id)    
    {      
          $page_title=trans('words.edit_property');

          $info = Property::findOrFail($post_id);

          $user_id = Auth::User()->id;

          if($info->user_id != $user_id)
          {
                Session::flash('error_flash_message', trans('words.access_denied'));

                return redirect('dashboard');
          }

          $gallery_images = PropertyGallery::where('post_id',$info->id)->orderBy('id')->get();

          $type_list = Type::orderBy('type_name')->get();  
          
          // Load locations with cities for edit form as well
          $locations = Location::with('cities')->orderBy('name')->get();
        
          return view('pages.user.property_addedit',compact('page_title','info','type_list','type_list','locations','gallery_images'));
        
    }

    public function addnew(Request $request)
    {  
       
       $data =  \Request::except(array('_token'));

       $inputs = $request->all();
       
       if(!empty($inputs['id'])){
         $rule=array(
                'type' => 'required',
                'location' => 'required',
                'title' => 'required'
                );
         
        }else
        {
            $rule=array(
                    'type' => 'required',
                    'title' => 'required',
                    'location' => 'required',
                    'image' => 'required'                               
                     );
        }

         
         $validator = \Validator::make($data,$rule);
 
        if ($validator->fails())
        {
                return redirect()->back()->withInput()->withErrors($validator->messages());
        } 
        
        
        if(!empty($inputs['id'])){
           
            $data_obj = Property::findOrFail($inputs['id']);

            // When user edits, require re-approval
            $data_obj->approval_status = 'pending';
            $data_obj->rejection_reason = null;
            $data_obj->approved_at = null;
            $data_obj->status = 0;

        }else{

            $data_obj = new Property;

            $data_obj->user_id = Auth::User()->id;

            // New user-created properties require admin approval
            $data_obj->approval_status = 'pending';
            $data_obj->rejection_reason = null;
            $data_obj->approved_at = null;
            $data_obj->status = 0; // invisible until approved
            // Track creation time for pending usage counting
            $data_obj->created_at = now();
            // Set default expiry for free trial: 10 days from posting
            $data_obj->property_expired_on = Carbon::now()->addDays(10)->toDateString();
        } 
        
        $title_slug = Str::slug($inputs['title'], '-',null);

        $data_obj->type_id = $inputs['type']; 
        $data_obj->title = addslashes($inputs['title']);
        $data_obj->slug = $title_slug;
        $data_obj->description = addslashes($inputs['description']);
        $data_obj->phone = $inputs['phone']; 
        $data_obj->location_id = $inputs['location'];
    $data_obj->address = $inputs['address']; 
    $data_obj->latitude = $inputs['latitude']; 
    $data_obj->longitude = $inputs['longitude']; 
        $data_obj->purpose = $inputs['purpose']; 
        $data_obj->bedrooms = $inputs['bedrooms']; 
        $data_obj->bathrooms = $inputs['bathrooms']; 
        $data_obj->area = $inputs['area']; 
        $data_obj->units = $inputs['units']; 
        $data_obj->furnishing = $inputs['furnishing']; 
        $data_obj->amenities = addslashes($inputs['amenities']);
        $data_obj->price = $inputs['price'];  
    // Optional fields
    $data_obj->city_id = isset($inputs['city']) ? $inputs['city'] : null;
    $data_obj->youtube_link = isset($inputs['youtube_link']) ? $inputs['youtube_link'] : null;

        if ($request->hasFile('image')) {
            $featured_image = $request->file('image');
            $tmpFilePath = public_path('/upload/');

            $featured_hardPath =  'featured-'.rand(0,99999).'-'.md5(time());
    
            $fp_img = Image::make($featured_image);
            $fp_img->save($tmpFilePath.$featured_hardPath.'-b.jpg');
    
            $data_obj->image = 'upload/'.$featured_hardPath.'-b.jpg';
        }

        //Floor Plan Image
        $floor_plan_image = $request->file('floor_plan_image');

        if($floor_plan_image){
            
            $fp_tmpFilePath = public_path('/floorplan/');

            $fp_hardPath =  'floor-plan-'.rand(0,99999).'-'.md5(time());
    
            $fp_img = Image::make($floor_plan_image);
            $fp_img->save($fp_tmpFilePath.$fp_hardPath.'-b.jpg');
    
            $data_obj->floor_plan_image = 'floorplan/'.$fp_hardPath.'-b.jpg';
        }

        //Brochure Upload
        $brochure = $request->file('brochure');

        if($brochure){

            $brochure_tmpFilePath = public_path('/brochures/');

            $brochure_hardPath =  'brochure-'.rand(0,99999).'-'.md5(time());

            $brochure->move($brochure_tmpFilePath, $brochure_hardPath.'.pdf');

            $data_obj->brochure = 'brochures/'.$brochure_hardPath.'.pdf';
        }
        
        $data_obj->save();
        
        
            //News Gallery Image           

            if(!empty($inputs['id']))
            {
               $property_id= $inputs['id'];
            }
            else
            {
                $property_id= $data_obj->id; 
            }

            if ($request->hasFile('image_gallery')) {
                foreach ($request->file('image_gallery') as $image) {
                    
                    $tmpFilePath1 = public_path('/gallery/');
                    $fileOriginalName = $image->getClientOriginalExtension();

                    $gallery_hardPath =  'gallery-'.rand(0,999999).'.'.$fileOriginalName;
            
                    $gall_img = Image::make($image);
                    $gall_img->save($tmpFilePath1.$gallery_hardPath);

                    $gallery_obj = new PropertyGallery;

                    $gallery_obj->post_id = $property_id; 
                    $gallery_obj->image = 'gallery/'.$gallery_hardPath;       
    
                    $gallery_obj->save();
                     
                }
            }
           
         
 
        if(!empty($inputs['id'])){

            Session::flash('flash_message', trans('words.successfully_updated'));

            return \Redirect::back();
        }else{

            Session::flash('flash_message', trans('words.added'));

            return \Redirect::back();

        }   
    }
    
    public function favourites_list()
    {  
        $user_id = Auth::User()->id;

        $favourites_list = Favourite::join('property', 'favourite.post_id', '=', 'property.id')
            ->where('favourite.user_id', $user_id)
            ->where('property.status', 1)
            ->where('property.approval_status', 'approved')
            ->select('favourite.*')
            ->orderBy('favourite.id', 'DESC')
            ->paginate(12);

        $page_title=trans('words.property_text');

           
        return view('pages.user.favourites_list',compact('page_title','favourites_list'));
    }
}