<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class MeetingDeclined extends Mailable
{
    use Queueable, SerializesModels;

    public $meeting;
    public $property;
    public $user;
    public $agent;
    public $reason;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($meeting, $property, $user, $agent, $reason)
    {
        $this->meeting = $meeting;
        $this->property = $property;
        $this->user = $user;
        $this->agent = $agent;
        $this->reason = $reason;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject($this->property->title . ' - Meeting Declined')
                    ->view('emails.meeting_declined');
    }
}
