<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class BusinessType extends Model
{
    protected $table = 'business_types';
    
    protected $fillable = [
        'name',
        'slug',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];
    
    protected static function boot()
    {
        parent::boot();
        
        static::creating(function ($businessType) {
            $businessType->slug = \Illuminate\Support\Str::slug($businessType->name);
        });
        
        static::updating(function ($businessType) {
            if ($businessType->isDirty('name')) {
                $businessType->slug = \Illuminate\Support\Str::slug($businessType->name);
            }
        });
    }

    /**
     * Get the users for the business type.
     */
    public function users(): HasMany
    {
        return $this->hasMany(User::class, 'business_type');
    }
}
