<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lead extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'phone',
        'email',
        'action',
        'property_id',
        'user_id',
        'ip',
        'meta',
    ];

    protected $casts = [
        'meta' => 'array',
    ];

    public function property()
    {
        return $this->belongsTo(\App\Property::class, 'property_id');
    }
}
