<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Relations\BelongsTo; 

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    // protected $fillable = [
    //     'name',
    //     'email',
    //     'password',
    // ];
    
    protected $fillable = ['business_type', 'name', 'phone', 'mobile', 'email', 'password', 'user_image', 'remember_token', 'phone_verified_at', 'usertype', 'status'];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'phone_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
    
    //sj_code
    public function banners()
    {
        return $this->hasMany(Banner::class, 'user_id');
    }
    
        /**
     * Get the primary phone number (phone field takes precedence over mobile)
     */
    public function getPrimaryPhoneAttribute()
    {
        return $this->phone ?: $this->mobile;
    }

    /**
     * Get all phone numbers as an array
     */
    public function getAllPhoneNumbersAttribute()
    {
        $phones = [];
        if ($this->phone) {
            $phones[] = $this->phone;
        }
        if ($this->mobile && $this->mobile !== $this->phone) {
            $phones[] = $this->mobile;
        }
        return $phones;
    }

    /**
     * Get the business type for the user.
     */
    public function businessType(): BelongsTo
    {
        return $this->belongsTo(BusinessType::class, 'business_type');
    }
}
