<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WebAdvertisement extends Model
{
    protected $table = 'web_advertisements';

    protected $fillable = [
        'page',
        'position',
        'name',
        'user_id',
        'image_path',
        'redirect_url',
        'description',
        'cost',
        'status',
        'starts_at',
        'ends_at',
        'location_id',
        'lat',
        'lng',
    ];

    protected $casts = [
        'lat' => 'float',
        'lng' => 'float',
        'starts_at' => 'datetime',
        'ends_at' => 'datetime',
    ];
}


