<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SubscriptionPlan extends Model
{
    protected $table = 'subscription_plan';

    protected $fillable = ['plan_name','plan_days','plan_duration','plan_price'];


	public $timestamps = false; 
	 
	
	public static function getSubscriptionPlanInfo($id,$field_name) 
    { 
 
		$plan_info = SubscriptionPlan::where('id',$id)->first();
		
		if($plan_info)
		{
			return  $plan_info->$field_name;
		}
		else
		{
			return  '';
		}
	}


	public static function getPlanDuration($id) 
    { 
        // No-expiry flow: regardless of stored duration, we present 'No Expiry'
        // to the user interface and API responses.
        $plan_obj = SubscriptionPlan::find($id);
        if (!$plan_obj) {
            return 'No Expiry';
        }
        return 'No Expiry';
    }

	
}
