<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // First create the table without foreign keys
        Schema::create('custom_plan_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('user_id');
            $table->integer('property_posts_requested');
            $table->integer('ads_posts_requested')->nullable();
            $table->text('notes')->nullable();
            $table->enum('payment_preference', ['online','cash'])->default('online');
            $table->enum('status', ['pending','approved','rejected','awaiting_payment','paid','activated'])->default('pending');
            // Admin decision fields
            $table->integer('approved_property_limit')->nullable();
            $table->integer('approved_ads_limit')->nullable();
            $table->decimal('approved_price', 10, 2)->nullable();
            $table->integer('approved_validity_days')->nullable();
            $table->text('admin_notes')->nullable();
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->timestamp('approved_at')->nullable();
            // Link to generated custom subscription plan
            $table->unsignedBigInteger('generated_plan_id')->nullable();
            // Payment tracking
            $table->string('payment_link')->nullable();
            $table->string('payment_gateway')->nullable();
            $table->string('payment_id')->nullable();
            $table->timestamp('paid_at')->nullable();
            $table->timestamp('activated_at')->nullable();
            $table->timestamps();
        });

        // Then add the foreign key constraint in a separate statement
        Schema::table('custom_plan_requests', function (Blueprint $table) {
            $table->foreign('user_id')
                  ->references('id')
                  ->on('users')
                  ->onDelete('cascade');
        });

        Schema::table('subscription_plan', function (Blueprint $table) {
            if (!Schema::hasColumn('subscription_plan', 'is_custom')) {
                $table->boolean('is_custom')->default(false)->after('status');
            }
            if (!Schema::hasColumn('subscription_plan', 'plan_ads_limit')) {
                $table->integer('plan_ads_limit')->nullable()->after('plan_property_limit');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // First drop the foreign key constraint
        Schema::table('custom_plan_requests', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
        });
        
        // Then drop the table
        Schema::dropIfExists('custom_plan_requests');

        // Handle subscription_plan table modifications
        Schema::table('subscription_plan', function (Blueprint $table) {
            if (Schema::hasColumn('subscription_plan', 'is_custom')) {
                $table->dropColumn('is_custom');
            }
            if (Schema::hasColumn('subscription_plan', 'plan_ads_limit')) {
                $table->dropColumn('plan_ads_limit');
            }
        });
    }
};
