<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('web_advertisements', function (Blueprint $table) {
            // Ensure coordinate columns are numeric
            $table->decimal('lat', 10, 7)->nullable()->change();
            $table->decimal('lng', 10, 7)->nullable()->change();

            // Make location_id numeric (optional, if you plan FK in future)
            // If your column already stores numeric ids as string, you may want to cast/clean before changing type.
            // Comment the next line if you want to keep it as varchar.
            // $table->unsignedBigInteger('location_id')->nullable()->change();
        });
    }

    public function down(): void
    {
        Schema::table('web_advertisements', function (Blueprint $table) {
            // Revert to previous types if needed
            $table->decimal('lat', 10, 7)->nullable()->change();
            $table->date('lng')->nullable()->change();
            // $table->string('location_id')->nullable()->change();
        });
    }
};


