<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasColumn('property', 'created_at')) {
            Schema::table('property', function (Blueprint $table) {
                $table->timestamp('created_at')->nullable()->after('approved_at');
            });
        }
        if (!Schema::hasColumn('property', 'updated_at')) {
            Schema::table('property', function (Blueprint $table) {
                $table->timestamp('updated_at')->nullable()->after('created_at');
            });
        }

        // Backfill existing rows: prefer approved_at, else current timestamp
        try {
            DB::statement("UPDATE `property` SET `created_at` = COALESCE(`approved_at`, NOW()) WHERE `created_at` IS NULL");
            DB::statement("UPDATE `property` SET `updated_at` = COALESCE(`approved_at`, NOW()) WHERE `updated_at` IS NULL");
        } catch (\Throwable $e) {
            // log error silently; migration should not fail if DB privileges restrict UPDATE
            logger()->warning('Backfill timestamps on property failed: '.$e->getMessage());
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('property', 'updated_at')) {
            Schema::table('property', function (Blueprint $table) {
                $table->dropColumn('updated_at');
            });
        }
        if (Schema::hasColumn('property', 'created_at')) {
            Schema::table('property', function (Blueprint $table) {
                $table->dropColumn('created_at');
            });
        }
    }
};
