<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('property', function (Blueprint $table) {
            $table->unsignedBigInteger('city_id')->nullable()->after('location_id');
            $table->index('city_id');
        });
    }

    public function down(): void
    {
        Schema::table('property', function (Blueprint $table) {
            if (Schema::hasColumn('property', 'city_id')) {
                $table->dropIndex(['city_id']);
                $table->dropColumn('city_id');
            }
        });
    }
};


