<style>
    /* Force Post Property button text to always be white, even on scroll or sticky/scrolled header */
    .header .menu-highlight.playbtn,
    .header .menu-highlight.playbtn *,
    .header.enhanced-header .menu-highlight.playbtn,
    .header.enhanced-header .menu-highlight.playbtn *,
    .header.scrolled .menu-highlight.playbtn,
    .header.scrolled .menu-highlight.playbtn *,
    .header.sticky .menu-highlight.playbtn,
    .header.sticky .menu-highlight.playbtn * {
        color: #fff !important;
    }
</style>
<style>
    /* Force Post Property button text to always be white, even on scroll */
    .enhanced-header .menu-highlight.playbtn,
    .enhanced-header .menu-highlight.playbtn *,
    .enhanced-header .menu-highlight.playbtn:visited,
    .enhanced-header .menu-highlight.playbtn:active,
    .enhanced-header .menu-highlight.playbtn:focus {
        color: #fff !important;
    }
    .enhanced-header .menu-highlight.playbtn span {
        color: #fff !important;
    }
</style>
<!-- ===== Real Estate Preloader (Amaze Edition) ===== -->
<div id="preloader" class="re-preloader amaze" aria-hidden="true">
    <!-- animated backdrop layers -->
    <div class="fx grid"></div>
    <div class="fx aurora"></div>

    <div class="re-wrap" role="status" aria-live="polite">
        <!-- Pin + radar (SVG) -->
        <svg class="pin-svg" viewBox="0 0 140 140" width="120" height="120" aria-label="Loading properties">
            <!-- radar rings -->
            <g class="radar">
                <circle cx="70" cy="70" r="26" class="ring r1" />
                <circle cx="70" cy="70" r="26" class="ring r2" />
                <circle cx="70" cy="70" r="26" class="ring r3" />
            </g>

            <!-- shadow -->
            <ellipse cx="70" cy="104" rx="18" ry="6" class="shadow" />

            <!-- pin -->
            <g class="pin">
                <path class="pin-body"
                    d="M70 28c-15 0-28 12.1-28 26.8 0 19.9 21.1 32.9 25.8 52.3.5 2.2 3.9 2.2 4.4 0C77 87.7 98 74.7 98 55.2 98 40.1 85 28 70 28z" />
                <circle class="pin-core" cx="70" cy="54" r="8" />
            </g>

            <!-- success badge (appears on done) — locked to pin core at (70,54) -->
            <g transform="translate(70,54)">
                <g class="success">
                    <circle class="badge" r="22" />
                    <polyline class="tick" points="-8,0 -2,6 9,-7" />
                    <g class="burst">
                        <line x1="0" y1="-34" x2="0" y2="-44" />
                        <line x1="24" y1="-24" x2="32" y2="-32" />
                        <line x1="34" y1="0" x2="44" y2="0" />
                        <line x1="24" y1="24" x2="32" y2="32" />
                        <line x1="0" y1="34" x2="0" y2="44" />
                        <line x1="-24" y1="24" x2="-32" y2="32" />
                        <line x1="-34" y1="0" x2="-44" y2="0" />
                        <line x1="-24" y1="-24" x2="-32" y2="-32" />
                    </g>
                </g>
            </g>

        </svg>

        <p class="tagline">
            Finding your dream home<span class="dots" aria-hidden="true"></span>
        </p>
        <p class="sub">Explore Top Properties Near You</p>
    </div>
</div>

<style>
    :root {
        --brand: #D8232A;
        /* <<< your accent */
        --backdrop: rgba(255, 255, 255, .80);
        /* overlay */
        --ink: #141414;
        --muted: #8e95a3;
        --card1: #f3f5f7;
        --card2: #ffffff;
    }

    .re-preloader.amaze {
        position: fixed;
        inset: 0;
        z-index: 9999;
        display: grid;
        place-items: center;
        background: var(--backdrop);
        backdrop-filter: saturate(115%) blur(3px);
        transition: opacity .42s ease, visibility .42s ease;
    }

    .re-preloader.amaze.hidden {
        opacity: 0;
        visibility: hidden;
        pointer-events: none;
    }

    html.re-lock,
    body.re-lock {
        overflow: hidden
    }

    .re-wrap {
        position: relative;
        width: min(560px, 92vw);
        display: grid;
        gap: 14px;
        place-items: center;
    }

    /* Background FX layers */
    .fx {
        position: absolute;
        inset: 0;
        pointer-events: none;
    }

    .fx.grid {
        --line: rgba(0, 0, 0, .06);
        --line2: rgba(0, 0, 0, .03);
        background:
            repeating-linear-gradient(90deg, var(--line) 0 1px, transparent 1px 28px),
            repeating-linear-gradient(0deg, var(--line2) 0 1px, transparent 1px 28px);
        mask: radial-gradient(ellipse at center, #000 0%, #0008 40%, transparent 85%);
        animation: pan 8s linear infinite;
    }

    .fx.aurora {
        background:
            radial-gradient(40% 30% at 20% 20%, rgba(216, 35, 42, .20), transparent 60%),
            radial-gradient(35% 25% at 80% 30%, rgba(216, 35, 42, .12), transparent 65%),
            radial-gradient(30% 25% at 50% 80%, rgba(216, 35, 42, .10), transparent 70%);
        filter: blur(20px) saturate(120%);
        animation: drift 14s ease-in-out infinite;
    }

    /* SVG */
    .pin-svg {
        overflow: visible;
        display: block
    }

    .pin-body {
        fill: var(--brand);
        filter: drop-shadow(0 8px 20px rgba(216, 35, 42, .28))
    }

    .pin-core {
        fill: #fff;
        stroke: #fff;
        stroke-width: 1
    }

    .shadow {
        fill: rgba(0, 0, 0, .12);
        filter: blur(.6px)
    }

    /* radar */
    .radar .ring {
        fill: none;
        stroke: var(--brand);
        stroke-width: 2;
        opacity: 0;
        transform-origin: 70px 70px
    }

    .r1 {
        animation: radar 1.6s linear infinite .0s
    }

    .r2 {
        animation: radar 1.6s linear infinite .33s
    }

    .r3 {
        animation: radar 1.6s linear infinite .66s
    }

    /* motion */
    .pin {
        animation: float 2.2s ease-in-out infinite;
        transform-origin: 70px 70px
    }

    .shadow {
        animation: shadow 2.2s ease-in-out infinite
    }

    /* text */
    .tagline {
        margin: 4px 0 0;
        font: 700 15px/1.45 system-ui, -apple-system, Segoe UI, Roboto, "Helvetica Neue", Arial;
        color: var(--ink)
    }

    .tagline .dots {
        display: inline-block;
        width: 1.5ch;
        text-align: left;
        margin-left: .2ch;
        animation: dots 1.1s steps(4, end) infinite
    }

    .sub {
        margin: 0;
        font: 500 12px/1.4 system-ui, -apple-system, Segoe UI, Roboto;
        color: var(--muted)
    }

    /* SUCCESS STATE (morph to checkmark) */
    .success {
        opacity: 0;
        transform: scale(.7);
        transform-origin: center;
        transform-box: fill-box;
        /* ensures 'center' means the shape center */
    }

    .badge {
        fill: #fff;
        stroke: var(--brand);
        stroke-width: 2;
        filter: drop-shadow(0 6px 14px rgba(216, 35, 42, .22))
    }

    .tick {
        fill: none;
        stroke: var(--brand);
        stroke-width: 3.5;
        stroke-linecap: round;
        stroke-linejoin: round;
        stroke-dasharray: 0 60;
    }

    /* burst rays hidden initially */
    .burst line {
        stroke: var(--brand);
        stroke-width: 2;
        stroke-linecap: round;
        opacity: 0;
    }

    /* When done */
    .re-preloader.amaze.done .radar .ring,
    .re-preloader.amaze.done .pin,
    .re-preloader.amaze.done .shadow {
        animation: none;
        opacity: 0;
    }

    .re-preloader.amaze.done .pin-svg .pin-body,
    .re-preloader.amaze.done .pin-svg .pin-core {
        transition: transform .35s ease, opacity .35s ease;
        transform: scale(.9);
        opacity: 0;
    }

    .re-preloader.amaze.done .success {
        animation: pop .38s ease forwards .12s;
    }

    .re-preloader.amaze.done .tick {
        animation: dash .5s ease .22s forwards;
    }

    .re-preloader.amaze.done .burst line {
        animation: burst .45s ease .34s forwards;
    }

    /* Animations */
    @keyframes radar {
        0% {
            transform: scale(.6);
            opacity: .45
        }

        100% {
            transform: scale(1.25);
            opacity: 0
        }
    }

    @keyframes float {

        0%,
        100% {
            transform: translateY(0)
        }

        50% {
            transform: translateY(-8px)
        }
    }

    @keyframes shadow {

        0%,
        100% {
            transform: scale(1);
            opacity: .35
        }

        50% {
            transform: scale(.9);
            opacity: .18
        }
    }

    @keyframes dots {
        0% {
            content: ""
        }

        25% {
            content: "."
        }

        50% {
            content: ".."
        }

        75% {
            content: "..."
        }
    }

    @keyframes pan {
        0% {
            background-position: 0 0, 0 0
        }

        100% {
            background-position: 200px 140px, 0 0
        }
    }

    @keyframes drift {
        0% {
            transform: translateY(0) rotate(0deg)
        }

        50% {
            transform: translateY(-6px) rotate(6deg)
        }

        100% {
            transform: translateY(0) rotate(0deg)
        }
    }

    @keyframes pop {
        0% {
            opacity: 0;
            transform: scale(.7)
        }

        100% {
            opacity: 1;
            transform: scale(1)
        }
    }

    @keyframes dash {
        0% {
            stroke-dasharray: 0 60
        }

        100% {
            stroke-dasharray: 60 0
        }
    }

    @keyframes burst {
        0% {
            opacity: 0;
            transform: scale(.8)
        }

        100% {
            opacity: 1;
            transform: scale(1.1)
        }
    }

    /* Reduced motion */
    @media (prefers-reduced-motion: reduce) {

        .fx.grid,
        .fx.aurora,
        .radar .ring,
        .pin,
        .shadow,
        .tagline .dots {
            animation: none !important
        }
    }

    /* Dark mode */
    @media (prefers-color-scheme: dark) {
        :root {
            --backdrop: rgba(20, 20, 20, .78);
            --ink: #e8ebf1;
            --muted: #a9b1bd;
            --card1: #2a2a2a;
            --card2: #353535
        }

        .fx.grid {
            --line: rgba(255, 255, 255, .08);
            --line2: rgba(255, 255, 255, .04);
        }

        .badge {
            fill: #1c1c1c
        }
    }
</style>

<script>
    /* Lock scroll immediately */
    document.documentElement.classList.add('re-lock');
    document.body.classList.add('re-lock');

    /* On window load: show success, then fade and remove */
    window.addEventListener('load', function() {
        const pre = document.getElementById('preloader');
        if (!pre) return;

        // Switch to "found" animation (pin -> check)
        pre.classList.add('done');

        // allow the success animation to play, then hide
        setTimeout(() => {
            pre.classList.add('hidden');
            document.documentElement.classList.remove('re-lock');
            document.body.classList.remove('re-lock');
            setTimeout(() => pre.remove(), 480);
        }, 800);
    });

    /* Failsafe: hide even if 'load' never fires (slow 3rd-party) */
    setTimeout(() => {
        const pre = document.getElementById('preloader');
        if (pre && !pre.classList.contains('hidden')) {
            pre.classList.add('done');
            setTimeout(() => {
                pre.classList.add('hidden');
                document.documentElement.classList.remove('re-lock');
                document.body.classList.remove('re-lock');
                setTimeout(() => pre.remove(), 480);
            }, 800);
        }
    }, 7000);
</script>
<!-- ===== /Real Estate Preloader (Amaze Edition) ===== -->


<!--header starts-->
<header class="header enhanced-header" style="background:#fff !important;">
<style>
    /* Enhanced header UI */
    .enhanced-header {
        background: #fff !important;
        box-shadow: 0 4px 18px rgba(40,40,40,0.07);
        border-radius: 0 0 18px 18px;
        /* padding: 18px 0 18px 0; */
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        z-index: 1050;
        transition: box-shadow 0.2s;
    }
    .enhanced-header .vfx-site-navbar-area {
        background: transparent !important;
        box-shadow: none;
        border-radius: 0;
        padding: 0 18px;
    }
    .enhanced-header .site-navbar {
        align-items: center;
        min-height: 64px;
    }
    .enhanced-header .navbar-brand img {
        max-height: 78px;
        width: auto;
        margin-right: 12px;
        transition: max-height 0.2s;
    }
    .enhanced-header .site-menu > li > a {
        padding: 10px 22px;
        font-size: 1.08rem;
        font-weight: 600;
        color: #222;
        border-radius: 8px;
        transition: background 0.18s, color 0.18s;
    }
    .enhanced-header .site-menu > li > a.active,
    .enhanced-header .site-menu > li > a:hover {
        background: #f7f7f7;
        color: #D8232A;
    }
    .enhanced-header .menu-highlight.playbtn {
        background: #d8232a !important;
        color: #fff !important;
        font-weight: 700;
        border-radius: 32px 32px 32px 32px / 22px 22px 22px 22px;
        padding: 10px 32px 10px 22px;
        margin-left: 10px;
        box-shadow: 0 2px 8px rgba(216,35,42,0.13);
        font-size: 1.08rem;
        border: none;
        position: relative;
        animation: blink-btn 1.2s infinite alternate;
        transition: background 0.18s, color 0.18s;
        letter-spacing: 0.5px;
        outline: none;
        display: inline-flex;
        align-items: center;
        gap: 7px;
    }
    .enhanced-header .menu-highlight.playbtn,
    .enhanced-header .menu-highlight.playbtn * {
        color: #fff !important;
    }
    .enhanced-header .menu-highlight.playbtn span {
        /* background: #424741 !important; */
        color: #fff !important;
        border-radius: 3px;
        margin-left: 7px;
        padding: 0 8px;
        font-size: 13px;
        font-weight: 700;
        letter-spacing: 1px;
        box-shadow: 0 1px 4px rgba(216,35,42,0.10);
        border: 1.5px solid #fff2;
        display: inline-block;
        height: auto;
        min-width: 0;
        width: auto;
        line-height: 1.2;
        vertical-align: middle;
    }
    @keyframes blink-btn {
        0% { box-shadow: 0 0 0 0 #d8232a44; }
        100% { box-shadow: 0 0 0 10px #d8232a11; }
    }
    @media (max-width: 991px) {
        .enhanced-header {
            padding: 10px 0 10px 0;
            border-radius: 0 0 12px 12px;
        }
        .enhanced-header .vfx-site-navbar-area {
            padding: 0 8px;
        }
    }
    @media (max-width: 575px) {
        .enhanced-header {
            padding: 6px 0 6px 0;
            border-radius: 0 0 8px 8px;
        }
        .enhanced-header .navbar-brand img {
            max-height: 54px;
        }
        .enhanced-header .menu-highlight.playbtn {
            padding: 8px 18px 8px 12px;
            font-size: 0.98rem;
        }
        .enhanced-header .menu-highlight.playbtn span {
            font-size: 12px;
            padding: 0 7px;
            border-radius: 3px;
        }
    }
</style>
    <!--Main Menu starts-->
    <div class="vfx-site-navbar-area vfx2" style="background:#fff !important;">
<style>
    /* Always white header background, no transparency */
    .header,
    .vfx-site-navbar-area {
        background: #fff !important;
        box-shadow: 0 2px 8px rgba(0,0,0,0.03);
    }
    .header.transparent,
    .header.scroll-hide {
        background: #fff !important;
    }
</style>
        <div class="container">
            <div class="site-navbar">
                <div class="row align-items-center">
                    <div class="col-lg-2 col-md-5 col-6">

                        @if (getcong('site_logo'))
                            <a href="{{ URL::to('/') }}" title="logo" class="navbar-brand"><img
                                    src="{{ URL::asset('/' . getcong('site_logo')) }}" alt="logo" title="logo"
                                    class="img-fluid"></a>
                        @else
                            <a href="{{ URL::to('/') }}" title="logo" class="navbar-brand"><img
                                    src="{{ URL::asset('site_assets/images/site_logo.png') }}" alt="logo"
                                    title="logo" class="img-fluid"></a>
                        @endif

                    </div>
                    <div class="col-lg-7 col-md-1 col-1 order-2 order-lg-1 pl-xs-0 nav-menu-mobile">
                        <nav class="site-navigation text-left">
                            <div class="container">
                                <ul class="site-menu vfx-clone-navigation d-none d-lg-block">
                                    <li><a class="{{ classActivePathSite('') }}" href="{{ URL::to('/') }}"
                                            title="{{ trans('words.home') }}">{{ trans('words.home') }}</a></li>

                                    {{-- <li><a class="{{ classActivePathSite('types') }}" href="{{ URL::to('/types') }}"
                                             title="{{ trans('words.type_text') }}">{{ trans('words.type_text') }}</a>
                                     </li> --}}

                                    <li><a class="{{ classActivePathSite('properties') }}"
                                            href="{{ URL::to('/properties') }}"
                                            title="{{ trans('words.property_text') }}">{{ trans('words.property_text') }}</a>
                                    </li>

                                    <li><a class="{{ classActivePathSite('pricing') }}"
                                            href="{{ URL::to('/pricing') }}"
                                            title="{{ trans('words.pricing') }}">{{ trans('words.pricing') }}</a>
                                    </li>
                                    <li>
                                        @if(Auth::check())
                                            <a class="menu-highlight playbtn" href="{{ url('user/property/add') }}"
                                                title="{{ trans('words.add_properties') }}"
                                                style="background:#fae1e1;color:#fff !important;font-weight:700;border-radius:30px;padding:4px 9px;">
                                                Post Property <span class="bg-success text-white"
                                                    style="font-size: 10px;padding:0px 3px; letter-spacing:1px;">FREE</span>
                                            </a>
                                        @else
                                            {{-- Redirect guests to login and preserve intended destination --}} 
                                            <a class="menu-highlight playbtn" href="{{ url('login') }}?redirect={{ urlencode(url('user/property/add')) }}"
                                                title="{{ trans('words.login_text') }}"
                                                style="background:#fae1e1;color:#fff !important;font-weight:700;border-radius:30px;padding:4px 9px;">
                                                Post Property <span class="bg-success text-white"
                                                    style="font-size: 10px;padding:0px 3px; letter-spacing:1px;">FREE</span>
                                            </a>
                                        @endif
                                    </li>

                                   
                                    {{-- <li>
                                         <a class="{{ classActivePathSite('pricing') }} menu-highlight"
                                             href="{{ URL::to('/pricing') }}" title="{{ trans('words.pricing') }}"
                                             style="background:#93d0ec;color:#3d3b3b;border-radius:6px;padding:4px 9px;">
                                             Post Property
                                         </a>
                                     </li> --}}

                                    {{-- @foreach (\App\Pages::where('status', '1')->where('page_position', 'Top')->orderBy('page_order')->get() as $page_data)
                                         <li><a class="{{ request()->is('page/' . $page_data->page_slug) ? 'active' : '' }}"
                                                 href="{{ URL::to('page/' . $page_data->page_slug) }}"
                                                 title="{{ $page_data->page_title }}">{{ $page_data->page_title }}</a>
                                         </li>
                                     @endforeach --}}
                                </ul>
                            </div>
                        </nav>
                        <div class="vfx-lg-none sm-right"> <a href="#" class="mobile-bar js-menu-toggle"
                                title="menu"> <span class="lnr lnr-menu"></span> </a> </div>
                        <!--mobile-menu starts -->
                        <div class="vfx-mobile-navigation-menu">
                            <div class="vfx-mobile-navigation-menu-header">
                                <div class="vfx-mobile-navigation-menu-close js-menu-toggle"> <span
                                        class="lnr lnr-cross"></span> </div>
                            </div>
                            <div class="vfx-mobile-navigation-menu-body"></div>
                        </div>
                        <!--mobile-menu ends-->
                    </div>
                    <div class="col-lg-3 col-md-6 col-5 order-1 order-lg-2 text-right pr-xs-0">

                        @if (Auth::check())
                            <div class="header-button">
                                <div class="vfx-header-button-item js-sidebar-btn">
                                    @if (Auth::User()->user_image and file_exists(public_path('upload/' . Auth::User()->user_image)))
                                        <img src="{{ URL::asset('upload/' . Auth::User()->user_image) }}"
                                            alt="profile_img" title="{{ Auth::User()->name }}" id="userPic">
                                    @else
                                        <img src="{{ URL::asset('site_assets/images/user-avatar.png') }}"
                                            alt="profile_img" title="{{ Auth::User()->name }}" id="userPic">
                                    @endif

                                    <span>Hi, {{ Str::limit(Auth::User()->name, 6) }} <i
                                            class="ion-arrow-down-b"></i></span>
                                </div>
                                <div class="vfx-setting-menu vfx-js-right-sidebar d-none d-lg-block">
                                    <div class="vfx-account-dropdown-item">
                                        <div class="vfx-account-dropdown-item-area">
                                            <a href="{{ URL::to('dashboard') }}"
                                                title="{{ trans('words.dashboard_text') }}"><i
                                                    class="ion-ios-speedometer-outline"></i>
                                                {{ trans('words.dashboard_text') }}</a>
                                        </div>
                                        @if (Auth::User()->usertype == 'User')
                                            <div class="vfx-account-dropdown-item-area">
                                                <a href="{{ URL::to('user/property') }}"
                                                    title="{{ trans('words.my_properties') }}"><i
                                                        class="ion-social-buffer-outline"></i>
                                                    {{ trans('words.my_properties') }}</a>
                                            </div>
                                            <div class="vfx-account-dropdown-item-area">
                                                <a href="{{ URL::to('user/property/add') }}"
                                                    title="{{ trans('words.add_properties') }}"><i
                                                        class="ion-ios-plus-outline"></i>
                                                    {{ trans('words.add_properties') }}</a>
                                            </div>
                                        @endif
                                        <div class="vfx-account-dropdown-item-area">
                                            <a href="{{ URL::to('user/favourites') }}"
                                                title="{{ trans('words.favourite_properties') }}"><i
                                                    class="ionicons ion-android-favorite-outline"></i>
                                                {{ trans('words.favourite_properties') }}</a>
                                        </div>

                                        <div class="vfx-account-dropdown-item-area">
                                            <a href="{{ URL::to('profile') }}"
                                                title="{{ trans('words.profile') }}"><i
                                                    class="ionicons ion-person"></i> {{ trans('words.profile') }}</a>
                                        </div>
                                        <div class="vfx-account-dropdown-item-area">
                                            <a href="{{ URL::to('logout') }}" title="{{ trans('words.logout') }}"><i
                                                    class="ionicons ion-log-out"></i> {{ trans('words.logout') }}</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="vfx-menu-btn">
                                <ul class="user-btn vfx2">
                                    <li><a href="{{ URL::to('/login') }}" title="{{ trans('words.login_text') }}"><i
                                                class="lnr lnr-user"></i><span
                                                class="user-login-text">{{ trans('words.login_text') }}</span></a>
                                    </li>
                                </ul>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Main Menu ends-->
</header>
<!--Header ends-->
<style>
    .playbtn {
        animation: pulse-highlight 1.2s infinite;
        /* border: 1px solid transparent; */
    }

    @keyframes pulse-highlight {
        0% {
            box-shadow: 0 0 0 0 rgba(245, 8, 8, 0.7);
        }

        70% {
            box-shadow: 0 0 0 12px rgba(255, 229, 152, 0);
        }

        100% {
            box-shadow: 0 0 0 0 rgba(255, 229, 152, 0);
        }
    }
</style>
