@extends("admin.admin_app")

@section("content")
 
  <div class="content-page">
      <div class="content" style="max-height: calc(100vh - 120px); overflow:auto;">
        <div class="container-fluid">
          <div class="row">
            <div class="col-lg-12">
              <div class="card-box">
                <h5 class="mb-4" style="color:#f9f9f9"><i class="fa fa-buysellads pr-2"></i> <b>{{ $page_title }}</b></h5>

                {{ html()->form('POST', url('admin/banner-ads/'.$position))->attributes(['class' => 'form-horizontal', 'enctype' => 'multipart/form-data'])->open() }}

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">User</label>
                    <div class="col-sm-6">
                      <select name="user_id" class="form-control" required>
                        <option value="">Select User</option>
                        @foreach($users as $user)
                          <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                      </select>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Location</label>
                    <div class="col-sm-6">
                      <select name="location_id" class="form-control" required>
                        <option value="">Select Location</option>
                        @foreach($locations as $loc)
                          <option value="{{ $loc->id }}">{{ $loc->name }}</option>
                        @endforeach
                      </select>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Name</label>
                    <div class="col-sm-6">
                      <input type="text" name="name" class="form-control" required>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Upload Image</label>
                    <div class="col-sm-6">
                      <input type="file" name="image_file" class="form-control" accept="image/*" required>
                      <small class="form-text text-muted">Allowed up to 4MB. Saved to site_assets/images/advertisement/</small>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Redirect URL</label>
                    <div class="col-sm-6">
                      <input type="url" name="redirect_url" class="form-control" placeholder="https://...">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Description</label>
                    <div class="col-sm-6">
                      <textarea name="description" class="form-control"></textarea>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Cost</label>
                    <div class="col-sm-3">
                      <input type="number" step="0.01" name="cost" class="form-control">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Active</label>
                    <div class="col-sm-3">
                      <input type="checkbox" name="status" value="1">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Starts At</label>
                    <div class="col-sm-3">
                      <input type="datetime-local" name="starts_at" class="form-control">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Ends At</label>
                    <div class="col-sm-3">
                      <input type="datetime-local" name="ends_at" class="form-control">
                    </div>
                  </div>

                  <input type="hidden" name="lat" required>
                  <input type="hidden" name="lng" required>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Select on map for latitude longitude</label>
                    <div class="col-sm-9">
                      <div id="bannerMap" style="height:220px;border:1px solid #2e3645;border-radius:4px;"></div>
                      <small class="form-text text-muted">Click on the map to set latitude & longitude. </small>
                    </div>
                  </div>

                  <div class="form-group">
                    <div class="offset-sm-3 col-sm-9 pl-1">
                      <button type="submit" class="btn btn-primary waves-effect waves-light">Save</button>
                      <a href="{{ url('admin/banner-ads/'.$position) }}" class="btn btn-secondary">Cancel</a>
                    </div>
                  </div>

                {{ html()->form()->close() }}

              </div>
            </div>            
          </div>              
        </div>
      </div>
      @include("admin.copyright") 
    </div> 
 
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin=""/>
<link rel="stylesheet" href="https://unpkg.com/leaflet.fullscreen@2.0.0/Control.FullScreen.css" integrity="sha256-7TkmOslR+CSKwJ/8h3jE68V3v45W6mo/nLUBs7e1IXQ=" crossorigin=""/>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>
<script src="https://unpkg.com/leaflet.fullscreen@2.0.0/Control.FullScreen.js" integrity="sha256-VNvmqD2N4AB1Yyeq3Fz2hNumlYg3D7PYjY2jD5d4LTc=" crossorigin=""></script>
<script>
'use strict';
(function(){
  if (!document.getElementById('bannerMap')) return;

  var chennaiCenter = [13.0827, 80.2707];
  var chennaiBounds = L.latLngBounds(
    [12.80, 79.90], // SW
    [13.30, 80.40]  // NE
  );

  var map = L.map('bannerMap', {
    center: chennaiCenter,
    zoom: 12,
    maxBounds: chennaiBounds,
    maxBoundsViscosity: 1.0,
    fullscreenControl: true,
    fullscreenControlOptions: {
      position: 'topleft',
      title: '',
      titleCancel: ''
    }
  });

  L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
    attribution: '&copy; OpenStreetMap contributors'
  }).addTo(map);

  var latInput = document.querySelector('input[name="lat"]');
  var lngInput = document.querySelector('input[name="lng"]');
  var marker = null;

  function setMarker(latlng){
    if(marker){ marker.setLatLng(latlng); }
    else { marker = L.marker(latlng, {draggable:false}).addTo(map); }
  }

  // If prefilled, show marker
  if(latInput.value && lngInput.value){
    var init = L.latLng(parseFloat(latInput.value), parseFloat(lngInput.value));
    if(chennaiBounds.contains(init)){
      setMarker(init);
      map.setView(init, 14);
    }
  }

  map.on('click', function(e){
    var latlng = e.latlng;
    if(!chennaiBounds.contains(latlng)){
      return; // ignore clicks outside Chennai bounds
    }
    latInput.value = latlng.lat.toFixed(6);
    lngInput.value = latlng.lng.toFixed(6);
    setMarker(latlng);
  });
})();
</script>

@endsection

<script type="text/javascript">
'use strict';

  @if(Session::has('flash_message'))
    const Toast = Swal.mixin({
      toast: true,
      position: 'top-end',
      showConfirmButton: false,
      timer: 3000,
      timerProgressBar: false,
    })
    Toast.fire({
      icon: 'success',
      title: '{{ Session::get('flash_message') }}'
    })
  @endif

  @if (session()->has('errors'))
    Swal.fire({
      icon: 'error',
      title: 'Oops...',
      html: '<p>@foreach (session('errors')->all() as $error) {{$error}}<br/> @endforeach</p>',
      showConfirmButton: true,
      confirmButtonColor: '#10c469',
      background:'#1a2234',
      color:'#fff'
    })
  @endif
</script>