@extends("admin.admin_app")

@section("content")

  <div class="content-page">
    <div class="content" style="max-height: calc(100vh - 120px); overflow:auto;">
      <div class="container-fluid">
        <div class="row">
          <div class="col-lg-12">
            <div class="card-box">
              <h5 class="mb-4" style="color:#f9f9f9"><i class="fa fa-buysellads pr-2"></i> <b>{{ $page_title }}</b></h5>

              <div class="d-flex justify-content-between align-items-center mb-3">
                <div></div>
                <a href="{{ url('admin/banner-ads/' . $position . '/create') }}" class="btn btn-success">Add Banner</a>
              </div>

              <div class="table-responsive">
                <table class="table table-bordered mb-0">
                  <thead>
                    <tr>
                      <th>S.No</th>
                      <th>Name</th>
                      <th>Page</th>
                      <th>Position</th>
                      <th>Image</th>
                      <th>Redirect URL</th>
                      <th>Status</th>
                      <th>Start</th>
                      <th>End</th>
                      <th>Actions</th>
                    </tr>
                  </thead>
                  <tbody>
                    @forelse($ads as $ad)
                      <tr data-id="{{ $ad->id }}">
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $ad->name }}</td>
                        <td>{{ $ad->page }}</td>
                        <td>{{ $ad->position }}</td>
                        <td>
                          @if(!empty($ad->image_path))
                            <img src="{{ asset($ad->image_path) }}" alt="{{ $ad->name }}" style="height:40px;">
                          @endif
                        </td>
                        <td>
                          @if(!empty($ad->redirect_url))
                            <a href="{{ $ad->redirect_url }}" target="_blank">Link</a>
                          @endif
                        </td>
                        <td>
                          @if($ad->status)
                            <span class="badge badge-success">Active</span>
                          @else
                            <span class="badge badge-secondary">Inactive</span>
                          @endif
                        </td>
                        <td>{{ $ad->starts_at }}</td>
                        <td>{{ $ad->ends_at }}</td>
                        <td>
                          <a href="{{ url('admin/banner-ads/' . $position . '/' . $ad->id . '/edit') }}"
                            class="btn btn-icon waves-effect waves-light btn-success m-b-5 m-r-5" data-toggle="tooltip"
                            title="{{trans('words.edit')}}"> <i class="fa fa-edit"></i> </a>
                          {{ html()->form('POST', url('admin/banner-ads/' . $position . '/' . $ad->id . '/delete'))->attributes(['style' => 'display:inline'])->open() }}
                          <button type="submit" class="btn btn-sm btn-danger"
                            onclick="return confirm('Delete this advertisement ?')"><i class="fa fa-remove"></i></button>
                          {{ html()->form()->close() }}
                        </td>
                      </tr>
                    @empty
                      <tr>
                        <td colspan="10" class="text-center">No records found.</td>
                      </tr>
                    @endforelse
                  </tbody>
                </table>
              </div>

              <nav class="paging_simple_numbers">
                @include('admin.pagination', ['paginator' => $banners])
              </nav>

            </div>
          </div>
        </div>
      </div>
    </div>
    @include("admin.copyright")
  </div>

@endsection

<script type="text/javascript">
'use strict';

  @if(Session::has('flash_message'))
    const Toast = Swal.mixin({
      toast: true,
      position: 'top-end',
      showConfirmButton: false,
      timer: 3000,
      timerProgressBar: false,
    })
    Toast.fire({
      icon: 'success',
      title: '{{ Session::get('flash_message') }}'
    })
  @endif

  @if (session()->has('errors'))
    Swal.fire({
      icon: 'error',
      title: 'Oops...',
      html: '<p>@foreach (session('errors')->all() as $error) {{$error}}<br/> @endforeach</p>',
      showConfirmButton: true,
      confirmButtonColor: '#10c469',
      background:'#1a2234',
      color:'#fff'
    })
  @endif
</script>