@extends('admin.admin_app')

@section('content')
<div class="content-page">
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-12">
          <div class="card-box">
            <h4 class="header-title m-t-0 m-b-30">{{ $page_title }}</h4>

            <div class="table-responsive">
              <table class="table table-bordered">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>User</th>
                    <th>Requested</th>
                    <th>Payment Pref</th>
                    <th>Status</th>
                    <th>Approved Price</th>
                    <th>Created</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                @foreach($requests as $req)
                  <tr>
                    <td>{{ $req->id }}</td>
                    <td>{{ optional($req->user)->name }}<br><small>{{ optional($req->user)->email }}</small></td>
                    <td>
                      Props: {{ $req->property_posts_requested }}<br>
                      Ads: {{ $req->ads_posts_requested ?? '-' }}
                    </td>
                    <td>{{ ucfirst($req->payment_preference) }}</td>
                    <td>
                      @php
                        $badge = 'badge-secondary';
                        switch($req->status){
                          case 'pending': $badge='badge-warning'; break;
                          case 'approved': $badge='badge-primary'; break;
                          case 'awaiting_payment': $badge='badge-info'; break;
                          case 'activated': $badge='badge-success'; break;
                          case 'rejected': $badge='badge-danger'; break;
                        }
                      @endphp
                      <span class="badge {{ $badge }}">{{ strtoupper($req->status) }}</span>
                    </td>
                    <td>{{ $req->approved_price ? number_format($req->approved_price,2) : '-' }}</td>
                    <td>{{ $req->created_at?->format('Y-m-d H:i') }}</td>
                    <td>
                      <a href="{{ url('admin/custom-plans/'.$req->id) }}" class="btn btn-sm btn-primary">Review</a>
                      @if($req->user_id)
                        <a href="{{ url('admin/users/'.$req->user_id) }}" class="btn btn-sm btn-purple">View User</a>
                      @endif
                    </td>
                  </tr>
                @endforeach
                </tbody>
              </table>
            </div>

            @include('_particles.pagination', ['paginator' => $requests])

          </div>
        </div>
      </div>
    </div>
  </div>
  @include('admin.copyright')
</div>
@endsection
