@extends('admin.admin_app')

@section('content')
<div class="content-page">
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-12">
          <div class="card-box" style="color:#e6e6e6;">
            <div class="row">
              <div class="col-sm-6">
                <h4 class="header-title m-t-0 m-b-30">{{ $page_title }}</h4>
              </div>
              <div class="col-sm-6 text-right">
                <a href="{{ url('admin/custom-plans') }}" class="btn btn-secondary">Back</a>
                @if($requestModel->user_id)
                  <a href="{{ url('admin/users/'.$requestModel->user_id) }}" class="btn btn-purple">View User</a>
                @endif
              </div>
            </div>

            <div class="row">
              <div class="col-md-6">
                <h5 class="text-muted">User Info</h5>
                <p><strong>Name:</strong> <span class="text-white">{{ $requestModel->user->name }}</span></p>
                <p><strong>Email:</strong> <span class="text-white">{{ $requestModel->user->email }}</span></p>
                <p><strong>Phone:</strong> <span class="text-white">{{ $requestModel->user->phone }}</span></p>
              </div>
              <div class="col-md-6">
                <h5 class="text-muted">Request</h5>
                <p><strong>Property postings needed:</strong> <span class="text-white">{{ $requestModel->property_posts_requested }}</span></p>
                <p><strong>Ads postings needed:</strong> <span class="text-white">{{ $requestModel->ads_posts_requested ?? '-' }}</span></p>
                <p><strong>Payment preference:</strong> <span class="text-white">{{ ucfirst($requestModel->payment_preference) }}</span></p>
                @php
                  $badge = 'badge-secondary';
                  switch($requestModel->status){
                    case 'pending': $badge='badge-warning'; break;
                    case 'approved': $badge='badge-primary'; break;
                    case 'awaiting_payment': $badge='badge-info'; break;
                    case 'activated': $badge='badge-success'; break;
                    case 'rejected': $badge='badge-danger'; break;
                  }
                @endphp
                <p><strong>Status:</strong> <span class="badge {{ $badge }}">{{ strtoupper($requestModel->status) }}</span></p>
                @if($requestModel->notes)
                <p><strong>Notes:</strong> <span class="text-white">{{ $requestModel->notes }}</span></p>
                @endif
              </div>
            </div>

            <hr>

            @if($requestModel->status === 'pending' || $requestModel->status === 'approved')
            <h5>Approve Request</h5>
            {{ html()->form('POST', url('admin/custom-plans/'.$requestModel->id.'/approve'))->open() }}
              <div class="row">
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Allowed property postings *</label>
                    <input type="number" class="form-control" name="approved_property_limit" value="{{ old('approved_property_limit', $requestModel->approved_property_limit ?? $requestModel->property_posts_requested) }}" min="0" required>
                    <small class="text-muted">Requested: {{ $requestModel->property_posts_requested }}</small>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Allowed ads postings</label>
                    <input type="number" class="form-control" name="approved_ads_limit" value="{{ old('approved_ads_limit', $requestModel->approved_ads_limit ?? $requestModel->ads_posts_requested) }}" min="0">
                    <small class="text-muted">Requested: {{ $requestModel->ads_posts_requested ?? '-'}}</small>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Price *</label>
                    <input type="number" class="form-control" name="approved_price" value="{{ old('approved_price', $requestModel->approved_price) }}" step="0.01" min="0" required>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Validity (days) *</label>
                    <input type="number" class="form-control" name="approved_validity_days" value="{{ old('approved_validity_days', $requestModel->approved_validity_days) }}" min="1" required>
                  </div>
                </div>
              </div>
              <div class="form-group">
                <label>Admin Notes</label>
                <textarea class="form-control" name="admin_notes" rows="3">{{ old('admin_notes', $requestModel->admin_notes) }}</textarea>
              </div>
              <button type="submit" class="btn btn-success">Approve</button>
            {{ html()->form()->close() }}

            <div class="mt-3">
              {{ html()->form('POST', url('admin/custom-plans/'.$requestModel->id.'/reject'))->open() }}
                <div class="form-group">
                  <label>Reason (optional)</label>
                  <input type="text" class="form-control" name="admin_notes" placeholder="Reason for rejection">
                </div>
                <button type="submit" class="btn btn-danger">Reject</button>
              {{ html()->form()->close() }}
            </div>
            @endif

            @if($requestModel->status === 'approved')
              <hr>
              <h5>Cash Payment</h5>
              {{ html()->form('POST', url('admin/custom-plans/'.$requestModel->id.'/mark-paid'))->open() }}
                <div class="form-group">
                  <label>Payment Reference ID (optional)</label>
                  <input type="text" class="form-control" name="payment_id" placeholder="Receipt no / Ref ID">
                </div>
                <button type="submit" class="btn btn-primary">Mark Paid</button>
              {{ html()->form()->close() }}
            @endif

            @if(in_array($requestModel->status, ['paid','awaiting_payment']))
              <hr>
              <h5>Activate Plan</h5>
              @if($requestModel->payment_preference==='online' && $requestModel->status==='awaiting_payment')
                <p>User payment link: <a href="{{ $requestModel->payment_link }}" class="btn btn-sm btn-outline-info" target="_blank">Open Payment Link</a></p>
              @endif
              {{ html()->form('POST', url('admin/custom-plans/'.$requestModel->id.'/activate'))->open() }}
                <button type="submit" class="btn btn-success">Activate for User</button>
              {{ html()->form()->close() }}
            @endif

          </div>
        </div>
      </div>
    </div>
  </div>
  @include('admin.copyright')
</div>
@endsection
