@extends("admin.admin_app")

@section("content")
 
 
  <div class="content-page">
      <div class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-lg-12">
              <div class="card-box">
                <a href="{{route('admin.herobanner.index')}}" class="btn btn-default waves-effect waves-light float-right"> <i class="fa fa-arrow-left"></i> {{trans('words.back')}}</a>
                <h4 class="mt-0 mb-3 header-title">{{$page_title}}</h4>

                {{ html()->form('POST', isset($banner) ? route('admin.herobanner.update', $banner->id) : route('admin.herobanner.store'))->attributes(['class' => 'form-horizontal form-label-left', 'enctype' => 'multipart/form-data'])->open() }}
                @if(isset($banner))
                  {{ html()->hidden('_method', 'PUT') }}
                @endif

                @if(Auth::user()->usertype == "Admin" || Auth::user()->usertype == "Sub_Admin")
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.user')}}*</label>
                    <div class="col-sm-9">
                      {{ html()->select('user_id', $users->pluck('name', 'id'), old('user_id', $banner->user_id ?? null))->class('form-control')->required() }}
                    </div>
                  </div>
                @endif

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.banner_name')}}*</label>
                    <div class="col-sm-9">
                      {{ html()->text('name', old('name', $banner->name ?? null))->class('form-control')->placeholder(trans('words.banner_name'))->required() }}
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.image')}}*</label>
                    <div class="col-sm-9">
                      <div class="fileinput fileinput-new" data-provides="fileinput">
                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;" data-trigger="fileinput">
                          @if(isset($banner) && $banner->image_path)
                            <img id="image_preview" src="{{ URL::asset($banner->image_path) }}" alt="..." style="max-width: 100%; height: auto; display: block;">
                          @else
                            <img id="image_preview" src="{{ URL::asset('admin_assets/images/no-image.jpg') }}" alt="..." style="max-width: 100%; height: auto; display: block;">
                          @endif
                        </div>
                        <div>
                                                <span class="btn btn-teal btn-file">
                                                    <span class="fileinput-new">{{trans('words.select_image')}}</span>
                                                    <span class="fileinput-exists">{{trans('words.change')}}</span>
                                                    <input type="file" name="image" id="image_upload" accept="image/*" {{ (!isset($banner) ? 'required' : '') }}>
                                                </span>
                          <a href="#" class="btn btn-danger fileinput-exists" data-dismiss="fileinput">{{trans('words.remove')}}</a>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.redirect_url')}}</label>
                    <div class="col-sm-9">
                      {{ html()->text('redirect_url', old('redirect_url', $banner->redirect_url ?? null))->class('form-control')->placeholder(trans('words.redirect_url'))->attribute('type', 'url') }}
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.small_title')}}</label>
                    <div class="col-sm-9">
                      {{ html()->text('small_title', old('small_title', $banner->description['small_title'] ?? null))->class('form-control')->placeholder(trans('words.small_title'))->attribute('maxlength', '20') }}
                      <small class="form-text text-muted">{{trans('words.max_characters', ['max' => 20])}}</small>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.main_content')}}</label>
                    <div class="col-sm-9">
                      {{ html()->text('main_content', old('main_content', $banner->description['main_content'] ?? null))->class('form-control')->placeholder(trans('words.main_content'))->attribute('maxlength', '20') }}
                      <small class="form-text text-muted">{{trans('words.max_characters', ['max' => 20])}}</small>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.bottom_content')}}</label>
                    <div class="col-sm-9">
                      {{ html()->text('bottom_content', old('bottom_content', $banner->description['bottom_content'] ?? null))->class('form-control')->placeholder(trans('words.bottom_content'))->attribute('maxlength', '20') }}
                      <small class="form-text text-muted">{{trans('words.max_characters', ['max' => 20])}}</small>
                      
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.cost')}}*</label>
                    <div class="col-sm-9">
                      {{ html()->number('cost', old('cost', $banner->cost ?? null))->class('form-control')->placeholder(trans('words.cost'))->required()->attribute('min', '0')->attribute('step', 'any') }}
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.status')}}*</label>
                    <div class="col-sm-9">
                      {{ html()->select('status', [1 => trans('words.active'), 0 => trans('words.inactive')], old('status', $banner->status ?? 1))->class('form-control')->required() }}
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.start_at')}}</label>
                    <div class="col-sm-9">
                      {{ html()->input('datetime-local', 'starts_at', old('starts_at', isset($banner) && $banner->starts_at ? $banner->starts_at->format('Y-m-d\TH:i') : null))->class('form-control') }}
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.end_at')}}</label>
                    <div class="col-sm-9">
                      {{ html()->input('datetime-local', 'ends_at', old('ends_at', isset($banner) && $banner->ends_at ? $banner->ends_at->format('Y-m-d\TH:i') : null))->class('form-control') }}
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.latitude')}}</label>
                    <div class="col-sm-9">
                      {{ html()->text('lat', old('lat', $banner->lat ?? null))->class('form-control')->placeholder(trans('words.latitude')) }}
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.longitude')}}</label>
                    <div class="col-sm-9">
                      {{ html()->text('lng', old('lng', $banner->lng ?? null))->class('form-control')->placeholder(trans('words.longitude')) }}
                    </div>
                  </div>

                  <div class="form-group">
                    <div class="offset-sm-3 col-sm-9">
                      <button type="submit" class="btn btn-primary">{{trans('words.save')}}</button>
                    </div>
                  </div>

                {{ html()->form()->close() }}
              </div>
            </div>            
          </div>              
        </div>
      </div>
      @include("admin.copyright") 
    </div> 

<script type="text/javascript">

'use strict';    

    @if(Session::has('flash_message'))     
 
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: false,         
      })

      Toast.fire({
        icon: 'success',
        title: '{{ Session::get('flash_message') }}'
      })     
     
  @endif

  @if (count($errors) > 0)
                  
          Swal.fire({
            icon: 'error',
            title: 'Oops...',
            html: '<p>@foreach ($errors->all() as $error) {{$error}}<br/> @endforeach</p>',
            showConfirmButton: true,
            confirmButtonColor: '#10c469',
            background:"#1a2234",
            color:"#fff"
           }) 
  @endif

  // Custom image preview JavaScript
  document.addEventListener('DOMContentLoaded', function() {
    const imageUpload = document.getElementById('image_upload');
    const imagePreview = document.getElementById('image_preview');

    imageUpload.addEventListener('change', function(event) {
      const file = event.target.files[0];
      if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
          imagePreview.src = e.target.result;
        };
        reader.readAsDataURL(file);
      } else {
        // Fallback to a default image if no file is selected
        imagePreview.src = "{{ URL::asset('admin_assets/images/no-image.jpg') }}";
      }
    });

    // Remove button functionality (optional, adjust as needed)
    document.querySelector('.fileinput-exists').addEventListener('click', function(e) {
      e.preventDefault();
      imageUpload.value = ''; // Clear the input
      imagePreview.src = "{{ URL::asset('admin_assets/images/no-image.jpg') }}"; // Reset to default
      // Optionally hide the "remove" and "change" buttons if they are part of a fileinput component
      // and re-show the "select image" button. This part might need adjustments depending on your CSS framework.
    });
  });

  // For testing only - remove in production
  document.addEventListener('DOMContentLoaded', function() {
    var showPasswordBtn = document.createElement('button');
    showPasswordBtn.textContent = 'Show Password';
    showPasswordBtn.onclick = function() {
        var passwordInput = document.querySelector('input[type="password"]');
        if (passwordInput) {
            passwordInput.type = passwordInput.type === 'password' ? 'text' : 'password';
        }
    };
    // Append the button to a relevant part of your form or page
    // For example, after the form or in a debug section
    // document.querySelector('.form-group:last-of-type').appendChild(showPasswordBtn);
});

</script>  

@endsection