@extends('admin.admin_app')

@section('content')

  <div class="content-page">
      <div class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-12">
              <div class="card-box table-responsive">

                <h4 class="mt-0 mb-3">Leads @if(isset($total)) <small>({{ $total }})</small> @endif</h4>

                @if(isset($total) && $total == 0)
                    <div class="alert alert-info">No leads yet. Once users request phone numbers or brochures, leads will appear here.</div>
                @endif

                <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Email</th>
                            <th>Action</th>
                            <th>Property</th>
                            <th>IP</th>
                            <th>Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($leads as $lead)
                            <tr id="lead_{{ $lead->id }}">
                                <td>{{ $lead->id }}</td>
                                <td>{{ $lead->name }}</td>
                                <td>{{ $lead->phone }}</td>
                                <td>{{ $lead->email }}</td>
                                <td>{{ $lead->action }}</td>
                <td>
                  @php
                    $prop = $lead->property ?? null;
                    if(!$prop && isset($lead->property_id)) {
                      $prop = \App\Property::find($lead->property_id);
                    }
                  @endphp
                  @if($prop)
                    <a href="{{ url('properties/'.$prop->slug.'/'.$prop->id) }}">
                      @if(isset($prop->title) && $prop->title != '')
                        {{ Str::limit(stripslashes($prop->title), 40) }}
                      @else
                        {{ $prop->reference_number }}
                      @endif
                    </a>
                  @else
                    N/A
                  @endif
                </td>
                                <td>{{ $lead->ip }}</td>
                                <td>{{ $lead->created_at }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8">No leads to display.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
                </div>

                <nav class="paging_simple_numbers">
                  @include('admin.pagination', ['paginator' => $leads])
                </nav>

              </div>
            </div>
          </div>
        </div>
      </div>
      @include('admin.copyright')
  </div>

@endsection
