@extends("admin.admin_app")

@section("content")

 
  <div class="content-page">
      <div class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-lg-12">
              <div class="card-box">
                 <div class="row">
                 <div class="col-sm-6">
                      <a href="{{ URL::to('admin/property') }}"><h4 class="header-title m-t-0 m-b-30 text-primary pull-left" style="font-size: 20px;"><i class="fa fa-arrow-left"></i> {{trans('words.back')}}</h4></a>
                 </div>                  
               </div>  
               
               {{ html()->form('POST', url('/admin/property/add_edit'))
                     ->attributes(['class' => 'form-horizontal', 'id' => 'post_form', 'name' => 'post_form', 'role' => 'form', 'enctype' => 'multipart/form-data'])->open() }}
 
                  
                 <input type="hidden" name="id" value="{{ isset($info->id) ? $info->id : null }}">

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.type')}}*</label>
                      <div class="col-sm-3">
                            <select class="form-control select2" name="type" id="type">   
                               <option value="">{{trans('words.select_type')}}</option>                            
                              @foreach($type_list as $type_data)  
                                <option value="{{$type_data->id}}" @if(isset($info->id) AND $type_data->id==$info->type_id) selected @endif>{{$type_data->type_name}}</option>
                              @endforeach   
                            </select>
                      </div>

                      <label class="col-sm-2 col-form-label">{{trans('words.purpose')}}</label>
                      <div class="col-sm-3">
                            <select class="form-control" name="purpose" id="purpose">                               
                                <option value="Sale" @if(isset($info->purpose) AND $info->purpose=="Sale") selected @endif>Sale</option>
                                <option value="Rent" @if(isset($info->purpose) AND $info->purpose=="Rent") selected @endif>Rent</option>
                                                   
                            </select>
                      </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">User*</label>
                    <div class="col-sm-8">
                        <select class="form-control select2" name="user_id" id="user_id">
                            <option value="">Select user</option>
                            @foreach($users as $user)
                                <option value="{{$user->id}}" @if(isset($info->user_id) AND $user->id==$info->user_id) selected @endif>{{$user->name}} ({{$user->email}})</option>
                            @endforeach
                        </select>
                    </div>
                  </div>
 
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.property_title')}}*  </label>
                    <div class="col-sm-8">
                      <input type="text" name="title" value="{{ isset($info->title) ? stripslashes($info->title) : old('title') }}" class="form-control">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.description')}}</label>
                    <div class="col-sm-8">
                    <textarea id="elm1" name="description" class="form-control">{{ isset($info->description) ? stripslashes($info->description) : null }}</textarea>
                    </div>
                  </div><br/>
                   

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.phone')}}</label>
                    <div class="col-sm-3">
                      <input type="text" name="phone" value="{{ isset($info->phone) ? $info->phone : null }}" class="form-control">
                    </div>

                    <label class="col-sm-2 col-form-label">{{trans('words.location_text')}} *</label>
                      <div class="col-sm-3">
                            <select class="form-control select2" name="location" id="location">   
                               <option value="">{{trans('words.select_location')}}</option>                            
                              @foreach($location_list as $location_data)  
                                <option value="{{$location_data->id}}" @if(isset($info->id) AND $location_data->id==$info->location_id) selected @endif>{{$location_data->name}}</option>
                              @endforeach   
                            </select>
                      </div>
                  </div>

                  <div class="form-group row">
                    
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.address')}} </label>
                    <div class="col-sm-8">
                      <input type="text" name="address" value="{{ isset($info->address) ? stripslashes($info->address) : null }}" class="form-control">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.lat_long')}}
                    <small class="form-text text-muted">Click on the map to select location or use current location</small> 
                    </label>
                    <div class="col-sm-9">
                      <div class="row">
                        <div class="col-sm-5">
                          <input type="text" name="latitude" id="latitude" value="{{ isset($info->latitude) ? stripslashes($info->latitude) : null }}" class="form-control" placeholder="Latitude" readonly>
                        </div>
                        <div class="col-sm-5">
                          <input type="text" name="longitude" id="longitude" value="{{ isset($info->longitude) ? stripslashes($info->longitude) : null }}" class="form-control" placeholder="Longitude" readonly>    
                        </div>
                      </div>
                      <div id="map" style="height: 400px; width: 100%; margin-top: 10px; border: 1px solid #ddd;"></div>
                    </div>
                  </div>

                  <hr/>
                  <h4 class="m-t-0 m-b-30 header-title" style="font-size: 20px;">Overview</h4>
                  
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.bedrooms')}}                    
                    </label>
                    <div class="col-sm-3">
                      <input type="text" name="bedrooms" value="{{ isset($info->bedrooms) ? stripslashes($info->bedrooms) : null }}" class="form-control">
                    </div>
                    <label class="col-sm-2 col-form-label">{{trans('words.bathrooms')}}                    
                    </label>
                    <div class="col-sm-3">
                    <input type="text" name="bathrooms" value="{{ isset($info->bathrooms) ? stripslashes($info->bathrooms) : null }}" class="form-control">    
                    </div>
                    
                  </div>    

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.area')}}                    
                    </label>
                    <div class="col-sm-3">
                          <input type="text" name="area" value="{{ isset($info->area) ? stripslashes($info->area) : null }}" class="form-control">
                    </div>
                    <label class="col-sm-2 col-form-label">Property Expired On
                    </label>
                    <div class="col-sm-3">
                    <input type="date" name="property_expired_on" value="{{ isset($info->property_expired_on) ? date('Y-m-d', strtotime($info->property_expired_on)) : null }}" class="form-control">    
                    </div>
                    
                  </div>    

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.furnishing')}}                    
                    </label>
                    <div class="col-sm-3">
                    <select class="form-control" name="furnishing" id="furnishing">                               
                                <option value="Unfurnished" @if(isset($info->furnishing) AND $info->furnishing=="Unfurnished") selected @endif>Unfurnished</option>
                                <option value="Semi-Furnished" @if(isset($info->furnishing) AND $info->furnishing=="Semi-Furnished") selected @endif>Semi-Furnished</option>
                                <option value="Furnished" @if(isset($info->furnishing) AND $info->furnishing=="Furnished") selected @endif>Furnished</option>
                                                   
                            </select>    
                    </div>
                    
                  </div>
  
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.price')}}                    
                    </label>
                    <div class="col-sm-3">
                          <input type="number" name="price" value="{{ isset($info->price) ? $info->price : null }}" class="form-control" min="1" step="1">
                    </div>
                    <label class="col-sm-2 col-form-label">{{trans('words.verified')}}                    
                    </label>
                    <div class="col-sm-3">
                            <select class="form-control" name="verified">
                                <option value="NO" @if(isset($info->verified) AND $info->verified=="NO") selected @endif>{{trans('words.no')}}</option>                                                           
                                <option value="YES" @if(isset($info->verified) AND $info->verified=="YES") selected @endif>{{trans('words.yes')}}</option>                                
                            </select>   
                    </div>
                    
                  </div>
                  
                  <div class="form-group row">                   
                    <label class="col-sm-3 col-form-label">{{trans('words.amenities')}}</label>
                    <div class="col-sm-8">
                        <!-- Hidden input to store selected amenities -->
                        <input type="hidden" name="amenities" id="amenities_input" value="{{ isset($info->amenities) ? stripslashes($info->amenities) : null }}">
                        
                        <!-- Search and filter -->
                        <div class="amenities-search mb-3">
                            <input type="text" id="amenities_search" class="form-control" placeholder="Search amenities..." style="margin-bottom: 10px;">
                            <div class="amenities-filter mb-2">
                                <button type="button" class="btn btn-sm btn-outline-primary filter-btn active" data-category="all">All</button>
                                <button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="basic">Basic</button>
                                <button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="security">Security</button>
                                <button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="entertainment">Entertainment</button>
                                <button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="outdoor">Outdoor</button>
                                <button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="utilities">Utilities</button>
                            </div>
                        </div>
                        
                        <!-- Selected amenities display -->
                        <div class="selected-amenities mb-3">
                            <label class="form-label">Selected Amenities:</label>
                            <div id="selected_amenities_display" class="selected-amenities-container" style="min-height: 50px; border: 1px solid #ddd; padding: 10px; border-radius: 4px; background-color: #f8f9fa;">
                                <span class="text-muted">No amenities selected</span>
                            </div>
                        </div>
                        
                        <!-- Amenities grid -->
                        <div class="amenities-grid" style="max-height: 300px; overflow-y: auto; border: 1px solid #ddd; padding: 15px; border-radius: 4px; background-color: #fff;">
                            <div class="row" id="amenities_container">
                                <!-- Amenities will be populated by JavaScript -->
                            </div>
                        </div>
                        
                        <!-- Custom amenity input -->
                        <div class="custom-amenity mt-3">
                            <div class="input-group">
                                <input type="text" id="custom_amenity" class="form-control" placeholder="Add custom amenity...">
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-success" id="add_custom_amenity" onclick="return false;">Add</button>
                                </div>
                            </div>
                        </div>
                    </div>
                  </div>                    

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.featured_image')}}*</label>
                    <div class="col-sm-8">
                      <div class="input-group">
                        <input type="text" name="image" id="image" value="{{ isset($info->image) ? stripslashes($info->image) : null }}" class="form-control" readonly>
                        <div class="input-group-append">                           
                          <button type="button" class="btn btn-dark waves-effect waves-light popup_selector" data-input="image" data-preview="holder_logo" data-inputid="image">Select</button>                        
                        </div>
                      </div>
                      <small class="form-text text-muted">({{trans('words.recommended_resolution')}} : 800x480, 600x350)</small> 

                      <div id="image_holder" style="margin-top:5px;max-height:100px;"></div>                     
                    </div>
                  </div>
                
                  @if(isset($info->image)) 
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">&nbsp;</label>
                    <div class="col-sm-8">                                                                         
                      <img src="{{URL::to('/'.$info->image)}}" alt="image" class="img-thumbnail" width="140">                                               
                    </div>
                  </div>
                  @endif  

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.floor_plan_image')}}</label>
                    <div class="col-sm-8">
                      <div class="input-group">
                        <input type="text" name="floor_plan_image" id="floor_plan_image" value="{{ isset($info->floor_plan_image) ? stripslashes($info->floor_plan_image) : null }}" class="form-control" readonly>
                        <div class="input-group-append">                           
                          <button type="button" class="btn btn-dark waves-effect waves-light popup_selector" data-input="floor_plan_image" data-preview="holder_logo" data-inputid="floor_plan_image">Select</button>                        
                        </div>
                      </div>
                      <small class="form-text text-muted">({{trans('words.recommended_resolution')}} : 800x480, 600x350)</small> 

                      <div id="floor_plan_image_holder" style="margin-top:5px;max-height:100px;"></div>                     
                    </div>
                  </div>
                
                  @if(isset($info->floor_plan_image)) 
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">&nbsp;</label>
                    <div class="col-sm-8">                                                                         
                      <img src="{{URL::to('/'.$info->floor_plan_image)}}" alt="image" class="img-thumbnail" width="140">                                               
                    </div>
                  </div>
                  @endif

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Property Brochure (PDF)</label>
                    <div class="col-sm-8">
                      <div class="input-group">
                        <input type="text" name="brochure" id="brochure" value="{{ isset($info->brochure) ? stripslashes($info->brochure) : null }}" class="form-control" readonly>
                        <div class="input-group-append">                           
                          <button type="button" class="btn btn-dark waves-effect waves-light popup_selector" data-input="brochure" data-preview="holder_logo" data-inputid="brochure">Select PDF</button>                        
                        </div>
                      </div>
                      <small class="form-text text-muted">Upload property brochure in PDF format</small> 

                      <div id="brochure_holder" style="margin-top:5px;max-height:100px;"></div>                     
                    </div>
                  </div>
                
                  @if(isset($info->brochure)) 
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">&nbsp;</label>
                    <div class="col-sm-8">                                                                         
                      <a href="{{URL::to('/'.$info->brochure)}}" target="_blank" class="btn btn-info btn-sm">
                        <i class="fa fa-file-pdf-o"></i> View Brochure
                      </a>                                               
                    </div>
                  </div>
                  @endif 

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.gallery_images')}}</label>
                    <div class="col-sm-8">
                    
                    @if(isset($info->id))
                      <div class="row">
                        @foreach($gallery_images as $i => $gallery_img)
                          <div class="col-md-6 col-xl-3 col-lg-4 gallery_block" id="gallery_box{{$gallery_img->id}}">
                                      
                                      <span title="Delete" class="gall_delete_img">
                                      <a href="#" class="image_remove" data-toggle="tooltip" title="{{trans('words.remove')}}" data-id="{{$gallery_img->id}}"> <i class="fa fa-remove"></i> </a>
                                      </span>
                                      <img src="{{ url('/'.$gallery_img->image) }}" class="img-thumbnail" alt="gallery" width="140">
                                   
                               
                          </div> 
                        @endforeach        
                                 
                      </div>  
                        
                      <br/>
                    @endif 
                       
                    <div class="form-group row">
                    <label class="col-sm-2 col-form-label">{{trans('words.image')}} 1</label>
                      <div class="col-sm-10">
                        <div class="input-group">
                          <input type="text" name="image_gallery[]" id="image1" value="" class="form-control" readonly>
                          <div class="input-group-append">                           
                            <button type="button" class="btn btn-dark waves-effect waves-light popup_selector" data-input="image" data-preview="holder_logo" data-inputid="image1">Select</button>                        
                          </div>
                        </div>
                          
                        <div id="image1_holder" class="gallery_img_item" style="margin-top:5px;max-height:100px;"></div>                     
                      </div>
                    </div>

                    <div id="dynamicInput"></div>

                    <div class="form-group row">
                      <label class="col-sm-2 col-form-label">&nbsp;</label>
                      <div class="col-sm-10">
                      <button type="button" class="btn btn-success btn-xs" onClick="addInput('dynamicInput');">{{trans('words.add_more_image')}}</button>
                      </div>
                    </div>
                       

                     </div>
                  </div>
 
                  
 
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">{{trans('words.status')}}</label>
                      <div class="col-sm-8">
                            <select class="form-control" name="status">                               
                                <option value="1" @if(isset($info->status) AND $info->status==1) selected @endif>{{trans('words.active')}}</option>
                                <option value="0" @if(isset($info->status) AND $info->status==0) selected @endif>{{trans('words.inactive')}}</option>                            
                            </select>
                      </div>
                  </div>
                  <div class="form-group">
                    <div class="offset-sm-3 col-sm-9 pl-1">
                      <button type="submit" class="btn btn-primary waves-effect waves-light"> {{trans('words.save')}}</button>                      
                    </div>
                  </div>
                  {{ html()->form()->close() }}
              </div>
            </div>            
          </div>              
        </div>
      </div>

      @include("admin.copyright") 
    
    </div>  

<script type="text/javascript">
    
     
// function to update the file selected by elfinder
function processSelectedFile(filePath, requestingField) {
   
  'use strict';    

    var elfinderUrl = "{{ URL::to('/') }}/";
     
      var target_preview = $('#'+requestingField+'_holder');
      target_preview.html('');
      target_preview.append(
              $('<img>').css('height', '5rem').attr('src', elfinderUrl + filePath.replace(/\\/g,"/"))
            );
      target_preview.trigger('change');
     
    $('#' + requestingField).val(filePath.replace(/\\/g,"/")).trigger('change');
 
}
 
 </script>

 <script type="text/javascript">
  
  'use strict';    

    @if(Session::has('flash_message'))     
 
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: false,         
      })

      Toast.fire({
        icon: 'success',
        title: '{{ Session::get('flash_message') }}'
      })     
     
  @endif

  @if (count($errors) > 0)
                  
          Swal.fire({
            icon: 'error',
            title: 'Oops...',
            html: '<p>@foreach ($errors->all() as $error) {{$error}}<br/> @endforeach</p>',
            showConfirmButton: true,
            confirmButtonColor: '#10c469',
            background:"#1a2234",
            color:"#fff"
           }) 
  @endif
 
  </script>

<script src="{{ URL::asset('admin_assets/js/jquery.min.js') }}"></script>
<script type="text/javascript">
  $(document).ready(function(e) {

    'use strict';    
       
    $("#news_type").change(function(){         
        var type=$("#news_type").val();

        if(type=="Image")
        {   
            $("#gallery_section").show();
            $("#video_section").hide();
        }         
        else
        {
            $("#gallery_section").hide();
            $("#video_section").show();
            $("#url_id_sec").hide();
        }

    });  

    $("#news_video_type").change(function(){         
        var video_type=$("#news_video_type").val();

        if(video_type=="Local")
        {   
            $("#local_id_sec").show();
            $("#url_id_sec").hide();
        }         
        else
        {
            $("#local_id_sec").hide();
            $("#url_id_sec").show();
        }

    }); 

  });
</script>

<script type="text/javascript">
// JavaScript Document
'use strict';    
var counter = 1;
var limit = 50;
function addInput(divName){
     if (counter == limit)  {
          alert("You have reached the limit of adding " + counter + " inputs");
     }
     else {
          var newdiv = document.createElement('div');

          var wall_number=counter+1;

          newdiv.innerHTML ='<div class="form-group row"><label class="col-sm-2 col-form-label">{{trans('words.image')}} '+wall_number+'</label><div class="col-sm-10"><div class="input-group"><input type="text" name="image_gallery[]" id="image'+wall_number+'" value="" class="form-control" readonly><div class="input-group-append"><button type="button" class="btn btn-dark waves-effect waves-light popup_selector" data-input="image" data-preview="holder_logo'+wall_number+'" data-inputid="image'+wall_number+'">Select</button></div></div><div id="image'+wall_number+'_holder" style="margin-top:5px;max-height:100px;"></div></div></div>';
          document.getElementById(divName).appendChild(newdiv);
          counter++;
     }
}

</script> 

<script type="text/javascript">
  //Single
  $(".image_remove").on('click', function () {      

   'use strict';    
  
  var post_id = $(this).data("id");
  var action_name='gallery_img_delete';

  Swal.fire({
  title: '{{trans('words.dlt_warning')}}',
  text: "{{trans('words.dlt_warning_text')}}",
  icon: 'warning',
  showCancelButton: true,
  confirmButtonColor: '#3085d6',
  cancelButtonColor: '#d33',
  confirmButtonText: '{{trans('words.dlt_confirm')}}',
  cancelButtonText: "{{trans('words.btn_cancel')}}",
  background:"#1a2234",
  color:"#fff"

}).then((result) => {

  //alert(post_id);

  //alert(JSON.stringify(result));

    if(result.isConfirmed) { 

        $.ajax({
            type: 'post',
            url: "{{ URL::to('admin/ajax_delete') }}",
            dataType: 'json',
            data: {"_token": "{{ csrf_token() }}",id: post_id, action_for: action_name},
            success: function(res) {

              if(res.status=='1')
              {  

                  var selector = "#gallery_box"+post_id;
                    $(selector ).fadeOut(1000);
                    setTimeout(function(){
                            $(selector ).remove()
                        }, 1000);

                  Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '{{trans('words.deleted')}}!',
                    showConfirmButton: true,
                    confirmButtonColor: '#10c469',
                    background:"#1a2234",
                    color:"#fff"
                  })
                
              } 
              else
              { 
                Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Something went wrong!',
                        showConfirmButton: true,
                        confirmButtonColor: '#10c469',
                        background:"#1a2234",
                        color:"#fff"
                       })
              }
              
            }
        });
    }
 
})

});  
</script>
<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />

<!-- Leaflet JavaScript -->
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize map with default location
    var map = L.map('map').setView([0, 0], 2);
    
    // Add OpenStreetMap tiles
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);
    
    // Get current coordinates from form or try to get user's location
    var currentLat = parseFloat(document.getElementById('latitude').value) || 0;
    var currentLng = parseFloat(document.getElementById('longitude').value) || 0;
    
    var marker = null;
    
    // If we have existing coordinates, use them
    if (currentLat !== 0 && currentLng !== 0) {
        map.setView([currentLat, currentLng], 13);
        marker = L.marker([currentLat, currentLng]).addTo(map);
    } else {
        // Try to get user's current location
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(
                function(position) {
                    var lat = position.coords.latitude;
                    var lng = position.coords.longitude;
                    
                    // Center map on user's location
                    map.setView([lat, lng], 13);
                    
                    // Add marker at user's location
                    marker = L.marker([lat, lng]).addTo(map);
                    
                    // Update form fields with current location
                    document.getElementById('latitude').value = lat.toFixed(6);
                    document.getElementById('longitude').value = lng.toFixed(6);
                },
                function(error) {
                    console.log('Geolocation error:', error);
                    // Fallback to a default location (e.g., center of the country or city)
                    map.setView([40.7128, -74.0060], 10); // New York City as fallback
                }
            );
        } else {
            // Fallback if geolocation is not supported
            map.setView([40.7128, -74.0060], 10); // New York City as fallback
        }
    }
    
    // Add click event to map
    map.on('click', function(e) {
        var lat = e.latlng.lat;
        var lng = e.latlng.lng;
        
        // Update input fields
        document.getElementById('latitude').value = lat.toFixed(6);
        document.getElementById('longitude').value = lng.toFixed(6);
        
        // Remove existing marker
        if (marker) {
            map.removeLayer(marker);
        }
        
        // Add new marker
        marker = L.marker([lat, lng]).addTo(map);
    });
    
    // Add geocoding functionality
    function geocodeAddress(address) {
        if (!address) return;
        
        // Using Nominatim (OpenStreetMap's geocoding service)
        fetch(`https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(address)}&limit=1`)
            .then(response => response.json())
            .then(data => {
                if (data && data.length > 0) {
                    var lat = parseFloat(data[0].lat);
                    var lng = parseFloat(data[0].lon);
                    
                    map.setView([lat, lng], 13);
                    
                    // Update input fields
                    document.getElementById('latitude').value = lat.toFixed(6);
                    document.getElementById('longitude').value = lng.toFixed(6);
                    
                    // Remove existing marker
                    if (marker) {
                        map.removeLayer(marker);
                    }
                    
                    // Add new marker
                    marker = L.marker([lat, lng]).addTo(map);
                }
            })
            .catch(error => console.error('Geocoding error:', error));
    }
    
    // Add geocoding when address changes
    var addressInput = document.querySelector('input[name="address"]');
    if (addressInput) {
        addressInput.addEventListener('blur', function() {
            if (this.value.trim()) {
                geocodeAddress(this.value);
            }
        });
    }
    
    // Add current location button functionality
    var getCurrentLocationBtn = document.getElementById('getCurrentLocation');
    if (getCurrentLocationBtn) {
        getCurrentLocationBtn.addEventListener('click', function() {
            if (navigator.geolocation) {
                getCurrentLocationBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Getting Location...';
                getCurrentLocationBtn.disabled = true;
                
                navigator.geolocation.getCurrentPosition(
                    function(position) {
                        var lat = position.coords.latitude;
                        var lng = position.coords.longitude;
                        
                        // Center map on user's location
                        map.setView([lat, lng], 13);
                        
                        // Remove existing marker
                        if (marker) {
                            map.removeLayer(marker);
                        }
                        
                        // Add marker at user's location
                        marker = L.marker([lat, lng]).addTo(map);
                        
                        // Update form fields with current location
                        document.getElementById('latitude').value = lat.toFixed(6);
                        document.getElementById('longitude').value = lng.toFixed(6);
                        
                        // Reset button
                        getCurrentLocationBtn.innerHTML = '<i class="fa fa-location-arrow"></i> Current Location';
                        getCurrentLocationBtn.disabled = false;
                    },
                    function(error) {
                        console.log('Geolocation error:', error);
                        alert('Unable to get your current location. Please select manually on the map.');
                        
                        // Reset button
                        getCurrentLocationBtn.innerHTML = '<i class="fa fa-location-arrow"></i> Current Location';
                        getCurrentLocationBtn.disabled = false;
                    }
                );
            } else {
                alert('Geolocation is not supported by this browser.');
            }
        });
    }
});
</script>

<!-- Advanced Amenities Selection JavaScript -->
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function() {
    'use strict';
    
    // Predefined amenities with categories and icons
    const amenitiesData = {
        basic: [
            { name: 'Air Conditioning', icon: 'fa-snowflake-o', value: 'Air Conditioning' },
            { name: 'Heating', icon: 'fa-thermometer-half', value: 'Heating' },
            { name: 'Parking', icon: 'fa-car', value: 'Parking' },
            { name: 'Elevator', icon: 'fa-arrows-v', value: 'Elevator' },
            { name: 'Balcony', icon: 'fa-home', value: 'Balcony' },
            { name: 'Garden', icon: 'fa-leaf', value: 'Garden' },
            { name: 'Terrace', icon: 'fa-home', value: 'Terrace' },
            { name: 'Storage', icon: 'fa-archive', value: 'Storage' }
        ],
        security: [
            { name: 'Security Guard', icon: 'fa-shield', value: 'Security Guard' },
            { name: 'CCTV', icon: 'fa-video-camera', value: 'CCTV' },
            { name: 'Alarm System', icon: 'fa-bell', value: 'Alarm System' },
            { name: 'Intercom', icon: 'fa-phone', value: 'Intercom' },
            { name: 'Gated Community', icon: 'fa-lock', value: 'Gated Community' },
            { name: 'Fire Safety', icon: 'fa-fire-extinguisher', value: 'Fire Safety' }
        ],
        entertainment: [
            { name: 'Swimming Pool', icon: 'fa-tint', value: 'Swimming Pool' },
            { name: 'Gym', icon: 'fa-dumbbell', value: 'Gym' },
            { name: 'Clubhouse', icon: 'fa-building', value: 'Clubhouse' },
            { name: 'Playground', icon: 'fa-child', value: 'Playground' },
            { name: 'Tennis Court', icon: 'fa-table-tennis', value: 'Tennis Court' },
            { name: 'Basketball Court', icon: 'fa-basketball-ball', value: 'Basketball Court' },
            { name: 'Cinema Hall', icon: 'fa-film', value: 'Cinema Hall' },
            { name: 'Library', icon: 'fa-book', value: 'Library' }
        ],
        outdoor: [
            { name: 'BBQ Area', icon: 'fa-fire', value: 'BBQ Area' },
            { name: 'Jogging Track', icon: 'fa-running', value: 'Jogging Track' },
            { name: 'Landscaping', icon: 'fa-tree', value: 'Landscaping' },
            { name: 'Fountain', icon: 'fa-tint', value: 'Fountain' },
            { name: 'Walking Trail', icon: 'fa-walking', value: 'Walking Trail' },
            { name: 'Outdoor Seating', icon: 'fa-chair', value: 'Outdoor Seating' }
        ],
        utilities: [
            { name: 'WiFi', icon: 'fa-wifi', value: 'WiFi' },
            { name: 'Cable TV', icon: 'fa-tv', value: 'Cable TV' },
            { name: 'Internet', icon: 'fa-globe', value: 'Internet' },
            { name: 'Laundry', icon: 'fa-tshirt', value: 'Laundry' },
            { name: 'Power Backup', icon: 'fa-battery-full', value: 'Power Backup' },
            { name: 'Water Heater', icon: 'fa-shower', value: 'Water Heater' },
            { name: 'Dishwasher', icon: 'fa-utensils', value: 'Dishwasher' },
            { name: 'Microwave', icon: 'fa-microchip', value: 'Microwave' }
        ]
    };
    
    let selectedAmenities = [];
    let currentFilter = 'all';
    let searchTerm = '';
    
    // Initialize amenities
    function initializeAmenities() {
        const existingAmenities = document.getElementById('amenities_input').value;
        if (existingAmenities) {
            selectedAmenities = existingAmenities.split(',').map(a => a.trim()).filter(a => a);
        }
        renderAmenities();
        updateSelectedDisplay();
    }
    
    // Render amenities grid
    function renderAmenities() {
        const container = document.getElementById('amenities_container');
        container.innerHTML = '';
        
        let amenitiesToShow = [];
        
        // Get amenities based on filter
        if (currentFilter === 'all') {
            Object.values(amenitiesData).forEach(category => {
                amenitiesToShow = amenitiesToShow.concat(category);
            });
        } else {
            amenitiesToShow = amenitiesData[currentFilter] || [];
        }
        
        // Filter by search term
        if (searchTerm) {
            amenitiesToShow = amenitiesToShow.filter(amenity => 
                amenity.name.toLowerCase().includes(searchTerm.toLowerCase())
            );
        }
        
        // Render amenities
        amenitiesToShow.forEach(amenity => {
            const isSelected = selectedAmenities.includes(amenity.value);
            const amenityElement = createAmenityElement(amenity, isSelected);
            container.appendChild(amenityElement);
        });
    }
    
    // Create amenity element
    function createAmenityElement(amenity, isSelected) {
        const col = document.createElement('div');
        col.className = 'col-md-4 col-sm-6 mb-2';
        
        const amenityClass = isSelected ? 'amenity-item selected' : 'amenity-item';
        
        col.innerHTML = `
            <div class="${amenityClass}" data-value="${amenity.value}" style="
                padding: 10px;
                border: 1px solid ${isSelected ? '#ef4444' : '#4a5568'};
                border-radius: 5px;
                cursor: pointer;
                transition: all 0.3s;
                background-color: ${isSelected ? '#dc2626' : '#2d3748'};
                color: ${isSelected ? '#ffffff' : '#e2e8f0'};
            " onmouseover="this.style.backgroundColor='${isSelected ? '#dc2626' : '#4a5568'}'" onmouseout="this.style.backgroundColor='${isSelected ? '#dc2626' : '#2d3748'}'">
                <div class="d-flex align-items-center">
                    <i class="fa ${amenity.icon} mr-2" style="color: ${isSelected ? '#ffffff' : '#a0aec0'};"></i>
                    <span style="font-size: 14px; color: ${isSelected ? '#ffffff' : '#e2e8f0'};">
                        ${amenity.name}
                    </span>
                    ${isSelected ? '<i class="fa fa-check ml-auto" style="color: #10b981;"></i>' : ''}
                </div>
            </div>
        `;
        
        // Add click event
        col.querySelector('.amenity-item').addEventListener('click', function() {
            toggleAmenity(amenity.value);
        });
        
        return col;
    }
    
    // Toggle amenity selection
    function toggleAmenity(value) {
        const index = selectedAmenities.indexOf(value);
        if (index > -1) {
            selectedAmenities.splice(index, 1);
        } else {
            selectedAmenities.push(value);
        }
        
        // Update hidden input
        document.getElementById('amenities_input').value = selectedAmenities.join(',');
        
        // Re-render amenities and selected display
        renderAmenities();
        updateSelectedDisplay();
    }
    
    // Update selected amenities display
    function updateSelectedDisplay() {
        const display = document.getElementById('selected_amenities_display');
        
        if (selectedAmenities.length === 0) {
            display.innerHTML = '<span class="text-muted" style="color: #a0aec0;">No amenities selected</span>';
            return;
        }
        
        display.innerHTML = selectedAmenities.map(amenity => `
            <span class="badge badge-primary mr-2 mb-2" style="font-size: 12px; padding: 5px 10px; background-color: #dc2626; color: #ffffff; border: 1px solid #ef4444;">
                ${amenity}
                <i class="fa fa-times ml-1" style="cursor: pointer; color: #ffffff;" onclick="removeAmenity('${amenity}')"></i>
            </span>
        `).join('');
    }
    
    // Remove amenity from selected
    window.removeAmenity = function(value) {
        const index = selectedAmenities.indexOf(value);
        if (index > -1) {
            selectedAmenities.splice(index, 1);
            document.getElementById('amenities_input').value = selectedAmenities.join(',');
            renderAmenities();
            updateSelectedDisplay();
        }
    };
    
    // Filter buttons
    document.querySelectorAll('.filter-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            // Remove active class from all buttons
            document.querySelectorAll('.filter-btn').forEach(b => b.classList.remove('active'));
            // Add active class to clicked button
            this.classList.add('active');
            
            currentFilter = this.dataset.category;
            renderAmenities();
        });
    });
    
    // Search functionality
    document.getElementById('amenities_search').addEventListener('input', function() {
        searchTerm = this.value;
        renderAmenities();
    });
    
    // Custom amenity addition
    document.getElementById('add_custom_amenity').addEventListener('click', function(e) {
        e.preventDefault(); // Prevent form submission
        e.stopPropagation(); // Stop event bubbling
        
        const customInput = document.getElementById('custom_amenity');
        const value = customInput.value.trim();
        
        if (value && !selectedAmenities.includes(value)) {
            selectedAmenities.push(value);
            document.getElementById('amenities_input').value = selectedAmenities.join(',');
            customInput.value = '';
            updateSelectedDisplay();
        }
    });
    
    // Allow Enter key for custom amenity
    document.getElementById('custom_amenity').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault(); // Prevent form submission
            e.stopPropagation(); // Stop event bubbling
            document.getElementById('add_custom_amenity').click();
        }
    });
    
    // Initialize on page load
    initializeAmenities();
});
</script>

<style>
/* Dark Theme with Red Buttons for Amenities */
.amenity-item {
    background-color: #2d3748 !important;
    border-color: #4a5568 !important;
    color: #e2e8f0 !important;
    transition: all 0.3s ease;
}

.amenity-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.3);
    background-color: #4a5568 !important;
    border-color: #dc2626 !important;
}

.amenity-item.selected {
    background-color: #dc2626 !important;
    border-color: #ef4444 !important;
    color: #ffffff !important;
}

.amenity-item.selected:hover {
    background-color: #dc2626 !important;
    border-color: #f87171 !important;
}

.amenity-item i {
    color: #a0aec0 !important;
}

.amenity-item.selected i {
    color: #ffffff !important;
}

.amenity-item.selected .fa-check {
    color: #10b981 !important;
}

.selected-amenities-container {
    min-height: 50px;
    display: flex;
    flex-wrap: wrap;
    align-items: center;
    background-color: #2d3748 !important;
    border-color: #4a5568 !important;
    color: #e2e8f0 !important;
}

.amenities-grid {
    background-color: #2d3748 !important;
    border-color: #4a5568 !important;
}

.amenities-search input {
    background-color: #2d3748 !important;
    border-color: #4a5568 !important;
    color: #e2e8f0 !important;
}

.amenities-search input:focus {
    background-color: #2d3748 !important;
    border-color: #dc2626 !important;
    color: #e2e8f0 !important;
    box-shadow: 0 0 0 0.2rem rgba(220, 38, 38, 0.25);
}

.amenities-search input::placeholder {
    color: #a0aec0 !important;
}

.amenities-filter .btn {
    margin-right: 5px;
    margin-bottom: 5px;
    background-color: #4a5568 !important;
    border-color: #4a5568 !important;
    color: #e2e8f0 !important;
}

.amenities-filter .btn:hover {
    background-color: #2d3748 !important;
    border-color: #dc2626 !important;
    color: #ffffff !important;
}

.amenities-filter .btn.active {
    background-color: #dc2626 !important;
    color: #ffffff !important;
    border-color: #ef4444 !important;
}

.custom-amenity input {
    background-color: #2d3748 !important;
    border-color: #4a5568 !important;
    color: #e2e8f0 !important;
}

.custom-amenity input:focus {
    background-color: #2d3748 !important;
    border-color: #dc2626 !important;
    color: #e2e8f0 !important;
    box-shadow: 0 0 0 0.2rem rgba(220, 38, 38, 0.25);
}

.custom-amenity input::placeholder {
    color: #a0aec0 !important;
}

.custom-amenity .btn-success {
    background-color: #dc2626 !important;
    border-color: #dc2626 !important;
    color: #ffffff !important;
}

.custom-amenity .btn-success:hover {
    background-color: #b91c1c !important;
    border-color: #b91c1c !important;
}

.badge-primary {
    background-color: #dc2626 !important;
    color: #ffffff !important;
    border: 1px solid #ef4444 !important;
}

.badge-primary .fa-times {
    color: #ffffff !important;
}

.text-muted {
    color: #a0aec0 !important;
}

/* Dark theme for form labels */
.form-label {
    color: #e2e8f0 !important;
}

/* Dark theme for the amenities section background */
.amenities-section {
    background-color: #1a202c !important;
    padding: 20px;
    border-radius: 8px;
    margin-bottom: 20px;
}

/* Scrollbar styling for dark theme */
.amenities-grid::-webkit-scrollbar {
    width: 8px;
}

.amenities-grid::-webkit-scrollbar-track {
    background: #2d3748;
    border-radius: 4px;
}

.amenities-grid::-webkit-scrollbar-thumb {
    background: #4a5568;
    border-radius: 4px;
}

.amenities-grid::-webkit-scrollbar-thumb:hover {
    background: #dc2626;
}

/* Red theme enhancements for buttons and selected items */
.amenity-item:hover {
    box-shadow: 0 4px 12px rgba(220, 38, 38, 0.4);
}

.amenity-item.selected {
    box-shadow: 0 2px 8px rgba(220, 38, 38, 0.3);
}

/* Red glow effect for selected items */
.amenity-item.selected::before {
    content: '';
    position: absolute;
    top: -2px;
    left: -2px;
    right: -2px;
    bottom: -2px;
    background: linear-gradient(45deg, #dc2626, #ef4444, #f87171, #ef4444, #dc2626);
    border-radius: 7px;
    z-index: -1;
    opacity: 0.3;
}
</style>

@endsection

