<div class="modal fade" id="reviewModal" tabindex="-1" role="dialog" aria-labelledby="reviewModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document" aria-modal="true">
    <div class="modal-content modern-modal">
      <div class="modal-header border-0 px-4 py-3">
        <h5 class="modal-title m-0" id="reviewModalLabel">Review Property</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body pt-0 px-4 pb-4">
        <style>
          /* Scoped styles for review modal */
          .modern-modal { background:#0f172a; color:#e5e7eb; border-radius:14px; overflow:hidden; }
          .modern-modal .modal-header { background:#0f172a; border-bottom:1px solid #1f2937; color:#e5e7eb; }
          .modern-modal .close { color:#9ca3af; opacity:1; }
          .modern-modal .close:hover { color:#fff; }
          .modern-modal .info-chip { display:inline-flex; align-items:center; gap:6px; padding:4px 10px; border-radius:999px; font-size:12px; background:transparent; border:1px solid #223049; color:#cbd5e1; }
          .modern-modal .thumb { width: 160px; height: 120px; border-radius:10px; object-fit:cover; border:1px solid #223049; }
          .modern-modal h4, .modern-modal h6, .modern-modal label { color:#e5e7eb; }
          .modern-modal .text-muted, .modern-modal small { color:#9ca3af !important; }
          .modern-modal .card { background:#0b1220; border:1px solid #1f2937; border-radius:12px; }
          .modern-modal .btn-success { background: linear-gradient(180deg,#22c55e,#16a34a); border:0; }
          .modern-modal .btn-outline { background:#0f172a; border:1px solid #223049; color:#cbd5e1; }
          .modern-modal .btn-outline:hover { background:#111827; }
          .modern-modal .form-control { background:#0f172a; border-color:#243041; color:#e5e7eb; }
          .modern-modal .form-control:focus { background:#0f172a; border-color:#375075; box-shadow: 0 0 0 .2rem rgba(59,130,246,.15); color:#e5e7eb; }
          .modern-modal .gallery-scroller { max-height: 220px; overflow:auto; padding-right:8px; }
          .modern-modal .g-thumb { width:100%; aspect-ratio:1.3/1; object-fit:cover; border-radius:10px; border:1px solid #223049; }
          .modern-modal .quick-presets { display:flex; flex-wrap:wrap; gap:6px; }
          .modern-modal .quick-presets .btn { padding:6px 10px; font-size:12px; border-radius:8px; }
          .modern-modal .badge-soft { padding:4px 8px; font-size:11px; border-radius:999px; }
          .modern-modal .badge-green { background:rgba(34,197,94,.15); color:#34d399; border:1px solid rgba(34,197,94,.25); }
          .modern-modal .badge-amber { background:rgba(245,158,11,.15); color:#fbbf24; border:1px solid rgba(245,158,11,.25); }
          .modern-modal .desc-truncate { position:relative; max-height: 96px; overflow:hidden; }
          .modern-modal .desc-fade { position:absolute; left:0; right:0; bottom:0; height:36px; background: linear-gradient(180deg, rgba(15,23,42,0), rgba(15,23,42,1)); }
          .modern-modal .link-muted { color:#9ca3af; text-decoration: none; }
          .modern-modal .link-muted:hover { color:#e5e7eb; text-decoration: underline; }
        </style>
        <div class="row">
          <div class="col-md-7">
            <div class="d-flex align-items-start mb-3">
              @if($property->image)
                <img src="{{ url('/'.$property->image) }}" alt="cover" class="thumb mr-3">
              @endif
              <div>
                <h4 class="mb-1">{{ $property->title }}</h4>
                <div class="mb-2">
                  <span class="info-chip"><i class="fa fa-home"></i> {{ $property->types->type_name ?? '—' }}</span>
                  <span class="info-chip"><i class="fa fa-map-marker"></i> {{ $property->locations->name ?? '—' }}</span>
                </div>
                <div class="text-muted small">Owner: {{ $property->users->name ?? '—' }} ({{ $property->users->email ?? '—' }})</div>
              </div>
            </div>
            <h6 class="mb-2">Description</h6>
            <div id="descWrap" class="text-muted desc-truncate">{!! nl2br(e(stripslashes($property->description))) !!}<div class="desc-fade"></div></div>
            <div class="mt-2">
              <a href="#" id="toggleDesc" class="link-muted small" data-expanded="false">Show more</a>
            </div>
            @if(count($gallery_images))
              <hr/>
              <div class="d-flex align-items-center justify-content-between">
                <h6 class="mb-2">Gallery</h6>
                <a href="#" class="link-muted small" id="toggleGallery" data-collapsed="true">Show gallery</a>
              </div>
              <div class="row gallery-scroller d-none" id="galleryWrap">
                @foreach($gallery_images as $g)
                  <div class="col-6 col-md-4 mb-3">
                    <img src="{{ url('/'.$g->image) }}" class="g-thumb" alt="gallery">
                  </div>
                @endforeach
              </div>
            @endif
          </div>
          <div class="col-md-5">
            <div class="card">
              <div class="card-body">
                <div class="d-flex align-items-center justify-content-between mb-2">
                  <h6 class="m-0">Approval</h6>
                  @php
                    $expiredOn = $property->property_expired_on ?? null;
                    $isExpired = $expiredOn ? \Carbon\Carbon::parse($expiredOn)->isPast() : false;
                  @endphp
                  @if($expiredOn)
                    <span class="badge-soft {{ $isExpired ? 'badge-amber' : 'badge-green' }}">{{ $isExpired ? 'Expired' : 'Active until '.date('M d, Y', strtotime($expiredOn)) }}</span>
                  @else
                    <span class="badge-soft badge-green">No expiry</span>
                  @endif
                </div>
                <form id="approveForm" method="POST" action="{{ url('admin/property/'.$property->id.'/approve') }}">
                  @csrf
                  <div class="form-group">
                    <label for="property_expired_on" class="mb-1">Expiry date</label>
                    <div class="d-flex align-items-start gap-2" style="gap:8px;">
                      <input type="date" id="property_expired_on" name="property_expired_on" class="form-control" value="{{ $property->property_expired_on ? date('Y-m-d', strtotime($property->property_expired_on)) : '' }}" min="{{ date('Y-m-d') }}" required autofocus>
                      <div class="quick-presets mt-1">
                        <button type="button" class="btn btn-outline btn-sm js-add-days" data-days="30">+30d</button>
                        <button type="button" class="btn btn-outline btn-sm js-add-days" data-days="60">+60d</button>
                        <button type="button" class="btn btn-outline btn-sm js-add-days" data-days="90">+90d</button>
                        <button type="button" class="btn btn-outline btn-sm js-clear-date">Clear</button>
                      </div>
                    </div>
                    <small class="form-text">After this date, the property is considered expired.</small>
                  </div>
                  <button type="submit" class="btn btn-success btn-block js-approve-btn">
                    <span class="js-approve-text">Approve</span>
                    <span class="js-approve-loading d-none"><i class="fa fa-circle-o-notch fa-spin"></i> Approving...</span>
                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
(function(){
  var $modal = $('#reviewModal');
  // Approve via AJAX
  $('#approveForm').on('submit', function(e){
    e.preventDefault();
    var $form = $(this);
    var $btn = $form.find('.js-approve-btn');
    $btn.prop('disabled', true);
    $btn.find('.js-approve-text').addClass('d-none');
    $btn.find('.js-approve-loading').removeClass('d-none');
    $.ajax({
      type: 'post',
      url: $form.attr('action'),
      data: $form.serialize(),
      dataType: 'json',
      success: function(res){
        if(res && res.status==1){
          $modal.modal('hide');
          Swal.fire({icon:'success', title:'Approved', background:'#1a2234', color:'#fff'}).then(()=>{ location.reload(); });
        }else{
          Swal.fire({icon:'error', title: (res && res.message) ? res.message : 'Error', background:'#1a2234', color:'#fff'});
          $btn.prop('disabled', false);
          $btn.find('.js-approve-text').removeClass('d-none');
          $btn.find('.js-approve-loading').addClass('d-none');
        }
      },
      error: function(xhr){
        var msg = 'Validation failed';
        if(xhr.responseJSON && xhr.responseJSON.errors){
          var es = xhr.responseJSON.errors; var firstKey = Object.keys(es)[0]; if(firstKey){ msg = es[firstKey][0]; }
        }
        Swal.fire({icon:'error', title: msg, background:'#1a2234', color:'#fff'});
        $btn.prop('disabled', false);
        $btn.find('.js-approve-text').removeClass('d-none');
        $btn.find('.js-approve-loading').addClass('d-none');
      }
    });
  });

  // Quick preset handlers
  $(document).on('click', '.js-add-days', function(){
    var days = parseInt($(this).data('days'), 10) || 0;
    var today = new Date();
    today.setHours(0,0,0,0);
    var d = new Date(today.getTime() + days*24*60*60*1000);
    var y = d.getFullYear();
    var m = (d.getMonth()+1).toString().padStart(2,'0');
    var da = d.getDate().toString().padStart(2,'0');
    $('#property_expired_on').val(y+'-'+m+'-'+da);
  });
  $(document).on('click', '.js-clear-date', function(){
    $('#property_expired_on').val('');
  });

  // Description toggle
  $('#toggleDesc').on('click', function(e){
    e.preventDefault();
    var expanded = $(this).data('expanded') === true;
    if(expanded){
      $('#descWrap').addClass('desc-truncate');
      $('#descWrap .desc-fade').removeClass('d-none');
      $(this).text('Show more').data('expanded', false);
    } else {
      $('#descWrap').removeClass('desc-truncate');
      $('#descWrap .desc-fade').addClass('d-none');
      $(this).text('Show less').data('expanded', true);
    }
  });

  // Auto-hide desc toggle if content is short
  (function(){
    var wrap = document.getElementById('descWrap');
    if(wrap){
      var tooShort = wrap.scrollHeight <= 110; // approx threshold
      if(tooShort){
        $('#toggleDesc').addClass('d-none');
        $('#descWrap .desc-fade').addClass('d-none');
      }
    }
  })();

  // Gallery toggle
  $('#toggleGallery').on('click', function(e){
    e.preventDefault();
    var collapsed = $(this).data('collapsed') !== false; // default true
    if(collapsed){
      $('#galleryWrap').removeClass('d-none');
      $(this).text('Hide gallery').data('collapsed', false);
    } else {
      $('#galleryWrap').addClass('d-none');
      $(this).text('Show gallery').data('collapsed', true);
    }
  });
})();
</script>
