@extends('admin.admin_app')

@section('content')
<div class="content-page">
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-12">
          <div class="card-box" style="color:#e6e6e6;">
            <div class="d-flex justify-content-between align-items-center mb-3">
              <h4 class="header-title m-t-0 m-b-0">{{ $page_title ?? 'User Details' }}</h4>
              <a href="{{ url('admin/users') }}" class="btn btn-secondary">Back to Users</a>
            </div>

            <div class="row">
              <div class="col-md-4">
                <div class="card" style="background:#0e1422;border:1px solid #24314d;">
                  <div class="card-body">
                    <h5 class="text-muted mb-2">User</h5>
                    <div class="d-flex align-items-center">
                      <div class="mr-3">
                        <img src="{{ $user->user_image ? asset('upload/'.$user->user_image) : asset('admin_assets/images/users/avatar-1.jpg') }}" alt="user" class="rounded-circle" width="64" height="64">
                      </div>
                      <div>
                        <div class="font-weight-bold">{{ $user->name }}</div>
                        <div class="text-muted small">{{ $user->email }}</div>
                        <div class="text-muted small">{{ $user->phone }}</div>
                        <div class="badge badge-{{ $user->status ? 'success':'secondary' }} mt-1">{{ $user->status ? 'Active':'Inactive' }}</div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-4">
                <div class="card" style="background:#0e1422;border:1px solid #24314d;">
                  <div class="card-body">
                    <h5 class="text-muted mb-2">Current Plan</h5>
                    @if($plan)
                      <div class="font-weight-bold mb-1">{{ $plan->plan_name }}</div>
                      <div class="text-muted small mb-2">Price: {{ number_format($plan->plan_price,2) }}</div>
                      <div class="text-muted small mb-2">Validity: {{ \App\SubscriptionPlan::getPlanDuration($plan->id) }}</div>
                      <div class="text-muted small">Expiry: {{ $expiry_date ?: '-' }}</div>
                    @else
                      <div class="text-muted">No active plan</div>
                    @endif
                  </div>
                </div>
              </div>

              <div class="col-md-4">
                <div class="card" style="background:#0e1422;border:1px solid #24314d;">
                  <div class="card-body">
                    <h5 class="text-muted mb-2">Usage</h5>
                    <div class="mb-1">Properties: <strong>{{ $properties_used }}</strong> / <strong>{{ $property_limit }}</strong> <span class="text-muted">(left {{ $properties_left }})</span></div>
                    @if(!is_null($ads_limit))
                      <div>Ads: <strong>{{ $ads_used ?? '-' }}</strong> / <strong>{{ $ads_limit }}</strong> @if(!is_null($ads_left)) <span class="text-muted">(left {{ $ads_left }})</span>@endif</div>
                    @endif
                  </div>
                </div>
              </div>
            </div>

            <hr>

            <h5 class="mb-3">Transactions</h5>
            <div class="table-responsive">
              <style>
                /* Scoped dark theme for user transactions table */
                #user-transactions-table {
                  color: #e6e6e6;
                  background: #0e1422;
                  border-color: #24314d;
                }
                #user-transactions-table thead th {
                  background: #121a2b;
                  color: #e6e6e6;
                  border-color: #24314d;
                }
                #user-transactions-table tbody tr {
                  background: #0e1422;
                  border-color: #24314d;
                }
                #user-transactions-table tbody tr:nth-child(odd) {
                  background: #10182a; /* subtle stripe, still dark */
                }
                #user-transactions-table td, #user-transactions-table th {
                  border-color: #24314d !important;
                }
              </style>
              <table id="user-transactions-table" class="table" style="color:#e6e6e6;">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Plan</th>
                    <th>Amount</th>
                    <th>Gateway</th>
                    <th>Status</th>
                    <th>Reference</th>
                    <th>Date</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($transactions as $t)
                    <tr>
                      <td>#{{ $t->id }}</td>
                      <td>{{ optional($t->subscriptionPlan)->plan_name }}</td>
                      <td>{{ $t->formatted_amount }}</td>
                      <td>{{ $t->gateway }}</td>
                      <td><span class="badge {{ $t->status_badge }}">{{ ucfirst($t->payment_status) }}</span></td>
                      <td>{{ $t->reference_id ?: '-' }}</td>
                      <td>{{ $t->formatted_date }}</td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>

            @include('_particles.pagination', ['paginator' => $transactions])

          </div>
        </div>
      </div>
    </div>
  </div>
  @include('admin.copyright')
</div>
@endsection
