    <!-- Internal CSS for City Modal -->
    <style>
        #cityModal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: rgba(0, 0, 0, 0.35);
            z-index: 9999;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: Arial, sans-serif;
        }

        #cityModal .city-modal-box {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.18);
            width: 480px;
            max-width: 96vw;
            padding: 32px 32px 24px 32px;
            position: relative;
        }

        #cityModal h3 {
            text-align: center;
            /* font-weight: 600; */
            margin-bottom: 24px;
            color: #D8232A
        }

        #cityModal .city-search {
            display: flex;
            align-items: center;
            border: 1px solid #eee;
            border-radius: 4px;
            padding: 0 12px;
            margin-bottom: 18px;
        }

        #cityModal .city-search input {
            flex: 1;
            border: none;
            outline: none;
            font-size: 16px;
            padding: 10px 0;
            background: transparent;
        }

        #cityModal .city-search .fa-search {
            color: #D8232A;
            font-size: 22px;
            margin-left: 8px;
        }

        #cityModal .city-list-label {
            font-size: 16px;
            margin-bottom: 10px;
            display: block;
            font-weight: 600;
        }

        #cityModal #cityList {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
        }

        #cityModal .city-option {
            cursor: pointer;
            padding: 6px 0;
            transition: background 0.2s, color 0.2s;
        }

        #cityModal .city-option:hover {
            /* background: #f7f7f7; */
            color: #D8232A;
        }
    </style>
    <!-- City Selection Modal -->
    <div id="cityModal">
        <div class="city-modal-box">
            <h3>SELECT CITY</h3>
            <div class="city-search">
                <input id="citySearchInput" type="text" placeholder="Select or Type your city" />
                <span><i class="fa fa-search"></i></span>
            </div>
            <div>
                <span class="city-list-label">Popular Cities</span>
                <div id="cityList">
                    <span class="city-option">Bangalore</span>
                    <span class="city-option">Mumbai</span>
                    <span class="city-option">Navi Mumbai</span>
                    <span class="city-option">Thane</span>
                    <span class="city-option">Delhi</span>
                    <span class="city-option">Gurgaon</span>
                    <span class="city-option">Noida</span>
                    <span class="city-option">Pune</span>
                    <span class="city-option">Chennai</span>
                    <span class="city-option">Hyderabad</span>
                    <span class="city-option">Kolkata</span>
                    <span class="city-option">Ahmedabad</span>
                </div>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var modal = document.getElementById('cityModal');
            var cityList = document.getElementById('cityList');
            var searchInput = document.getElementById('citySearchInput');
            var options = Array.from(cityList.getElementsByClassName('city-option'));

            function selectCity(city) {
                // You can store the selected city in localStorage or a hidden input for later use
                localStorage.setItem('selectedCity', city);
                modal.style.display = 'none';
            }
            options.forEach(function(opt) {
                opt.addEventListener('click', function() {
                    selectCity(opt.textContent.trim());
                });
            });
            searchInput.addEventListener('input', function() {
                var val = searchInput.value.toLowerCase();
                options.forEach(function(opt) {
                    if (opt.textContent.toLowerCase().includes(val)) {
                        opt.style.display = '';
                    } else {
                        opt.style.display = 'none';
                    }
                });
            });
            // Prevent closing modal until a city is selected
            modal.addEventListener('click', function(e) {
                if (e.target === modal) {
                    e.stopPropagation();
                }
            });
            // Optionally, if you want to allow typing a custom city and selecting it:
            searchInput.addEventListener('keydown', function(e) {
                if (e.key === 'Enter' && searchInput.value.trim()) {
                    selectCity(searchInput.value.trim());
                }
            });
        });
    </script>
