@extends('site_app')

@section('head_title', getcong('site_name'))

@section('head_url', Request::url())
@section('content')
    {{-- Popular Cities popup window --}}
    @include('pages.city-modal')

    <!--Hero Section Starts-->
    @if (count($banners) > 0)
        <div class="hero-slider-wrap">
            <div class="swiper-container hero-swiper">
                <div class="swiper-wrapper">
                    @foreach ($banners as $banner)
                        @php
                            $bannerLink = $banner->redirect_url ?? '';
                            $isExternal = $bannerLink && Str::startsWith($bannerLink, ['http://', 'https://']);
                            $bg = asset($banner->image_path ?? '');

                            // Ensure we always have an array even if DB row still stores plain string
                            $desc = is_array($banner->description)
                                ? $banner->description
                                : (json_decode($banner->description ?? '[]', true) ?:
                                []);
                        @endphp

                        <div class="swiper-slide">
                            @if ($bannerLink)
                                <a href="{{ $isExternal ? $bannerLink : url($bannerLink) }}"
                                    @if ($isExternal) rel="noopener noreferrer" @endif class="banner-link">
                            @endif

                            <div class="hero vfx2 section-padding" style="background-image:url('{{ $bg }}')">
                                <div class="overlay"></div>
                                <div class="container vfx-posabs">
                                    <div class="row">
                                        <div class="col-md-10 offset-md-1">
                                            <div class="header-text vfx1">
                                                <p class="mb-12">{{ $desc['small_title'] ?? '' }}</p>
                                                <h1>{{ $desc['main_content'] ?? '' }}</h1>
                                                <p>{{ $desc['bottom_content'] ?? '' }}</p> {{-- typo fixed: bottom_content --}}
                                                <button type="button" class="btn btn-warning btn-lg explore-btn"
                                                    style="padding: 12px 32px; font-size: 18px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; border-radius: 50px; box-shadow: 0 4px 15px rgba(0,0,0,0.2); transition: all 0.3s ease;">
                                                    Explore
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            @if ($bannerLink)
                                </a>
                            @endif
                        </div>
                    @endforeach
                </div>
                <!-- Add Pagination -->
                <div class="swiper-pagination hero-swiper-pagination"></div>
                <!-- Add Navigation -->
                <div class="swiper-button-prev hero-swiper-prev"></div>
                <div class="swiper-button-next hero-swiper-next"></div>
            </div>
        </div>
    @endif
    <!--Hero Section Ends-->

    <!--search section starts-->
    <div class="container">
        <div class="row">
            <div class="col-md-12">

                {{-- {{ html()->form('GET', url('/properties/search'))->attributes(['class' => 'vfx_hero_form_area vfx2 filter bg-cb', 'id' => 'search', 'role' => 'form', 'style' => 'max-width:1120px;margin:0 auto;'])->open() }} --}}
                {{ html()->form('GET', url('/properties/search'))->attributes(['class' => 'vfx_hero_form_area vfx2 filter', 'id' => 'search', 'role' => 'form', 'style' => 'margin:0 auto;'])->open() }}
                <style>
                    .vfx-search-row .input-group {
                        border-radius: 10px;
                        box-shadow: 0 1px 6px rgba(0, 0, 0, 0.04);
                        margin-bottom: 0.5rem;
                        min-height: 48px;
                        display: flex;
                        flex-wrap: nowrap;
                        align-items: stretch;
                    }

                    .vfx-search-row .input-group .input-group-text {
                        background: #fff;
                        border: none;
                        padding: 0 12px;
                        font-size: 1.2rem;
                        color: #D8232A;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        height: 48px;
                        width: 48px;
                        margin: 0;
                        border-radius: 10px 0 0 10px;
                        box-shadow: 0 1px 4px rgba(216, 35, 42, 0.07);
                        transition: background 0.2s, color 0.2s;
                        flex-shrink: 0;
                    }

                    .vfx-search-row .input-group .input-group-text i {
                        margin: 0;
                        font-size: 1.15rem;
                        color: #D8232A;
                        transition: color 0.2s;
                        vertical-align: middle;
                    }

                    /* .vfx-search-row .input-group:focus-within .input-group-text {
                                                                            background: #D8232A;
                                                                            color: #fff;
                                                                        }
                                                                        .vfx-search-row .input-group:focus-within .input-group-text i {
                                                                            color: #fff;
                                                                        } */
                    .vfx-search-row .form-select,
                    .vfx-search-row .form-control {
                        border: none;
                        background: transparent;
                        box-shadow: none;
                        font-size: 1rem;
                        height: 48px;
                        padding-left: 0;
                        border-radius: 0 10px 10px 0;
                    }

                    .vfx-search-row .form-select:focus,
                    .vfx-search-row .form-control:focus {
                        box-shadow: none;
                        outline: none;
                        background: #fff;
                    }

                    .vfx-search-row .input-group:focus-within {
                        box-shadow: 0 2px 8px rgba(216, 35, 42, 0.10);
                        background: #fff;
                    }

                    .vfx-search-row .btn.vfx3 {
                        border-radius: 10px;
                        font-weight: 700;
                        font-size: 1.1rem;
                        box-shadow: 0 2px 8px rgba(216, 35, 42, 0.08);
                        background: #D8232A;
                        color: #fff;
                        transition: background 0.2s;
                        height: 48px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                    }

                    .vfx-search-row .btn.vfx3 i {
                        margin-right: 6px;
                        font-size: 1.1rem;
                    }

                    .search-button {
                        border-radius: 10px;
                        /* font-weight: 700; */
                        font-size: 1.0rem;
                        box-shadow: 0 2px 8px rgba(216, 35, 42, 0.08);
                        background: #D8232A;
                        color: #fff;
                        transition: background 0.2s;
                        height: 45px;
                        /* display: flex;
                                                                        align-items: center;
                                                                        justify-content: center; */
                    }
                </style>
                <div class="row justify-content-center align-items-center py-3 px-2 vfx-search-row"
                    style="background: #fff; border-radius: 18px; box-shadow: 0 2px 16px rgba(0,0,0,0.06);">
                    <div class="col-12 mb-2">
                        <h3 class="text-center text-muted mb-2"
                            style="font-weight:700;font-size:2rem;letter-spacing:0.5px;">Find your perfect <span
                                class="text-danger">workspace</span></h3>
                        <div class="vfx-type-tabs text-center mb-3">
                            <ul class="type-tabs-list"
                                style="list-style:none;padding:0;margin:0;display:inline-flex;flex-wrap:wrap;gap:8px;">
                                <li class="tab-item active" data-type-id=""
                                    style="padding:8px 18px;border-radius:8px;border:1px solid #eee;background:#f7f7f7;cursor:pointer;font-weight:600;color:#D8232A;transition:all 0.2s;box-shadow:0 1px 4px rgba(0,0,0,0.03);">
                                    <i class="fa fa-th-large mr-1"></i> All
                                </li>
                                @foreach (\App\Type::where('status', 1)->orderby('type_name')->get() as $tab_type)
                                    <li class="tab-item" data-type-id="{{ $tab_type->id }}"
                                        style="padding:8px 18px;border-radius:8px;border:1px solid #eee;background:transparent;cursor:pointer;font-weight:600;color:#333;transition:all 0.2s;">
                                        <i class="{{ $tab_type->icon ? $tab_type->icon : 'fa fa-building' }} mr-1"></i>
                                        {{ $tab_type->type_name }}
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>

                    <div class="col-xl-2 col-lg-3 col-sm-6 mb-2 pr-lg-0" hidden>
                        <div class="input-group align-items-center">
                            <span class="input-group-text"><i class="fa fa-list"></i></span>
                            <select name="type_id" class="form-select vfx_hero_form_area_input vfx-custom-select-area">
                                <option value="">{{ trans('words.property_type') }}</option>
                                @foreach (\App\Type::where('status', 1)->orderby('type_name')->get() as $type_data)
                                    <option value="{{ $type_data->id }}">{{ $type_data->type_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-sm-6 mb-2 pr-lg-0">
                        <div class="input-group align-items-center">
                            <span class="input-group-text"><i class="fa fa-map-marker"></i></span>
                            <select name="location_id" class="form-select vfx_hero_form_area_input vfx-custom-select-area"
                                onchange="handleCityChange(this);">
                                <option value="">{{ trans('words.select_city') }}</option>
                                @foreach (\App\Location::where('status', 1)->orderby('name')->get() as $location_data)
                                    {{-- check city_id in cookie --}}
                                    @if (isset($_COOKIE['city_id']) && $_COOKIE['city_id'] == $location_data->id)
                                        <option value="{{ $location_data->id }}" selected>{{ $location_data->name }}
                                        </option>
                                    @else
                                        <option value="{{ $location_data->id }}">{{ $location_data->name }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <script>
                        function handleCityChange(selectElement) {
                            const cityId = selectElement.value;

                            if (!cityId) return; // Prevent empty values

                            // Set or update the cookie
                            document.cookie = `city_id=${cityId}; path=/; max-age=${60 * 60 * 24 * 30}`; // Expires in 30 days
                            location.reload();
                        }
                    </script>
                    <div class="col-xl-2 col-lg-3 col-sm-6 mb-2 pr-lg-0">
                        <div class="input-group align-items-center">
                            <span class="input-group-text"><i class="fa fa-bullseye"></i></span>
                            <select name="purpose" class="form-select vfx_hero_form_area_input vfx-custom-select-area">
                                <option value="">{{ trans('words.purpose') ?? 'Purpose' }}</option>
                                <option value="Buy">Buy</option>
                                <option value="Rent">Rent</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-3 col-sm-12 pr-lg-0">
                        <div class="input-group align-items-center">
                            <span class="input-group-text"><i class="fa fa-search"></i></span>
                            <input type="text" name="search_text" id="search_text"
                                class="form-control vfx_hero_form_area_input"
                                placeholder="{{ trans('words.search_by_title') }} (e.g. Anna Nagar, 2BHK, Villa)">
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-3 col-sm-12 mb-2">
                        <button class="btn search-button" type="submit">
                            {{ trans('words.search_property') }}
                        </button>
                    </div>
                </div>
                {{ html()->form()->close() }}
            </div>
        </div>
    </div>
    <!--search section ends-->

    <!-- Top banner Section -->
    {{-- @if (get_web_banner('home_top') != '')
        <div class="add_banner_section pb-0 mb-20">
            <div class="container">
                <div class="row">
                    <h3 class="advertisment-title title">New Launch Offer</h3>
                    <div class="col-md-12 advertisment">
                        {!! stripslashes(get_web_banner('home_top')) !!}
                    </div>
                </div>
            </div>
        </div>
    @endif --}}
    <!-- Top banner Section -->

    {{-- Top Ads Section --}}
    @if (count($top_ads) > 0)
        <div class="container">
            <div class="top-ads-slider-container">
                <div class="swiper top-ads-swiper">
                    <div class="swiper-wrapper">
                        @foreach ($top_ads as $ad)
                            <div class="swiper-slide">
                                <a href="{{ $ad->redirect_url }}">
                                    <img src="{{ \URL::to($ad->image_path) }}" alt="Top Ads" title="Top Ads"
                                        class="top-ads-image" />
                                </a>
                            </div>
                        @endforeach
                    </div>
                    <!-- Add Pagination -->
                    <div class="swiper-pagination top-ads-pagination"></div>
                    <!-- Add Navigation -->
                    <div class="swiper-button-prev top-ads-prev"></div>
                    <div class="swiper-button-next top-ads-next"></div>
                </div>
            </div>

            <style>
                .top-ads-slider-container {
                    padding: 20px 0;
                    position: relative;
                }

                .top-ads-swiper {
                    width: 100%;
                    border-radius: 12px;
                    overflow: hidden;
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
                }

                .top-ads-image {
                    width: 100%;
                    height: auto;
                    display: block;
                    /* object-fit: cover; */
                    /* aspect-ratio: 16/6; */
                }

                .top-ads-pagination {
                    position: absolute;
                    bottom: 10px !important;
                }

                .top-ads-prev,
                .top-ads-next {
                    color: #fff !important;
                    background: rgba(0, 0, 0, 0.3);
                    border-radius: 50%;
                    width: 40px !important;
                    height: 40px !important;
                    transition: background 0.3s ease;
                }

                .top-ads-prev:hover,
                .top-ads-next:hover {
                    background: rgba(0, 0, 0, 0.5);
                }

                .top-ads-prev:after,
                .top-ads-next:after {
                    font-size: 18px !important;
                }

                @media (max-width: 768px) {
                    /*.top-ads-image {*/
                    /*    aspect-ratio: 16/9;*/
                    /*}*/

                    .top-ads-prev,
                    .top-ads-next {
                        width: 32px !important;
                        height: 32px !important;
                    }

                    .top-ads-prev:after,
                    .top-ads-next:after {
                        font-size: 16px !important;
                    }
                }
            </style>

            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    new Swiper('.top-ads-swiper', {
                        slidesPerView: 1,
                        spaceBetween: 0,
                        loop: true,
                        autoplay: {
                            delay: 3000,
                            disableOnInteraction: false,
                            pauseOnMouseEnter: true
                        },
                        effect: 'slide',
                        speed: 600,
                        grabCursor: true,
                        watchOverflow: true,
                        pagination: {
                            el: '.top-ads-pagination',
                            clickable: true,
                            dynamicBullets: true
                        },
                        navigation: {
                            nextEl: '.top-ads-next',
                            prevEl: '.top-ads-prev',
                        },
                        breakpoints: {
                            320: {
                                touchRatio: 1.5,
                                speed: 300
                            },
                            768: {
                                touchRatio: 1,
                                speed: 400
                            },
                            1024: {
                                touchRatio: 1,
                                speed: 600
                            }
                        },
                        on: {
                            init: function() {
                                this.el.addEventListener('mouseenter', () => {
                                    this.autoplay.stop();
                                });
                                this.el.addEventListener('mouseleave', () => {
                                    this.autoplay.start();
                                });
                            }
                        }
                    });
                });
            </script>
        </div>
    @endif
    {{-- Top Ads Section --}}


    <!--Latest Property Starts-->
    {{-- <div class="vfx-trending-places bg-cb pb-30 pt-20"> --}}
    <div class="vfx-trending-places pb-30 pt-20">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-title vid-item-section mb-15">
                        {{-- <h2>{{ trans('words.latest_property') }}</h2> --}}
                        <div class="text-center">
                            <h1 class="mb-0">Our Latest Properties</h1>
                            <p>Highlight the best of your properties by using the List Category shortcode.<br>You can list
                                categories, types, cities, areas and states of your choice.</p>
                        </div>
                        <span class="view-more">
                            <a href="{{ URL::to('latest') }}" title="view all">{{ trans('words.view_all') }}<svg
                                    xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                    viewBox="0 0 512 512" style="vertical-align: text-top">
                                    <path fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144"></path>
                                </svg></a>
                        </span>
                    </div>
                </div>
                <div class="swiper-container vfx-latest-property-wrap">
                    <div class="swiper-wrapper">

                        @foreach ($latest_list as $latest_data)
                            <div class="swiper-slide">
                                <div class="vfx-single-property-box-area">
                                    <div class="vfx-property-item"> <a class="vfx-property-img"
                                            href="{{ URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id) }}"
                                            title="{{ stripslashes($latest_data->title) }}"><img
                                                src="{{ \URL::to('/' . $latest_data->image) }}" alt="image"
                                                title="image">
                                        </a>
                                        <ul class="vfx-feature-text">
                                            @if ($latest_data->purpose == 'Rent')
                                                <li class="feature_cb"><span>{{ trans('words.rent') }}</span></li>
                                            @else
                                                <li class="feature_or"><span>{{ trans('words.sale') }}</span></li>
                                            @endif
                                            @if ($latest_data->verified == 'YES')
                                                <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                        data-toggle="tooltip" data-placement="top" title=""
                                                        data-original-title="{{ trans('words.verified') }}"></i></li>
                                            @endif
                                        </ul>
                                        <div class="vfx-property-author-wrap">
                                            <p class="text-tlt">{{ $latest_data->types->type_name }}</p>
                                            <ul class="vfx-save-btn">

                                                <li data-toggle="tooltip" data-placement="top" title=""
                                                    data-original-title="Set Favourite"
                                                    class="favourite_property favourite_title_id{{ $latest_data->id }}"
                                                    data-id="{{ $latest_data->id }}">
                                                    @if (check_favourite('Property', $latest_data->id, isset(Auth::user()->id) ? Auth::user()->id : ''))
                                                        <a href="Javascript:void(0);" title="fav"><i
                                                                class="fa fa-heart favourite_icon_id{{ $latest_data->id }}"></i></a>
                                                    @else
                                                        <a href="Javascript:void(0);" title="fav"><i
                                                                class="fa fa-heart-o favourite_icon_id{{ $latest_data->id }}"></i></a>
                                                    @endif
                                                </li>

                                            </ul>
                                        </div>
                                    </div>
                                    <div class="vfx-property-title-box-area">
                                        <h4><a href="{{ URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id) }}"
                                                title="{{ stripslashes($latest_data->title) }}">{{ Str::limit(stripslashes($latest_data->title), 30) }}</a>
                                        </h4>
                                        <div class="vfx-property-location"
                                            style="display: flex; justify-content: space-between; width: 100%;">
                                            <div>
                                                <i class="fa fa-map-marker"></i>
                                                @if (isset($latest_data->locations->name) and $latest_data->locations->name != '')
                                                    {{ $latest_data->locations->name }}
                                                @else
                                                    {{ Str::limit(stripslashes($latest_data->address), 40) }}
                                                @endif
                                            </div>
                                            <div>
                                                {{ post_views_count($latest_data->id, 'Property') . ' views' }}
                                            </div>
                                        </div>
                                        <div class="trending-bottom">
                                            <div class="trend-left float-left">
                                                <div class="vfx-property-author-wrap">
                                                    <a href="{{ URL::to('properties/owner/' . $latest_data->user_id) }}"
                                                        class="property-author" title="user profile">

                                                        @if ($latest_data->users->user_image)
                                                            <img src="{{ \URL::to('upload/' . $latest_data->users->user_image) }}"
                                                                alt="user_image"
                                                                title="{{ stripslashes($latest_data->title) }}">
                                                        @else
                                                            <img src="{{ \URL::to('site_assets/images/user-default.jpg') }}"
                                                                alt="user" title="title">
                                                        @endif

                                                        <span>{{ $latest_data->users->name }}</span>
                                                    </a>
                                                </div>
                                            </div>
                                            <a href="{{ URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id) }}"
                                                class="vfx-trend-right float-right"
                                                title="{{ stripslashes($latest_data->title) }}">
                                                <div class="vfx-trend-open-price">
                                                    {{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($latest_data->price) }}
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <div class="vfx-latest-property-pagination"></div>
            </div>
        </div>
    </div>
    <!--Latest Property Ends-->

    <!-- Side banner Section -->
    {{-- @if (get_web_banner('home_side') != '') --}}
    <div class="add_banner_section pb-0 mb-20">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-lg-6 col-sm-12 text-center">
                    {{-- <h3 class="advertisment-title title">Special Launch Price</h3> --}}
                    <div class="col-md-12 advertisment">
                        {!! stripslashes(get_web_banner('home_side_one')) !!}
                    </div>
                </div>
                <div class="col-md-12 col-lg-6 col-sm-12 text-center">
                    {{-- <h3 class="advertisment-title title">Special Launch Price</h3> --}}
                    <div class="col-md-12 advertisment">
                        {!! stripslashes(get_web_banner('home_side_two')) !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- @endif --}}
    <!-- Side banner Section -->

    <!--High-Demand Properties Property Starts-->
    @if (count($trending_list) > 0)
        {{-- <div class="vfx-trending-places bg-cb pb-30 pt-20"> --}}
        <div class="vfx-trending-places pb-30 pt-20">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="section-title vid-item-section mb-15">
                            {{-- <h2>{{ trans('words.high_demand_properties_heading') }}</h2> --}}
                            <div class="text-center">
                                <h1 class="mb-0">High-Demand Properties</h1>
                                <p>Highlight the best of your properties by using the List Category shortcode.<br>You can
                                    list categories, types, cities, areas and states of your choice.</p>
                            </div>
                            <span class="view-more">
                                <a href="{{ URL::to('popular') }}" title="popular">{{ trans('words.view_all') }}<svg
                                        xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 512 512" style="vertical-align: text-top">
                                        <path fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144">
                                        </path>
                                    </svg></a>
                            </span>
                        </div>
                    </div>
                    <div class="swiper-container vfx-popular-property-wrap">
                        <div class="swiper-wrapper">

                            @foreach ($trending_list as $trending_data)
                                @php
                                    $property_info = \App\Property::find($trending_data->post_id);
                                @endphp
                                <div class="swiper-slide">
                                    <div class="vfx-single-property-box-area">
                                        <div class="vfx-property-item"> <a class="vfx-property-img"
                                                href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                title="{{ stripslashes($property_info->title) }}"><img
                                                    src="{{ \URL::to('/' . $property_info->image) }}" alt="image"
                                                    title="image"> </a>
                                            <ul class="vfx-feature-text">
                                                @if ($property_info->purpose == 'Rent')
                                                    <li class="feature_cb"><span>{{ trans('words.rent') }}</span></li>
                                                @else
                                                    <li class="feature_or"><span>{{ trans('words.sale') }}</span></li>
                                                @endif

                                                @if ($property_info->verified == 'YES')
                                                    <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                            data-toggle="tooltip" data-placement="top" title=""
                                                            data-original-title="{{ trans('words.verified') }}"></i></li>
                                                @endif
                                            </ul>
                                            <div class="vfx-property-author-wrap">
                                                <p class="text-tlt">{{ $property_info->types->type_name }}</p>
                                                <ul class="vfx-save-btn">

                                                    <li data-toggle="tooltip" data-placement="top" title=""
                                                        data-original-title="Set Favourite"
                                                        class="favourite_property favourite_title_id{{ $property_info->id }}"
                                                        data-id="{{ $property_info->id }}">
                                                        @if (check_favourite('Property', $property_info->id, isset(Auth::user()->id) ? Auth::user()->id : ''))
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @else
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart-o favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @endif
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="vfx-property-title-box-area">
                                            <h4><a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    title="{{ stripslashes($property_info->title) }}">{{ Str::limit(stripslashes($property_info->title), 30) }}</a>
                                            </h4>
                                            <div class="vfx-property-location"
                                                style="display: flex; justify-content: space-between; width: 100%;">
                                                <div>
                                                    <i class="fa fa-map-marker"></i>

                                                    @if (isset($property_info->locations->name) and $property_info->locations->name != '')
                                                        {{ $property_info->locations->name }}
                                                    @else
                                                        {{ Str::limit(stripslashes($property_info->address), 40) }}
                                                    @endif
                                                </div>

                                                <div>
                                                    {{ post_views_count($latest_data->id, 'Property') . ' views' }}
                                                </div>
                                            </div>
                                            <div class="trending-bottom">
                                                <div class="trend-left float-left">
                                                    <div class="vfx-property-author-wrap">
                                                        <a href="{{ URL::to('properties/owner/' . $property_info->user_id) }}"
                                                            class="property-author">

                                                            @if ($property_info->users->user_image)
                                                                <img src="{{ \URL::to('upload/' . $property_info->users->user_image) }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @else
                                                                <img src="{{ \URL::to('site_assets/images/user-default.jpg') }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @endif

                                                            <span>{{ $property_info->users->name }}</span>
                                                        </a>
                                                    </div>
                                                </div>
                                                <a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    class="vfx-trend-right float-right"
                                                    title="{{ stripslashes($property_info->title) }}">
                                                    <div class="vfx-trend-open-price">
                                                        {{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($property_info->price) }}
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </div>
                    </div>
                    <div class="vfx-popular-property-pagination"></div>
                </div>
            </div>
        </div>
    @endif
    <!--High-Demand Properties Property Ends-->

    <!--Latest Property Starts-->
    {{-- <div class="vfx-trending-places bg-cb pb-30 pt-20">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-title vid-item-section mb-15">
                        <h2>Explore Real Estate in Popular Indian Cities</h2>
                        <span class="view-more">
                            <a href="{{ URL::to('latest') }}" title="view all">{{ trans('words.view_all') }}<svg
                                    xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                    viewBox="0 0 512 512" style="vertical-align: text-top">
                                    <path fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144"></path>
                                </svg></a>
                        </span>
                    </div>
                </div>
                @foreach ($latest_list as $latest_data)
                    <div class="col-md-3">
                        <div class="vfx-single-property-box-area">
                            <div class="vfx-property-item"> <a class="vfx-property-img"
                                    href="{{ URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id) }}"
                                    title="{{ stripslashes($latest_data->title) }}"><img
                                        src="{{ \URL::to('/' . $latest_data->image) }}" alt="image" title="image">
                                </a>
                                <ul class="vfx-feature-text">
                                    @if ($latest_data->purpose == 'Rent')
                                        <li class="feature_cb"><span>{{ trans('words.rent') }}</span></li>
                                    @else
                                        <li class="feature_or"><span>{{ trans('words.sale') }}</span></li>
                                    @endif
                                    @if ($latest_data->verified == 'YES')
                                        <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                data-toggle="tooltip" data-placement="top" title=""
                                                data-original-title="{{ trans('words.verified') }}"></i></li>
                                    @endif
                                </ul>
                                <div class="vfx-property-author-wrap">
                                    <p class="text-tlt">{{ $latest_data->types->type_name }}</p>
                                    <ul class="vfx-save-btn">

                                        <li data-toggle="tooltip" data-placement="top" title=""
                                            data-original-title="Set Favourite"
                                            class="favourite_property favourite_title_id{{ $latest_data->id }}"
                                            data-id="{{ $latest_data->id }}">
                                            @if (check_favourite('Property', $latest_data->id, isset(Auth::user()->id) ? Auth::user()->id : ''))
                                                <a href="Javascript:void(0);" title="fav"><i
                                                        class="fa fa-heart favourite_icon_id{{ $latest_data->id }}"></i></a>
                                            @else
                                                <a href="Javascript:void(0);" title="fav"><i
                                                        class="fa fa-heart-o favourite_icon_id{{ $latest_data->id }}"></i></a>
                                            @endif
                                        </li>

                                    </ul>
                                </div>
                            </div>
                            <div class="vfx-property-title-box-area">
                                <h4><a href="{{ URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id) }}"
                                        title="{{ stripslashes($latest_data->title) }}">{{ Str::limit(stripslashes($latest_data->title), 30) }}</a>
                                </h4>
                                <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                    <p>
                                        @if (isset($latest_data->locations->name) and $latest_data->locations->name != '')
                                            {{ $latest_data->locations->name }}
                                        @else
                                            {{ Str::limit(stripslashes($latest_data->address), 40) }}
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
                <div class="vfx-latest-property-pagination"></div>
            </div>
        </div>
    </div> --}}


    <!--Latest Property Ends-->
    <div class="vfx-trending-places our-story-bg-2 pb-30 mt-20">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-title vid-item-section mb-15">
                        <div class="text-center">
                            <h1 class="mb-0">Property Options in Chennai</h1>
                            {{-- <p>Highlight the best of your properties by using the List Category shortcode.<br>You can
                                    list categories, types, cities, areas and states of your choice.</p> --}}
                        </div>
                        {{-- <h2 class="pb-3">Property Options in Chennai</h2> --}}
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item" role="presentation" style="font-size:18px;font-weight:600;">
                                <a class="nav-link active" id="simple-tab-0" data-bs-toggle="tab"
                                    href="#simple-tabpanel-0" role="tab" aria-controls="simple-tabpanel-0"
                                    aria-selected="true">Buy</a>
                            </li>
                            <li class="nav-item" role="presentation" style="font-size:18px;font-weight:600;">
                                <a class="nav-link" id="simple-tab-1" data-bs-toggle="tab" href="#simple-tabpanel-1"
                                    role="tab" aria-controls="simple-tabpanel-1" aria-selected="false">Rent</a>
                            </li>
                        </ul>
                        <div class="tab-content" id="tab-content">
                            <div class="tab-pane active" id="simple-tabpanel-0" role="tabpanel"
                                aria-labelledby="simple-tab-0">
                                <div class="row text-left">
                                    <div class="col-lg-3">
                                        <h6 class="pt-3">Popular Residential Searches</h6>
                                        <ul>
                                            <li><a href="/property-for-sale-in-chennai">Property for Sale in Chennai</a>
                                            </li>
                                            <li><a href="/flats-in-chennai">Flats in Chennai</a></li>
                                            <li><a href="/studio-apartments-in-chennai">Studio Apartments in Chennai</a>
                                            </li>
                                            <li><a href="/resale-house-in-chennai">Resale House in Chennai</a></li>
                                            <li><a href="/house-for-sale-in-chennai">House for Sale in Chennai</a></li>
                                            <li><a href="/villas-for-sale-in-chennai">Villas for Sale in Chennai</a></li>
                                            <li><a href="/penthouse-in-chennai">Penthouse in Chennai</a></li>
                                            <li><a href="/ready-to-move-flats-in-chennai">Ready To Move Flats in
                                                    Chennai</a></li>
                                            <li><a href="/resale-flats-in-chennai">Resale Flats in Chennai</a></li>
                                        </ul>
                                    </div>

                                    <div class="col-lg-3">
                                        <h6 class="pt-3">Popular BHK Searches</h6>
                                        <ul>
                                            <li><a href="/1-bhk-flats-in-chennai">1 BHK Flats in Chennai</a></li>
                                            <li><a href="/2-bhk-flats-in-chennai">2 BHK Flats in Chennai</a></li>
                                            <li><a href="/3-bhk-flats-in-chennai">3 BHK Flats in Chennai</a></li>
                                            <li><a href="/4-bhk-flats-in-chennai">4 BHK Flats in Chennai</a></li>
                                            <li><a href="/1-bhk-house-for-sale-in-chennai">1 BHK House for Sale in
                                                    Chennai</a></li>
                                            <li><a href="/2-bhk-house-for-sale-in-chennai">2 BHK House for Sale in
                                                    Chennai</a></li>
                                            <li><a href="/3-bhk-house-for-sale-in-chennai">3 BHK House for Sale in
                                                    Chennai</a></li>
                                            <li><a href="/4-bhk-house-for-sale-in-chennai">4 BHK House for Sale in
                                                    Chennai</a></li>
                                            <li><a href="/1-bhk-villa-for-sale-in-chennai">1 BHK Villa for Sale in
                                                    Chennai</a></li>
                                            <li><a href="/2-bhk-villa-for-sale-in-chennai">2 BHK Villa for Sale in
                                                    Chennai</a></li>
                                            <li><a href="/3-bhk-villa-for-sale-in-chennai">3 BHK Villa for Sale in
                                                    Chennai</a></li>
                                            <li><a href="/4-bhk-villa-for-sale-in-chennai">4 BHK Villa for Sale in
                                                    Chennai</a></li>
                                        </ul>
                                    </div>

                                    <div class="col-lg-3">
                                        <h6 class="pt-3">Popular Flat Searches</h6>
                                        <ul>
                                            <li><a href="/flats-for-sale-in-anna-nagar">Flats for Sale in Anna Nagar</a>
                                            </li>
                                            <li><a href="/flats-for-sale-in-porur">Flats for Sale in Porur</a></li>
                                            <li><a href="/flats-for-sale-in-velachery">Flats for Sale in Velachery</a></li>
                                            <li><a href="/flats-for-sale-in-sholinganallur">Flats for Sale in
                                                    Sholinganallur</a></li>
                                            <li><a href="/flats-for-sale-in-mogappair">Flats for Sale in Mogappair</a></li>
                                            <li><a href="/flats-for-sale-in-nanganallur">Flats for Sale in Nanganallur</a>
                                            </li>
                                            <li><a href="/flats-for-sale-in-adyar">Flats for Sale in Adyar</a></li>
                                            <li><a href="/flats-for-sale-in-mylapore">Flats for Sale in Mylapore</a></li>
                                            <li><a href="/flats-for-sale-in-medavakkam">Flats for Sale in Medavakkam</a>
                                            </li>
                                            <li><a href="/flats-for-sale-in-omr">Flats for Sale in OMR</a></li>
                                        </ul>
                                    </div>

                                    <div class="col-lg-3">
                                        <h6 class="pt-3">Popular House Searches</h6>
                                        <ul>
                                            <li><a href="/house-for-sale-in-velachery">House for Sale in Velachery</a></li>
                                            <li><a href="/house-for-sale-in-avadi">House for Sale in Avadi</a></li>
                                            <li><a href="/house-for-sale-in-kolathur">House for Sale in Kolathur</a></li>
                                            <li><a href="/house-for-sale-in-porur">House for Sale in Porur</a></li>
                                            <li><a href="/house-for-sale-in-ambattur">House for Sale in Ambattur</a></li>
                                            <li><a href="/house-for-sale-in-anna-nagar">House for Sale in Anna Nagar</a>
                                            </li>
                                            <li><a href="/house-for-sale-in-madipakkam">House for Sale in Madipakkam</a>
                                            </li>
                                            <li><a href="/house-for-sale-in-pallikaranai">House for Sale in
                                                    Pallikaranai</a></li>
                                            <li><a href="/house-for-sale-in-medavakkam">House for Sale in Medavakkam</a>
                                            </li>
                                            <li><a href="/house-for-sale-in-perambur">House for Sale in Perambur</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                            <!-- If your second tab shows the same lists, you can duplicate the block above -->
                            <div class="tab-pane" id="simple-tabpanel-1" role="tabpanel" aria-labelledby="simple-tab-1">
                                <div class="row text-left">
                                    <div class="col-lg-3">
                                        <h6 class="pt-3">Popular Residential Searches</h6>
                                        <ul>
                                            <li><a href="/property-for-sale-in-chennai">Property for Rent in Chennai</a>
                                            </li>
                                            <li><a href="/flats-in-chennai">Flats in Chennai</a></li>
                                            <li><a href="/studio-apartments-in-chennai">Studio Apartments in Chennai</a>
                                            </li>
                                            <li><a href="/resale-house-in-chennai">Resale House in Chennai</a></li>
                                            <li><a href="/house-for-sale-in-chennai">House for Rent in Chennai</a></li>
                                            <li><a href="/villas-for-sale-in-chennai">Villas for Rent in Chennai</a></li>
                                            <li><a href="/penthouse-in-chennai">Penthouse in Chennai</a></li>
                                            <li><a href="/ready-to-move-flats-in-chennai">Ready To Move Flats in
                                                    Chennai</a></li>
                                            <li><a href="/resale-flats-in-chennai">Resale Flats in Chennai</a></li>
                                        </ul>
                                    </div>

                                    <div class="col-lg-3">
                                        <h6 class="pt-3">Popular BHK Searches</h6>
                                        <ul>
                                            <li><a href="/1-bhk-flats-in-chennai">1 BHK Flats in Chennai</a></li>
                                            <li><a href="/2-bhk-flats-in-chennai">2 BHK Flats in Chennai</a></li>
                                            <li><a href="/3-bhk-flats-in-chennai">3 BHK Flats in Chennai</a></li>
                                            <li><a href="/4-bhk-flats-in-chennai">4 BHK Flats in Chennai</a></li>
                                            <li><a href="/1-bhk-house-for-sale-in-chennai">1 BHK House for Rent in
                                                    Chennai</a></li>
                                            <li><a href="/2-bhk-house-for-sale-in-chennai">2 BHK House for Rent in
                                                    Chennai</a></li>
                                            <li><a href="/3-bhk-house-for-sale-in-chennai">3 BHK House for Rent in
                                                    Chennai</a></li>
                                            <li><a href="/4-bhk-house-for-sale-in-chennai">4 BHK House for Rent in
                                                    Chennai</a></li>
                                            <li><a href="/1-bhk-villa-for-sale-in-chennai">1 BHK Villa for Rent in
                                                    Chennai</a></li>
                                            <li><a href="/2-bhk-villa-for-sale-in-chennai">2 BHK Villa for Rent in
                                                    Chennai</a></li>
                                            <li><a href="/3-bhk-villa-for-sale-in-chennai">3 BHK Villa for Rent in
                                                    Chennai</a></li>
                                            <li><a href="/4-bhk-villa-for-sale-in-chennai">4 BHK Villa for Rent in
                                                    Chennai</a></li>
                                        </ul>
                                    </div>

                                    <div class="col-lg-3">
                                        <h6 class="pt-3">Popular Flat Searches</h6>
                                        <ul>
                                            <li><a href="/flats-for-sale-in-anna-nagar">Flats for Rent in Anna Nagar</a>
                                            </li>
                                            <li><a href="/flats-for-sale-in-porur">Flats for Rent in Porur</a></li>
                                            <li><a href="/flats-for-sale-in-velachery">Flats for Rent in Velachery</a></li>
                                            <li><a href="/flats-for-sale-in-sholinganallur">Flats for Rent in
                                                    Sholinganallur</a></li>
                                            <li><a href="/flats-for-sale-in-mogappair">Flats for Rent in Mogappair</a></li>
                                            <li><a href="/flats-for-sale-in-nanganallur">Flats for Rent in Nanganallur</a>
                                            </li>
                                            <li><a href="/flats-for-sale-in-adyar">Flats for Rent in Adyar</a></li>
                                            <li><a href="/flats-for-sale-in-mylapore">Flats for Rent in Mylapore</a></li>
                                            <li><a href="/flats-for-sale-in-medavakkam">Flats for Rent in Medavakkam</a>
                                            </li>
                                            <li><a href="/flats-for-sale-in-omr">Flats for Rent in OMR</a></li>
                                        </ul>
                                    </div>

                                    <div class="col-lg-3">
                                        <h6 class="pt-3">Popular House Searches</h6>
                                        <ul>
                                            <li><a href="/house-for-sale-in-velachery">House for Rent in Velachery</a></li>
                                            <li><a href="/house-for-sale-in-avadi">House for Rent in Avadi</a></li>
                                            <li><a href="/house-for-sale-in-kolathur">House for Rent in Kolathur</a></li>
                                            <li><a href="/house-for-sale-in-porur">House for Rent in Porur</a></li>
                                            <li><a href="/house-for-sale-in-ambattur">House for Rent in Ambattur</a></li>
                                            <li><a href="/house-for-sale-in-anna-nagar">House for Rent in Anna Nagar</a>
                                            </li>
                                            <li><a href="/house-for-sale-in-madipakkam">House for Rent in Madipakkam</a>
                                            </li>
                                            <li><a href="/house-for-sale-in-pallikaranai">House for Rent in
                                                    Pallikaranai</a></li>
                                            <li><a href="/house-for-sale-in-medavakkam">House for Rent in Medavakkam</a>
                                            </li>
                                            <li><a href="/house-for-sale-in-perambur">House for Rent in Perambur</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!--Category section starts-->
        <div class="vfx-team-section-area bg-cb-gra pb-20 pt-20">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="section-title vid-item-section mb-15">
                            <h2>{{ trans('words.property_type') }}</h2>
                            <span class="view-more">
                                <a href="{{ URL::to('types') }}" title="types">{{ trans('words.view_all') }}<svg
                                        xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 512 512" style="vertical-align: text-top">
                                        <path fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144">
                                        </path>
                                    </svg></a>
                            </span>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="vfx-team-wrapper swiper-container">
                            <div class="swiper-wrapper">
                                @foreach ($type_list as $type_data)
                                    <div class="swiper-slide">
                                        <div class="vfx-single-team-member vfx-cat-item vfx2"> <a
                                                href="{{ URL::to('types/' . $type_data->type_slug . '/' . $type_data->id) }}"
                                                title="{{ $type_data->type_name }}"><img
                                                    src="{{ URL::to('/' . $type_data->type_image) }}"
                                                    alt="{{ $type_data->type_name }}"
                                                    title="{{ $type_data->type_name }}"></a>
                                            <div class="vfx-single-team-info">
                                                <h4><a href="{{ URL::to('types/' . $type_data->type_slug . '/' . $type_data->id) }}"
                                                        title="{{ $type_data->type_name }}">{{ $type_data->type_name }}</a>
                                                </h4>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach

                            </div>
                            <div class="slider-btn vfx2 team_next"><i class="lnr lnr-arrow-right"></i></div>
                            <div class="slider-btn vfx2 team_prev"><i class="lnr lnr-arrow-left"></i></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Category section starts-->

        <!-- Add banner Section -->



        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
        <!-- Add banner Section -->
        @if (get_web_banner('home_bottom') != '')
            <div class="add_banner_section pt-0">
                <div class="container">
                    <div class="row">
                        <h3 class="advertisment-title">Modern Solutions for You</h3>
                        <div class="col-md-12 advertisment">
                            {!! stripslashes(get_web_banner('home_bottom')) !!}
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <span class="vfx-scroll-top-btn"><i class="lnr lnr-arrow-up"></i></span>


        <!--Page Wrapper ends-->
    @endsection

    @push('scripts')
        <script>
            // Initialize hero Swiper autoplay slider
            document.addEventListener('DOMContentLoaded', function() {
                'use strict';
                if (typeof Swiper !== 'undefined' && document.querySelector('.hero-swiper')) {
                    new Swiper('.hero-swiper', {
                        loop: true,
                        autoplay: {
                            delay: 5000,
                            disableOnInteraction: false,
                        },
                        effect: 'fade',
                        fadeEffect: {
                            crossFade: true
                        },
                        pagination: {
                            el: '.hero-swiper-pagination',
                            clickable: true,
                        },
                        navigation: {
                            nextEl: '.hero-swiper-next',
                            prevEl: '.hero-swiper-prev',
                        },
                        speed: 800,
                        allowTouchMove: true
                    });
                }
            });

            document.addEventListener('DOMContentLoaded', function() {
                // Type tabs: clicking a tab sets the type_id value (supports select or hidden input)
                var tabs = document.querySelectorAll('.vfx-type-tabs .tab-item');
                var typeSelect = document.querySelector('select[name="type_id"]');
                var typeInput = document.querySelector('input[name="type_id"]');
                var $typeSelect = (window.jQuery && typeSelect) ? jQuery(typeSelect) : null;
                // purpose select
                var purposeSelect = document.querySelector('select[name="purpose"]');
                var $purposeSelect = (window.jQuery && purposeSelect) ? jQuery(purposeSelect) : null;
                // URL to fetch purpose list (server route)
                var getPurposeUrl = "{{ url('/properties/get-purpose-list') }}";

                if (tabs.length && (typeSelect || typeInput)) {
                    tabs.forEach(function(tab) {
                        tab.addEventListener('click', function() {
                            tabs.forEach(function(t) {
                                t.classList.remove('active');
                                t.style.background = 'transparent';
                                t.style.color = '#333';
                            });
                            tab.classList.add('active');
                            tab.style.background = '#f7f7f7';
                            tab.style.color = '#D8232A';
                            var id = tab.getAttribute('data-type-id') || '';

                            if (typeSelect) {
                                // set native select value and notify plugin
                                try {
                                    typeSelect.value = id;
                                    if ($typeSelect && typeof $typeSelect.niceSelect === 'function') {
                                        $typeSelect.val(id);
                                        $typeSelect.trigger('change');
                                        // refresh the nice-select display
                                        $typeSelect.niceSelect('update');
                                    } else {
                                        // dispatch change event for vanilla listeners
                                        var evt = new Event('change', {
                                            bubbles: true
                                        });
                                        typeSelect.dispatchEvent(evt);
                                    }
                                } catch (e) {
                                    console.error(e);
                                }
                                // After setting the type, fetch purpose options for this type and update the purpose select
                                try {
                                    if (purposeSelect && getPurposeUrl) {
                                        // preserve a default placeholder
                                        var placeholder = '<option value="">Select Purpose</option>';

                                        // helper: build unique options from an array of items
                                        function buildUniqueOptions(items, includePlaceholder) {
                                            var seen = {};
                                            var html = includePlaceholder ? placeholder : '';
                                            items.forEach(function(it) {
                                                var value = (it && (it.value || it.id)) || it ||
                                                    '';
                                                var label = (it && (it.label || it.name || it
                                                    .text)) || it || '';
                                                var key = String(value);
                                                if (!seen[key]) {
                                                    seen[key] = true;
                                                    html += '<option value="' + value + '">' +
                                                        label + '</option>';
                                                }
                                            });
                                            return html;
                                        }

                                        // helper: parse HTML <option> string into array of {value,label}
                                        function parseOptionsHtml(html) {
                                            var tmp = document.createElement('div');
                                            tmp.innerHTML = '<select>' + html + '</select>';
                                            var opts = tmp.querySelectorAll('option');
                                            var arr = [];
                                            opts.forEach(function(o) {
                                                arr.push({
                                                    value: o.value,
                                                    label: o.textContent
                                                });
                                            });
                                            return arr;
                                        }

                                        // helper: apply options and reinit nice-select safely
                                        function applyPurposeOptionsFromArray(arr, keepPlaceholder) {
                                            var html = buildUniqueOptions(arr, keepPlaceholder);
                                            purposeSelect.innerHTML = html;
                                            if ($purposeSelect && typeof $purposeSelect.niceSelect ===
                                                'function') {
                                                try {
                                                    var $pwrap = $purposeSelect.next('.nice-select');
                                                    if ($pwrap.length) {
                                                        $pwrap.remove();
                                                    }
                                                    $purposeSelect.css('display', '');
                                                    $purposeSelect.niceSelect();
                                                } catch (err) {
                                                    /* ignore */
                                                }
                                            }
                                        }

                                        // Use jQuery if available
                                        if (window.jQuery) {
                                            jQuery.get(getPurposeUrl, {
                                                type_id: id
                                            }, function(resp) {
                                                if (Array.isArray(resp)) {
                                                    applyPurposeOptionsFromArray(resp, true);
                                                } else if (typeof resp === 'string') {
                                                    if (resp.indexOf('<option') !== -1) {
                                                        var arr = parseOptionsHtml(resp);
                                                        applyPurposeOptionsFromArray(arr,
                                                            false);
                                                    } else {
                                                        // plain string -> treat as single option
                                                        applyPurposeOptionsFromArray([resp],
                                                            true);
                                                    }
                                                } else {
                                                    // fallback
                                                    purposeSelect.innerHTML = placeholder;
                                                    if ($purposeSelect && typeof $purposeSelect
                                                        .niceSelect === 'function') {
                                                        try {
                                                            $purposeSelect.next('.nice-select')
                                                                .remove();
                                                            $purposeSelect.css('display', '');
                                                            $purposeSelect.niceSelect();
                                                        } catch (e) {}
                                                    }
                                                }
                                            }, 'json').fail(function(xhr) {
                                                var txt = xhr.responseText || '';
                                                if (txt.indexOf('<option') !== -1) {
                                                    var arr = parseOptionsHtml(txt);
                                                    applyPurposeOptionsFromArray(arr, false);
                                                }
                                            });
                                        } else {
                                            // fetch fallback
                                            fetch(getPurposeUrl + '?type_id=' + encodeURIComponent(id))
                                                .then(function(r) {
                                                    return r.text();
                                                })
                                                .then(function(text) {
                                                    if (text.indexOf('<option') !== -1) {
                                                        var arr = parseOptionsHtml(text);
                                                        applyPurposeOptionsFromArray(arr, false);
                                                    } else {
                                                        try {
                                                            var j = JSON.parse(text);
                                                            if (Array.isArray(j)) {
                                                                applyPurposeOptionsFromArray(j,
                                                                    true);
                                                            } else {
                                                                purposeSelect.innerHTML =
                                                                    placeholder;
                                                            }
                                                        } catch (e) {
                                                            purposeSelect.innerHTML = placeholder;
                                                        }
                                                    }
                                                }).catch(function() {
                                                    /* noop */
                                                });
                                        }
                                    }
                                } catch (ee) {
                                    console.error(ee);
                                }
                            } else if (typeInput) {
                                typeInput.value = id;
                            }
                        });
                    });

                    // initialize active from select/input value
                    var current = (typeSelect && typeSelect.value) || (typeInput && typeInput.value) || '';
                    var activeTab = document.querySelector('.vfx-type-tabs .tab-item[data-type-id="' + current + '"]');
                    if (activeTab) {
                        tabs.forEach(function(t) {
                            t.classList.remove('active');
                            t.style.background = 'transparent';
                            t.style.color = '#333';
                        });
                        activeTab.classList.add('active');
                        activeTab.style.background = '#f7f7f7';
                        activeTab.style.color = '#D8232A';
                        // trigger click to load purpose options for the active tab on page load
                        try {
                            activeTab.click();
                        } catch (e) {
                            /* ignore */
                        }
                    } else {
                        // no active tab found - load for first tab
                        try {
                            if (tabs[0]) tabs[0].click();
                        } catch (e) {
                            /* ignore */
                        }
                    }
                }
            });
        </script>
    @endpush
