@extends('site_app')

@section('head_title', 'Request Custom Plan - '.getcong('site_name'))
@section('head_url', Request::url())

@section('content')

<div class="breadcrumb-section bg-xs" style="background-image: url({{ URL::asset('site_assets/images/breadcrumb-1.jpg') }})">
  <div class="overlay op-2"></div>
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <div class="breadcrumb-menu">
          <h2>Request Custom Plan</h2>
          <span><a href="{{ URL::to('/') }}">{{trans('words.home')}}</a></span> <span>Request Custom Plan</span>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="about-section pt-30 pb-30">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-8 col-md-10">
        <div class="card-box p-4">
          {{ html()->form('POST', url('/custom-plan/request'))->attributes(['id' => 'custom_plan_form'])->open() }}
            <div class="form-group">
              <label>Property postings needed *</label>
              <input type="number" class="form-control" name="property_posts_needed" value="{{ old('property_posts_needed') }}" min="1" step="1" required>
            </div>
            <div class="form-group">
              <label>Ads postings needed</label>
              <input type="number" class="form-control" name="ads_posts_needed" value="{{ old('ads_posts_needed') }}" min="0" step="1">
            </div>
            <div class="form-group">
              <label>Special notes (requirements)</label>
              <textarea class="form-control" name="notes" rows="4" placeholder="Describe any special requirements">{{ old('notes') }}</textarea>
            </div>
            <div class="form-group">
              <label>Payment preference *</label>
              <select class="form-control" name="payment_preference" required>
                <option value="online" @if(old('payment_preference')==='online') selected @endif>Online</option>
                <option value="cash" @if(old('payment_preference')==='cash') selected @endif>Cash</option>
              </select>
            </div>

            <div class="form-group mt-3">
              <button type="submit" class="btn vfx7">Submit Request</button>
              <a href="{{ url('pricing') }}" class="btn btn-secondary">Back to Plans</a>
            </div>
          {{ html()->form()->close() }}
        </div>

        @if (count($errors) > 0)
          <div class="alert alert-danger mt-3">
            <ul class="mb-0">
              @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
              @endforeach
            </ul>
          </div>
        @endif
      </div>
    </div>
  </div>
</div>

@endsection
