@extends('site_app')

@section('head_title', 'Request Submitted - '.getcong('site_name'))
@section('head_url', Request::url())

@section('content')

<div class="breadcrumb-section bg-xs" style="background-image: url({{ URL::asset('site_assets/images/breadcrumb-1.jpg') }})">
  <div class="overlay op-2"></div>
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <div class="breadcrumb-menu">
          <h2>Request Submitted</h2>
          <span><a href="{{ URL::to('/') }}">{{trans('words.home')}}</a></span> <span>Request Submitted</span>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="about-section pt-30 pb-30">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-8 col-md-10">
        <div class="card-box p-4 text-center">
          <i class="fa fa-check-circle" style="font-size:64px;color:#10c469"></i>
          <h3 class="mt-3">Your request has been submitted</h3>
          <p class="mb-1">Status: <strong>{{ strtoupper($request->status) }}</strong></p>
          <p class="text-muted">Our team will review your requirements and get back with the finalized plan and payment details.</p>
          <a href="{{ url('custom-plan/requests') }}" class="btn vfx7 mt-2">Go to My Custom Plan Requests</a>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection
