@extends('site_app')

@section('head_title', 'Compare Properties - '.getcong('site_name'))
@section('head_url', Request::url())

@section('content')
  <!--Breadcrumb section starts-->
  <div class="breadcrumb-section bg-xs" style="background-image: url({{ URL::asset('site_assets/images/breadcrumb-1.jpg') }})">
    <div class="overlay op-2"></div>
    <div class="container">
      <div class="row">
        <div class="col-md-8 offset-md-2 text-center">
          <div class="breadcrumb-menu">
            <h2>Compare Properties</h2>
            <span><a href="{{ URL::to('/') }}" title="{{trans('words.home')}}">{{trans('words.home')}}</a></span> <span>Compare</span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!--Breadcrumb section ends-->
<div class="container py-4">
  <div class="row">
    <div class="col-12 d-flex align-items-center justify-content-between mb-3">
      <h3 class="mb-0">Compare Properties</h3>
      <a href="{{ url('properties') }}" class="btn btn-outline-secondary btn-sm">
        <i class="fa fa-arrow-left"></i> Back to Listings
      </a>
    </div>
  </div>

  @php
    $cols = max(2, min(4, $properties->count()));
  @endphp

  <div class="comparison-wrapper">
    <div class="table-responsive">
      <table class="table table-bordered table-compare">
        <tbody>
          <tr class="compare-row compare-images">
            <th class="compare-label">Property</th>
            @foreach($properties as $p)
              <td class="text-center">
                <a href="{{ url('properties/'.$p->slug.'/'.$p->id) }}" target="_blank" class="d-inline-block mb-2">
                  <img src="{{ asset('/'.ltrim($p->image,'/')) }}" alt="{{ $p->title }}" class="img-fluid rounded" style="max-height:140px;object-fit:cover;">
                </a>
                <div class="fw-bold">{{ $p->title }}</div>
                <div class="text-muted small">
                  {{ $p->locations ? $p->locations->name : \Illuminate\Support\Str::limit($p->address, 42) }}
                </div>
              </td>
            @endforeach
          </tr>

          <tr class="compare-row">
            <th class="compare-label">Price</th>
            @foreach($properties as $p)
              <td><strong>{{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($p->price) }}</strong></td>
            @endforeach
          </tr>

          <tr class="compare-row">
            <th class="compare-label">Purpose</th>
            @foreach($properties as $p)
              <td>
                @if($p->purpose === 'Rent')
                  <span class="badge bg-success">Rent</span>
                @else
                  <span class="badge bg-primary">Sale</span>
                @endif
              </td>
            @endforeach
          </tr>

          <tr class="compare-row">
            <th class="compare-label">Type</th>
            @foreach($properties as $p)
              <td>{{ $p->types ? $p->types->type_name : '-' }}</td>
            @endforeach
          </tr>

          <tr class="compare-row">
            <th class="compare-label">Bedrooms</th>
            @foreach($properties as $p)
              <td>{{ $p->bedrooms ?? '-' }}</td>
            @endforeach
          </tr>

          <tr class="compare-row">
            <th class="compare-label">Bathrooms</th>
            @foreach($properties as $p)
              <td>{{ $p->bathrooms ?? '-' }}</td>
            @endforeach
          </tr>

          <tr class="compare-row">
            <th class="compare-label">Area (sq ft)</th>
            @foreach($properties as $p)
              <td>{{ $p->area ?? '-' }}</td>
            @endforeach
          </tr>

          <tr class="compare-row">
            <th class="compare-label">Furnishing</th>
            @foreach($properties as $p)
              <td>{{ $p->furnishing ?? 'Not specified' }}</td>
            @endforeach
          </tr>

          <tr class="compare-row">
            <th class="compare-label">Verified</th>
            @foreach($properties as $p)
              <td>
                @if($p->verified == 'YES' || $p->verified == 1)
                  <span class="badge bg-success"><i class="fa fa-check"></i> Verified</span>
                @else
                  <span class="badge bg-secondary">No</span>
                @endif
              </td>
            @endforeach
          </tr>

          <tr class="compare-row">
            <th class="compare-label">Agent</th>
            @foreach($properties as $p)
              <td>
                @if($p->users)
                  <div class="d-flex align-items-center gap-2">
                    @if($p->users->user_image)
                      <img src="{{ asset('/upload/'.$p->users->user_image) }}" alt="{{ $p->users->name }}" class="rounded-circle" style="width:28px;height:28px;object-fit:cover;">
                    @endif
                    <span>{{ $p->users->name }}</span>
                  </div>
                @else
                  -
                @endif
              </td>
            @endforeach
          </tr>

          <tr class="compare-row">
            <th class="compare-label">Actions</th>
            @foreach($properties as $p)
              <td>
                <div class="d-flex gap-2">
                  <a href="{{ url('properties/'.$p->slug.'/'.$p->id) }}" target="_blank" class="btn btn-primary btn-sm"><i class="fa fa-eye"></i> View</a>
                  @if(!empty($p->users->phone))
                    <a href="tel:{{ $p->users->phone }}" class="btn btn-outline-primary btn-sm"><i class="fa fa-phone"></i> Contact</a>
                  @endif
                </div>
              </td>
            @endforeach
          </tr>
        </tbody>
      </table>
    </div>
  </div>
</div>
@endsection

@push('styles')
<style>
  .table-compare { background: #fff; border-radius: 12px; overflow: hidden; }
  .table-compare .compare-label { width: 180px; background: #f7f9fc; font-weight: 600; vertical-align: middle; }
  .table-compare .compare-row td { vertical-align: middle; }
  .table-compare .badge { font-weight: 600; }
</style>
@endpush
