@extends('site_app')

@section('head_title', stripslashes($property_info->title) . ' - ' . getcong('site_name'))

@section('head_description', Str::limit(stripslashes($property_info->description), 160))

@section('head_image', URL::to('/' . $property_info->image))

@section('head_url', Request::url())

@section('content')

    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Product",
        "name": "{{stripslashes($property_info->title)}}",
        "description": "{{Str::limit(stripslashes(strip_tags($property_info->description)),155)}}",
        "sku": "{{$property_info->reference_number}}",
        "image":[
            @foreach($gallery_images as $gallery_img)
                "{{\URL::to('/'.$gallery_img->image)}}",
            @endforeach
            "{{\URL::to('/'.$property_info->image)}}"
        ],
        "offers": {
            "@type": "Offer",
            "priceCurrency": "{{getcong('currency_code')}}",
            "price": "{{$property_info->price}}",
            "availability": "https://schema.org/InStock",
            "url": "{{ URL::to('properties/'.$property_info->slug.'/'.$property_info->id) }}"
             
        },
        "additionalProperty": [
            {
                "@type": "PropertyValue",
                "name": "Bedrooms",
                "value": "{{$property_info->bedrooms}}"
            },
            {
                "@type": "PropertyValue",
                "name": "Bathrooms",
                "value": "{{$property_info->bathrooms}}"
            },
            {
                "@type": "PropertyValue",
                "name": "Total Area",
                "value": "{{$property_info->area}}"
            }
        ],
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "{{stripslashes($property_info->address)}}",
            "addressLocality": "{{get_location_info($property_info->location_id,'name')}}"
        }
    }
    </script>

    <!--Breadcrumb section starts-->
    <div class="breadcrumb-section bg-xs"
        style="background-image: url({{ URL::asset('site_assets/images/breadcrumb-1.jpg') }})">
        <div class="overlay op-2"></div>
        <div class="container">
            <div class="row">
                <div class="col-md-8 offset-md-2 text-center">
                    <div class="breadcrumb-menu">
                        <h2>{{ trans('words.property_text') }} </h2>
                        <span><a href="{{ URL::to('/') }}"
                                title="{{ trans('words.home') }}">{{ trans('words.home') }}</a></span>
                        <span>{{ trans('words.property_text') }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Breadcrumb section ends-->


    {{-- <div class="property-details-wrap bg-cb mt-70"> --}}
    <div class="property-details-wrap bg-cb">

        @if (get_web_banner('details_top') != '')
            <div class="add_banner_section pb-0">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                            {!! stripslashes(get_web_banner('details_top')) !!}
                        </div>
                    </div>
                </div>
            </div>
        @endif


        <!--Listing Details Info starts-->
        <div class="single-property-details vfx1">
            <div class="container">
                <div class="row">
                    <div class="col-xl-8 col-lg-12">
                        <div class="single-property-header mt-30">

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="property_poster_item">
                                        <div id="gallery" class="list-details-section">
                                            <style>
                                            /* Gallery / thumbnails layout fixes */
                                            #carousel-thumb { position: relative; z-index: 1; }
                                            #carousel-thumb .carousel-inner img { max-height: 480px; object-fit: cover; }
                                            #carousel-thumb .list-gallery-thumb { position: static; display:flex; gap:8px; margin-top:10px; padding-left:0; list-style:none; justify-content:flex-start; }
                                            #carousel-thumb .list-gallery-thumb li { width: 100px; cursor:pointer; overflow:hidden; border-radius:4px; }
                                            #carousel-thumb .list-gallery-thumb li img { width:100%; height:60px; object-fit:cover; display:block; opacity:0.95; }
                                            .list-details-title { position: relative; z-index: 3; }
                                            .property_poster_item { margin-bottom: 10px; }
                                            /* Ensure price box and share buttons appear above thumbnails */
                                            .single-listing-title .vfx-trend-open-price, .single-listing-title .btn-group { position: relative; z-index: 4; }
                                            @media (max-width: 767px) { #carousel-thumb .list-gallery-thumb { overflow-x:auto; } #carousel-thumb .list-gallery-thumb li { flex: 0 0 auto; width:80px; } }
                                            </style>
                                            <!--Carousel Wrapper-->
                                            <div id="carousel-thumb"
                                                class="carousel slide carousel-fade carousel-thumbnails list-gallery pt-2"
                                                data-ride="carousel">
                                                @php
                                                    // Build an ordered list of images: featured image first, then gallery images without duplicates
                                                    $images = [];
                                                    if (!empty($property_info->image)) {
                                                        $images[] = $property_info->image;
                                                    }
                                                    if (isset($gallery_images) && count($gallery_images) > 0) {
                                                        foreach ($gallery_images as $g) {
                                                            $imgPath = is_object($g) ? $g->image : $g;
                                                            if ($imgPath && $imgPath != $property_info->image) {
                                                                $images[] = $imgPath;
                                                            }
                                                        }
                                                    }
                                                @endphp
                                                <!--Slides-->
                                                <div class="carousel-inner" role="listbox">

                                                    @foreach ($images as $i => $img)
                                                        <div class="carousel-item @if ($i == 0) active @endif">
                                                            <img class="d-block w-100" src="{{ url('/' . $img) }}" alt="slide" title="gallery image">
                                                        </div>
                                                    @endforeach

                                                </div>
                                                <!--Controls starts-->
                                                <a class="carousel-control-prev" href="javascript:void(0)" role="button"
                                                    data-slide="prev" data-target="#carousel-thumb" title="prev"> <span class="lnr lnr-arrow-left"
                                                        aria-hidden="true"></span> <span class="sr-only">Previous</span>
                                                </a>
                                                <a class="carousel-control-next" href="javascript:void(0)" role="button"
                                                    data-slide="next" data-target="#carousel-thumb" title="next"> <span class="lnr lnr-arrow-right"
                                                        aria-hidden="true"></span> <span class="sr-only">Next</span> </a>
                                                <!--Controls ends-->
                                                <ol class="carousel-indicators list-gallery-thumb">
                                                    @foreach ($images as $i => $img)
                                                        <li role="button" aria-label="Slide {{ $i + 1 }}" data-target="#carousel-thumb"
                                                            data-slide-to="{{ $i }}" class="@if($i==0) active @endif">
                                                            <img class="img-fluid d-block w-100" src="{{ url('/' . $img) }}" alt="gallery image" title="{{ stripslashes($property_info->title) }}">
                                                        </li>
                                                    @endforeach

                                                </ol>
                                            </div>
                                            <!--/.Carousel Wrapper-->
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>



                        <div class="list-details-title vfx1">

                            <div class="row align-items-center">
                                <div class="col-lg-9 col-md-8 col-sm-12">
                                    <div class="single-listing-title">
                                        <h2 class="mb-2 font-weight-bold text-dark">
                                            <a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                               title="{{ stripslashes($property_info->title) }}"
                                               class="text-dark">
                                                {{ stripslashes($property_info->title) }}
                                            </a>
                                            @if ($property_info->purpose == 'Rent')
                                                <span class="badge badge-info ml-2">{{ trans('words.rent') }}</span>
                                            @else
                                                <span class="badge badge-success ml-2">{{ trans('words.sale') }}</span>
                                            @endif
                                            @if ($property_info->verified == 'YES')
                                                <span class="ml-2" data-toggle="tooltip" title="{{ trans('words.verified') }}">
                                                    <i class="fa fa-check text-success"></i>
                                                </span>
                                            @endif
                                        </h2>
                                        <p class="mb-2">
                                            <a href="{{ URL::to('properties/location/' . get_location_info($property_info->location_id, 'slug')) }}"
                                               title="{{ get_location_info($property_info->location_id, 'name') }}"
                                               class="text-muted">
                                                <i class="fa fa-map-marker"></i>
                                                @if (get_location_info($property_info->location_id, 'name') != '')
                                                    {{ get_location_info($property_info->location_id, 'name') }}
                                                @else
                                                    {{ stripslashes($property_info->address) }}
                                                @endif
                                            </a>
                                        </p>
                                        <div class="d-flex flex-wrap align-items-center mb-2 gap-2">
                                            <button class="btn btn-modern" id="btn-view-number" data-action="view_number">
                                                <i class="fa fa-phone mr-1"></i> {{ __('View Phone Number') }}
                                            </button>
                                            <button class="btn btn-modern" id="btn-download-brochure" data-action="download_brochure">
                                                <i class="fa fa-file-pdf-o mr-1"></i> {{ __('Download Brochure') }}
                                            </button>
                                            <div class="btn-group btn-group-modern" role="group" aria-label="Share">
                                                <button class="btn btn-modern" id="btn-copy-link" title="Copy link">
                                                    <i class="fa fa-link"></i>
                                                </button>
                                                <a class="btn btn-modern" id="share-facebook" target="_blank" title="Share on Facebook">
                                                    <i class="fa fa-facebook"></i>
                                                </a>
                                                <a class="btn btn-modern" id="share-twitter" target="_blank" title="Share on Twitter">
                                                    <i class="fa fa-twitter"></i>
                                                </a>
                                                <a class="btn btn-modern" id="share-whatsapp" target="_blank" title="Share on WhatsApp">
                                                    <i class="fa fa-whatsapp"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-4 col-sm-12 text-lg-right text-md-right text-sm-left mt-3 mt-md-0 d-flex justify-content-lg-end justify-content-md-end justify-content-sm-start align-items-start">
                                    <button class="btn btn-modern price-btn" style="margin-top:0;">
                                        {{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($property_info->price) }}
                                    </button>
                                </div>
                            </div>
                            <style>
                                .btn-modern {
                                    border-radius: 24px !important;
                                    font-weight: 500;
                                    box-shadow: 0 2px 8px rgba(220,53,69,0.08);
                                    transition: background 0.2s, box-shadow 0.2s;
                                    padding: 0.5rem 1.25rem;
                                    font-size: 1rem;
                                    border: none;
                                    background: linear-gradient(90deg, #dc3545 80%, #b71c1c 100%);
                                    color: #fff !important;
                                    margin-right: 8px;
                                    margin-bottom: 8px;
                                    display: inline-flex;
                                    align-items: center;
                                }
                                .btn-modern:last-child {
                                    margin-right: 0;
                                }
                                .btn-modern:hover, .btn-modern:focus {
                                    background: linear-gradient(90deg, #b71c1c 80%, #dc3545 100%);
                                    box-shadow: 0 4px 16px rgba(220,53,69,0.18);
                                    color: #fff !important;
                                }
                                .btn-group-modern .btn-modern {
                                    margin-right: 4px;
                                }
                                .btn-group-modern .btn-modern:last-child {
                                    margin-right: 0;
                                }
                                .gap-2 {
                                    gap: 0.5rem;
                                }
                                .price-btn {
                                    font-size: 1.25rem;
                                    font-weight: bold;
                                    border: 1px solid red;
                                    background: linear-gradient(90deg, #dc3545 80%, #b71c1c 100%);
                                    color: #fff !important;
                                    box-shadow: 0 2px 8px rgba(220,53,69,0.12);
                                    margin-bottom: 0;
                                    margin-right: 0;
                                    border-radius: 24px !important;
                                    white-space: nowrap;
                                }
                                @media (max-width: 991px) {
                                    .single-listing-title h2 {
                                        font-size: 1.25rem;
                                    }
                                    .price-btn {
                                        font-size: 1.1rem;
                                        padding: 0.5rem 1.2rem;
                                    }
                                }
                                @media (max-width: 767px) {
                                    .single-listing-title h2 {
                                        font-size: 1rem;
                                    }
                                    .btn-modern {
                                        font-size: 0.95rem;
                                        padding: 0.4rem 1rem;
                                    }
                                    .price-btn {
                                        font-size: 1rem;
                                        padding: 0.4rem 1rem;
                                    }
                                }
                            </style>

                        </div>

                        <div class="listing-desc-wrap">
                            <div class="list-details-wrap">
                                <div id="description" class="list-details-section">
                                    <h4>{{ trans('words.property_info') }}</h4>
                                    <div class="overview-content">
                                        <p class="mb-10">{!! stripslashes($property_info->description) !!}</p>

                                        <p class="mt-30"><b>{{ trans('words.address') }}</b> :
                                            {{ stripslashes($property_info->address) }}
                                        </p>
                                    </div>
                                    <div class="list-details-section">
                                        <h4>{{ trans('words.property_details') }}</h4>
                                        <ul class="property-info">
                                            <li>{{ trans('words.type') }} :
                                                <span>{{ get_type_info($property_info->type_id, 'type_name') }}</span></li>
                                            <li>{{ trans('words.purpose') }} : <span>{{ $property_info->purpose }}</span>
                                            </li>
                                            <li data-toggle="tooltip" data-placement="top"
                                                title="{{ trans('words.reference_number') }}">
                                                {{ trans('words.reference_number') }}:
                                                <span>{{ $property_info->reference_number }}</span></li>
                                            <li data-toggle="tooltip" data-placement="top"
                                                title="{{ trans('words.bedrooms') }}">{{ trans('words.bedrooms') }}:
                                                <span>{{ $property_info->bedrooms }}</span></li>
                                            <li data-toggle="tooltip" data-placement="top"
                                                title="{{ trans('words.bathrooms') }}">{{ trans('words.bathrooms') }}:
                                                <span>{{ $property_info->bathrooms }}</span></li>
                                            <li data-toggle="tooltip" data-placement="top"
                                                title="{{ trans('words.area') }}">{{ trans('words.area') }}:
                                                <span>{{ $property_info->area }}</span></li>
                                            <li data-toggle="tooltip" data-placement="top"
                                                title="{{ trans('words.furnishing') }}">{{ trans('words.furnishing') }}:
                                                <span>{{ $property_info->furnishing }}</span></li>
                                        </ul>
                                    </div>
                                    <div class="list-details-section">
                                        <h4>{{ trans('words.amenities') }}</h4>
                                        <ul class="listing-features">
                                            @foreach (explode(',', $property_info->amenities) as $amenities)
                                                <li><i class="fa fa-angle-right"></i>{{ $amenities }}</li>
                                            @endforeach

                                        </ul>
                                    </div>
                                    <div id="floor_plan" class="list-details-section">
                                        <h4>{{ trans('words.floor_plan_image') }}</h4>
                                        <div class="list-gallery pt-2">
                                            <img class="d-block w-100" src="{{ url('/' . $property_info->floor_plan_image) }}"
                                                alt="slide" title="floor plan">
                                        </div>
                                    </div>
                                    <div class="list-details-section">
                                        <h4>Video</h4>
                                        <div class="embed-responsive embed-responsive-16by9">
                                            @php
                                                // Robust YouTube ID extraction.
                                                $youtube = trim($property_info->youtube_link ?? '');
                                                $youtube_id = null;
                                                if (!empty($youtube)) {
                                                    // If user supplied just an 11-char id
                                                    if (preg_match('/^[a-zA-Z0-9_-]{11}$/', $youtube)) {
                                                        $youtube_id = $youtube;
                                                    } else {
                                                        // Ensure scheme present for parse_url
                                                        $urlForParse = $youtube;
                                                        if (!preg_match('#^https?://#i', $urlForParse)) {
                                                            $urlForParse = 'https://' . ltrim($urlForParse, '/');
                                                        }
                                                        $parts = parse_url($urlForParse);
                                                        // If query has v parameter
                                                        if (!empty($parts['query'])) {
                                                            parse_str($parts['query'], $qs);
                                                            if (!empty($qs['v']) && preg_match('/^[a-zA-Z0-9_-]{11}$/', $qs['v'])) {
                                                                $youtube_id = $qs['v'];
                                                            }
                                                        }
                                                        // youtu.be short link or embed path
                                                        if (empty($youtube_id) && !empty($parts['host'])) {
                                                            if (strpos($parts['host'], 'youtu.be') !== false) {
                                                                $path = trim($parts['path'] ?? '', '/');
                                                                if (preg_match('/^[a-zA-Z0-9_-]{11}$/', $path)) {
                                                                    $youtube_id = $path;
                                                                }
                                                            }
                                                            // embed or /v/ style
                                                            if (empty($youtube_id) && !empty($parts['path'])) {
                                                                if (preg_match('/(?:embed|v)\/([A-Za-z0-9_-]{11})/', $parts['path'], $m)) {
                                                                    $youtube_id = $m[1];
                                                                }
                                                            }
                                                        }
                                                        // Last resort: regex across the whole string
                                                        if (empty($youtube_id)) {
                                                            if (preg_match('/(?:youtube(?:-nocookie)?\.com\/(?:.*v=|embed\/|v\/)|youtu\.be\/)([A-Za-z0-9_-]{11})/i', $youtube, $m2)) {
                                                                $youtube_id = $m2[1];
                                                            }
                                                        }
                                                    }
                                                }
                                            @endphp
                                            @if($youtube_id)
                                                <iframe class="embed-responsive-item" src="https://www.youtube.com/embed/{{ $youtube_id }}" allowfullscreen></iframe>
                                            @elseif(!empty($youtube))
                                                <p><a href="{{ $youtube }}" target="_blank">View Video</a></p>
                                            @else
                                                <div style="background:#e0e0e0;display:flex;align-items:center;justify-content:center;height:350px;border-radius:8px;">
                                                    <span style="color:#888;font-size:22px;">No video available</span>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <style>
                                    .embed-responsive-16by9::before {
                                        padding-top: 0;
                                    }
                                    </style>
                                   

                                    <div class="mt-40">
                                        <h4 class="list-subtitle">{{ trans('words.location') }}</h4>

                                        <ul class="listing-address">
                                            <iframe width="750" height="350" frameborder="0" scrolling="no"
                                                marginheight="0" marginwidth="0"
                                                src="https://maps.google.com/maps?q={{ $property_info->latitude }},{{ $property_info->longitude }}&hl=es&z=14&amp;output=embed">
                                            </iframe>
                                            <li class="mt-2"><a
                                                    href="https://maps.google.com/maps?q={{ $property_info->latitude }},{{ $property_info->longitude }}&hl=en&z=14&amp;output=embed"
                                                    target="_blank" class="btn vfx5"
                                                    title="{{ trans('words.view_on_map') }}">View On Map</a></li>
                                        </ul>
                                    </div>
                                    
                                </div>
                                <div class="list-details-section">
                                    <h4>{{ trans('words.calculators') }}</h4>
                                    <div class="row">
                                        <!-- Mortgage Calculator -->
                                        <div class="col-md-6">
                                            <h5>{{ trans('words.mortgage_calculator') }}</h5>
                                            <div class="form-group">
                                                <label for="mortgage_price">{{ trans('words.property_price') }}</label>
                                                <input type="number" class="form-control" id="mortgage_price"
                                                    value="{{ $property_info->price }}">
                                            </div>
                                            <div class="form-group">
                                                <label for="down_payment">{{ trans('words.down_payment') }}</label>
                                                <input type="number" class="form-control" id="down_payment"
                                                    value="0">
                                            </div>
                                            <div class="form-group">
                                                <label for="loan_term">{{ trans('words.loan_term') }}</label>
                                                <select class="form-control" id="loan_term">
                                                    <option value="15">15 {{ trans('words.years') }}</option>
                                                    <option value="20">20 {{ trans('words.years') }}</option>
                                                    <option value="30">30 {{ trans('words.years') }}</option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label for="interest_rate">{{ trans('words.interest_rate') }}</label>
                                                <input type="number" class="form-control" id="interest_rate"
                                                    value="4.5" step="0.01">
                                            </div>
                                            <h4 class="mt-3">{{ trans('words.monthly_payment') }}: <span
                                                    id="monthly_payment">0.00</span></h4>
                                        </div>

                                        <!-- Rental Yield Calculator -->
                                        <div class="col-md-6">
                                            <h5>{{ trans('words.rental_yield_calculator') }}</h5>
                                            <div class="form-group">
                                                <label for="rental_price">{{ trans('words.property_price') }}</label>
                                                <input type="number" class="form-control" id="rental_price"
                                                    value="{{ $property_info->price }}">
                                            </div>
                                            <div class="form-group">
                                                <label
                                                    for="rental_income">{{ trans('words.rental_income_monthly') }}</label>
                                                <input type="number" class="form-control" id="rental_income"
                                                    value="0">
                                            </div>
                                            <div class="form-group">
                                                <label for="annual_expenses">{{ trans('words.annual_expenses') }}</label>
                                                <input type="number" class="form-control" id="annual_expenses"
                                                    value="0">
                                            </div>
                                            <h4 class="mt-3">{{ trans('words.gross_rental_yield') }}: <span
                                                    id="gross_rental_yield">0.00%</span></h4>
                                            <h4>{{ trans('words.net_rental_yield') }}: <span
                                                    id="net_rental_yield">0.00%</span></h4>
                                        </div>
                                    </div>
                                    <script>
                                        function calculateMortgage() {
                                            var price = parseFloat(document.getElementById('mortgage_price').value);
                                            var downPayment = parseFloat(document.getElementById('down_payment').value);
                                            var loanTerm = parseFloat(document.getElementById('loan_term').value);
                                            var interestRate = parseFloat(document.getElementById('interest_rate').value);

                                            var principal = price - downPayment;
                                            var monthlyInterestRate = (interestRate / 100) / 12;
                                            var numberOfPayments = loanTerm * 12;

                                            if (monthlyInterestRate === 0) {
                                                var monthlyPayment = principal / numberOfPayments;
                                            } else {
                                                var monthlyPayment = principal * (monthlyInterestRate * Math.pow(1 + monthlyInterestRate,
                                                    numberOfPayments)) / (Math.pow(1 + monthlyInterestRate, numberOfPayments) - 1);
                                            }
                                            document.getElementById('monthly_payment').innerText = monthlyPayment.toFixed(2);
                                        }

                                        function calculateRentalYield() {
                                            var price = parseFloat(document.getElementById('rental_price').value);
                                            var rentalIncomeMonthly = parseFloat(document.getElementById('rental_income').value);
                                            var annualExpenses = parseFloat(document.getElementById('annual_expenses').value);

                                            var annualRentalIncome = rentalIncomeMonthly * 12;
                                            var netAnnualRentalIncome = annualRentalIncome - annualExpenses;

                                            var grossYield = (annualRentalIncome / price) * 100;
                                            var netYield = (netAnnualRentalIncome / price) * 100;

                                            document.getElementById('gross_rental_yield').innerText = grossYield.toFixed(2) + '% ';
                                            document.getElementById('net_rental_yield').innerText = netYield.toFixed(2) + '% ';
                                        }

                                        // Mortgage Calculator Event Listeners
                                        document.getElementById('mortgage_price').addEventListener('input', calculateMortgage);
                                        document.getElementById('down_payment').addEventListener('input', calculateMortgage);
                                        document.getElementById('loan_term').addEventListener('change', calculateMortgage);
                                        document.getElementById('interest_rate').addEventListener('input', calculateMortgage);

                                        // Rental Yield Calculator Event Listeners
                                        document.getElementById('rental_price').addEventListener('input', calculateRentalYield);
                                        document.getElementById('rental_income').addEventListener('input', calculateRentalYield);
                                        document.getElementById('annual_expenses').addEventListener('input', calculateRentalYield);

                                        // Initial calculation on page load
                                        calculateMortgage();
                                        calculateRentalYield();
                                    </script>
                                </div>
                               

                            </div>
                        </div>
                    </div>
                    @include('pages.sidebar_right')
                </div>
            </div>
        </div>
        <!--Listing Details Info ends-->
        <script>
            document.addEventListener('DOMContentLoaded', function(){
                const pageUrl = encodeURIComponent(window.location.href);
                const title = encodeURIComponent(document.title);

                const fb = document.getElementById('share-facebook');
                const tw = document.getElementById('share-twitter');
                const wa = document.getElementById('share-whatsapp');
                const copyBtn = document.getElementById('btn-copy-link');

                if(fb) fb.href = `https://www.facebook.com/sharer/sharer.php?u=${pageUrl}`;
                if(tw) tw.href = `https://twitter.com/intent/tweet?text=${title}&url=${pageUrl}`;
                if(wa) wa.href = `https://api.whatsapp.com/send?text=${title}%20${pageUrl}`;

                if(copyBtn){
                    copyBtn.addEventListener('click', function(){
                        navigator.clipboard.writeText(window.location.href).then(function(){
                            alert('Link copied to clipboard');
                        }, function(){
                            prompt('Copy the link', window.location.href);
                        });
                    });
                }
            });
        </script>

        <!--Similar Listing starts-->
        <div class="similar-listing-wrap bg-white pb-30 pt-10 mt-10">
            <div class="container">
                <div class="row">
                    <div class="col-12 px-0">
                        <div class="similar-listing">
                        <div class="section-title vfx2">
                            <h2>{{ trans('words.similar_properties') }}</h2>
                        </div>
                        <style>
                        /* Ensure similar listing cards align and images have fixed height */
                        .similar-list-wrap .vfx-single-property-box-area { height: 100%; display:flex; flex-direction:column; }
                        .similar-list-wrap .vfx-property-img img { width:100%; height:180px; object-fit:cover; border-radius:4px; }
                        .similar-list-wrap .vfx-property-title-box-area { margin-top:8px; }
                        @media (max-width:767px) { .similar-list-wrap .vfx-property-img img { height:120px; } }
                        </style>
                        <div class="swiper-container similar-list-wrap">
                            <div class="swiper-wrapper">

                                @foreach ($related_list as $related)
                                    <div class="swiper-slide">
                                        <div class="vfx-single-property-box-area">
                                            <div class="vfx-property-item"> <a class="vfx-property-img"
                                                    href="{{ URL::to('properties/' . $related->slug . '/' . $related->id) }}"
                                                    title="{{ stripslashes($related->title) }}"><img
                                                        src="{{ \URL::to('/' . $related->image) }}"
                                                        alt="{{ stripslashes($related->title) }}"
                                                        title="{{ stripslashes($related->title) }}"> </a>
                                                <ul class="vfx-feature-text">
                                                    @if ($related->purpose == 'Rent')
                                                        <li class="feature_cb" data-toggle="tooltip" data-placement="top"
                                                            title="{{ trans('words.for_rent') }}">
                                                            <span>{{ trans('words.rent') }}</span></li>
                                                    @else
                                                        <li class="feature_or" data-toggle="tooltip" data-placement="top"
                                                            title="{{ trans('words.for_sale') }}">
                                                            <span>{{ trans('words.sale') }}</span></li>
                                                    @endif

                                                    @if ($related->verified == 'YES')
                                                        <li class="feature_cb verified_item" data-toggle="tooltip"
                                                            data-placement="top" title=""
                                                            data-original-title="{{ trans('words.verified') }}"><i
                                                                class="fa fa-check"></i></li>
                                                    @endif
                                                </ul>
                                                <div class="vfx-property-author-wrap">
                                                    <p class="text-tlt" data-toggle="tooltip" data-placement="top"
                                                        title="{{ get_type_info($related->type_id, 'type_name') }}">
                                                        {{ get_type_info($related->type_id, 'type_name') }}</p>
                                                    <ul class="vfx-save-btn">

                                                        <li data-toggle="tooltip" data-placement="top"
                                                            title="{{ trans('words.add_to_favourite') }}"
                                                            class="favourite_property favourite_title_id{{ $related->id }}"
                                                            data-id="{{ $related->id }}">
                                                            @if (check_favourite('Property', $related->id, isset(Auth::user()->id) ? Auth::user()->id : ''))
                                                                <a href="Javascript:void(0);" title="fav"><i
                                                                        class="fa fa-heart favourite_icon_id{{ $related->id }}"></i></a>
                                                            @else
                                                                <a href="Javascript:void(0);" title="fav"><i
                                                                        class="fa fa-heart-o favourite_icon_id{{ $related->id }}"></i></a>
                                                            @endif
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="vfx-property-title-box-area">
                                                <h4><a href="{{ URL::to('properties/' . $related->slug . '/' . $related->id) }}"
                                                        title="{{ stripslashes($related->title) }}">{{ Str::limit(stripslashes($related->title), 25) }}</a>
                                                </h4>
                                                <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                                    <p>
                                                        @if (get_location_info($related->location_id, 'name') != '')
                                                            {{ get_location_info($related->location_id, 'name') }}
                                                        @else
                                                            {{ Str::limit(stripslashes($related->address), 40) }}
                                                        @endif
                                                    </p>
                                                </div>
                                                <div class="trending-bottom">
                                                    <div class="trend-left float-left">
                                                        <div class="vfx-property-author-wrap"> <a
                                                                href="{{ URL::to('properties/owner/' . $related->user_id) }}"
                                                                class="property-author" title="User">
                                                                @if (file_exists(URL::to('upload/' . get_user_info($related->user_id, 'user_image'))))
                                                                    <img src="{{ \URL::to('upload/' . get_user_info($related->user_id, 'user_image')) }}"
                                                                        alt="image" title="image user">
                                                                @else
                                                                    <img src="{{ \URL::to('site_assets/images/user-default.jpg') }}"
                                                                        alt="image" title="image user">
                                                                @endif
                                                                <span>{{ get_user_info($related->user_id, 'name') }}</span>
                                                            </a></div>
                                                    </div>
                                                    <a href="{{ URL::to('properties/' . $related->slug . '/' . $related->id) }}"
                                                        class="vfx-trend-right float-right"
                                                        title="{{ stripslashes($related->title) }}">
                                                        <div class="vfx-trend-open-price">
                                                            {{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($related->price) }}
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach



                            </div>
                        </div>
                        <div class="slider-btn vfx2 similar-next"><i class="lnr lnr-arrow-right"></i></div>
                        <div class="slider-btn vfx2 similar-prev"><i class="lnr lnr-arrow-left"></i></div>
                    </div>
                </div>
                    </div>
                </div>
            </div>


            @if (get_web_banner('details_bottom') != '')
                <div class="add_banner_section pb-0">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                {!! stripslashes(get_web_banner('details_bottom')) !!}
                            </div>
                        </div>
                    </div>
                </div>
            @endif

        </div>
        <!--Similar Listing ends-->


    </div>
    </div>
    <!--Page Wrapper ends-->


    <!-- Reports Modal Starts -->
    <div class="modal fade" id="vfx-report-popup">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-dark">{{ trans('words.reports_property') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true"><i class="lnr lnr-cross"></i></span></button>
                </div>
                    <div class="modal-body pl-0 pr-0">
                    <div class="container">
                        @php
                            // Extract YouTube video ID for property
                            $youtube = trim($property_info->youtube_link ?? '');
                            $youtube_id = null;
                            if (!empty($youtube)) {
                                if (preg_match('/^[a-zA-Z0-9_-]{11}$/', $youtube)) {
                                    $youtube_id = $youtube;
                                } elseif (preg_match('/(?:youtube(?:-nocookie)?\.com\/(?:.*v=|embed\/|v\/)|youtu\.be\/)([A-Za-z0-9_-]{11})/i', $youtube, $matches)) {
                                    $youtube_id = $matches[1];
                                }
                            }
                        @endphp

                        {{ html()->form('POST', url('/properties/report'))->attributes(['class' => 'form-horizontal', 'id' => 'report_form', 'name' => 'report_form', 'role' => 'form'])->open() }}
                        <input type="hidden" name="property_id" value="{{ $property_info->id }}">
                        <div class="form-control-wrap">
                            <div class="row">
                                <div class="col-lg-12 col-md-12">
                                    <div class="form-group">
                                        <textarea class="form-control" rows="3" name="report_text" id="report_text"
                                            placeholder="{{ trans('words.write_reason') }}"></textarea>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12">
                                    <div class="form-group mb-0">
                                        <button type="submit"
                                            class="btn vfx7 w-100">{{ trans('words.submit') }}</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{ html()->form()->close() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Reports Modal Ends -->

    <!-- Social Media Modal Starts -->
    <div class="modal fade" id="vfx-social-media-popup">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-dark">Social Media</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true"><i class="lnr lnr-cross"></i></span></button>
                </div>
                <div class="modal-body pt-4 pb-4">
                    <div class="vfx-user-login-section">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12">
                                    <ul class="vfx-social-button style1 text-center">
                                        <li><a href="https://www.facebook.com/sharer/sharer.php?u={{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                target="_blank" title="facebook"><i class="fa fa-facebook-f"></i></a>
                                        </li>
                                        <li><a href="https://twitter.com/intent/tweet?text={{ $property_info->title }}&amp;url={{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                target="_blank" title="twitter"><i class="fa fa-twitter"></i></a></li>
                                        <li><a href="https://wa.me?text={{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                target="_blank" title="whatsapp"><i class="fa fa-whatsapp"></i></a></li>
                                        <li><a href="https://www.instagram.com/?url={{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                target="_blank" title="instagram"><i class="fa fa-instagram"></i></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Social Media Modal Ends -->

    <!-- Compact Phone Popup (reusable) -->
    @include('partials.phone-popup', ['uid' => 'prop_' . $property_info->id, 'context' => 'property', 'property_id' => $property_info->id])

    <script>
        // Backward-compatible handlers: open compact popup for view number & brochure
        (function(){
            const uid = 'prop_{{ $property_info->id }}';
            const modalSelector = '#phonePopupModal_' + uid;

            function openPopupFor(action) {
                var actionInput = document.getElementById('phonePopup_action_' + uid);
                if (actionInput) actionInput.value = action;
                $(modalSelector).modal({backdrop:'static', keyboard:false});
                $(modalSelector).modal('show');
            }

            document.addEventListener('DOMContentLoaded', function(){
                var viewBtn = document.getElementById('btn-view-number');
                var downloadBtn = document.getElementById('btn-download-brochure');
                if (viewBtn) viewBtn.addEventListener('click', function(e){ e.preventDefault(); openPopupFor('view_number'); });
                if (downloadBtn) downloadBtn.addEventListener('click', function(e){ e.preventDefault(); openPopupFor('download_brochure'); });

                // Listen for reveal event from phone-popup.js and show modern popup
                window.addEventListener('phonePopupRevealed', function(ev){
                    const d = ev.detail || {};
                    if (!d || d.uid !== uid) return;
                    
                    // Handle brochure download if that was the requested action
                    if (d.action === 'download_brochure') {
                        if (d.reveal && d.reveal.brochure_url) {
                            // Show loading indicator
                            if (typeof Swal !== 'undefined') {
                                Swal.fire({
                                    title: 'Preparing Download',
                                    text: 'Please wait while we prepare your brochure...',
                                    allowOutsideClick: false,
                                    showConfirmButton: false,
                                    willOpen: () => {
                                        Swal.showLoading();
                                    }
                                });
                            }

                            // Attempt to download the brochure
                            fetch(d.reveal.brochure_url)
                                .then(response => response.blob())
                                .then(blob => {
                                    const url = window.URL.createObjectURL(blob);
                                    const link = document.createElement('a');
                                    link.href = url;
                                    link.download = 'property-brochure.pdf'; // or use a dynamic name
                                    document.body.appendChild(link);
                                    link.click();
                                    window.URL.revokeObjectURL(url);
                                    document.body.removeChild(link);
                                    
                                    if (typeof Swal !== 'undefined') {
                                        Swal.fire({
                                            icon: 'success',
                                            title: 'Download Started',
                                            text: 'Your brochure is being downloaded.',
                                            timer: 3000,
                                            timerProgressBar: true,
                                            showConfirmButton: false
                                        });
                                    }
                                })
                                .catch(error => {
                                    console.error('Brochure download error:', error);
                                    if (typeof Swal !== 'undefined') {
                                        Swal.fire({
                                            icon: 'error',
                                            title: 'Download Failed',
                                            text: 'Failed to download the brochure. Please try again.',
                                            showConfirmButton: true
                                        });
                                    }
                                });
                            return;
                        } else {
                            if (typeof Swal !== 'undefined') {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Brochure Unavailable',
                                    text: 'Sorry, the brochure is currently unavailable.',
                                    showConfirmButton: true
                                });
                            }
                            return;
                        }
                    }
                    
                    const sellerPhone = d.phone;
                    if (!sellerPhone) return;
                    if (typeof Swal !== 'undefined') {
                        Swal.fire({
                            title: 'Seller Phone',
                            html: '<div style="font-size:18px;margin-bottom:8px;">' + sellerPhone + '</div>',
                            showCancelButton: true,
                            confirmButtonText: 'Call',
                            cancelButtonText: 'Copy',
                            showCloseButton: true
                        }).then((res) => {
                            if (res.isConfirmed) { window.location.href = 'tel:' + sellerPhone; }
                            else if (res.isDismissed) { try { navigator.clipboard.writeText(sellerPhone); Swal.fire('Copied!', 'Phone number copied to clipboard', 'success'); } catch(e){ alert('Phone: ' + sellerPhone); } }
                        });
                    } else {
                        if (confirm('Seller Phone: ' + sellerPhone + '\n\nClick OK to copy.')) {
                            try { navigator.clipboard.writeText(sellerPhone); alert('Copied to clipboard'); } catch(e){ alert('Phone: ' + sellerPhone); }
                        }
                    }
                    // If reveal contains a brochure URL, open in new tab (download-friendly)
                    try {
                        const reveal = d.reveal || {};
                        if (reveal.brochure_url) {
                            // open brochure in new tab; browsers will handle download or display
                            window.open(reveal.brochure_url, '_blank');
                        }
                    } catch(err) { /* ignore */ }
                });
            });
        })();

        @php
            $errors_html = '';
            if (isset($errors) && is_object($errors) && method_exists($errors, 'all')) {
                    $errors_html = '<p>' . implode('<br/>', $errors->all()) . '</p>';
            }
        @endphp

        @if ($errors && is_object($errors) && $errors->any())
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                html: {!! json_encode($errors_html) !!},
                showConfirmButton: true,
                confirmButtonColor: '#10c469',
                background:"#1a2234",
                color:"#fff"
             });
        @endif
        </script>

@endsection

  <!-- legacy lead modal JS removed - replaced by compact phone popup component -->