<!-- Modern Filter Panel - Complete Integration -->
{!! html()->form('GET', url('/map/data'))
  ->attributes(['class' => 'modern-filter-panel compact', 'id' => 'map-filter-form', 'name' => 'map-filter-form'])->open() !!}

  <!-- Top Row: Location Search -->
  <div class="filter-top-row">
    <!-- Left: Location Search and GPS -->
    <div class="filters-location filter-top-left">
      <label for="location-search" class="mb-1 fw-semibold small text-muted">{{ __('Location or Address') }}</label>
      <div class="location-input-container">
        <i class="fa fa-map-marker location-icon" aria-hidden="true"></i>
        <input type="text" class="location-input" id="location-search" name="search" placeholder="{{ __('Search by area, city or address') }}" value="{{ request('search') }}" />
        <button type="button" id="use-gps" class="gps-button" title="{{ __('Use my location') }}" aria-label="{{ __('Use my location') }}">
          <i class="fa fa-crosshairs" aria-hidden="true"></i>
        </button>
      </div>
    </div>
    <!-- Right: Purpose Tabs -->
    <div class="filter-top-right">
      <label class="mb-1 fw-semibold small text-muted" for="purpose-input">{{ __('Purpose') }}</label>
      <div class="purpose-tabs purpose-tabs-row" role="tablist" aria-label="{{ __('Purpose') }}">
        <button type="button" class="purpose-tab @if(!isset($_GET['purpose']) || $_GET['purpose'] == 'Sale') active @endif" data-purpose="Sale" role="tab" aria-selected="@if(!isset($_GET['purpose']) || $_GET['purpose'] == 'Sale')true@else false @endif">
          <span class="tab-text">{{trans('words.sale')}}</span>
        </button>
        <button type="button" class="purpose-tab @if(isset($_GET['purpose']) && $_GET['purpose'] == 'Rent') active @endif" data-purpose="Rent" role="tab" aria-selected="@if(isset($_GET['purpose']) && $_GET['purpose'] == 'Rent')true@else false @endif">
          <span class="tab-text">{{trans('words.rent')}}</span>
        </button>
      </div>
      <input type="hidden" name="purpose" id="purpose-input" value="{{ request('purpose', 'Sale') }}">
    </div>
  </div>

  <!-- Second Row: Price Range and Radius -->
  <div class="filter-secondary-row">
    <div class="price-inline-control">
      <span class="radius-label">{{ trans('words.price_range') }}</span>
      <div id="price_range_slider" class="flex-grow-1 price-range noUi-touch-area"></div>
      <span id="price_value" class="radius-label"></span>
      <input type="hidden" id="price_range" name="price_range" value="{{ request('price_range') }}" />
    </div>
   
    <div class="radius-control">
      <span class="radius-label">{{ __('Radius') }}</span>
      <input type="range" id="search-radius" class="radius-slider" min="0" max="50" step="1" value="{{ request('radius', 0) }}" />
      <span id="radius-value" class="radius-label">{{ request('radius', 0) }} km</span>
      <input type="hidden" id="radius" name="radius" value="{{ request('radius', 0) }}" />
    </div>
  </div>
  
  <!-- Filter Dropdowns Row -->
  <div class="filter-dropdowns-row">
    <div class="filter-grid">
      <select name="type_id" id="map-property-type" class="filter-select">
        <option value="">{{trans('words.type')}}</option>
        @foreach(\App\Type::where('status', 1)->orderby('type_name')->get() as $type_data)
          <option value="{{$type_data->id}}" @if(request('type_id') == $type_data->id) selected @endif>
            {{$type_data->type_name}}
          </option>
        @endforeach
      </select>
      
      <select name="location_id" id="filter-location" class="filter-select">
        <option value="">{{trans('words.location')}}</option>
        @foreach(\App\Location::where('status', 1)->orderby('name')->get() as $location_data)
          <option value="{{$location_data->id}}" @if(request('location_id') == $location_data->id) selected @endif>
            {{$location_data->name}}
          </option>
        @endforeach
      </select>
      
      <select name="bedrooms" id="map-bedrooms" class="filter-select">
        <option value="">{{trans('words.bedrooms')}} : Any</option>
        <option value="1" @if(request('bedrooms') == '1') selected @endif>1</option>
        <option value="2" @if(request('bedrooms') == '2') selected @endif>2</option>
        <option value="3" @if(request('bedrooms') == '3') selected @endif>3</option>
        <option value="4" @if(request('bedrooms') == '4') selected @endif>4+</option>
      </select>

      <select name="bathrooms" id="map-bathrooms" class="filter-select">
        <option value="">{{trans('words.bathrooms')}} : Any</option>
        <option value="1" @if(request('bathrooms') == '1') selected @endif>1</option>
        <option value="2" @if(request('bathrooms') == '2') selected @endif>2</option>
        <option value="3" @if(request('bathrooms') == '3') selected @endif>3</option>
        <option value="4" @if(request('bathrooms') == '4') selected @endif>4+</option>
      </select>

      <select name="furnishing" id="filter-furnishing" class="filter-select">
        <option value="">{{trans('words.furnishing')}} : Any</option>
        <option value="Unfurnished" @if(request('furnishing') == 'Unfurnished') selected @endif>Unfurnished</option>
        <option value="Semi-Furnished" @if(request('furnishing') == 'Semi-Furnished') selected @endif>Semi-Furnished</option>
        <option value="Furnished" @if(request('furnishing') == 'Furnished') selected @endif>Furnished</option>
      </select>
      
      <!-- Verified input -->
      <select name="verified" id="filter-verified" class="filter-select">
        <option value="" selected>{{trans('words.verified')}} : Any</option>
        <option value="0" @if(request('verified') == 0)  @endif>No</option>
        <option value="1" @if(request('verified') == 1)  @endif>Yes</option>
      </select>

      <button type="submit" class="apply-filters-btn" aria-label="{{ trans('words.search_property') }}">
        <i class="fa fa-search me-1" aria-hidden="true"></i> {{ trans('words.search_property') }}
      </button>
      <button type="button" id="reset-filters" class="reset-btn" aria-label="{{ __('Reset filters') }}">
        <i class="fa fa-refresh me-1" aria-hidden="true"></i> {{ __('Reset') }}
      </button>
    </div>
  </div>

   
{!! html()->form()->close() !!}
