@extends('site_app')

@section('head_title', 'My Custom Plan Requests - '.getcong('site_name'))
@section('head_url', Request::url())

@section('content')

<div class="breadcrumb-section bg-xs" style="background-image: url({{ URL::asset('site_assets/images/breadcrumb-1.jpg') }})">
  <div class="overlay op-2"></div>
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <div class="breadcrumb-menu">
          <h2>My Custom Plan Requests</h2>
          <span><a href="{{ URL::to('/') }}">{{trans('words.home')}}</a></span> <span>My Custom Plan Requests</span>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="about-section pt-30 pb-30">
  <div class="container">
    <div class="row">
      <div class="col-12 mb-3">
        <a href="{{ url('custom-plan/request') }}" class="btn vfx7">Request Custom Plan</a>
      </div>
      <div class="col-12">
        <div class="table-wrapper">
          <table class="fl-table">
            <thead>
              <tr>
                <th>ID</th>
                <th>Requested</th>
                <th>Status</th>
                <th>Approved Details</th>
                <th>Payment</th>
                <th>Updated</th>
              </tr>
            </thead>
            <tbody>
              @forelse($requests as $req)
              <tr>
                <td>#{{ $req->id }}</td>
                <td>
                  <div>Property posts: <strong>{{ $req->property_posts_requested }}</strong></div>
                  <div>Ads posts: <strong>{{ $req->ads_posts_requested ?? '-' }}</strong></div>
                  @if($req->notes)
                  <div class="text-muted">{{ Str::limit($req->notes, 80) }}</div>
                  @endif
                </td>
                <td><span class="badge badge-info">{{ strtoupper($req->status) }}</span></td>
                <td>
                  @if($req->approved_price)
                    <div>Price: <strong>{{ number_format($req->approved_price,2) }}</strong></div>
                    <div>Validity: <strong>{{ $req->approved_validity_days }} days</strong></div>
                    <div>Limits: <strong>{{ $req->approved_property_limit }} props</strong> / <strong>{{ $req->approved_ads_limit ?? '-' }} ads</strong></div>
                  @else
                    —
                  @endif
                </td>
                <td>
                  @if($req->payment_preference==='online' && $req->status==='awaiting_payment' && $req->payment_link)
                    <a class="btn btn-sm btn-primary" href="{{ $req->payment_link }}">Pay Now</a>
                  @elseif($req->payment_preference==='cash' && in_array($req->status, ['approved']))
                    <span>Awaiting Cash</span>
                  @elseif(in_array($req->status, ['paid','activated']))
                    <span>Paid</span>
                  @else
                    —
                  @endif
                </td>
                <td>{{ optional($req->updated_at)->format('Y-m-d H:i') }}</td>
              </tr>
              @empty
              <tr>
                <td colspan="6" class="text-center">No custom plan requests yet.</td>
              </tr>
              @endforelse
            </tbody>
          </table>
        </div>
        <div class="post-nav nav-res pt-20">
          <div class="row">
            @include('_particles.pagination', ['paginator' => $requests])
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection
