@extends('site_app')

@section('head_title', trans('words.dashboard_text').' | '.getcong('site_name') )

@section('head_url', Request::url())

@section('content')
  

<!--Breadcrumb section starts-->
<div class="breadcrumb-section bg-xs" style="background-image: url({{ URL::asset('site_assets/images/breadcrumb-1.jpg') }})">
    <div class="overlay op-2"></div>
    <div class="container">
      <div class="row">
        <div class="col-md-12 text-center">
          <div class="breadcrumb-menu">
            <h2>{{trans('words.dashboard_text')}}</h2>
            <span><a href="{{ URL::to('/') }}">{{trans('words.home')}}</a></span> <span>{{trans('words.dashboard_text')}}</span></div>
        </div>
      </div>
    </div>
  </div>
  <!--Breadcrumb section ends--> 
  
  <!--Dashboard section starts-->
  <div class="about-section pt-30 pb-20">
    <div class="container">
      <div class="row">
         <div class="col-lg-12 col-md-12">
			  <div class="vfx-statistic-wrap-area">
				<div class="row">
					<div class="col-xl-3 col-md-6 col-12">
						<a href="{{ URL::to('user/property') }}">
						<div class="vfx-statistic-item vfx-item-blue-violet">
							<div class="icon">
								<i class="fa fa-home"></i>
							</div>
							<h2 class="counter-value">{{$property_total}}</h2>
							<span class="desc">{{trans('words.total_properties')}}</span>                                
						</div>
						</a>
					</div>
					<div class="col-xl-3 col-md-6 col-12">
						<a href="{{ URL::to('user/property') }}">
						<div class="vfx-statistic-item vfx-item-green">
							<div class="icon">
								<i class="fa fa-home"></i>
							</div>
							<h2 class="counter-value">{{$property_active}}</h2>
							<span class="desc">{{trans('words.active_properties')}}</span>                                
						</div>
						</a>
					</div>
					<div class="col-xl-3 col-md-6 col-12">
						<a href="{{ URL::to('user/property') }}">
						<div class="vfx-statistic-item vfx-item-orange">
							<div class="icon">
								<i class="fa fa-home"></i>
							</div>
							<h2 class="counter-value">{{$property_pending}}</h2>
							<span class="desc">{{trans('words.pending_properties')}}</span>                                
						</div>
						</a>
					</div>
					<div class="col-xl-3 col-md-6 col-12">
						<a href="{{ URL::to('user/favourites') }}">
						<div class="vfx-statistic-item vfx-item-blue">
							<div class="icon">
								<i class="fa fa-heart"></i>
							</div>
							<h2 class="counter-value">{{$favourite_total}}</h2>
							<span class="desc">{{trans('words.favourites')}}</span>                                
						</div>
						</a>
					</div>
				</div>
			</div>
		
			<div class="vfx-dashboard-content-area">
				<div class="row">
					<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
					   <div class="profile-section">
						 <div class="row">
							<div class="col-lg-6 col-md-12 col-sm-12 col-xs-12">
							  <div class="member-ship-option">
							  <h5 class="color-up">{{trans('words.my_subscription')}}</h5>
							                              @if($user->plan_id!=0)
                                <span class="premuim-memplan-bold-text"><strong>{{trans('words.current_plan')}}:</strong><span>{{\App\SubscriptionPlan::getSubscriptionPlanInfo($user->plan_id,'plan_name')}}</span></span>

                                <span class="premuim-memplan-bold-text"><strong>{{trans('words.property_limit')}}:</strong><span>{{\App\SubscriptionPlan::getSubscriptionPlanInfo($user->plan_id,'plan_property_limit')}}</span></span>                                
                                 <div class="mt-2" style="border:1px solid #24314d;border-radius:6px;padding:10px;">
                                  <div class="premuim-memplan-bold-text" style="margin-bottom:4px;">
                                    <strong>Usage:</strong>
                                    <span>
                                      {{ $properties_used }} / {{ $property_limit }} properties
                                      (left {{ $properties_left }})
                                    </span>
                                  </div>
                                  @if(!is_null($ads_limit))
                                  <div class="premuim-memplan-bold-text">
                                    <strong>Ads:</strong>
                                    <span>
                                      {{ $ads_used ?? '-' }} / {{ $ads_limit }}
                                      @if(!is_null($ads_left)) (left {{ $ads_left }}) @endif
                                    </span>
                                  </div>
                                  @endif
                                </div>

                                @if(!empty($latest_cpr))
                                <div class="mt-2" style="border:1px solid #24314d;border-radius:6px;padding:10px;">
                                  @if($latest_cpr->status==='awaiting_payment' && $latest_cpr->payment_link)
                                    <a href="{{ $latest_cpr->payment_link }}" class="btn btn-sm btn-primary">Pay Now</a>
                                  @elseif($latest_cpr->status==='pending' || $latest_cpr->status==='approved')
                                    <a href="{{ url('custom-plan/requests') }}" class="btn btn-sm btn-secondary">View Details</a>
                                  @elseif($latest_cpr->status==='rejected')
                                    <a href="{{ url('custom-plan/request') }}" class="btn btn-sm btn-danger">Request Again</a>
                                  @elseif($latest_cpr->status==='activated')
                                    <span class="text-success">Activated on {{ optional($latest_cpr->activated_at)->format('Y-m-d H:i') }}</span>
                                  @endif
                                </div>
                                @endif

                                <a href="{{ URL::to('pricing') }}" class="btn vfx7 mt-2 mb-0 upgrad_plan">{{trans('words.upgrade_plan')}}</a>

								@else
								<a href="{{ URL::to('pricing') }}" class="btn vfx7 mt-2 mb-0 upgrad_plan">{{trans('words.select_plan')}}</a>	
								 
								@endif

							  </div>
							</div>
							<div class="col-lg-6 col-md-12 col-sm-12 col-xs-12">
							   <div class="member-ship-option">
								                                  <h5 class="color-up">{{trans('words.last_invoice')}}</h5>
                                  <span class="premuim-memplan-bold-text"><strong>{{trans('words.date')}}:</strong>
                                  	@if($user->start_date)
									<span>{{date('F,  d, Y',$user->start_date)}}</span>
                                    @endif
                                  </span>
                                  <span class="premuim-memplan-bold-text"><strong>{{trans('words.plan')}}:</strong>
                                  	@if($user->plan_id)
									<span>{{\App\SubscriptionPlan::getSubscriptionPlanInfo($user->plan_id,'plan_name')}}</span>
									@endif
                                  </span>
                                  <span class="premuim-memplan-bold-text"><strong>{{trans('words.amount')}}:</strong>
                                  	@if($user->plan_amount)
									<span>{{number_format($user->plan_amount,2,'.', '') }}</span>
									@endif
                                  </span>
							   </div>
							</div>
						  </div>
					   </div>
					</div>

					<!-- Custom Plan Center & Quick Actions -->
					<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
					  <div class="row">
					    <div class="col-lg-8 col-md-12">
					      <div class="member-ship-option" style="border:1px solid #24314d;border-radius:8px;padding:15px;">
					        <h5 class="color-up">Custom Plan Center</h5>
					        @php
					          $usagePercent = ($property_limit>0) ? min(100, round(($properties_used/$property_limit)*100)) : 0;
					        @endphp
					        <div class="premuim-memplan-bold-text mb-2"><strong>Property Usage:</strong> {{ $properties_used }} / {{ $property_limit }} (left {{ $properties_left }})</div>
					        <div class="progress" style="height:10px;background:#1a2234;border-radius:6px;">
					          <div class="progress-bar" role="progressbar" style="width: {{ $usagePercent }}%; background:#10c469;" aria-valuenow="{{ $usagePercent }}" aria-valuemin="0" aria-valuemax="100"></div>
					        </div>
					                          

					        @if(!empty($latest_cpr))
					          <div class="mt-3" style="border:1px dashed #2b3a5f;border-radius:6px;padding:10px;">
					            <div class="d-flex align-items-center justify-content-between">
					              <div>
					                <div class="premuim-memplan-bold-text"><strong>Latest Request:</strong> <span class="badge badge-info">{{ strtoupper($latest_cpr->status) }}</span></div>
					                <div class="text-muted small">Requested: {{ $latest_cpr->property_posts_requested }} properties @if($latest_cpr->ads_posts_requested) | {{ $latest_cpr->ads_posts_requested }} ads @endif</div>
					              </div>
					              <div>
					                @if($latest_cpr->status==='awaiting_payment' && $latest_cpr->payment_link)
					                  <a href="{{ $latest_cpr->payment_link }}" class="btn btn-sm btn-primary">Pay Now</a>
					                @elseif($latest_cpr->status==='pending' || $latest_cpr->status==='approved')
					                  <a href="{{ url('custom-plan/requests') }}" class="btn btn-sm btn-secondary">View Details</a>
					                @elseif($latest_cpr->status==='rejected')
					                  <a href="{{ url('custom-plan/request') }}" class="btn btn-sm btn-danger">Request Again</a>
					                @elseif($latest_cpr->status==='activated')
					                  <span class="text-success small">Activated on {{ optional($latest_cpr->activated_at)->format('Y-m-d H:i') }}</span>
					                @endif
					              </div>
					            </div>
					          </div>
					        @endif

					        <div class="mt-3">
					          <a href="{{ url('custom-plan/request') }}" class="btn vfx7">Request Custom Plan</a>
					          <a href="{{ url('custom-plan/requests') }}" class="btn btn-outline-secondary">My Requests</a>
					          <a href="{{ url('pricing') }}" class="btn btn-outline-primary">Browse Plans</a>
					        </div>
					      </div>
					    </div>
					    <div class="col-lg-4 col-md-12">
					      <div class="member-ship-option" style="border:1px solid #24314d;border-radius:8px;padding:15px;">
					        <h5 class="color-up">Quick Actions</h5>
					        <div class="d-flex flex-column">
					          <a class="btn btn-sm btn-primary mb-2" href="{{ url('user/property/add') }}">Add Property</a>
					          <a class="btn btn-sm btn-secondary mb-2" href="{{ url('user/property') }}">Manage Properties</a>
					          <a class="btn btn-sm btn-outline-info" href="{{ url('user/favourites') }}">My Favourites</a>
					        </div>
					      </div>
					    </div>
					  </div>
					</div>
					<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
						<div class="vfx-popular-listing">
							<div class="vfx-act-title mb-15">
								<h5>{{trans('words.user_plan_history')}}</h5>
							</div>
							<div class="table-wrapper">
							  <table class="fl-table">
								<thead>
								  <tr>            
									<th>{{trans('words.plan')}}</th>
									<th>{{trans('words.amount')}}</th>
									<th>{{trans('words.payment_gateway')}}</th>
									<th>{{trans('words.payment_id')}}</th>
									<th>Type</th>
									<th>Reference</th>
									<th>{{trans('words.payment_date')}}</th>
								  </tr>
								</thead> 
								<tbody>
									@foreach($transactions_list as $transaction_data)
									<tr>                      
										<td><span class="current-plan-item">{{\App\SubscriptionPlan::getSubscriptionPlanInfo($transaction_data->plan_id,'plan_name')}}</span></td>
										<td>{{html_entity_decode(getCurrencySymbols(getcong('currency_code')))}} {{ number_format($transaction_data->payment_amount,2) }}</td>
										<td>{{ $transaction_data->gateway }}</td>
										<td>{{ $transaction_data->payment_id }}</td>    
										<td>
										  @if(!empty($transaction_data->reference_id) && strpos($transaction_data->reference_id, 'CPR_') === 0)
										    <span class="badge badge-info">Custom Plan</span>
										  @else
										    <span class="badge badge-secondary">Standard</span>
										  @endif
										</td>
										<td>{{ $transaction_data->reference_id ?: '-' }}</td>
										<td><span class="expires-plan-item">{{ date('M d Y h:i A',$transaction_data->date) }}</span></td>            
								  	</tr>
									@endforeach
						 
								</tbody>
							  </table>

							  <!--pagination starts-->
							<div class="post-nav nav-res pt-20">
								<div class="row">
								
								@include('_particles.pagination', ['paginator' => $transactions_list])	 

								</div>
							</div>
							<!--pagination ends-->

							  						

							</div>
						</div>
					</div>
				</div>

				<!-- Recent Leads -->
				<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 mt-4">
					<div class="vfx-popular-listing">
						<div class="vfx-act-title mb-15">
							<h5>Your Recent Leads</h5>
							<a href="{{ url('user/leads') }}" class="float-right">View all leads</a>
						</div>
						<div class="table-wrapper">
							<table class="fl-table">
							<thead>
								<tr>
									<th>ID</th>
									<th>Name</th>
									<th>Phone</th>
									<th>Property</th>
									<th>Action</th>
									<th>Created</th>
								</tr>
							</thead>
							<tbody>
								@forelse($leads as $lead)
								<tr>
									<td>{{ $lead->id }}</td>
									<td>{{ $lead->name ?: '-' }}</td>
									<td>{{ $lead->phone ?: '-' }}</td>
									<td>
										@php $p = $lead->property ?? (isset($lead->property_id) ? \App\Property::find($lead->property_id) : null); @endphp
										@if($p)
											<a href="{{ url('properties/'.$p->slug.'/'.$p->id) }}">{{ Str::limit(stripslashes($p->title ?? $p->reference_number), 30) }}</a>
										@else
										-
										@endif
									</td>
									<td>{{ $lead->action }}</td>
									<td>{{ $lead->created_at }}</td>
								</tr>
								@empty
								<tr>
									<td colspan="6">No recent leads.</td>
								</tr>
								@endforelse
							</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
        </div>
      </div>
    </div>
  </div>
  <!--Dashboard section ends--> 

  <script type="text/javascript">

	'use strict';
    
    @if(Session::has('flash_message'))     
 
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: false,        
      })

      Toast.fire({
        icon: 'success',
        title: '{{ Session::get('flash_message') }}'
      })     
     
  @endif

  @if(Session::has('success'))     
 
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: false,       
      })

      Toast.fire({
        icon: 'success',
        title: '{{ Session::get('success') }}'
      })     
     
  @endif

  @if(Session::has('error_flash_message'))     
 
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: false,        
      })

      Toast.fire({
        icon: 'error',
        title: '{{ Session::get('error_flash_message') }}'
      })     
     
  @endif
 
  </script>  
 
@endsection