@extends('site_app')

@section('head_title', trans('words.sign_up').' | '.getcong('site_name') )

@section('head_url', Request::url())

@section('content')

<style>
/* Modern Form Styling */
.modern-input {
    border: 2px solid #e3e6f0;
    border-radius: 12px;
    padding: 16px 20px 16px 55px;
    font-size: 16px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    background-color: #fff;
    line-height: 1.5;
    color: #374151;
}

.modern-input::placeholder {
    color: #9ca3af;
    opacity: 1;
    font-style: italic;
}

.modern-input:focus {
    border-color: #dc3545;
    box-shadow: 0 0 0 3px rgba(220, 53, 69, 0.1);
    outline: none;
    transform: translateY(-1px);
    color: #374151;
}

.form-label {
    font-weight: 600;
    color: #374151;
    margin-bottom: 8px;
    display: block;
    font-size: 14px;
    letter-spacing: 0.025em;
}

/* Input Group Styling */
.input-group {
    position: relative;
}

.input-icon {
    position: absolute;
    left: 18px;
    top: 50%;
    transform: translateY(-50%);
    color: #9ca3af;
    z-index: 2;
    font-size: 18px;
    transition: color 0.3s ease;
    pointer-events: none;
}

.modern-input:focus + .input-icon,
.input-group:focus-within .input-icon {
    color: #dc3545;
}

/* Welcome Section */
.welcome-icon {
    width: 48px;
    height: 48px;
    margin: 0 auto;
    background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 20px;
}

.welcome-title {
    font-size: 24px;
    font-weight: 700;
    color: #1f2937;
    margin-bottom: 6px;
    letter-spacing: -0.025em;
}

.welcome-subtitle {
    color: #6b7280;
    font-size: 14px;
    margin: 0;
}

/* Step Indicator */
.form-step-indicator {
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 20px;
}

.step {
    display: flex;
    flex-direction: column;
    align-items: center;
    opacity: 0.4;
    transition: opacity 0.3s ease;
}

.step.active {
    opacity: 1;
}

.step.completed {
    opacity: 1;
    color: #10b981;
}

.step-number {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #e5e7eb;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    margin-bottom: 8px;
    transition: all 0.3s ease;
}

.step.active .step-number {
    background: #dc3545;
    color: white;
}

.step.completed .step-number {
    background: #10b981;
    color: white;
}

.step-text {
    font-size: 12px;
    font-weight: 500;
    color: #6b7280;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.step-line {
    flex: 1;
    height: 2px;
    background: #e5e7eb;
    margin: 0 16px;
    position: relative;
}

.step-line::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    height: 100%;
    background: #dc3545;
    width: 0%;
    transition: width 0.3s ease;
}

/* Radio Button Styling */
.business-type-selection {
    display: flex;
    flex-direction: column;
    gap: 16px;
    margin-top: 8px;
}

.radio-option {
    position: relative;
}

.radio-option input[type="radio"] {
    position: absolute;
    opacity: 0;
    width: 0;
    height: 0;
}

.radio-label {
    display: flex;
    align-items: center;
    cursor: pointer;
    padding: 20px;
    border: 2px solid #e5e7eb;
    border-radius: 12px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    background-color: #fff;
    min-height: 80px;
}

.radio-label:hover {
    border-color: #dc3545;
    background-color: #f8fafc;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(220, 53, 69, 0.15);
}

.radio-option input[type="radio"]:checked + .radio-label {
    border-color: #dc3545;
    background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
    box-shadow: 0 8px 25px rgba(220, 53, 69, 0.15);
    transform: translateY(-2px);
}

.radio-custom {
    width: 24px;
    height: 24px;
    border: 2px solid #dc3545;
    border-radius: 50%;
    margin-right: 16px;
    position: relative;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    flex-shrink: 0;
}

.radio-option input[type="radio"]:checked + .radio-label .radio-custom {
    background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
    border-color: #dc3545;
}

.radio-option input[type="radio"]:checked + .radio-label .radio-custom::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 8px;
    height: 8px;
    border-radius: 50%;
    background-color: white;
}

.radio-content {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.radio-title {
    font-size: 16px;
    font-weight: 600;
    color: #1f2937;
}

.radio-subtitle {
    font-size: 14px;
    color: #6b7280;
    line-height: 1.4;
}

/* Modern Button Styling */
.btn-modern {
    border-radius: 12px;
    padding: 12px 20px;
    font-weight: 600;
    font-size: 14px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    border: none;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    text-decoration: none;
    position: relative;
    overflow: hidden;
}

.btn-full-width {
    width: 100%;
}

.btn-primary.btn-modern {
    background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
    color: white;
    box-shadow: 0 4px 15px rgba(220, 53, 69, 0.3);
}

.btn-primary.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(220, 53, 69, 0.4);
}

.btn-primary.btn-modern:active {
    transform: translateY(0);
}

.btn-icon {
    transition: transform 0.3s ease;
}

.btn:hover .btn-icon {
    transform: translateX(2px);
}

/* Form Text */
.form-text {
    display: block;
    margin-top: 8px;
    font-size: 14px;
    color: #6b7280;
    font-style: italic;
}

/* Account Text */
.account-text {
    color: #6b7280;
    font-size: 14px;
    margin: 0;
}

.account-link {
    color: #dc3545;
    text-decoration: none;
    font-weight: 600;
    transition: color 0.3s ease;
}

.account-link:hover {
    color: #bd2130;
    text-decoration: underline;
}

/* Form Container Styling */
.login-wrapper .ui-dash {
    background: white;
    border-radius: 20px;
    padding: 32px 24px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(10px);
}

.vid_title h4 {
    color: #333;
    font-size: 24px;
    margin-bottom: 8px;
}

/* Loading Spinner */
.spinner-border {
    width: 2rem;
    height: 2rem;
    color: #dc3545;
}

/* Responsive Design */
@media (max-width: 768px) {
    .login-wrapper .ui-dash {
        padding: 24px 16px;
        margin: 0 16px;
    }

    .business-type-selection {
        gap: 12px;
    }

    .radio-label {
        padding: 16px;
        min-height: 70px;
    }

    .welcome-title {
        font-size: 20px;
    }

    .form-step-indicator {
        margin: 0 10px;
    }

    .step-text {
        font-size: 11px;
    }
}

/* Animation for step transitions */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

#signup-form > div {
    animation: fadeInUp 0.5s ease-out;
}

/* Progress bar animation */
.step-line::after {
    width: 100%;
}

/* Success state styling */
.success-message {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    padding: 16px;
    border-radius: 12px;
    text-align: center;
    margin-bottom: 20px;
}
.input-group>.custom-select:not(:first-child), .input-group>.form-control:not(:first-child) {
   border-radius: 10px;
padding-left: 40 !important;
}

</style>
  <!--Breadcrumb section starts-->
  <div class="breadcrumb-section bg-xs" style="background-image: url({{ URL::asset('site_assets/images/breadcrumb-1.jpg') }})">
    <div class="overlay op-2"></div>
    <div class="container">
      <div class="row">
        <div class="col-md-8 offset-md-2 text-center">
          <div class="breadcrumb-menu">
            <h2>{{trans('words.sign_up')}}</h2>
            <span><a href="{{ URL::to('/') }}" title="{{trans('words.home')}}">{{trans('words.home')}}</a></span> <span>{{trans('words.sign_up')}}</span></div>
        </div>
      </div>
    </div>
  </div>
  <!--Breadcrumb section ends-->

  <!--Signup starts-->
  <div class="about-section pt-30 pb-20">
    <div class="container">
      <div class="row">
        <div class="col-lg-5 mx-auto">
           <div class="signup-form" style="border: 2px solid #e5e7eb; padding: 10px; border-radius: 30px;>
                <div id="signup-form" >
                    <div class="text-center mb-30">
                        <div class="welcome-icon mb-20">
                        <i class="fa fa-user-plus"></i>
                        </div>
                        <h3 class="welcome-title">Welcome to Floor Locator</h3>
                        <p class="welcome-subtitle">Create your account to get started</p>
                    </div>

                    <div class="form-step-indicator mb-25">
                        <div class="step active" data-step="1">
                        <span class="step-number">1</span>
                        <span class="step-text">Personal Info</span>
                        </div>
                        <div class="step-line"></div>
                        <div class="step" data-step="2">
                        <span class="step-number">2</span>
                        <span class="step-text">Verification</span>
                        </div>
                    </div>

                    <div class="form-group mb-20">
                        <label for="name" class="form-label">Full Name</label>
                        <div class="input-group">
                        <span class="input-icon"><i class="fa fa-user"></i></span>
                        <input type="text" name="name" id="name" tabindex="1" class="form-control modern-input" placeholder="Enter your full name" value="">
                        </div>
                    </div>

                    <div class="form-group mb-20">
                        <label class="form-label">I am a</label>
                        <div class="business-type-selection">
                        <div class="radio-option">
                            <input type="radio" name="business_type" id="business_type_individual" value="1" tabindex="2" required>
                            <label for="business_type_individual" class="radio-label">
                            <span class="radio-custom"></span>
                            <div class="radio-content">
                                <span class="radio-title">Buyer / Owner</span>
                                <span class="radio-subtitle">Looking to buy or sell property</span>
                            </div>
                            </label>
                        </div>
                        <div class="radio-option">
                            <input type="radio" name="business_type" id="business_type_promoter" value="2" tabindex="3" required>
                            <label for="business_type_promoter" class="radio-label">
                            <span class="radio-custom"></span>
                            <div class="radio-content">
                                <span class="radio-title">Agent / Builder</span>
                                <span class="radio-subtitle">Helping others find properties</span>
                            </div>
                            </label>
                        </div>
                        </div>
                    </div>

                    <div class="form-group mb-25">
                        <label for="phone" class="form-label">Mobile Number</label>
                        <div class="input-group">
                        <span class="input-icon"><i class="fa fa-mobile"></i></span>
                        <input type="tel" name="phone" id="phone" tabindex="4" class="form-control modern-input" placeholder="Enter your mobile number" value="">
                        </div>
                    </div>

                    <div id="otp-section" style="display: none;">
                        <div class="form-step-indicator mb-25">
                        <div class="step completed" data-step="1">
                            <span class="step-number"><i class="fa fa-check"></i></span>
                            <span class="step-text">Personal Info</span>
                        </div>
                        <div class="step-line"></div>
                        <div class="step active" data-step="2">
                            <span class="step-number">2</span>
                            <span class="step-text">Verification</span>
                        </div>
                        </div>

                        <div class="form-group mb-25">
                        <label for="otp" class="form-label">Enter Verification Code</label>
                        <div class="input-group">
                            <span class="input-icon"><i class="fa fa-key"></i></span>
                            <input type="text" name="otp" id="otp" tabindex="5" class="form-control modern-input" placeholder="Enter 4-digit OTP" maxlength="6">
                        </div>
                        <small class="form-text">We've sent a verification code to your mobile number</small>
                        </div>

                        <div class="text-center mb-20">
                        <button type="button" id="verify-otp-btn" class="btn btn-primary btn-modern btn-full-width">
                            <span class="btn-text">Create My Account</span>
                            <span class="btn-icon"><i class="fa fa-arrow-right"></i></span>
                        </button>
                        </div>
                        <div class="text-center">
                        <button type="button" id="resend-otp-btn" class="btn btn-link btn-modern-link">
                            <i class="fa fa-refresh"></i> Resend Code
                        </button>
                        </div>
                    </div>

                    <div id="send-otp-section">
                        <div class="text-center mb-25">
                        <button type="button" id="send-otp-btn" class="btn btn-primary btn-modern btn-full-width">
                            <span class="btn-text">Send Verification Code</span>
                            <span class="btn-icon"><i class="fa fa-paper-plane"></i></span>
                        </button>
                        </div>
                    </div>

                    <div id="loading" style="display: none;" class="text-center mt-3">
                        <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">Loading...</span>
                        </div>
                    </div>

                    <div class="text-center mt-25">
                        <p class="account-text">Already have an account?
                        <a href="{{ url('login') }}" class="account-link">Sign In</a>
                        </p>
                    </div>
			    </div>
			</div>
         </div>
      </div>
    </div>
  </div>
  <!--Signup ends-->


<script type="text/javascript">
'use strict';

@if(Session::has('flash_message'))
  const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: false,
  })

  Toast.fire({
    icon: 'success',
    title: '{{ Session::get('flash_message') }}'
  })
@endif

@if(Session::has('error_flash_message'))
  const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: false,
  })

  Toast.fire({
    icon: 'error',
    title: '{{ Session::get('error_flash_message') }}'
  })
@endif

document.addEventListener('DOMContentLoaded', function() {
    const nameInput = document.getElementById('name');
    const businessTypeInputs = document.querySelectorAll('input[name="business_type"]');
    const phoneInput = document.getElementById('phone');
    const sendOtpBtn = document.getElementById('send-otp-btn');
    const otpInput = document.getElementById('otp');
    const verifyOtpBtn = document.getElementById('verify-otp-btn');
    const resendOtpBtn = document.getElementById('resend-otp-btn');
    const otpSection = document.getElementById('otp-section');
    const sendOtpSection = document.getElementById('send-otp-section');
    const loading = document.getElementById('loading');

    let currentPhone = '';
    let currentName = '';
    let currentBusinessType = '';

    // Send OTP
    sendOtpBtn.addEventListener('click', function() {
        const name = nameInput.value.trim();
        const businessType = document.querySelector('input[name="business_type"]:checked');
        const phone = phoneInput.value.trim();

        if (!name) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please enter your full name'
            });
            return;
        }

        if (!businessType) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please select your business type'
            });
            return;
        }

        if (!phone) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please enter your mobile number'
            });
            return;
        }

        if (!/^[6-9][0-9]{9}$/.test(phone)) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please enter a valid 10-digit mobile number'
            });
            return;
        }

        currentPhone = phone;
        currentName = name;
        currentBusinessType = businessType.value;
        showLoading();

        fetch('{{ url("/signup/send-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                phone: phone,
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            })
        })
        .then(response => response.json())
        .then(data => {
            hideLoading();
            if (data.success) {
                otpSection.style.display = 'block';
                sendOtpSection.style.display = 'none';
                otpInput.focus();

                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: data.message
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message
                });
            }
        })
        .catch(error => {
            hideLoading();
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Something went wrong. Please try again.'
            });
        });
    });

    // Verify OTP and Create Account
    verifyOtpBtn.addEventListener('click', function() {
        const otp = otpInput.value.trim();

        if (!otp || otp.length !== 4) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please enter a valid 4-digit OTP'
            });
            return;
        }

        showLoading();

        fetch('{{ url("/signup/verify-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                phone: currentPhone,
                otp: otp,
                name: currentName,
                business_type: currentBusinessType,
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            })
        })
        .then(response => response.json())
        .then(data => {
            hideLoading();
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: data.message
                }).then(() => {
                    window.location.href = data.redirect || '/dashboard';
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message
                });
            }
        })
        .catch(error => {
            hideLoading();
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Something went wrong. Please try again.'
            });
        });
    });

    // Resend OTP
    resendOtpBtn.addEventListener('click', function() {
        if (!currentPhone) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please enter your mobile number first'
            });
            return;
        }

        showLoading();

        fetch('{{ url("/signup/resend-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                type: 'signup',
                phone: currentPhone,
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            })
        })
        .then(response => response.json())
        .then(data => {
            hideLoading();
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: data.message
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message
                });
            }
        })
        .catch(error => {
            hideLoading();
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Something went wrong. Please try again.'
            });
        });
    });

    function showLoading() {
        loading.style.display = 'block';
        sendOtpBtn.disabled = true;
        verifyOtpBtn.disabled = true;
        resendOtpBtn.disabled = true;
    }

    function hideLoading() {
        loading.style.display = 'none';
        sendOtpBtn.disabled = false;
        verifyOtpBtn.disabled = false;
        resendOtpBtn.disabled = false;
    }

    // Enter key to send OTP
    phoneInput.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            sendOtpBtn.click();
        }
    });

    // Enter key to verify OTP
    otpInput.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            verifyOtpBtn.click();
        }
    });
});
</script>

