@extends('site_app')

@section('head_title', trans('words.sign_up').' | '.getcong('site_name') )

@section('head_url', Request::url())

@section('content')

@if(getcong('recaptcha_on_signup'))
<script src='https://www.google.com/recaptcha/api.js'></script>
<script>
function submitForm() {
    var response = grecaptcha.getResponse();
    if(response.length == 0) {
        document.getElementById('g-recaptcha-error').innerHTML = '<span class="text-red-500 text-sm">This field is required.</span>';
        return false;
    }
    return true;
}
 
function verifyCaptcha() {
    document.getElementById('g-recaptcha-error').innerHTML = '';
}
</script>
@endif

<!--Breadcrumb section starts-->
<div class="bg-cover bg-center py-8" style="background-image: url({{ URL::asset('site_assets/images/breadcrumb-1.jpg') }})">
    <div class="bg-black bg-opacity-20">
        <div class="container mx-auto px-4">
            <div class="text-center">
                <h2 class="text-2xl font-semibold text-white">{{trans('words.sign_up')}}</h2>
                <nav class="text-sm text-gray-200 mt-2">
                    <a href="{{ URL::to('/') }}" class="hover:underline">{{trans('words.home')}}</a> 
                    <span class="mx-2">/</span> 
                    <span>{{trans('words.sign_up')}}</span>
                </nav>
            </div>
        </div>
    </div>
</div>
<!--Breadcrumb section ends--> 

<!--Register starts-->
<div class="py-8 bg-gray-100">
    <div class="container mx-auto px-4">
        <div class="max-w-md mx-auto bg-white rounded-lg shadow-md p-6">
            <h4 class="text-lg font-semibold text-gray-800 mb-6 text-center">{{trans('words.sign_up')}}</h4>
            {{ html()->form('POST', url('/signup'))
                     ->attributes(['class' => 'space-y-4', 'id' => 'signupform', 'role' => 'form', 'onsubmit' => 'return submitForm();'])->open() }}
                <div>
                    <input type="text" name="name" id="name" tabindex="1" class="w-full px-3 py-2 text-sm border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="{{trans('words.name')}}" value="{{old('name')}}">
                </div>
                <div>
                    <input type="email" name="email" id="email" tabindex="1" class="w-full px-3 py-2 text-sm border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="{{trans('words.email')}}" value="{{old('email')}}">
                </div>
                <div>
                    <input type="password" name="password" id="password" tabindex="2" class="w-full px-3 py-2 text-sm border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="{{trans('words.password')}} {{trans('words.at_least_8_char')}}">
                </div>
                <div>
                    <input type="password" name="password_confirmation" id="password_confirmation" tabindex="2" class="w-full px-3 py-2 text-sm border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="{{trans('words.confirm_password')}}">
                </div>
                @if(getcong('recaptcha_on_signup'))
                <div class="text-center">
                    <div class="g-recaptcha mx-auto" data-sitekey="{{getcong('recaptcha_site_key')}}" data-callback="verifyCaptcha"></div>
                    <div id="g-recaptcha-error" class="mt-2"></div>
                </div>     
                @endif
                <div class="flex items-center space-x-2">
                    <input type="checkbox" name="remember" id="remember" tabindex="3" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" checked onclick="return false">
                    <label for="remember" class="text-sm text-gray-600">
                        {{trans('words.by_signing_accept')}} 
                        <a href="{{ URL::to('page/'.\App\Pages::getPageInfo(3,'page_slug')) }}" class="text-blue-600 hover:underline" target="_blank" title="privacy">{{\App\Pages::getPageInfo(3,'page_title')}}</a>
                    </label>
                </div>
                <div class="text-center">
                    <button type="submit" class="w-full px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500">{{trans('words.sign_up')}}</button>
                </div>
                <p class="text-center text-sm text-gray-600 mt-4">
                    {{trans('words.already_have_account')}} 
                    <a href="{{ url('login') }}" class="text-blue-600 hover:underline">{{trans('words.login_text')}}</a>
                </p>
            {{ html()->form()->close() }}
        </div>
    </div>
</div>
<!--Register ends--> 

<script type="text/javascript">
'use strict';

@if(Session::has('signup_flash_message'))     
const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: false,         
})
Toast.fire({
    icon: 'success',
    title: '{{ Session::get('signup_flash_message') }}'
})     
@endif

@if(Session::has('error_flash_message'))     
const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: false,         
})
Toast.fire({
    icon: 'error',
    title: '{{ Session::get('error_flash_message') }}'
})     
@endif

@php
$errors_html = '';
if (isset($errors) && is_object($errors) && method_exists($errors, 'all')) {
    $errors_html = '<p>' . implode('<br/>', $errors->all()) . '</p>';
}
@endphp

@if ($errors && is_object($errors) && $errors->any())
Swal.fire({
    icon: 'error',
    title: 'Oops...',
    html: '{!! $errors_html !!}',
    showConfirmButton: true,
    confirmButtonColor: '#10c469',
    background: '#1a2234',
    color: '#fff'
}) 
@endif
</script>

@endsection