<!-- Property Detail Drawer -->
<div id="property-drawer" class="property-drawer">
  <div class="drawer-header">
    <h4 id="drawer-title">Property Details</h4>
    <div class="drawer-actions">
      <button id="drawer-favorite" class="action-btn" title="Add to Favorites">
        <i class="fa fa-heart-o"></i>
      </button>
      <button id="drawer-share" class="action-btn" title="Share Property">
        <i class="fa fa-share-alt"></i>
      </button>
      <button id="drawer-compare" class="action-btn" title="Add to Compare">
        <i class="fa fa-balance-scale"></i>
      </button>
      <button id="close-drawer" class="action-btn close-btn" title="Close">
        <i class="fa fa-times"></i>
      </button>
    </div>
  </div>
  
  <div class="drawer-content" id="drawer-content">
    <!-- Property details will be populated here -->
    <div class="loading-state" id="drawer-loading">
      <div class="spinner"></div>
      <p>Loading property details...</p>
    </div>
  </div>
</div>

<!-- Property Detail Modal (for full details) -->
<div class="modal fade" id="property-detail-modal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modal-property-title">Property Details</h5>
        <button type="button" class="close" data-dismiss="modal">
          <span>&times;</span>
        </button>
      </div>
      <div class="modal-body" id="modal-property-content">
        <!-- Full property details will be loaded here -->
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary" id="contact-agent-btn">Contact Agent</button>
        <a href="#" id="view-full-details" class="btn btn-success" target="_blank">View Full Details</a>
      </div>
    </div>
  </div>
</div>


<div class="modal fade" id="contact-agent-modal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Contact Agent</h5>
        <button type="button" class="close" data-dismiss="modal">
          <span>&times;</span>
        </button>
      </div>
      <form id="contact-agent-form">
        <div class="modal-body">
          <div class="agent-info" id="agent-info">
            <!-- Agent details will be populated here -->
          </div>
          <div class="form-group">
            <label>Your Name</label>
            <input type="text" class="form-control" id="contact-name" required>
          </div>
          <div class="form-group">
            <label>Email</label>
            <input type="email" class="form-control" id="contact-email" required>
          </div>
          <div class="form-group">
            <label>Phone</label>
            <input type="tel" class="form-control" id="contact-phone">
          </div>
          <div class="form-group">
            <label>Message</label>
            <textarea class="form-control" id="contact-message" rows="4" placeholder="I'm interested in this property..."></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Send Message</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Property Comparison Modal -->
<div class="modal fade" id="property-compare-modal" tabindex="-1">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Property Comparison</h5>
        <button type="button" class="close" data-dismiss="modal">
          <span>&times;</span>
        </button>
      </div>
      <div class="modal-body" id="comparison-content">
        <!-- Property comparison table will be populated here -->
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary" id="export-comparison">Export Comparison</button>
      </div>
    </div>
  </div>
</div>
<?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/pages/property/partials/property-drawer.blade.php ENDPATH**/ ?>