

<?php $__env->startSection("content"); ?>

  
  <div class="content-page">
      <div class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-12">
              <div class="card-box table-responsive">

                <div class="row">                  
                  <div class="col-md-3">
                      
                     <?php echo e(html()->form('GET', url('/admin/users'))
                     ->attributes(['class' => 'app-search', 'id' => 'search'])->open()); ?>  
                      <input type="text" name="s" placeholder="<?php echo e(trans('words.search_by_name_email')); ?>" class="form-control">
                      <button type="submit"><i class="fa fa-search"></i></button>
                      <?php echo e(html()->form()->close()); ?>

                  </div>             
                <div class="col-md-3">
                  <a href="<?php echo e(URL::to('admin/users/add')); ?>" class="btn btn-success btn-md waves-effect waves-light m-b-20 mt-2" data-toggle="tooltip" title="<?php echo e(trans('words.add_user')); ?>"><i class="fa fa-plus"></i> <?php echo e(trans('words.add_user')); ?></a>
                </div>
                <div class="col-sm-3">
                      
                  </div>
                <div class="col-md-3">
                  <a href="<?php echo e(URL::to('admin/users/export')); ?>" class="btn btn-info btn-md waves-effect waves-light m-b-20 mt-2 pull-right" data-toggle="tooltip" title="<?php echo e(trans('words.export_user')); ?>"><i class="fa fa-file-excel-o"></i> <?php echo e(trans('words.export_user')); ?></a>
                </div>
              </div>

                <?php if(Session::has('flash_message')): ?>
                    <div class="alert alert-success">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                      <span aria-hidden="true">&times;</span></button>
                        <?php echo e(Session::get('flash_message')); ?>

                    </div>
                <?php endif; ?>
                <div class="table-responsive">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th><?php echo e(trans('words.name')); ?></th>
                      <th><?php echo e(trans('words.email')); ?></th>
                      <th><?php echo e(trans('words.phone')); ?></th>
                      <th><?php echo e(trans('words.status')); ?></th>                        
                      <th><?php echo e(trans('words.action')); ?></th>
                    </tr>
                  </thead>
                  <tbody>
                   <?php $__currentLoopData = $user_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $user_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr id="post_id_<?php echo e($user_data->id); ?>">
                      <td><?php echo e($user_data->name); ?></td>
                      <td><?php echo e($user_data->email); ?></td>
                      <td><?php echo e($user_data->phone); ?></td>
                      <td><?php if($user_data->status==1): ?><span class="badge badge-success"><?php echo e(trans('words.active')); ?></span> <?php else: ?><span class="badge badge-danger"><?php echo e(trans('words.inactive')); ?></span><?php endif; ?></td>
                      <td>
                        <a href="<?php echo e(url('admin/users/'.$user_data->id)); ?>" class="btn btn-icon waves-effect waves-light btn-purple m-b-5 m-r-5" data-toggle="tooltip" title="View"> <i class="fa fa-eye"></i> </a>
                        <a href="<?php echo e(url('admin/users/edit/'.$user_data->id)); ?>" class="btn btn-icon waves-effect waves-light btn-success m-b-5 m-r-5" data-toggle="tooltip" title="<?php echo e(trans('words.edit')); ?>"> <i class="fa fa-edit"></i> </a>
                        <a href="<?php echo e(url('admin/payments/user/'.$user_data->id)); ?>" class="btn btn-icon waves-effect waves-light btn-info m-b-5 m-r-5" data-toggle="tooltip" title="Payment History"> <i class="fa fa-list-alt"></i> </a>
                        <button type="button" class="btn btn-icon waves-effect waves-light btn-primary m-b-5 m-r-5" data-toggle="modal" data-target="#createPayment<?php echo e($user_data->id); ?>" title="Create Payment Transaction"> <i class="fa fa-plus-circle"></i> </button>
                        <a href="javascript::" onclick="delete_fun('<?php echo e($user_data->id); ?>');" class="btn btn-icon waves-effect waves-light btn-danger m-b-5 data_remove" data-toggle="tooltip" title="<?php echo e(trans('words.remove')); ?>"> <i class="fa fa-times"></i> </a>
                      </td>
                    </tr>
                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     
                     
                     
                  </tbody>
                </table>
              </div>
                <nav class="paging_simple_numbers">
                <?php echo $__env->make('admin.pagination', ['paginator' => $user_list], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                </nav>
           
              </div>
            </div>
          </div>
        </div>
      </div>
      <?php echo $__env->make("admin.copyright", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
    </div>

<!-- Payment Creation Modals for each user -->
<?php $__currentLoopData = $user_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="createPayment<?php echo e($user_data->id); ?>" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Create Payment for <?php echo e($user_data->name); ?></h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <?php echo e(html()->form('POST', url('/admin/users/create-payment'))
               ->attributes(['class' => 'form-horizontal'])->open()); ?>

            <input type="hidden" name="user_id" value="<?php echo e($user_data->id); ?>">
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>User Information</label>
                            <div class="form-control-static">
                                <strong><?php echo e($user_data->name); ?></strong><br>
                                <small class="text-muted"><?php echo e($user_data->email); ?></small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Current Plan</label>
                            <div class="form-control-static">
                                <span class="badge badge-info">
                                    <?php echo e(\App\SubscriptionPlan::getSubscriptionPlanInfo($user_data->plan_id, 'plan_name') ?: 'No Plan'); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Subscription Plan (Optional)</label>
                            <select name="plan_id" class="form-control">
                                <option value="">No Plan / Custom Payment</option>
                                <?php $__currentLoopData = \App\SubscriptionPlan::where('status', '1')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($plan->id); ?>" data-price="<?php echo e($plan->plan_price); ?>">
                                        <?php echo e($plan->plan_name); ?> - <?php echo e(html_entity_decode(getCurrencySymbols(getcong('currency_code')))); ?><?php echo e($plan->plan_price); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Amount *</label>
                            <input type="number" name="payment_amount" class="form-control" step="0.01" min="0" placeholder="Enter amount" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Gateway *</label>
                            <select name="gateway" class="form-control" required>
                                <option value="">Select Gateway</option>
                                <option value="Bank Transfer">Bank Transfer</option>
                                <option value="Cash">Cash</option>
                                <option value="Check">Check</option>
                                <option value="PayPal">PayPal</option>
                                <option value="Stripe">Stripe</option>
                                <option value="Razorpay">Razorpay</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment ID/Reference *</label>
                            <input type="text" name="payment_id" class="form-control" placeholder="Enter payment reference" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Transaction Type</label>
                            <select name="transaction_type" class="form-control">
                                <option value="subscription">Subscription</option>
                                <option value="upgrade">Plan Upgrade</option>
                                <option value="renewal">Plan Renewal</option>
                                <option value="refund">Refund</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Status</label>
                            <select name="payment_status" class="form-control">
                                <option value="completed">Completed</option>
                                <option value="pending">Pending</option>
                                <option value="failed">Failed</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Description</label>
                    <input type="text" name="description" class="form-control" placeholder="Payment description">
                </div>
                
                <div class="form-group">
                    <label>Admin Notes</label>
                    <textarea name="notes" class="form-control" rows="3" placeholder="Add any notes about this payment..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Create Payment</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
            </div>
            <?php echo e(html()->form()->close()); ?>

        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<script src="<?php echo e(URL::asset('admin_assets/js/jquery.min.js')); ?>"></script>
 
 <!-- SweetAlert2 -->
 <script src="<?php echo e(URL::asset('admin_assets/js/sweetalert2@11.js')); ?>"></script>
  
 <script type="text/javascript">

// Auto-fill payment amount when plan is selected (optional)
$(document).on('change', 'select[name="plan_id"]', function() {
    var selectedOption = $(this).find('option:selected');
    var price = selectedOption.data('price');
    var modal = $(this).closest('.modal');
    var amountField = modal.find('input[name="payment_amount"]');
    
    if (price && !amountField.val()) {
        amountField.val(price);
    }
});

// Generate unique payment ID
$(document).on('click', '[data-target^="#createPayment"]', function() {
    var userId = $(this).data('target').replace('#createPayment', '');
    var timestamp = Date.now();
    var paymentId = 'PAY_' + userId + '_' + timestamp;
    
    setTimeout(function() {
        $($(this).data('target') + ' input[name="payment_id"]').val(paymentId);
    }.bind(this), 100);
});
 
 $(".data_remove").on('click', function () {      
  
  'use strict';    
   
   var post_id = $(this).data("id");
   var action_name='user_delete';
 
   Swal.fire({
     title: '<?php echo e(trans('words.dlt_warning')); ?>',
   text: "<?php echo e(trans('words.dlt_warning_text')); ?>",
   icon: 'warning',
   showCancelButton: true,
   confirmButtonColor: '#3085d6',
   cancelButtonColor: '#d33',
   confirmButtonText: '<?php echo e(trans('words.dlt_confirm')); ?>',
   cancelButtonText: "<?php echo e(trans('words.btn_cancel')); ?>",
   background:"#1a2234",
   color:"#fff"
 
 }).then((result) => {
  
     if(result.isConfirmed) { 
 
         $.ajax({
             type: 'post',
             url: "<?php echo e(URL::to('admin/ajax_delete')); ?>",
             dataType: 'json',
             data: {"_token": "<?php echo e(csrf_token()); ?>",id: post_id, action_for: action_name},
             success: function(res) {
 
               if(res.status=='1')
               {  
 
                   var selector = "#post_id_"+post_id;
                     $(selector ).fadeOut(1000);
                     setTimeout(function(){
                             $(selector ).remove()
                         }, 1000);
 
                   Swal.fire({
                     position: 'center',
                     icon: 'success',
                     title: '<?php echo e(trans('words.deleted')); ?>!',
                     showConfirmButton: true,
                     confirmButtonColor: '#10c469',
                     background:"#1a2234",
                     color:"#fff"
                   })
                 
               } 
               else
               { 
                 Swal.fire({
                         position: 'center',
                         icon: 'error',
                         title: 'Something went wrong!',
                         showConfirmButton: true,
                         confirmButtonColor: '#10c469',
                         background:"#1a2234",
                         color:"#fff"
                        })
               }
               
             }
         });
     }
  
 })
 
 });
 
 </script>    
    

<?php $__env->stopSection(); ?>
<?php echo $__env->make("admin.admin_app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/realestate.dextragroups.com/resources/views/admin/pages/users/list.blade.php ENDPATH**/ ?>