<?php $__env->startSection('content'); ?>
<div class="content-page">
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-12">
          <div class="card-box" style="color:#e6e6e6;">
            <div class="row">
              <div class="col-sm-6">
                <h4 class="header-title m-t-0 m-b-30"><?php echo e($page_title); ?></h4>
              </div>
              <div class="col-sm-6 text-right">
                <a href="<?php echo e(url('admin/custom-plans')); ?>" class="btn btn-secondary">Back</a>
                <?php if($requestModel->user_id): ?>
                  <a href="<?php echo e(url('admin/users/'.$requestModel->user_id)); ?>" class="btn btn-purple">View User</a>
                <?php endif; ?>
              </div>
            </div>

            <div class="row">
              <div class="col-md-6">
                <h5 class="text-muted">User Info</h5>
                <p><strong>Name:</strong> <span class="text-white"><?php echo e($requestModel->user->name); ?></span></p>
                <p><strong>Email:</strong> <span class="text-white"><?php echo e($requestModel->user->email); ?></span></p>
                <p><strong>Phone:</strong> <span class="text-white"><?php echo e($requestModel->user->phone); ?></span></p>
              </div>
              <div class="col-md-6">
                <h5 class="text-muted">Request</h5>
                <p><strong>Property postings needed:</strong> <span class="text-white"><?php echo e($requestModel->property_posts_requested); ?></span></p>
                <p><strong>Ads postings needed:</strong> <span class="text-white"><?php echo e($requestModel->ads_posts_requested ?? '-'); ?></span></p>
                <p><strong>Payment preference:</strong> <span class="text-white"><?php echo e(ucfirst($requestModel->payment_preference)); ?></span></p>
                <?php
                  $badge = 'badge-secondary';
                  switch($requestModel->status){
                    case 'pending': $badge='badge-warning'; break;
                    case 'approved': $badge='badge-primary'; break;
                    case 'awaiting_payment': $badge='badge-info'; break;
                    case 'activated': $badge='badge-success'; break;
                    case 'rejected': $badge='badge-danger'; break;
                  }
                ?>
                <p><strong>Status:</strong> <span class="badge <?php echo e($badge); ?>"><?php echo e(strtoupper($requestModel->status)); ?></span></p>
                <?php if($requestModel->notes): ?>
                <p><strong>Notes:</strong> <span class="text-white"><?php echo e($requestModel->notes); ?></span></p>
                <?php endif; ?>
              </div>
            </div>

            <hr>

            <?php if($requestModel->status === 'pending' || $requestModel->status === 'approved'): ?>
            <h5>Approve Request</h5>
            <?php echo e(html()->form('POST', url('admin/custom-plans/'.$requestModel->id.'/approve'))->open()); ?>

              <div class="row">
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Allowed property postings *</label>
                    <input type="number" class="form-control" name="approved_property_limit" value="<?php echo e(old('approved_property_limit', $requestModel->approved_property_limit)); ?>" min="0" required>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Allowed ads postings</label>
                    <input type="number" class="form-control" name="approved_ads_limit" value="<?php echo e(old('approved_ads_limit', $requestModel->approved_ads_limit)); ?>" min="0">
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Price *</label>
                    <input type="number" class="form-control" name="approved_price" value="<?php echo e(old('approved_price', $requestModel->approved_price)); ?>" step="0.01" min="0" required>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Validity (days) *</label>
                    <input type="number" class="form-control" name="approved_validity_days" value="<?php echo e(old('approved_validity_days', $requestModel->approved_validity_days)); ?>" min="1" required>
                  </div>
                </div>
              </div>
              <div class="form-group">
                <label>Admin Notes</label>
                <textarea class="form-control" name="admin_notes" rows="3"><?php echo e(old('admin_notes', $requestModel->admin_notes)); ?></textarea>
              </div>
              <button type="submit" class="btn btn-success">Approve</button>
            <?php echo e(html()->form()->close()); ?>


            <div class="mt-3">
              <?php echo e(html()->form('POST', url('admin/custom-plans/'.$requestModel->id.'/reject'))->open()); ?>

                <div class="form-group">
                  <label>Reason (optional)</label>
                  <input type="text" class="form-control" name="admin_notes" placeholder="Reason for rejection">
                </div>
                <button type="submit" class="btn btn-danger">Reject</button>
              <?php echo e(html()->form()->close()); ?>

            </div>
            <?php endif; ?>

            <?php if($requestModel->status === 'approved'): ?>
              <hr>
              <h5>Cash Payment</h5>
              <?php echo e(html()->form('POST', url('admin/custom-plans/'.$requestModel->id.'/mark-paid'))->open()); ?>

                <div class="form-group">
                  <label>Payment Reference ID (optional)</label>
                  <input type="text" class="form-control" name="payment_id" placeholder="Receipt no / Ref ID">
                </div>
                <button type="submit" class="btn btn-primary">Mark Paid</button>
              <?php echo e(html()->form()->close()); ?>

            <?php endif; ?>

            <?php if(in_array($requestModel->status, ['paid','awaiting_payment'])): ?>
              <hr>
              <h5>Activate Plan</h5>
              <?php if($requestModel->payment_preference==='online' && $requestModel->status==='awaiting_payment'): ?>
                <p>User payment link: <a href="<?php echo e($requestModel->payment_link); ?>" class="btn btn-sm btn-outline-info" target="_blank">Open Payment Link</a></p>
              <?php endif; ?>
              <?php echo e(html()->form('POST', url('admin/custom-plans/'.$requestModel->id.'/activate'))->open()); ?>

                <button type="submit" class="btn btn-success">Activate for User</button>
              <?php echo e(html()->form()->close()); ?>

            <?php endif; ?>

          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('admin.copyright', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.admin_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/realestate.dextragroups.com/resources/views/admin/pages/custom_plans/show.blade.php ENDPATH**/ ?>