<template id="property-popup-template">
  <div class="popup-container">
    <div class="popup-image-container">
      <img class="popup-img" src="[[image]]" alt="[[title]]" loading="lazy">
      <div class="popup-badges-container">
        [[verified_badge]]
        [[featured_badge]]
      </div>
      <div class="popup-price-container">
        <span class="price-amount">[[price]]</span>
        <span class="price-type [[purpose_class]]">[[purpose_text]]</span>
      </div>
    </div>
    <div class="popup-content">
      <div class="popup-header-section">
        <div class="popup-title-text" title="[[title]]">[[title]]</div>
        <span class="popup-location-text" title="[[location]]">
          <i class="fa fa-map-marker"></i>
          [[location]]
        </span>
      </div>
      <div class="popup-actions-container">
        <a class="action-button btn-primary view-details-btn" data-property-id="[[id]]" href="[[url]]" target="_blank" rel="noopener">
          <i class="fa fa-eye"></i>
          View
        </a>
        <button class="action-button btn-fav favorite-btn [[favorite_active]]" data-property-id="[[id]]" title="[[favorite_title]]"><i class="fa fa-heart-o"></i></button>
        <button class="action-button btn-share share-btn" data-property-id="[[id]]" title="Share"><i class="fa fa-share-alt"></i></button>
      </div>
    </div>
  </div>
</template>
<?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/pages/property/partials/map-popup-template.blade.php ENDPATH**/ ?>