<?php $__env->startSection('head_title', 'Property Map View - '.getcong('site_name')); ?>

<?php $__env->startSection('head_url', Request::url()); ?>

<?php $__env->startPush('head'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<!-- Map View Header -->
<div class="map-view-header">
  <div class="container-fluid">
    <div class="row align-items-center">
      <div class="col-md-6">
        <h3 class="map-view-title">
          <i class="fa fa-map-marker"></i> Property Discovery
          <span id="property-count" class="property-count">0 properties</span>
        </h3>
        <div class="map-breadcrumb">
          <span class="breadcrumb-item">Home</span>
          <i class="fa fa-chevron-right"></i>
          <span class="breadcrumb-item active">Map View</span>
        </div>
      </div>
      <div class="col-md-6 text-right">
        <div class="map-view-controls">
          <div class="view-mode-toggle">
            <a href="<?php echo e(URL::to('properties')); ?>" class="view-btn" title="Grid View">
              <i class="fa fa-th"></i>
            </a>
            <a href="<?php echo e(URL::to('properties')); ?>" class="view-btn" title="List View">
              <i class="fa fa-list"></i>
            </a>
            <button id="map-view-btn-active" class="view-btn active" title="Map View">
              <i class="fa fa-map"></i>
            </button>
          </div>
          <button id="toggle-filters" class="btn btn-outline-primary btn-sm">
            <i class="fa fa-filter"></i> <span class="btn-text">Filters</span>
          </button>
          <button id="toggle-3d-mode" class="btn btn-outline-info btn-sm">
            <i class="fa fa-cube"></i> <span class="btn-text">3D</span>
          </button>
          <button id="toggle-dark-mode" class="btn btn-outline-secondary btn-sm">
            <i class="fa fa-moon-o"></i> <span class="btn-text">Dark</span>
          </button>
          <button id="fullscreen-map" class="btn btn-outline-warning btn-sm">
            <i class="fa fa-expand"></i> <span class="btn-text">Fullscreen</span>
          </button>
          <a href="<?php echo e(URL::to('properties')); ?>" class="btn btn-outline-danger btn-sm">
            <i class="fa fa-times"></i> <span class="btn-text">Close</span>
          </a>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Map View Content -->
<div class="map-view-content">
  <!-- Left Panel: Interactive Map -->
  <div id="map-left-panel" class="map-left-panel">
    <div id="advanced-map" class="advanced-map"></div>
    
    <!-- Map Controls -->
    <?php echo $__env->make('pages.property.partials.map-controls', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </div>

  <!-- Right Panel: Filters Topbar + Property List -->
  <div id="map-right-panel" class="map-right-panel">
    <?php echo $__env->make('pages.property.partials.map-filters', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('pages.property.partials.property-list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/map-view.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Complete Filter Panel JavaScript with Backend Integration
document.addEventListener('DOMContentLoaded', function() {
    // Initialize price range slider
    initializePriceRangeSlider();
    
    // Purpose tabs functionality
    const purposeTabs = document.querySelectorAll('.purpose-tab');
    const purposeInput = document.getElementById('purpose-input');
    
    purposeTabs.forEach(tab => {
        tab.addEventListener('click', function() {
            // Remove active class from all tabs
            purposeTabs.forEach(t => t.classList.remove('active'));
            // Add active class to clicked tab
            this.classList.add('active');
            
            // Update hidden input
            const purpose = this.dataset.purpose;
            if (purposeInput) {
                purposeInput.value = purpose;
            }
            
            // Auto-submit form for real-time filtering
            submitFilterForm();
        });
    });

    // More options toggle
    const moreOptionsBtn = document.getElementById('more-search-options');
    const advancedFilters = document.getElementById('advanced-filters');
    
    if (moreOptionsBtn && advancedFilters) {
        moreOptionsBtn.addEventListener('click', function() {
            const isExpanded = advancedFilters.style.display !== 'none';
            
            if (isExpanded) {
                advancedFilters.style.display = 'none';
                this.classList.remove('expanded');
            } else {
                advancedFilters.style.display = 'block';
                this.classList.add('expanded');
            }
        });
    }

    // Radius slider functionality
    const radiusSlider = document.getElementById('search-radius');
    const radiusValue = document.getElementById('radius-value');
    
    if (radiusSlider && radiusValue) {
        radiusSlider.addEventListener('input', function() {
            radiusValue.textContent = this.value + ' km';
        });
        
        radiusSlider.addEventListener('change', function() {
            // Auto-submit when radius changes
            submitFilterForm();
        });
    }

    // GPS button functionality
    const gpsButton = document.getElementById('use-gps');
    const locationInput = document.getElementById('location-search');
    
    if (gpsButton && locationInput) {
        gpsButton.addEventListener('click', function() {
            if (navigator.geolocation) {
                this.innerHTML = '<i class="fa fa-spinner fa-spin"></i>';
                
                navigator.geolocation.getCurrentPosition(
                    function(position) {
                        const lat = position.coords.latitude;
                        const lng = position.coords.longitude;
                        
                        // Use reverse geocoding or coordinates
                        locationInput.value = `${lat.toFixed(4)}, ${lng.toFixed(4)}`;
                        gpsButton.innerHTML = '<i class="fa fa-crosshairs"></i>';
                        
                        // Auto-submit after getting location
                        submitFilterForm();
                    },
                    function(error) {
                        console.error('Geolocation error:', error);
                        gpsButton.innerHTML = '<i class="fa fa-crosshairs"></i>';
                        alert('Unable to get your location. Please enter manually.');
                    }
                );
            } else {
                alert('Geolocation is not supported by this browser.');
            }
        });
    }

    // Filter change handlers with debounce
    const filterSelects = document.querySelectorAll('.filter-select');
    filterSelects.forEach(select => {
        select.addEventListener('change', function() {
            console.log(`Filter ${this.id} changed to:`, this.value);
            // Auto-submit form when filters change
            submitFilterForm();
        });
    });

    // Location search with debounce
    if (locationInput) {
        let searchTimeout;
        locationInput.addEventListener('input', function() {
            clearTimeout(searchTimeout);
            searchTimeout = setTimeout(() => {
                if (this.value.length > 2) {
                    submitFilterForm();
                }
            }, 1000); // 1 second delay
        });
    }

    // Reset filters functionality
    const resetBtn = document.getElementById('reset-filters');
    if (resetBtn) {
        resetBtn.addEventListener('click', function() {
            // Reset all form elements
            const form = document.getElementById('map-filter-form');
            if (form) {
                form.reset();
            }
            
            // Reset purpose tabs
            purposeTabs.forEach(tab => tab.classList.remove('active'));
            if (purposeTabs[0]) {
                purposeTabs[0].classList.add('active');
                if (purposeInput) purposeInput.value = 'Sale';
            }
            
            // Reset radius
            if (radiusSlider && radiusValue) {
                radiusSlider.value = 10;
                radiusValue.textContent = '10 km';
            }
            
            // Reset price range slider
            if (window.priceRangeSlider) {
                window.priceRangeSlider.noUiSlider.reset();
            }
            
            // Submit reset form
            submitFilterForm();
        });
    }

    // Form submission handler
    const filterForm = document.getElementById('map-filter-form');
    if (filterForm) {
        filterForm.addEventListener('submit', function(e) {
            e.preventDefault();
            submitFilterForm();
        });
    }
});

// Initialize price range slider using noUiSlider
function initializePriceRangeSlider() {
    const priceSlider = document.getElementById('price_range_slider');
    const priceInput = document.getElementById('price_range');
    
    if (!priceSlider) return;
    
    // Load noUiSlider if not already loaded
    if (typeof noUiSlider === 'undefined') {
        const link = document.createElement('link');
        link.rel = 'stylesheet';
        link.href = 'https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/15.7.1/nouislider.min.css';
        document.head.appendChild(link);
        
        const script = document.createElement('script');
        script.src = 'https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/15.7.1/nouislider.min.js';
        script.onload = function() {
            createPriceSlider();
        };
        document.head.appendChild(script);
    } else {
        createPriceSlider();
    }
    
    function createPriceSlider() {
        // Get current values or set defaults
        const currentRange = priceInput.value || '500000 - 10000000';
        const [minVal, maxVal] = currentRange.split(' - ').map(v => parseInt(v.replace(/[^\d]/g, '')) || 0);
        
        noUiSlider.create(priceSlider, {
            start: [minVal || 500000, maxVal || 10000000],
            connect: true,
            range: {
                'min': 0,
                'max': 50000000
            },
            step: 100000,
            format: {
                to: function(value) {
                    return Math.round(value);
                },
                from: function(value) {
                    return Number(value);
                }
            }
        });
        
        // Store reference for reset functionality
        window.priceRangeSlider = priceSlider;
        
        priceSlider.noUiSlider.on('update', function(values, handle) {
            const min = parseInt(values[0]);
            const max = parseInt(values[1]);
            const currency = '<?php echo e(html_entity_decode(getCurrencySymbols(getcong("currency_code")))); ?>';
            
            priceInput.value = `${currency}${formatNumber(min)} - ${currency}${formatNumber(max)}`;
        });
        
        priceSlider.noUiSlider.on('change', function(values, handle) {
            // Auto-submit when price range changes
            submitFilterForm();
        });
    }
}

// Format number for display
function formatNumber(num) {
    if (num >= 10000000) {
        return (num / 10000000).toFixed(1) + 'Cr';
    } else if (num >= 100000) {
        return (num / 100000).toFixed(1) + 'L';
    } else if (num >= 1000) {
        return (num / 1000).toFixed(1) + 'K';
    }
    return num.toString();
}

// Submit filter form and update map
function submitFilterForm() {
    const form = document.getElementById('map-filter-form');
    if (!form) return;
    
    const formData = new FormData(form);
    const params = new URLSearchParams(formData);
    
    // Update map with new filters
    if (window.mapView && window.mapView.updateFilters) {
        window.mapView.updateFilters(Object.fromEntries(params));
    }
    
    // Update property list
    updatePropertyList(params.toString());
}

// Update property list via AJAX
function updatePropertyList(queryString) {
    const listContainer = document.getElementById('property-list-container');
    const countElement = document.getElementById('property-count');
    
    if (!listContainer) return;
    
    // Show loading state
    listContainer.innerHTML = '<div class="loading-properties"><i class="fa fa-spinner fa-spin"></i> Loading properties...</div>';
    
    fetch(`/properties/map-data?${queryString}`, {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.properties) {
            updatePropertyListHTML(data.properties);
            
            // Update count
            if (countElement) {
                countElement.textContent = `${data.properties.length} properties`;
            }
        }
    })
    .catch(error => {
        console.error('Error updating properties:', error);
        listContainer.innerHTML = '<div class="error-state">Error loading properties. Please try again.</div>';
    });
}

// Update property list HTML
function updatePropertyListHTML(properties) {
    const listContainer = document.getElementById('property-list-container');
    const emptyState = document.getElementById('empty-state');
    
    if (properties.length === 0) {
        listContainer.innerHTML = '';
        if (emptyState) emptyState.style.display = 'block';
        return;
    }
    
    if (emptyState) emptyState.style.display = 'none';
    
    const html = properties.map(property => `
        <div class="property-item" data-id="${property.id}">
            <div class="property-image">
                <img src="${property.image}" alt="${property.title}" loading="lazy">
                <div class="property-badge">${property.purpose}</div>
            </div>
            <div class="property-details">
                <h6 class="property-title">${property.title}</h6>
                <p class="property-location">
                    <i class="fa fa-map-marker"></i> ${property.location || property.address}
                </p>
                <div class="property-features">
                    <span><i class="fa fa-bed"></i> ${property.bedrooms || 0}</span>
                    <span><i class="fa fa-bath"></i> ${property.bathrooms || 0}</span>
                </div>
                <div class="property-price">
                    <?php echo e(html_entity_decode(getCurrencySymbols(getcong('currency_code')))); ?>${formatNumber(property.price)}
                </div>
            </div>
        </div>
    `).join('');
    
    listContainer.innerHTML = html;
}

// Initialize current location on map startup with enhanced error handling
function initializeCurrentLocation() {
    const locationInput = document.getElementById('location-search');
    
    // Check if geolocation is supported
    if (!navigator.geolocation) {
        console.warn('Geolocation is not supported by this browser');
        showLocationError('Geolocation not supported');
        return;
    }
    
    // Show loading indicator
    showLocationLoading();
    
    // Get current position with options
    const options = {
        enableHighAccuracy: true,
        timeout: 15000, // Increased timeout
        maximumAge: 300000 // 5 minutes cache
    };
    
    navigator.geolocation.getCurrentPosition(
        function(position) {
            try {
                const lat = position.coords.latitude;
                const lng = position.coords.longitude;
                const accuracy = position.coords.accuracy;
                
                console.log('Current location detected:', lat, lng, 'accuracy:', accuracy + 'm');
                
                // Validate coordinates
                if (!isValidCoordinate(lat, lng)) {
                    throw new Error('Invalid coordinates received');
                }
                
                // Store current location globally for map initialization
                window.currentUserLocation = {
                    lat: lat,
                    lng: lng,
                    accuracy: accuracy
                };
                
                // Hide loading indicator
                hideLocationLoading();
                
                // Reverse geocode to get address name with error handling
                reverseGeocode(lat, lng, function(address) {
                    if (locationInput && address) {
                        locationInput.value = address;
                        locationInput.placeholder = address;
                    }
                }, function(error) {
                    console.warn('Reverse geocoding failed:', error);
                });
                
                // Initialize map with current location if map is ready
                if (window.mapView && window.mapView.setCenter) {
                    window.mapView.setCenter(lat, lng);
                    window.mapView.setZoom(12); // Zoom to neighborhood level
                } else {
                    // Store for later use when map initializes
                    window.initialMapCenter = { lat: lat, lng: lng, zoom: 12 };
            }
            
            // Auto-submit filters to load nearby properties
            setTimeout(() => {
                submitFilterForm();
            }, 1000);
            } catch (error) {
                console.error('Error processing location:', error);
                hideLocationLoading();
                showLocationError('Failed to process location data');
            }
        },
        function(error) {
            console.warn('Geolocation error:', error.message);
            hideLocationLoading();
            
            let errorMessage = 'Unable to get your location';
            switch(error.code) {
                case error.PERMISSION_DENIED:
                    errorMessage = 'Location access denied by user';
                    break;
                case error.POSITION_UNAVAILABLE:
                    errorMessage = 'Location information unavailable';
                    break;
                case error.TIMEOUT:
                    errorMessage = 'Location request timed out';
                    break;
            }
            
            showLocationError(errorMessage);
        },
        options
    );
}

// Helper functions for location handling
function isValidCoordinate(lat, lng) {
    return !isNaN(lat) && !isNaN(lng) && 
           lat >= -90 && lat <= 90 && 
           lng >= -180 && lng <= 180;
}

function showLocationLoading() {
    const gpsBtn = document.querySelector('.gps-btn');
    if (gpsBtn) {
        gpsBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i>';
        gpsBtn.disabled = true;
    }
}

function hideLocationLoading() {
    const gpsBtn = document.querySelector('.gps-btn');
    if (gpsBtn) {
        gpsBtn.innerHTML = '<i class="fa fa-location-arrow"></i>';
        gpsBtn.disabled = false;
    }
}

function showLocationError(message) {
    console.error('Location Error:', message);
    // You can add toast notification here if needed
    const gpsBtn = document.querySelector('.gps-btn');
    if (gpsBtn) {
        gpsBtn.style.color = '#dc3545';
        setTimeout(() => {
            gpsBtn.style.color = '';
        }, 3000);
    }
}

// Enhanced reverse geocoding function with error handling
function reverseGeocode(lat, lng, successCallback, errorCallback) {
    // Use Google Maps Geocoding API if available
    if (window.google && window.google.maps && window.google.maps.Geocoder) {
        const geocoder = new google.maps.Geocoder();
        const latlng = { lat: lat, lng: lng };
        
        geocoder.geocode({ location: latlng }, function(results, status) {
            if (status === 'OK' && results[0]) {
                // Get the most relevant address component
                const address = results[0].formatted_address;
                if (successCallback) successCallback(address);
            } else {
                console.warn('Geocoding failed:', status);
                if (errorCallback) errorCallback('Geocoding failed: ' + status);
            }
        });
    } else {
        // Fallback to a simple coordinate display
        const fallbackAddress = `${lat.toFixed(4)}, ${lng.toFixed(4)}`;
        if (successCallback) successCallback(fallbackAddress);
    }
}

// Map initialization manager - handles clean setup and prevents reload issues
class MapInitializer {
    constructor() {
        this.isInitialized = false;
        this.isInitializing = false;
        this.initPromise = null;
        this.retryCount = 0;
        this.maxRetries = 2;
        this.modules = [];
        this.mapView = null;
    }

    async loadScript(src) {
        return new Promise((resolve, reject) => {
            // Check if script already exists
            const existing = document.querySelector(`script[src="${src}"]`);
            if (existing) {
                if (existing.dataset.loaded === 'true') {
                    resolve();
                    return;
                }
                existing.addEventListener('load', resolve);
                existing.addEventListener('error', reject);
                return;
            }

            const script = document.createElement('script');
            script.src = src;
            script.onload = () => {
                script.dataset.loaded = 'true';
                resolve();
            };
            script.onerror = () => reject(new Error(`Failed to load script: ${src}`));
            document.head.appendChild(script);
        });
    }

    async loadModules() {
        const moduleScripts = [
            "<?php echo e(asset('assets/js/map-view/map-utils.js')); ?>",
            "<?php echo e(asset('assets/js/map-view/map-core.js')); ?>",
            "<?php echo e(asset('assets/js/map-view/map-filters.js')); ?>",
            "<?php echo e(asset('assets/js/map-view/map-markers.js')); ?>",
            "<?php echo e(asset('assets/js/map-view/map-interactions.js')); ?>",
            "<?php echo e(asset('assets/js/map-view/property-details.js')); ?>"
        ];

        try {
            for (const src of moduleScripts) {
                await this.loadScript(src);
            }
            console.log('All map modules loaded successfully');
        } catch (error) {
            console.error('Error loading map modules:', error);
            throw new Error('Failed to load required map modules');
        }
    }

    async waitForGoogleMaps(timeout = 15000) {
        const startTime = Date.now();
        
        while (!window.google?.maps?.Map) {
            if (Date.now() - startTime > timeout) {
                throw new Error('Google Maps API failed to load within timeout');
            }
            await new Promise(resolve => setTimeout(resolve, 100));
        }
        
        // Ensure required libraries are loaded
        const requiredLibs = ['drawing', 'geometry'];
        for (const lib of requiredLibs) {
            while (!window.google.maps[lib]) {
                if (Date.now() - startTime > timeout) {
                    console.warn(`Google Maps ${lib} library not loaded, continuing anyway`);
                    break;
                }
                await new Promise(resolve => setTimeout(resolve, 100));
            }
        }
    }

    showLoadingState() {
       
    }

    showErrorState(error, canRetry = true) {
        const container = document.getElementById('advanced-map');
        if (!container) return;

        let errorMessage = 'Failed to initialize map';
        if (error.message.includes('Google Maps API')) {
            errorMessage = 'Google Maps failed to load. Please check your internet connection.';
        } else if (error.message.includes('modules')) {
            errorMessage = 'Map components failed to load. Please refresh the page.';
        } else if (error.message.includes('timeout')) {
            errorMessage = 'Map loading timed out. Please try again.';
        }

        container.innerHTML = `
            <div class="map-error-state" style="
                display: flex;
                align-items: center;
                justify-content: center;
                height: 100%;
                min-height: 400px;
                background: #f8f9fa;
                border: 2px dashed #dee2e6;
                border-radius: 8px;
                text-align: center;
                padding: 40px;
            ">
                <div>
                    <div style="font-size: 48px; color: #dc3545; margin-bottom: 20px;">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                    <h4 style="color: #495057; margin-bottom: 12px;">Map Initialization Failed</h4>
                    <p style="color: #6c757d; margin-bottom: 24px; max-width: 400px;">
                        ${errorMessage}
                    </p>
                    <div>
                        ${canRetry && this.retryCount < this.maxRetries ? `
                            <button class="btn btn-primary me-2" onclick="window.mapInitializer.retry()">
                                <i class="fa fa-refresh"></i> Try Again
                            </button>
                        ` : ''}
                        <button class="btn btn-outline-secondary" onclick="location.reload()">
                            <i class="fa fa-reload"></i> Reload Page
                        </button>
                    </div>
                    <details style="margin-top: 20px; text-align: left;">
                        <summary style="cursor: pointer; color: #6c757d;">Technical Details</summary>
                        <pre style="
                            background: #f1f3f4;
                            padding: 12px;
                            border-radius: 4px;
                            font-size: 12px;
                            margin-top: 8px;
                            overflow-x: auto;
                            white-space: pre-wrap;
                        ">${error.stack || error.message}</pre>
                    </details>
                </div>
            </div>
        `;
    }

    async initialize() {
        // Prevent multiple simultaneous initializations
        if (this.isInitialized) {
            return this.initPromise;
        }
        if (this.isInitializing) {
            // Wait for the ongoing initialization
            return this.initPromise;
        }
        this.isInitializing = true;
        this.initPromise = this._doInitialize()
            .then(() => {
                this.isInitialized = true;
                this.isInitializing = false;
                return true;
            })
            .catch((err) => {
                this.isInitialized = false;
                this.isInitializing = false;
                this.initPromise = null;
                throw err;
            });
        return this.initPromise;
    }

    async _doInitialize() {
        try {
            this.showLoadingState();

            // Step 1: Load all required modules
            await this.loadModules();

            // Step 2: Wait for Google Maps API
            await this.waitForGoogleMaps();

            // Step 3: Try to get current location first (with timeout)
            await this.waitForCurrentLocation();

            // Step 4: Verify MapView class is available
            if (typeof MapView === 'undefined') {
                throw new Error('MapView class not available after loading modules');
            }

            // Step 5: Initialize MapView
            // Use current location if available, otherwise fallback to default
            const mapCenter = window.currentUserLocation || window.initialMapCenter || { lat: 20.5937, lng: 78.9629 };
            const mapZoom = window.currentUserLocation ? 12 : (window.initialMapCenter ? window.initialMapCenter.zoom : 6);
            
            this.mapInstance = new MapView({
                mapContainer: 'advanced-map',
                apiEndpoint: "<?php echo e(url('properties/map-data')); ?>",
                currencySymbol: "<?php echo e(html_entity_decode(getCurrencySymbols(getcong('currency_code')))); ?>",
                propertyTypes: <?php echo json_encode(\App\Type::where('status', 1)->orderby('type_name')->get(), 512) ?>,
                defaultCenter: [mapCenter.lat, mapCenter.lng],
                defaultZoom: mapZoom
            });

            // Step 6: Initialize the map view
            await this.mapInstance.init();

            this.isInitialized = true;
            console.log('Map initialized successfully with center:', mapCenter);

        } catch (error) {
            console.error('Map initialization failed:', error);
            this.showErrorState(error, this.retryCount < this.maxRetries);
            throw error;
        }
    }

    async waitForCurrentLocation() {
        return new Promise((resolve) => {
            // If location is already available, resolve immediately
            if (window.currentUserLocation) {
                console.log('Current location already available:', window.currentUserLocation);
                resolve();
                return;
            }

            // Set a timeout to not wait too long for geolocation
            const timeout = setTimeout(() => {
                console.log('Geolocation timeout - proceeding with default location');
                resolve();
            }, 8000); // 8 second timeout

            // Start geolocation if not already started
            if (!window.geolocationStarted) {
                window.geolocationStarted = true;
                this.getCurrentLocation().then(() => {
                    clearTimeout(timeout);
                    resolve();
                }).catch(() => {
                    clearTimeout(timeout);
                    resolve();
                });
            } else {
                // Check periodically if location becomes available
                const checkInterval = setInterval(() => {
                    if (window.currentUserLocation) {
                        clearInterval(checkInterval);
                        clearTimeout(timeout);
                        resolve();
                    }
                }, 500);
            }
        });
    }

    async getCurrentLocation() {
        return new Promise((resolve, reject) => {
            if (!navigator.geolocation) {
                reject(new Error('Geolocation not supported'));
                return;
            }

            const options = {
                enableHighAccuracy: true,
                timeout: 10000,
                maximumAge: 300000
            };

            navigator.geolocation.getCurrentPosition(
                (position) => {
                    const lat = position.coords.latitude;
                    const lng = position.coords.longitude;
                    
                    if (isValidCoordinate(lat, lng)) {
                        window.currentUserLocation = {
                            lat: lat,
                            lng: lng,
                            accuracy: position.coords.accuracy
                        };
                        console.log('Geolocation success:', window.currentUserLocation);
                        resolve(window.currentUserLocation);
                    } else {
                        reject(new Error('Invalid coordinates'));
                    }
                },
                (error) => {
                    console.warn('Geolocation failed:', error.message);
                    reject(error);
                },
                options
            );
        });
    }

    async retry() {
        if (this.retryCount >= this.maxRetries) {
            console.warn('Maximum retry attempts reached');
            return;
        }
        this.retryCount++;
        this.isInitialized = false;
        this.isInitializing = false;
        this.initPromise = null;
        // Clean up previous map instance if any
        if (this.mapInstance && typeof this.mapInstance.destroy === 'function') {
            try { this.mapInstance.destroy(); } catch (_) {}
        }
        this.mapInstance = null;
        console.log(`Retrying map initialization (attempt ${this.retryCount + 1})`);
        await this.initialize();
    }

    // Cleanup method for page unload
    cleanup() {
        if (this.mapView && typeof this.mapView.destroy === 'function') {
            this.mapView.destroy();
        }
        this.mapView = null;
        this.isInitialized = false;
        this.isInitializing = false;
        this.initPromise = null;
    }
}

// Create global initializer instance
window.mapInitializer = new MapInitializer();

// Google Maps callback
window.initMap = function() {
    // Always use the same promise to avoid race conditions
    window.mapInitializer.initialize().catch(error => {
        console.error('Failed to initialize map from callback:', error);
    });
};

// Initialize when DOM is ready
document.addEventListener('DOMContentLoaded', function() {
    // Small delay to ensure all resources are ready
    setTimeout(() => {
        // Only initialize if not already started by Google callback
        if (!window.mapInitializer.isInitialized && !window.mapInitializer.isInitializing) {
            window.mapInitializer.initialize().catch(error => {
                console.error('Failed to initialize map on DOM ready:', error);
            });
        }
    }, 100);
});

// Cleanup on page unload
window.addEventListener('beforeunload', function() {
    if (window.mapInitializer) {
        window.mapInitializer.cleanup();
    }
});
</script>

<!-- Load Google Maps API -->
<script>
(function() {
    // Prevent multiple script injections
    if (document.querySelector('script[src*="maps.googleapis.com"]')) {
        return;
    }
    
    const script = document.createElement('script');
    script.src = 'https://maps.googleapis.com/maps/api/js?key=AIzaSyCHL0C6zAjjNzW-J-EhekmEDzNxBUv5FXw&libraries=drawing,geometry,marker&loading=async&callback=initMap';
    script.async = true;
    script.defer = true;
    script.onerror = function() {
        console.error('Failed to load Google Maps API');
        if (window.mapInitializer) {
            window.mapInitializer.showErrorState(new Error('Google Maps API failed to load'), true);
        }
    };
    document.head.appendChild(script);
})();
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('site_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/realestate.dextragroups.com/resources/views/pages/property/map.blade.php ENDPATH**/ ?>