

<?php $__env->startSection('head_title', isset($info->id) ? trans('words.edit_property') : trans('words.add_property').' | '.getcong('site_name') ); ?>

<?php $__env->startSection('head_url', Request::url()); ?>

<?php $__env->startSection('content'); ?>

<link href="<?php echo e(URL::asset('site_assets/js/bootstrap-tagsinput/dist/bootstrap-tagsinput.css')); ?>" rel="stylesheet" />

<script src="<?php echo e(URL::asset('site_assets/js/tinymce/tinymce.min.js')); ?>"></script>
 

  <!--Breadcrumb section starts-->
  <div class="breadcrumb-section bg-xs" style="background-image: url(<?php echo e(URL::asset('site_assets/images/breadcrumb-1.jpg')); ?>)">
    <div class="overlay op-2"></div>
    <div class="container">
      <div class="row">
        <div class="col-md-12 text-center">
          <div class="breadcrumb-menu">
            <h2><?php echo e(isset($info->id) ? trans('words.edit_property') : trans('words.add_property')); ?> </h2>
            <span><a href="<?php echo e(URL::to('/')); ?>"><?php echo e(trans('words.home')); ?></a></span> <span><?php echo e(isset($info->id) ? trans('words.edit_property') : trans('words.add_property')); ?></span></div>
        </div>
      </div>
    </div>
  </div>
  <!--Breadcrumb section ends--> 

 <!--Add Property section starts-->
 <div class="about-section pt-30 pb-20">
    <div class="container">
      <div class="row">
         <div class="col-lg-10 col-md-10 m-auto">
	     <?php echo e(html()->form('POST', url('/user/property/add_edit'))
                     ->attributes(['class' => '', 'id' => 'property_form', 'name' => 'property_form', 'role' => 'form', 'enctype' => 'multipart/form-data'])->open()); ?>

 

            <input type="hidden" name="id" value="<?php echo e(isset($info->id) ? $info->id : null); ?>">

                
                <div class="mb-4">
                    <div class="d-flex align-items-center p-3" style="background: linear-gradient(90deg,#fff7ed,#fff1f0); border-radius:12px; border:1px solid #ffe5d4;">
                        <div style="flex:0 0 auto; width:56px; height:56px; display:grid; place-items:center; background:#fff; border-radius:10px; box-shadow: 0 4px 12px rgba(216,35,42,0.08);">
                            <i class="fa fa-gift" style="color:#dc3545; font-size:22px;"></i>
                        </div>
                        <div style="flex:1 1 auto; padding-left:14px;">
                            <div style="font-weight:700; color:#2c2c2c; font-size:16px;">Post free for 10 days</div>
                            <div style="color:#6b6b6b; font-size:13px;">Your listing is free for the first 10 days. After that you can keep it live by purchasing a listing plan.</div>
                        </div>
                        <div style="flex:0 0 auto; padding-left:12px;">
                            <a href="<?php echo e(url('pricing')); ?>" class="btn btn-sm" style="background:#dc3545;color:#fff;border-radius:8px;padding:8px 12px;font-weight:600;">View Plans</a>
                        </div>
                    </div>
                </div>

                <div class="vfx-dashboard-add-list-wrap">
					<div class="vfx-act-title">
						<h5><?php echo e(trans('words.general_information')); ?> :</h5>
					</div>
					<div class="vfx-dashboard-add-listing">
						<div class="row">
							<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 col-12">
								<div class="form-group">
									<label>Number of Units</label>
									<?php
										$userBusinessType = Auth::check() ? Auth::user()->business_type : 1;
										$isIndividual = $userBusinessType == 1;
									?>
									<input type="number"
										   class="form-control filter-input"
										   name="units"
										   value="<?php echo e($isIndividual ? 1 : (isset($info->units) ? $info->units : null)); ?>"
										   min="1"
										   <?php echo e($isIndividual ? 'readonly' : ''); ?>

										   placeholder="<?php echo e($isIndividual ? 'Fixed to 1 for individual users' : 'Enter number of units'); ?>">
									<?php if($isIndividual): ?>
										<small class="form-text text-muted">Individual users can only list 1 unit at a time</small>
									<?php endif; ?>
								</div>
							</div>
							<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 col-12">
								<label><?php echo e(trans('words.type')); ?> *</label>
								<select class="listing-input vfx_hero_form_area_input vfx-custom-select-area" name="type" id="type_id">   
									<option value=""><?php echo e(trans('words.select_type')); ?></option>                            
									<?php $__currentLoopData = $type_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>  
										<option value="<?php echo e($type_data->id); ?>" <?php if(isset($info->id) AND $type_data->id==$info->type_id): ?> selected <?php endif; ?>><?php echo e($type_data->type_name); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>   
								</select>
							</div>
							<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 col-12">
								<label><?php echo e(trans('words.purpose')); ?></label>
								 <select class="listing-input vfx_hero_form_area_input vfx-custom-select-area" name="purpose" id="purpose">                               
									<option value="Sale" <?php if(isset($info->purpose) AND $info->purpose=="Sale"): ?> selected <?php endif; ?>>Sale</option>
									<option value="Rent" <?php if(isset($info->purpose) AND $info->purpose=="Rent"): ?> selected <?php endif; ?>>Rent</option>
								 </select>
 							</div>
							<div class="col-lg-6 col-md-4 col-sm-6 col-xs-12 col-12">
								<div class="form-group">
									<label><?php echo e(trans('words.property_title')); ?> *</label>
									<input type="text" name="title" class="form-control filter-input" value="<?php echo e(isset($info->title) ? stripslashes($info->title) : null); ?>">
								</div>
							</div>
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 col-12">
								<div class="form-group">
									<label><?php echo e(trans('words.description')); ?> </label>
									<textarea id="description" name="description" class="elm1_editor form-control filter-input"><?php echo e(isset($info->description) ? stripslashes($info->description) : null); ?></textarea>
								</div>
							</div>
							<div class="col-lg-6 col-md-4 col-sm-6 col-xs-12 col-12">
								<div class="form-group">
									<label><?php echo e(trans('words.phone')); ?></label>
                                    <input type="text" name="phone" class="form-control filter-input" value="<?php echo e(isset($info->phone) ? $info->phone : null); ?>">
                                </div>
                                <div class="form-group">
                                    <label><?php echo e(trans('words.select_city')); ?></label>
                                    <select id="city_select" name="city" class="listing-input vfx_hero_form_area_input vfx-custom-select-area">
                                        <option value=""><?php echo e(trans('words.select_city')); ?></option>
                                        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $__currentLoopData = $loc->cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($city->id); ?>" data-location-id="<?php echo e($loc->id); ?>" <?php if(isset($info->city_id) AND $info->city_id==$city->id): ?> selected <?php endif; ?>><?php echo e($city->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>YouTube Video Link</label>
                                    <input type="text" name="youtube_link" class="form-control filter-input" value="<?php echo e(isset($info->youtube_link) ? $info->youtube_link : null); ?>" placeholder="Paste YouTube video URL here">
                                </div>
							</div>
							<div class="col-lg-6 col-md-4 col-sm-6 col-xs-12 col-12">
								<div class="form-group">
									<label><?php echo e(trans('words.location_text')); ?> *</label>
                                    <select class="listing-input vfx_hero_form_area_input vfx-custom-select-area" name="location" id="location">   
                                        <option value=""><?php echo e(trans('words.select_location')); ?></option>                            
                                        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>  
                                            <option value="<?php echo e($location_data->id); ?>" data-city-ids="<?php echo e(implode(',', $location_data->cities->pluck('id')->toArray())); ?>" <?php if(isset($info->id) AND $location_data->id==$info->location_id): ?> selected <?php endif; ?>><?php echo e($location_data->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>   
                                    </select>
								</div>
							</div>
							<div class="col-lg-6 col-md-4 col-sm-6 col-xs-12 col-12">
								<div class="form-group">
									<label><?php echo e(trans('words.address')); ?></label>
									<textarea id="elm1" name="address" class="form-control filter-input"><?php echo e(isset($info->address) ? stripslashes($info->address) : null); ?></textarea>
								</div>
							</div>
							<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 col-12">
								<div class="form-group">
									<label><?php echo e(trans('words.latitude')); ?> <span><a href="http://www.latlong.net" target="_blank">Find Here!</a></span></label>
									<input type="text" name="latitude" id="latitude" value="<?php echo e(isset($info->latitude) ? stripslashes($info->latitude) : null); ?>" class="form-control filter-input" placeholder="Latitude" readonly>
								</div>
							</div>
							<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 col-12">
								<div class="form-group">
									<label><?php echo e(trans('words.longitude')); ?></label>
									<input type="text" name="longitude" id="longitude" value="<?php echo e(isset($info->longitude) ? stripslashes($info->longitude) : null); ?>" class="form-control filter-input" placeholder="Longitude" readonly>
								</div>
							</div>
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 col-12">
								<div class="form-group">
									<label>Map Location</label>
									<small class="form-text text-muted">Click on the map to select location or use current location</small>
									<div id="map" style="height: 400px; width: 100%; margin-top: 10px; border: 1px solid #ddd; border-radius: 5px;"></div>
								</div>
							</div>
							
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 col-12">
								<div class="vfx-act-title mt-15">
									<h5>Overview</h5>
								</div>
							</div>
							
							<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 col-12">
								<div class="form-group">
									<label><?php echo e(trans('words.bedrooms')); ?></label>
									<input type="text" class="form-control filter-input" name="bedrooms" value="<?php echo e(isset($info->bedrooms) ? stripslashes($info->bedrooms) : null); ?>">
								</div>
							</div>

							<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 col-12">
								<div class="form-group">
									<label><?php echo e(trans('words.bathrooms')); ?></label>
									<input type="text" class="form-control filter-input" name="bathrooms" value="<?php echo e(isset($info->bathrooms) ? stripslashes($info->bathrooms) : null); ?>">
								</div>
							</div>

							<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 col-12">
								<div class="form-group">
									<label><?php echo e(trans('words.area')); ?></label>
									<input type="text" class="form-control filter-input" name="area" value="<?php echo e(isset($info->area) ? stripslashes($info->area) : null); ?>">
								</div>
							</div>

							

							<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 col-12">
								<div class="form-group">
									<label><?php echo e(trans('words.furnishing')); ?></label>
									<select class="listing-input vfx_hero_form_area_input vfx-custom-select-area" name="furnishing" id="furnishing">                               
										<option value="Unfurnished" <?php if(isset($info->furnishing) AND $info->furnishing=="Unfurnished"): ?> selected <?php endif; ?>>Unfurnished</option>
										<option value="Semi-Furnished" <?php if(isset($info->furnishing) AND $info->furnishing=="Semi-Furnished"): ?> selected <?php endif; ?>>Semi-Furnished</option>
										<option value="Furnished" <?php if(isset($info->furnishing) AND $info->furnishing=="Furnished"): ?> selected <?php endif; ?>>Furnished</option>
									</select> 
								</div>
							</div>

							<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 col-12">
								<label><?php echo e(trans('words.price')); ?></label>
								<input type="text" class="form-control filter-input" name="price" value="<?php echo e(isset($info->price) ? $info->price : null); ?>">
							</div>
							<div class="col-lg-6 col-md-4 col-sm-6 col-xs-12 col-12">
								<div class="form-group">
									<label><?php echo e(trans('words.amenities')); ?></label>
									<!-- Hidden input to store selected amenities -->
									<input type="hidden" name="amenities" id="amenities_input" value="<?php echo e(isset($info->amenities) ? stripslashes($info->amenities) : null); ?>">

									<!-- Search and filter -->
									<div class="amenities-search mb-3">
										<input type="text" id="amenities_search" class="form-control" placeholder="Search amenities..." style="margin-bottom: 10px;">
										<div class="amenities-filter mb-2">
											<button type="button" class="btn btn-sm btn-outline-primary filter-btn active" data-category="all">All</button>
											<button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="basic">Basic</button>
											<button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="security">Security</button>
											<button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="entertainment">Entertainment</button>
											<button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="outdoor">Outdoor</button>
											<button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="utilities">Utilities</button>
										</div>
									</div>

									<!-- Selected amenities display -->
									<div class="selected-amenities mb-3">
										<label class="form-label">Selected Amenities:</label>
										<div id="selected_amenities_display" class="selected-amenities-container" style="min-height: 50px; border: 1px solid #ddd; padding: 10px; border-radius: 4px; background-color: #f8f9fa;">
											<span class="text-muted">No amenities selected</span>
										</div>
									</div>

									<!-- Amenities grid -->
									<div class="amenities-grid" style="max-height: 300px; overflow-y: auto; border: 1px solid #ddd; padding: 15px; border-radius: 4px; background-color: #fff;">
										<div class="row" id="amenities_container">
											<!-- Amenities will be populated by JavaScript -->
										</div>
									</div>

									<!-- Custom amenity input -->
									<div class="custom-amenity mt-3">
										<div class="input-group">
											<input type="text" id="custom_amenity" class="form-control" placeholder="Add custom amenity...">
											<div class="input-group-append">
												<button type="button" class="btn btn-success btn-sm" id="add_custom_amenity">Add</button>
											</div>
										</div>
									</div>
								</div>
							</div>
							  
							<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 col-12">
								<label><?php echo e(trans('words.featured_image')); ?> * <span>(<?php echo e(trans('words.recommended_resolution')); ?> : 800x480, 600x350)</span></label>
								<div class="fileupload_block">
									<input type="file" name="image" onchange="readURL(this);" id="fileupload" value="<?php echo e(isset($info->image) ? stripslashes($info->image) : null); ?>">
									<div class="fileupload_img">
									
									<?php if(isset($info->image)): ?> 
									<img src="<?php echo e(URL::to('/'.$info->image)); ?>" style="width:150px;height:100px" id="pro_featured_image" alt="landscape">	
									<?php else: ?>
									<img src="<?php echo e(URL::to('/site_assets/images/landscape.jpg')); ?>" style="width:150px;height:100px" id="pro_featured_image" alt="landscape">
									<?php endif; ?>
 
									</div>
								</div>									 
							</div>
							<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 col-12">
								<label><?php echo e(trans('words.floor_plan_image')); ?> <span>(<?php echo e(trans('words.recommended_resolution')); ?> : 800x480, 600x350)</span></label>
								<div class="fileupload_block">
									<input type="file" name="floor_plan_image" onchange="readURLFloor(this);" value="<?php echo e(isset($info->floor_plan_image) ? stripslashes($info->floor_plan_image) : null); ?>">
									<div class="fileupload_img">
									<?php if(isset($info->floor_plan_image)): ?> 
									<img src="<?php echo e(URL::to('/'.$info->floor_plan_image)); ?>" style="width:150px;height:100px" id="pro_floor_plan" alt="landscape">	
									<?php else: ?>
									<img src="<?php echo e(URL::to('/site_assets/images/landscape.jpg')); ?>" style="width:150px;height:100px" id="pro_floor_plan" alt="landscape">
									<?php endif; ?> 
										
									</div> 
								</div>									 
							</div> 
							<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 col-12">
								<label>Upload Brochure <span>(PDF format)</span></label>
								<div class="fileupload_block">
									<input type="file" name="brochure" accept=".pdf" value="<?php echo e(isset($info->brochure) ? stripslashes($info->brochure) : null); ?>">
									<div class="fileupload_img">
									<?php if(isset($info->brochure)): ?> 
									<a href="<?php echo e(URL::to('/'.$info->brochure)); ?>" target="_blank" class="btn btn-info btn-sm">
										<i class="fa fa-file-pdf-o"></i> <?php echo e(trans('words.view_brochure')); ?>

									</a>
									<?php else: ?>
									<img src="<?php echo e(URL::to('/site_assets/images/pdf-icon.png')); ?>" style="width:150px;height:100px" alt="PDF">
									<?php endif; ?> 
									</div> 
								</div>									 
							</div> 
							
						<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 col-12">
							<div class="vfx-act-title mt-15">
								<h5><?php echo e(trans('words.gallery_images')); ?></h5>
							</div>
						</div>

						<?php if(isset($info->id)): ?>
						<div class="gallery_item col-md-12 mb-15">	
							<div class="row">
								<?php $__currentLoopData = $gallery_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $gallery_img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<div class="col-lg-2 col-md-3 col-sm-3 col-xs-4 col-6 gallery_block" id="gallery_box<?php echo e($gallery_img->id); ?>">
									<span title="Delete" class="gall_delete_img">
									<a href="#" class="image_remove" data-toggle="tooltip" title="<?php echo e(trans('words.remove')); ?>" data-id="<?php echo e($gallery_img->id); ?>"> <i class="fa fa-remove"></i> </a>
									</span>
									<img src="<?php echo e(url('/'.$gallery_img->image)); ?>" class="img-thumbnail" alt="gallery" width="140">
								</div> 
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>        
										
							</div>
						</div>	
							
						<br/>
						<?php endif; ?> 
						 
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 col-12">
								<label><?php echo e(trans('words.image')); ?> 1</label>
								<div class="fileupload_block">
									<input type="file" name="image_gallery[]">								 
								</div>									 
							</div>
							
							<div id="dynamicInput"></div>
							
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 col-12">
								<button type="button" class="btn btn-success btn-xs" onClick="addInput('dynamicInput');"><?php echo e(trans('words.add_more_image')); ?></button>
							</div>
							 
                            
                            <div class="col-md-12 text-right sm-left">
                                <button class="btn vfx3" type="submit"><?php echo e(trans('words.submit')); ?></button>
                            </div>
						</div>
					</div>
				</div>
				 
				  
				<?php echo e(html()->form()->close()); ?>

         </div>
      </div>
    </div>
  </div>
  <!--Add Property section ends--> 

 
  
<!-- Scroll to top starts--> 
<span class="vfx-scroll-top-btn"><i class="lnr lnr-arrow-up"></i></span> 
<!-- Scroll to top ends--> 
</div>
<!--Page Wrapper ends--> 
 
<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />

<!-- Leaflet JavaScript -->
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script src="<?php echo e(URL::asset('site_assets/js/jquery.min.js')); ?>"></script>

<script src="<?php echo e(URL::asset('site_assets/js/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js')); ?>" type="text/javascript"></script>


<script type="text/javascript">
$(document).ready(function () {	
  'use strict';	
  if ($(".elm1_editor").length > 0) {
	tinymce.init({
	  selector: "textarea.elm1_editor",           
	  height: 300,
	  plugins: 'print preview paste importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists wordcount imagetools textpattern noneditable help charmap quickbars emoticons',
	   toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor",
	  style_formats: [
		{ title: 'Bold text', inline: 'b' },
		{ title: 'Red text', inline: 'span', styles: { color: '#ff0000' } },
		{ title: 'Red header', block: 'h1', styles: { color: '#ff0000' } },
		{ title: 'Example 1', inline: 'span', classes: 'example1' },
		{ title: 'Example 2', inline: 'span', classes: 'example2' },
		{ title: 'Table styles' },
		{ title: 'Table row 1', selector: 'tr', classes: 'tablerow1' }
	  ]
	});
  }
});
</script>

<script type="text/javascript">
    'use strict';
    <?php if(Session::has('flash_message')): ?>     

<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function() {
    // Filter locations based on selected city
    const citySelect = document.getElementById('city_select');
    const locationSelect = document.getElementById('location');

    if(citySelect && locationSelect){
        citySelect.addEventListener('change', function(){
            const selectedCity = this.value;

            // If a city is selected, find its parent location via data-location-id
            const selectedOption = this.options[this.selectedIndex];
            const locationId = selectedOption ? selectedOption.getAttribute('data-location-id') : null;

            // If locationId found, set location select to that; otherwise clear selection
            if(locationId){
                locationSelect.value = locationId;
            }
        });

        // When location changes, try to set the city if possible
        locationSelect.addEventListener('change', function(){
            const opt = this.options[this.selectedIndex];
            if(!opt) return;

            const cityIds = opt.getAttribute('data-city-ids');
            if(cityIds){
                // If editing and city already set, keep it; otherwise pick first city of this location
                const currentCity = citySelect.value;
                if(!currentCity){
                    const firstCity = cityIds.split(',')[0];
                    if(firstCity) citySelect.value = firstCity;
                }
            }
        });

    }
});
</script>
 
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: false,         
      })

      Toast.fire({
        icon: 'success',
        title: '<?php echo e(Session::get('flash_message')); ?>'
      })     
     
  <?php endif; ?>
 
   
        <?php
            $errors_html = '';
            if (isset($errors) && is_object($errors) && method_exists($errors, 'all')) {
                    $errors_html = '<p>' . implode('<br/>', $errors->all()) . '</p>';
            }
        ?>

        <?php if($errors && is_object($errors) && $errors->any()): ?>
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            html: '<?php echo $errors_html; ?>',
                            showConfirmButton: true,
                            confirmButtonColor: '#10c469',
                            background:"#1a2234",
                            color:"#fff"
                         }) 
        <?php endif; ?>
 

  </script>

<script>
function readURL(input) {
	'use strict';
	if (input.files && input.files[0]) {
	var reader = new FileReader();

	reader.onload = function(e) {
		 $("#pro_featured_image").attr('src', e.target.result);
	}

	reader.readAsDataURL(input.files[0]);
	}
}
function readURLFloor(input) {
	'use strict';
	if (input.files && input.files[0]) {
	var reader = new FileReader();

	reader.onload = function(e) {
		 $("#pro_floor_plan").attr('src', e.target.result);
	}

	reader.readAsDataURL(input.files[0]);
	}
}
</script>

<script type="text/javascript">
// JavaScript Document
'use strict';
var counter = 1;
var limit = 50;
function addInput(divName){
     if (counter == limit)  {
          alert("You have reached the limit of adding " + counter + " inputs");
     }
     else {
          var newdiv = document.createElement('div');

		  newdiv.className = "col-lg-12 col-md-12 col-sm-12 col-xs-12 col-12";

          var wall_number=counter+1;

          newdiv.innerHTML ='<label><?php echo e(trans('words.image')); ?> '+wall_number+'</label><div class="fileupload_block"><input type="file" name="image_gallery[]"></div>';
          document.getElementById(divName).appendChild(newdiv);
          counter++;
     }
}

</script>

<script type="text/javascript">
  //Single   
  $(".image_remove").on('click', function () {      	
  'use strict';	
  
  var post_id = $(this).data("id");
  var action_name='gallery_img_delete';

  Swal.fire({
  title: '<?php echo e(trans('words.dlt_warning')); ?>',
  text: "<?php echo e(trans('words.dlt_warning_text')); ?>",
  icon: 'warning',
  showCancelButton: true,
  confirmButtonColor: '#3085d6',
  cancelButtonColor: '#d33',
  confirmButtonText: '<?php echo e(trans('words.dlt_confirm')); ?>',
  cancelButtonText: "<?php echo e(trans('words.btn_cancel')); ?>",
  background:"#1a2234",
  color:"#fff"

}).then((result) => {

   
    if(result.isConfirmed) { 

        $.ajax({
            type: 'post',
            url: "<?php echo e(URL::to('ajax_actions')); ?>",
            dataType: 'json',
            data: {"_token": "<?php echo e(csrf_token()); ?>",id: post_id, action_for: action_name},
            success: function(res) {

              if(res.status=='1')
              {  

                  var selector = "#gallery_box"+post_id;
                    $(selector ).fadeOut(1000);
                    setTimeout(function(){
                            $(selector ).remove()
                        }, 1000);

                  Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<?php echo e(trans('words.deleted')); ?>!',
                    showConfirmButton: true,
                    confirmButtonColor: '#10c469',
                    background:"#1a2234",
                    color:"#fff"
                  })
                
              } 
              else
              { 
                Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Something went wrong!',
                        showConfirmButton: true,
                        confirmButtonColor: '#10c469',
                        background:"#1a2234",
                        color:"#fff"
                       })
              }
              
            }
        });
    }
 
})

});  
</script>

<!-- Advanced Amenities Selection JavaScript -->
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function() {
    'use strict';

    // Predefined amenities with categories and icons
    const amenitiesData = {
        basic: [
            { name: 'Air Conditioning', icon: 'fa-snowflake-o', value: 'Air Conditioning' },
            { name: 'Heating', icon: 'fa-thermometer-half', value: 'Heating' },
            { name: 'Parking', icon: 'fa-car', value: 'Parking' },
            { name: 'Elevator', icon: 'fa-arrows-v', value: 'Elevator' },
            { name: 'Balcony', icon: 'fa-home', value: 'Balcony' },
            { name: 'Garden', icon: 'fa-leaf', value: 'Garden' },
            { name: 'Terrace', icon: 'fa-home', value: 'Terrace' },
            { name: 'Storage', icon: 'fa-archive', value: 'Storage' }
        ],
        security: [
            { name: 'Security Guard', icon: 'fa-shield', value: 'Security Guard' },
            { name: 'CCTV', icon: 'fa-video-camera', value: 'CCTV' },
            { name: 'Alarm System', icon: 'fa-bell', value: 'Alarm System' },
            { name: 'Intercom', icon: 'fa-phone', value: 'Intercom' },
            { name: 'Gated Community', icon: 'fa-lock', value: 'Gated Community' },
            { name: 'Fire Safety', icon: 'fa-fire-extinguisher', value: 'Fire Safety' }
        ],
        entertainment: [
            { name: 'Swimming Pool', icon: 'fa-tint', value: 'Swimming Pool' },
            { name: 'Gym', icon: 'fa-dumbbell', value: 'Gym' },
            { name: 'Clubhouse', icon: 'fa-building', value: 'Clubhouse' },
            { name: 'Playground', icon: 'fa-child', value: 'Playground' },
            { name: 'Tennis Court', icon: 'fa-table-tennis', value: 'Tennis Court' },
            { name: 'Basketball Court', icon: 'fa-basketball-ball', value: 'Basketball Court' },
            { name: 'Cinema Hall', icon: 'fa-film', value: 'Cinema Hall' },
            { name: 'Library', icon: 'fa-book', value: 'Library' }
        ],
        outdoor: [
            { name: 'BBQ Area', icon: 'fa-fire', value: 'BBQ Area' },
            { name: 'Jogging Track', icon: 'fa-running', value: 'Jogging Track' },
            { name: 'Landscaping', icon: 'fa-tree', value: 'Landscaping' },
            { name: 'Fountain', icon: 'fa-tint', value: 'Fountain' },
            { name: 'Walking Trail', icon: 'fa-walking', value: 'Walking Trail' },
            { name: 'Outdoor Seating', icon: 'fa-chair', value: 'Outdoor Seating' }
        ],
        utilities: [
            { name: 'WiFi', icon: 'fa-wifi', value: 'WiFi' },
            { name: 'Cable TV', icon: 'fa-tv', value: 'Cable TV' },
            { name: 'Internet', icon: 'fa-globe', value: 'Internet' },
            { name: 'Laundry', icon: 'fa-tshirt', value: 'Laundry' },
            { name: 'Power Backup', icon: 'fa-battery-full', value: 'Power Backup' },
            { name: 'Water Heater', icon: 'fa-shower', value: 'Water Heater' },
            { name: 'Dishwasher', icon: 'fa-utensils', value: 'Dishwasher' },
            { name: 'Microwave', icon: 'fa-microchip', value: 'Microwave' }
        ]
    };

    let selectedAmenities = [];
    let currentFilter = 'all';
    let searchTerm = '';

    // Initialize amenities
    function initializeAmenities() {
        const existingAmenities = document.getElementById('amenities_input').value;
        if (existingAmenities) {
            selectedAmenities = existingAmenities.split(',').map(a => a.trim()).filter(a => a);
        }
        renderAmenities();
        updateSelectedDisplay();
    }

    // Render amenities grid
    function renderAmenities() {
        const container = document.getElementById('amenities_container');
        container.innerHTML = '';

        let amenitiesToShow = [];

        // Get amenities based on filter
        if (currentFilter === 'all') {
            Object.values(amenitiesData).forEach(category => {
                amenitiesToShow = amenitiesToShow.concat(category);
            });
        } else {
            amenitiesToShow = amenitiesData[currentFilter] || [];
        }

        // Filter by search term
        if (searchTerm) {
            amenitiesToShow = amenitiesToShow.filter(amenity =>
                amenity.name.toLowerCase().includes(searchTerm.toLowerCase())
            );
        }

        // Render amenities
        amenitiesToShow.forEach(amenity => {
            const isSelected = selectedAmenities.includes(amenity.value);
            const amenityElement = createAmenityElement(amenity, isSelected);
            container.appendChild(amenityElement);
        });
    }

    // Create amenity element
    function createAmenityElement(amenity, isSelected) {
        const col = document.createElement('div');
        col.className = 'col-md-4 col-sm-6 mb-2';

        const amenityClass = isSelected ? 'amenity-item selected' : 'amenity-item';

        col.innerHTML = `
            <div class="${amenityClass}" data-value="${amenity.value}" style="
                padding: 10px;
                border: 1px solid ${isSelected ? '#dc3545' : '#e3e6f0'};
                border-radius: 5px;
                cursor: pointer;
                transition: all 0.3s;
                background-color: ${isSelected ? '#dc3545' : '#fff'};
                color: ${isSelected ? '#ffffff' : '#374151'};
            " onmouseover="this.style.backgroundColor='${isSelected ? '#c82333' : '#f8f9fa'}'" onmouseout="this.style.backgroundColor='${isSelected ? '#dc3545' : '#fff'}'">
                <div class="d-flex align-items-center">
                    <i class="fa ${amenity.icon} mr-2" style="color: ${isSelected ? '#ffffff' : '#9ca3af'};"></i>
                    <span style="font-size: 14px; color: ${isSelected ? '#ffffff' : '#374151'};">
                        ${amenity.name}
                    </span>
                    ${isSelected ? '<i class="fa fa-check ml-auto" style="color: #10b981;"></i>' : ''}
                </div>
            </div>
        `;

        // Add click event
        col.querySelector('.amenity-item').addEventListener('click', function() {
            toggleAmenity(amenity.value);
        });

        return col;
    }

    // Toggle amenity selection
    function toggleAmenity(value) {
        const index = selectedAmenities.indexOf(value);
        if (index > -1) {
            selectedAmenities.splice(index, 1);
        } else {
            selectedAmenities.push(value);
        }

        // Update hidden input
        document.getElementById('amenities_input').value = selectedAmenities.join(',');

        // Re-render amenities and selected display
        renderAmenities();
        updateSelectedDisplay();
    }

    // Update selected amenities display
    function updateSelectedDisplay() {
        const display = document.getElementById('selected_amenities_display');

        if (selectedAmenities.length === 0) {
            display.innerHTML = '<span class="text-muted">No amenities selected</span>';
            return;
        }

        display.innerHTML = selectedAmenities.map(amenity => `
            <span class="badge badge-primary mr-2 mb-2" style="font-size: 12px; padding: 5px 10px; background-color: #dc3545; color: #ffffff; border: 1px solid #bd2130;">
                ${amenity}
                <i class="fa fa-times ml-1" style="cursor: pointer; color: #ffffff;" onclick="removeAmenity('${amenity}')"></i>
            </span>
        `).join('');
    }

    // Remove amenity from selected
    window.removeAmenity = function(value) {
        const index = selectedAmenities.indexOf(value);
        if (index > -1) {
            selectedAmenities.splice(index, 1);
            document.getElementById('amenities_input').value = selectedAmenities.join(',');
            renderAmenities();
            updateSelectedDisplay();
        }
    };

    // Filter buttons
    document.querySelectorAll('.filter-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            // Remove active class from all buttons
            document.querySelectorAll('.filter-btn').forEach(b => b.classList.remove('active'));
            // Add active class to clicked button
            this.classList.add('active');

            currentFilter = this.dataset.category;
            renderAmenities();
        });
    });

    // Search functionality
    document.getElementById('amenities_search').addEventListener('input', function() {
        searchTerm = this.value;
        renderAmenities();
    });

    // Custom amenity addition
    document.getElementById('add_custom_amenity').addEventListener('click', function(e) {
        e.preventDefault();

        const customInput = document.getElementById('custom_amenity');
        const value = customInput.value.trim();

        if (value && !selectedAmenities.includes(value)) {
            selectedAmenities.push(value);
            document.getElementById('amenities_input').value = selectedAmenities.join(',');
            customInput.value = '';
            updateSelectedDisplay();
        }
    });

    // Allow Enter key for custom amenity
    document.getElementById('custom_amenity').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            document.getElementById('add_custom_amenity').click();
        }
    });

    // Initialize the amenities system
    initializeAmenities();
});
</script>

<!-- Map Integration JavaScript -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize map with default location
        var map = L.map('map').setView([0, 0], 2);

        // Add OpenStreetMap tiles
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap contributors'
        }).addTo(map);

        // Get current coordinates from form or try to get user's location
        var currentLat = parseFloat(document.getElementById('latitude').value) || 0;
        var currentLng = parseFloat(document.getElementById('longitude').value) || 0;

        var marker = null;

        // If we have existing coordinates, use them
        if (currentLat !== 0 && currentLng !== 0) {
            map.setView([currentLat, currentLng], 13);
            marker = L.marker([currentLat, currentLng]).addTo(map);
        } else {
            // Try to get user's current location
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(
                    function(position) {
                        var lat = position.coords.latitude;
                        var lng = position.coords.longitude;

                        // Center map on user's location
                        map.setView([lat, lng], 13);

                        // Add marker at user's location
                        marker = L.marker([lat, lng]).addTo(map);

                        // Update form fields with current location
                        document.getElementById('latitude').value = lat.toFixed(6);
                        document.getElementById('longitude').value = lng.toFixed(6);
                    },
                    function(error) {
                        console.log('Geolocation error:', error);
                        // Fallback to a default location (e.g., center of the country or city)
                        map.setView([40.7128, -74.0060], 10); // New York City as fallback
                    }
                );
            } else {
                // Fallback if geolocation is not supported
                map.setView([40.7128, -74.0060], 10); // New York City as fallback
            }
        }

        // Add click event to map
        map.on('click', function(e) {
            var lat = e.latlng.lat;
            var lng = e.latlng.lng;

            // Update input fields
            document.getElementById('latitude').value = lat.toFixed(6);
            document.getElementById('longitude').value = lng.toFixed(6);

            // Remove existing marker
            if (marker) {
                map.removeLayer(marker);
            }

            // Add new marker
            marker = L.marker([lat, lng]).addTo(map);
        });

        // Add geocoding functionality
        function geocodeAddress(address) {
            if (!address) return;

            // Using Nominatim (OpenStreetMap's geocoding service)
            fetch(`https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(address)}&limit=1`)
                .then(response => response.json())
                .then(data => {
                    if (data && data.length > 0) {
                        var lat = parseFloat(data[0].lat);
                        var lng = parseFloat(data[0].lon);

                        map.setView([lat, lng], 13);

                        // Update input fields
                        document.getElementById('latitude').value = lat.toFixed(6);
                        document.getElementById('longitude').value = lng.toFixed(6);

                        // Remove existing marker
                        if (marker) {
                            map.removeLayer(marker);
                        }

                        // Add new marker
                        marker = L.marker([lat, lng]).addTo(map);
                    }
                })
                .catch(error => console.error('Geocoding error:', error));
        }

        // Add geocoding when address changes
        var addressInput = document.querySelector('textarea[name="address"]');
        if (addressInput) {
            addressInput.addEventListener('blur', function() {
                if (this.value.trim()) {
                    geocodeAddress(this.value);
                }
            });
        }

        // Add current location button functionality
        var getCurrentLocationBtn = document.getElementById('getCurrentLocation');
        if (getCurrentLocationBtn) {
            getCurrentLocationBtn.addEventListener('click', function() {
                if (navigator.geolocation) {
                    getCurrentLocationBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Getting Location...';
                    getCurrentLocationBtn.disabled = true;

                    navigator.geolocation.getCurrentPosition(
                        function(position) {
                            var lat = position.coords.latitude;
                            var lng = position.coords.longitude;

                            // Center map on user's location
                            map.setView([lat, lng], 13);

                            // Remove existing marker
                            if (marker) {
                                map.removeLayer(marker);
                            }

                            // Add marker at user's location
                            marker = L.marker([lat, lng]).addTo(map);

                            // Update form fields with current location
                            document.getElementById('latitude').value = lat.toFixed(6);
                            document.getElementById('longitude').value = lng.toFixed(6);

                            // Reset button
                            getCurrentLocationBtn.innerHTML = '<i class="fa fa-location-arrow"></i> Current Location';
                            getCurrentLocationBtn.disabled = false;
                        },
                        function(error) {
                            console.log('Geolocation error:', error);
                            alert('Unable to get your current location. Please select manually on the map.');

                            // Reset button
                            getCurrentLocationBtn.innerHTML = '<i class="fa fa-location-arrow"></i> Current Location';
                            getCurrentLocationBtn.disabled = false;
                        }
                    );
                } else {
                    alert('Geolocation is not supported by this browser.');
                }
            });
        }
    });
</script>

<!-- Business Type Units Logic -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const unitsInput = document.querySelector('input[name="units"]');
        const unitsLabel = unitsInput.closest('.form-group').querySelector('label');
        const unitsHelpText = unitsInput.closest('.form-group').querySelector('small');

        // Get user's business type (this should be passed from the backend)
        <?php if(auth()->guard()->check()): ?>
            const userBusinessType = <?php echo e(Auth::user()->business_type ?? 1); ?>;
        <?php else: ?>
            const userBusinessType = 1;
        <?php endif; ?>

        const isIndividual = userBusinessType === 1;

        // Apply business type logic
        if (isIndividual) {
            unitsInput.value = '1';
            unitsInput.setAttribute('readonly', 'readonly');
            unitsInput.style.backgroundColor = '#f8f9fa';
            unitsInput.style.cursor = 'not-allowed';

            if (unitsHelpText) {
                unitsHelpText.textContent = 'Individual users can only list 1 unit at a time';
                unitsHelpText.style.color = '#6c757d';
            }
        } else {
            // For agents/builders, make it editable
            unitsInput.removeAttribute('readonly');
            unitsInput.style.backgroundColor = '';
            unitsInput.style.cursor = 'text';

            if (unitsHelpText) {
                unitsHelpText.textContent = 'Enter the total number of units in this property';
                unitsHelpText.style.color = '#6c757d';
            }
        }

        // Add visual feedback
        unitsInput.addEventListener('focus', function() {
            if (isIndividual) {
                this.style.borderColor = '#dc3545';
            }
        });

        unitsInput.addEventListener('blur', function() {
            if (isIndividual) {
                this.style.borderColor = '#e3e6f0';
            }
        });

        // Prevent manual input for individual users
        unitsInput.addEventListener('input', function() {
            if (isIndividual) {
                this.value = '1';
            }
        });

        // Add change listener for dynamic updates (if business type changes)
        unitsInput.addEventListener('change', function() {
            if (isIndividual && this.value !== '1') {
                this.value = '1';
            }
        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('site_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/pages/user/property_addedit.blade.php ENDPATH**/ ?>