
<div class="modern-filter-container">
    <?php echo e(html()->form('GET', url('map'))
        ->attributes([
            'class' => 'modern-filter-form', 
            'id' => 'search_horizontal', 
            'name' => 'search_horizontal',
            'aria-label' => 'Property Search Form'
        ])->open()); ?>

    
    <div class="filter-grid">
        <div class="filter-row">
            
            <div class="filter-group search-group" style="grid-column: span 2;">
                <div class="input-with-icon">
                    <i class="fa fa-search" aria-hidden="true"></i>
                    <input type="text" 
                           id="search_text"
                           name="search" 
                           value="<?php echo e(request('search')); ?>" 
                           class="form-control" 
                           placeholder="<?php echo e(trans('words.search_by_title')); ?>"
                           aria-label="<?php echo e(trans('words.search_by_title')); ?>">
                </div>
            </div>

            
            <div class="filter-group">
                <div class="select-wrapper">
                    <i class="fa fa-map-marker" aria-hidden="true"></i>
                    <select id="location_id" name="location_id" class="form-control" aria-label="<?php echo e(trans('words.location')); ?>" title="<?php echo e(trans('words.location')); ?>">
                        <option value="" disabled selected><?php echo e(trans('words.location')); ?></option>
                        <?php $__currentLoopData = \App\Location::where('status', 1)->orderby('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($location_data->id); ?>" <?php echo e(request('location_id') == $location_data->id ? 'selected' : ''); ?>>
                                <?php echo e($location_data->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <i class="fa fa-chevron-down" aria-hidden="true"></i>
                </div>
            </div>

            
            <div class="filter-group">
                <div class="select-wrapper">
                    <i class="fa fa-home" aria-hidden="true"></i>
                    <select id="type_id" name="type_id" class="form-control" aria-label="<?php echo e(trans('words.type')); ?>" title="<?php echo e(trans('words.type')); ?>">
                        <option value="" disabled selected><?php echo e(trans('words.type')); ?></option>
                        <?php $__currentLoopData = \App\Type::where('status', 1)->orderby('type_name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type_data->id); ?>" <?php echo e(request('type_id') == $type_data->id ? 'selected' : ''); ?>>
                                <?php echo e($type_data->type_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <i class="fa fa-chevron-down" aria-hidden="true"></i>
                </div>
            </div>
        </div>

        <div class="filter-row">
            
            <div class="filter-group">
                <div class="select-wrapper">
                    <i class="fa fa-tag" aria-hidden="true"></i>
                    <select id="purpose" name="purpose" class="form-control" aria-label="<?php echo e(trans('words.purpose')); ?>" title="<?php echo e(trans('words.purpose')); ?>">
                        <option value="" disabled selected><?php echo e(trans('words.purpose')); ?></option>
                        <option value="Sale" <?php echo e(request('purpose') == 'Sale' ? 'selected' : ''); ?>><?php echo e(trans('words.sale')); ?></option>
                        <option value="Rent" <?php echo e(request('purpose') == 'Rent' ? 'selected' : ''); ?>><?php echo e(trans('words.rent')); ?></option>
                    </select>
                    <i class="fa fa-chevron-down" aria-hidden="true"></i>
                </div>
            </div>

            
            <div class="filter-group">
                <div class="select-wrapper">
                    <i class="fa fa-bed" aria-hidden="true"></i>
                    <select id="bedrooms" name="bedrooms" class="form-control" aria-label="<?php echo e(trans('words.bedrooms')); ?>" title="<?php echo e(trans('words.bedrooms')); ?>">
                        <option value="" disabled selected><?php echo e(trans('words.bedrooms')); ?></option>
                        <?php for($i = 1; $i <= 4; $i++): ?>
                            <option value="<?php echo e($i); ?>" <?php echo e(request('bedrooms') == $i ? 'selected' : ''); ?>>
                                <?php echo e($i); ?>+
                            </option>
                        <?php endfor; ?>
                    </select>
                    <i class="fa fa-chevron-down" aria-hidden="true"></i>
                </div>
            </div>

            
            <div class="filter-group">
                <div class="select-wrapper">
                    <i class="fa fa-bath" aria-hidden="true"></i>
                    <select id="bathrooms" name="bathrooms" class="form-control" aria-label="<?php echo e(trans('words.bathrooms')); ?>" title="<?php echo e(trans('words.bathrooms')); ?>">
                        <option value="" disabled selected><?php echo e(trans('words.bathrooms')); ?></option>
                        <?php for($i = 1; $i <= 4; $i++): ?>
                            <option value="<?php echo e($i); ?>" <?php echo e(request('bathrooms') == $i ? 'selected' : ''); ?>>
                                <?php echo e($i); ?>+
                            </option>
                        <?php endfor; ?>
                    </select>
                    <i class="fa fa-chevron-down" aria-hidden="true"></i>
                </div>
            </div>

            
            <div class="filter-group search-btn-container">
                <button type="submit" class="btn-search" aria-label="<?php echo e(trans('words.search')); ?>">
                    <i class="fa fa-search" aria-hidden="true"></i>
                    <span>Search</span>
                </button>
            </div>
        </div>
    </div>
    
    <?php echo e(html()->form()->close()); ?>

</div>

<style>
/* ==========================================================================
   Modern Property Search Filter Styles
   ========================================================================== */

/* Base Container */
.modern-filter-container {
    --primary-color: #e53935;
    --primary-dark: #c62828;
    --text-color: #1f2937;
    --border-color: #ffebee;
    --bg-color: rgba(255, 255, 255, 0.98);
    --shadow-color: rgba(229, 57, 53, 0.1);
    
    background: var(--bg-color);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    border-radius: 12px;
    padding: 1.5rem;
    box-shadow: 0 4px 20px var(--shadow-color);
    margin: -1.25rem auto 1.25rem;
    max-width: 1000px;
    width: calc(100% - 2rem);
    position: relative;
    z-index: 1000;
    border: 1px solid rgba(229, 57, 53, 0.08);
    transition: all 0.3s ease;
}

.modern-filter-container:hover {
    box-shadow: 0 15px 35px rgba(229, 57, 53, 0.2);
}

/* Form Layout */
.modern-filter-form {
    width: 100%;
}

.filter-grid {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
    width: 100%;
    max-width: 1400px;
    margin: 0 auto;
}

.filter-row {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 1rem;
    width: 100%;
    align-items: flex-end;
}

/* Form Elements */
.filter-group {
    position: relative;
    margin: 0;
}

/* Input with Icon */
.input-with-icon {
    position: relative;
    width: 100%;
}

.input-with-icon i {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #6b7280;
    font-size: 1rem;
    pointer-events: none;
}

/* Select Wrapper */
.select-wrapper {
    position: relative;
    width: 100%;
}

.select-wrapper i:first-child {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #6b7280;
    font-size: 1rem;
    z-index: 1;
    pointer-events: none;
}

.select-wrapper i:last-child {
    position: absolute;
    right: .9rem;
    top: 40%;
    transform: translateY(-60%);
    color: #6b7280;
    pointer-events: none;
}

/* Form Controls */
.form-control {
    width: 100%;
    height: 3rem;
    padding: .8rem 1rem 0 2.8rem;
    font-size: 0.875rem;
    color: var(--text-color);
    background-color: #fff8f8;
    border: 1px solid var(--border-color);
    border-radius: 0.5rem;
    transition: all 0.3s ease;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    font-weight: 500;
    line-height: 1.5;
}

.form-control:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(229, 57, 53, 0.15);
    outline: none;
    background-color: #fff;
}

/* Hide default select arrow in IE10+ */
select.form-control::-ms-expand {
    display: none;
}

/* Search Button */
.btn-search {
    --btn-padding: 0 1.5rem;
    
    width: 100%;
    height: 3rem;
    background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
    color: #fff;
    border: none;
    border-radius: 0.5rem;
    font-size: 0.875rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    padding: var(--btn-padding);
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(229, 57, 53, 0.3);
    position: relative;
    overflow: hidden;
}

.btn-search::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, 
        transparent, 
        rgba(255, 255, 255, 0.2), 
        transparent
    );
    transition: 0.5s;
}

.btn-search:hover {
    background: linear-gradient(135deg, #d32f2f, #b71c1c);
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(183, 28, 28, 0.4);
}

.btn-search:hover::before {
    left: 100%;
}

.btn-search:active {
    transform: translateY(0);
    box-shadow: 0 4px 10px rgba(183, 28, 28, 0.3);
}

.btn-search:focus {
    outline: 2px solid #fff;
    outline-offset: 2px;
}

/* Accessibility */
.sr-only {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}

/* ==========================================================================
   Responsive Adjustments
   ========================================================================== */

/* Large Desktops */
@media (min-width: 1201px) {
    .filter-row {
        grid-template-columns: repeat(4, 1fr);
    }
    
    .modern-filter-container {
        width: calc(100% - 10rem);
        max-width: 1400px;
        margin: -1.5rem auto 1.5rem;
        padding: 1.5rem 2rem;
    }
    
    .filter-group {
        margin-bottom: 0;
    }
    
    .btn-search {
        height: 3rem;
        font-size: 0.9rem;
    }
}

/* Desktops */
@media (max-width: 1200px) and (min-width: 993px) {
    .modern-filter-container {
        width: calc(100% - 2.5rem);
        max-width: 1200px;
        padding: 1.25rem 1.5rem;
    }
    
    .filter-row {
        grid-template-columns: repeat(4, 1fr);
        gap: 0.875rem;
    }
    
    .form-control {
        font-size: 0.85rem;
        padding-left: 2.5rem;
    }
}

/* Tablets */
@media (max-width: 992px) and (min-width: 577px) {
    .filter-row {
        grid-template-columns: repeat(2, 1fr);
        gap: 0.75rem;
    }
    
    .search-group {
        grid-column: span 2 !important;
    }
    
    .search-btn-container {
        grid-column: span 2;
    }
    
    .modern-filter-container {
        padding: 1.25rem;
        margin: -1.25rem auto 1.5rem;
    }
}

/* Mobile */
@media (max-width: 576px) {
    .modern-filter-container {
        padding: 1rem;
        width: calc(100% - 1.5rem);
        margin: -1rem auto 1rem;
    }
    
    .filter-row {
        grid-template-columns: 1fr;
        gap: 0.75rem;
    }
    
    .search-group,
    .search-btn-container {
        grid-column: auto;
    }
    
    .search-btn-container {
        margin-top: 0.25rem;
    }
    
    .btn-search {
        height: 2.75rem;
    }
}

/* Small Mobile */
@media (max-width: 400px) {
    .modern-filter-container {
        padding: 0.75rem;
        border-radius: 0.5rem;
    }
    
    .form-control {
        height: 2.75rem;
        padding-left: 2.5rem;
        font-size: 0.8125rem;
    }
    
    .btn-search {
        font-size: 0.8125rem;
        height: 2.5rem;
    }
}
    }
    
    .map-controls {
        right: 10px;
        bottom: 10px;
    }
    
    .map-control-btn {
        width: 36px;
        height: 36px;
        border-radius: 8px;
    }
}

/* Animation */
@keyframes fadeIn {
    from { 
        opacity: 0; 
        transform: translateY(20px);
    }
    to { 
        opacity: 1; 
        transform: translateY(0);
    }
}

.modern-filter-container {
    animation: fadeIn 0.6s cubic-bezier(0.16, 1, 0.3, 1) forwards;
}

/* Red theme accents */
.input-with-icon i,
.select-wrapper i:first-child {
    color: #e53935;
    transition: all 0.3s ease;
}

.select-wrapper i:last-child {
    color: #e53935;
}

/* Custom scrollbar */
select::-webkit-scrollbar {
    width: 8px;
}

select::-webkit-scrollbar-track {
    background: #fff5f5;
    border-radius: 4px;
}

select::-webkit-scrollbar-thumb {
    background: #e53935;
    border-radius: 4px;
}

select::-webkit-scrollbar-thumb:hover {
    background: #c62828;
}

/* Custom scrollbar for dropdowns */
select::-ms-expand {
    display: none;
}

select {
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
}

/* Custom dropdown arrow */
select::-ms-expand {
    display: none;
}

/* Hover and focus states */
.form-control:hover {
    border-color: #ffcdd2;
    background-color: #fff;
    box-shadow: 0 0 0 2px rgba(229, 57, 53, 0.1);
}

/* Placeholder text color */
::placeholder {
    color: #9ca3af;
    opacity: 1;
}

:-ms-input-placeholder {
    color: #9ca3af;
}

::-ms-input-placeholder {
    color: #9ca3af;
}
</style>
<?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/pages/map_filter_horizontal.blade.php ENDPATH**/ ?>