

<?php $__env->startSection("content"); ?>
 
  <div class="content-page">
      <div class="content" style="max-height: calc(100vh - 120px); overflow:auto;">
        <div class="container-fluid">
          <div class="row">
            <div class="col-lg-12">
              <div class="card-box">
                <h5 class="mb-4" style="color:#f9f9f9"><i class="fa fa-buysellads pr-2"></i> <b><?php echo e($page_title); ?></b></h5>

                <?php echo e(html()->form('POST', url('admin/banner-ads/'.$position.'/'.$banner->id))->attributes(['class' => 'form-horizontal', 'enctype' => 'multipart/form-data'])->open()); ?>


                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">User</label>
                    <div class="col-sm-6">
                      <select name="user_id" class="form-control" required>
                        <option value="">Select User</option>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($user->id); ?>" <?php echo e($banner->user_id==$user->id?'selected':''); ?>><?php echo e($user->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Location</label>
                    <div class="col-sm-6">
                      <select name="location_id" class="form-control" required>
                        <option value="">Select Location</option>
                        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($loc->id); ?>" <?php echo e($banner->location_id==$loc->id?'selected':''); ?>><?php echo e($loc->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Name</label>
                    <div class="col-sm-6">
                      <input type="text" name="name" class="form-control" value="<?php echo e($banner->name); ?>" required>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Replace Image</label>
                    <div class="col-sm-6">
                      <input type="file" name="image_file" class="form-control" accept="image/*">
                      <small class="form-text text-muted">Leave empty to keep existing.</small>
                      <?php if($banner->image_path): ?>
                        <div class="mt-2"><img src="<?php echo e(asset($banner->image_path)); ?>" style="height:50px"></div>
                      <?php endif; ?>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Redirect URL</label>
                    <div class="col-sm-6">
                      <input type="url" name="redirect_url" class="form-control" value="<?php echo e($banner->redirect_url); ?>" placeholder="https://...">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Description</label>
                    <div class="col-sm-6">
                      <textarea name="description" class="form-control"><?php echo e($banner->description); ?></textarea>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Cost</label>
                    <div class="col-sm-3">
                      <input type="number" step="0.01" name="cost" class="form-control" value="<?php echo e($banner->cost); ?>">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Active</label>
                    <div class="col-sm-3">
                      <input type="checkbox" name="status" value="1" <?php echo e($banner->status ? 'checked' : ''); ?>>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Starts At</label>
                    <div class="col-sm-3">
                      <input type="datetime-local" name="starts_at" class="form-control" value="<?php echo e(optional($banner->starts_at)->format('Y-m-d\TH:i')); ?>">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Ends At</label>
                    <div class="col-sm-3">
                      <input type="datetime-local" name="ends_at" class="form-control" value="<?php echo e(optional($banner->ends_at)->format('Y-m-d\TH:i')); ?>">
                    </div>
                  </div>

                  <input type="hidden" name="lat" value="<?php echo e($banner->lat); ?>" required>
                  <input type="hidden" name="lng" value="<?php echo e($banner->lng); ?>" required>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Select on map for latitude longitude</label>
                    <div class="col-sm-9">
                      <div id="bannerMap" style="height:220px;border:1px solid #2e3645;border-radius:4px;"></div>
                      <small class="form-text text-muted">Click on the map to set latitude & longitude. </small>
                    </div>
                  </div>

                  <div class="form-group">
                    <div class="offset-sm-3 col-sm-9 pl-1">
                      <button type="submit" class="btn btn-primary waves-effect waves-light">Update</button>
                      <a href="<?php echo e(url('admin/banner-ads/'.$position)); ?>" class="btn btn-secondary">Cancel</a>
                    </div>
                  </div>

                <?php echo e(html()->form()->close()); ?>


              </div>
            </div>            
          </div>              
        </div>
      </div>
      <?php echo $__env->make("admin.copyright", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
    </div> 
 
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin=""/>
<link rel="stylesheet" href="https://unpkg.com/leaflet.fullscreen@2.0.0/Control.FullScreen.css" integrity="sha256-7TkmOslR+CSKwJ/8h3jE68V3v45W6mo/nLUBs7e1IXQ=" crossorigin=""/>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>
<script src="https://unpkg.com/leaflet.fullscreen@2.0.0/Control.FullScreen.js" integrity="sha256-VNvmqD2N4AB1Yyeq3Fz2hNumlYg3D7PYjY2jD5d4LTc=" crossorigin=""></script>
<script>
'use strict';
(function(){
  if (!document.getElementById('bannerMap')) return;

  var chennaiCenter = [13.0827, 80.2707];
  var chennaiBounds = L.latLngBounds(
    [12.80, 79.90],
    [13.30, 80.40]
  );

  var map = L.map('bannerMap', {
    center: [<?php echo e($banner->lat ?? 13.0827); ?>, <?php echo e($banner->lng ?? 80.2707); ?>],
    zoom: 12,
    maxBounds: chennaiBounds,
    maxBoundsViscosity: 1.0,
    fullscreenControl: true,
    fullscreenControlOptions: { position: 'topleft', title: '', titleCancel: '' }
  });

  L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { attribution: '&copy; OpenStreetMap contributors' }).addTo(map);

  var latInput = document.querySelector('input[name="lat"]');
  var lngInput = document.querySelector('input[name="lng"]');
  var marker = null;

  function setMarker(latlng){
    if(marker){ marker.setLatLng(latlng); }
    else { marker = L.marker(latlng, {draggable:false}).addTo(map); }
  }

  if(latInput.value && lngInput.value){
    var init = L.latLng(parseFloat(latInput.value), parseFloat(lngInput.value));
    if(chennaiBounds.contains(init)){
      setMarker(init);
      map.setView(init, 14);
    }
  }

  map.on('click', function(e){
    var latlng = e.latlng;
    if(!chennaiBounds.contains(latlng)){
      return;
    }
    latInput.value = latlng.lat.toFixed(6);
    lngInput.value = latlng.lng.toFixed(6);
    setMarker(latlng);
  });
})();
</script>

<?php $__env->stopSection(); ?>

<script type="text/javascript">
'use strict';

  <?php if(Session::has('flash_message')): ?>
    const Toast = Swal.mixin({
      toast: true,
      position: 'top-end',
      showConfirmButton: false,
      timer: 3000,
      timerProgressBar: false,
    })
    Toast.fire({
      icon: 'success',
      title: '<?php echo e(Session::get('flash_message')); ?>'
    })
  <?php endif; ?>

  <?php if(session()->has('errors')): ?>
    Swal.fire({
      icon: 'error',
      title: 'Oops...',
      html: '<p><?php $__currentLoopData = session('errors')->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($error); ?><br/> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></p>',
      showConfirmButton: true,
      confirmButtonColor: '#10c469',
      background:'#1a2234',
      color:'#fff'
    })
  <?php endif; ?>
</script>



<?php echo $__env->make("admin.admin_app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/admin/pages/banner_ads/edit.blade.php ENDPATH**/ ?>