

<?php $__env->startSection('head_title', 'My Custom Plan Requests - '.getcong('site_name')); ?>
<?php $__env->startSection('head_url', Request::url()); ?>

<?php $__env->startSection('content'); ?>

<div class="breadcrumb-section bg-xs" style="background-image: url(<?php echo e(URL::asset('site_assets/images/breadcrumb-1.jpg')); ?>)">
  <div class="overlay op-2"></div>
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <div class="breadcrumb-menu">
          <h2>My Custom Plan Requests</h2>
          <span><a href="<?php echo e(URL::to('/')); ?>"><?php echo e(trans('words.home')); ?></a></span> <span>My Custom Plan Requests</span>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="about-section pt-30 pb-30">
  <div class="container">
    <div class="row">
      <div class="col-12 mb-3">
        <a href="<?php echo e(url('custom-plan/request')); ?>" class="btn vfx7">Request Custom Plan</a>
      </div>
      <div class="col-12">
        <div class="table-wrapper">
          <table class="fl-table">
            <thead>
              <tr>
                <th>ID</th>
                <th>Requested</th>
                <th>Status</th>
                <th>Approved Details</th>
                <th>Payment</th>
                <th>Updated</th>
              </tr>
            </thead>
            <tbody>
              <?php $__empty_1 = true; $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td>#<?php echo e($req->id); ?></td>
                <td>
                  <div>Property posts: <strong><?php echo e($req->property_posts_requested); ?></strong></div>
                  <div>Ads posts: <strong><?php echo e($req->ads_posts_requested ?? '-'); ?></strong></div>
                  <?php if($req->notes): ?>
                  <div class="text-muted"><?php echo e(Str::limit($req->notes, 80)); ?></div>
                  <?php endif; ?>
                </td>
                <td><span class="badge badge-info"><?php echo e(strtoupper($req->status)); ?></span></td>
                <td>
                  <?php if($req->approved_price): ?>
                    <div>Price: <strong><?php echo e(number_format($req->approved_price,2)); ?></strong></div>
                    <div>Validity: <strong><?php echo e($req->approved_validity_days); ?> days</strong></div>
                    <div>Limits: <strong><?php echo e($req->approved_property_limit); ?> props</strong> / <strong><?php echo e($req->approved_ads_limit ?? '-'); ?> ads</strong></div>
                  <?php else: ?>
                    —
                  <?php endif; ?>
                </td>
                <td>
                  <?php if($req->payment_preference==='online' && $req->status==='awaiting_payment' && $req->payment_link): ?>
                    <a class="btn btn-sm btn-primary" href="<?php echo e($req->payment_link); ?>">Pay Now</a>
                  <?php elseif($req->payment_preference==='cash' && in_array($req->status, ['approved'])): ?>
                    <span>Awaiting Cash</span>
                  <?php elseif(in_array($req->status, ['paid','activated'])): ?>
                    <span>Paid</span>
                  <?php else: ?>
                    —
                  <?php endif; ?>
                </td>
                <td><?php echo e(optional($req->updated_at)->format('Y-m-d H:i')); ?></td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="6" class="text-center">No custom plan requests yet.</td>
              </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
        <div class="post-nav nav-res pt-20">
          <div class="row">
            <?php echo $__env->make('_particles.pagination', ['paginator' => $requests], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('site_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/realestate.dextragroups.com/resources/views/pages/user/custom_plan_requests.blade.php ENDPATH**/ ?>