<!-- Modern Filter Panel - Complete Integration -->
<?php echo html()->form('GET', url('/map/data'))
  ->attributes(['class' => 'modern-filter-panel compact', 'id' => 'map-filter-form', 'name' => 'map-filter-form'])->open(); ?>


  <!-- Top Row: Location Search -->
  <div class="filter-top-row">
    <!-- Left: Location Search and GPS -->
    <div class="filters-location filter-top-left">
      <label for="location-search" class="mb-1 fw-semibold small text-muted"><?php echo e(__('Location or Address')); ?></label>
      <div class="location-input-container">
        <i class="fa fa-map-marker location-icon" aria-hidden="true"></i>
        <input type="text" class="location-input" id="location-search" name="search" placeholder="<?php echo e(__('Search by area, city or address')); ?>" value="<?php echo e(request('search')); ?>" />
        <button type="button" id="use-gps" class="gps-button" title="<?php echo e(__('Use my location')); ?>" aria-label="<?php echo e(__('Use my location')); ?>">
          <i class="fa fa-crosshairs" aria-hidden="true"></i>
        </button>
      </div>
    </div>
    <!-- Right: Purpose Tabs -->
    <div class="filter-top-right">
      <label class="mb-1 fw-semibold small text-muted" for="purpose-input"><?php echo e(__('Purpose')); ?></label>
      <div class="purpose-tabs purpose-tabs-row" role="tablist" aria-label="<?php echo e(__('Purpose')); ?>">
        <button type="button" class="purpose-tab <?php if(!isset($_GET['purpose']) || $_GET['purpose'] == 'Sale'): ?> active <?php endif; ?>" data-purpose="Sale" role="tab" aria-selected="<?php if(!isset($_GET['purpose']) || $_GET['purpose'] == 'Sale'): ?>true@else false <?php endif; ?>">
          <span class="tab-text"><?php echo e(trans('words.sale')); ?></span>
        </button>
        <button type="button" class="purpose-tab <?php if(isset($_GET['purpose']) && $_GET['purpose'] == 'Rent'): ?> active <?php endif; ?>" data-purpose="Rent" role="tab" aria-selected="<?php if(isset($_GET['purpose']) && $_GET['purpose'] == 'Rent'): ?>true@else false <?php endif; ?>">
          <span class="tab-text"><?php echo e(trans('words.rent')); ?></span>
        </button>
      </div>
      <input type="hidden" name="purpose" id="purpose-input" value="<?php echo e(request('purpose', 'Sale')); ?>">
    </div>
  </div>

  <!-- Second Row: Price Range and Radius -->
  <div class="filter-secondary-row">
    <div class="price-inline-control">
      <span class="radius-label"><?php echo e(trans('words.price_range')); ?></span>
      <div id="price_range_slider" class="flex-grow-1 price-range noUi-touch-area"></div>
      <span id="price_value" class="radius-label"></span>
      <input type="hidden" id="price_range" name="price_range" value="<?php echo e(request('price_range')); ?>" />
    </div>
   
    <div class="radius-control">
      <span class="radius-label"><?php echo e(__('Radius')); ?></span>
      <input type="range" id="search-radius" class="radius-slider" min="0" max="50" step="1" value="<?php echo e(request('radius', 0)); ?>" />
      <span id="radius-value" class="radius-label"><?php echo e(request('radius', 0)); ?> km</span>
      <input type="hidden" id="radius" name="radius" value="<?php echo e(request('radius', 0)); ?>" />
    </div>
  </div>
  
  <!-- Filter Dropdowns Row -->
  <div class="filter-dropdowns-row">
    <div class="filter-grid">
      <select name="type_id" id="map-property-type" class="filter-select">
        <option value=""><?php echo e(trans('words.type')); ?></option>
        <?php $__currentLoopData = \App\Type::where('status', 1)->orderby('type_name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($type_data->id); ?>" <?php if(request('type_id') == $type_data->id): ?> selected <?php endif; ?>>
            <?php echo e($type_data->type_name); ?>

          </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
      
      <select name="location_id" id="filter-location" class="filter-select">
        <option value=""><?php echo e(trans('words.location')); ?></option>
        <?php $__currentLoopData = \App\Location::where('status', 1)->orderby('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($location_data->id); ?>" <?php if(request('location_id') == $location_data->id): ?> selected <?php endif; ?>>
            <?php echo e($location_data->name); ?>

          </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
      
      <select name="bedrooms" id="map-bedrooms" class="filter-select">
        <option value=""><?php echo e(trans('words.bedrooms')); ?> : Any</option>
        <option value="1" <?php if(request('bedrooms') == '1'): ?> selected <?php endif; ?>>1</option>
        <option value="2" <?php if(request('bedrooms') == '2'): ?> selected <?php endif; ?>>2</option>
        <option value="3" <?php if(request('bedrooms') == '3'): ?> selected <?php endif; ?>>3</option>
        <option value="4" <?php if(request('bedrooms') == '4'): ?> selected <?php endif; ?>>4+</option>
      </select>

      <select name="bathrooms" id="map-bathrooms" class="filter-select">
        <option value=""><?php echo e(trans('words.bathrooms')); ?> : Any</option>
        <option value="1" <?php if(request('bathrooms') == '1'): ?> selected <?php endif; ?>>1</option>
        <option value="2" <?php if(request('bathrooms') == '2'): ?> selected <?php endif; ?>>2</option>
        <option value="3" <?php if(request('bathrooms') == '3'): ?> selected <?php endif; ?>>3</option>
        <option value="4" <?php if(request('bathrooms') == '4'): ?> selected <?php endif; ?>>4+</option>
      </select>

      <select name="furnishing" id="filter-furnishing" class="filter-select">
        <option value=""><?php echo e(trans('words.furnishing')); ?> : Any</option>
        <option value="Unfurnished" <?php if(request('furnishing') == 'Unfurnished'): ?> selected <?php endif; ?>>Unfurnished</option>
        <option value="Semi-Furnished" <?php if(request('furnishing') == 'Semi-Furnished'): ?> selected <?php endif; ?>>Semi-Furnished</option>
        <option value="Furnished" <?php if(request('furnishing') == 'Furnished'): ?> selected <?php endif; ?>>Furnished</option>
      </select>
      
      <!-- Verified input -->
      <select name="verified" id="filter-verified" class="filter-select">
        <option value="" selected><?php echo e(trans('words.verified')); ?> : Any</option>
        <option value="0" <?php if(request('verified') == 0): ?>  <?php endif; ?>>No</option>
        <option value="1" <?php if(request('verified') == 1): ?>  <?php endif; ?>>Yes</option>
      </select>

      <button type="submit" class="apply-filters-btn" aria-label="<?php echo e(trans('words.search_property')); ?>">
        <i class="fa fa-search me-1" aria-hidden="true"></i> <?php echo e(trans('words.search_property')); ?>

      </button>
      <button type="button" id="reset-filters" class="reset-btn" aria-label="<?php echo e(__('Reset filters')); ?>">
        <i class="fa fa-refresh me-1" aria-hidden="true"></i> <?php echo e(__('Reset')); ?>

      </button>
    </div>
  </div>

   
<?php echo html()->form()->close(); ?>

<?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/pages/property/partials/map-filters.blade.php ENDPATH**/ ?>