<?php
    // expects: uid (string), context ('property'|'owner'|'profile'), property_id, owner_id
    $uid = $uid ?? uniqid('pp_');
    $context = $context ?? 'generic';
    $property_id = $property_id ?? '';
    $owner_id = $owner_id ?? '';
?>

<!-- Modern Phone Popup (reusable) -->
<div class="modal fade phone-popup-modal" id="phonePopupModal_<?php echo e($uid); ?>" tabindex="-1" role="dialog" aria-labelledby="phonePopupLabel_<?php echo e($uid); ?>" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content border-0 shadow-lg overflow-hidden" style="border-radius:12px;">
            <div class="modal-header align-items-center bg-white py-3 px-4">
                <div class="d-flex align-items-center mr-3">
                    <div class="phone-icon bg-danger text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width:44px;height:44px;">
                        <i class="fa fa-phone" aria-hidden="true"></i>
                    </div>
                </div>
                <div class="flex-grow-1 pl-1">
                    <h5 class="modal-title mb-0 h6 text-dark" id="phonePopupLabel_<?php echo e($uid); ?>">Verify your phone</h5>
                    <small class="text-muted">Quick verification so you can view contact details</small>
                </div>
                <button type="button" class="close ml-3" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body py-4 px-4 bg-white">
                <form id="phonePopupForm_<?php echo e($uid); ?>" class="phone-popup-form" novalidate aria-live="polite">
                    <div class="form-row" id="phonePopup_input_<?php echo e($uid); ?>">
                        <div class="col-12 mb-3">
                            <label for="phonePopup_name_<?php echo e($uid); ?>" class="font-weight-600">Full name</label>
                            <input type="text" name="name" class="form-control form-control-lg" id="phonePopup_name_<?php echo e($uid); ?>" placeholder="Jane Doe" aria-label="Your name" required style="border-radius:8px;">
                            <small class="form-text text-muted">So the owner knows who's contacting them.</small>
                        </div>
                        <div class="col-12 mb-3">
                            <label for="phonePopup_phone_<?php echo e($uid); ?>" class="font-weight-600">Phone number</label>
                            <div class="input-group input-group-lg">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-light border-right-0">+91</span>
                                </div>
                                <input type="tel" 
                                       name="phone" 
                                       class="form-control form-control-lg" 
                                       id="phonePopup_phone_<?php echo e($uid); ?>" 
                                       value="" 
                                       placeholder="e.g. 9876543210" 
                                       aria-label="Phone number" 
                                       required 
                                       style="border-radius:8px;"
                                       autocomplete="off"
                                       autocorrect="off"
                                       autocapitalize="off"
                                       spellcheck="false"
                                       inputmode="numeric"
                                       pattern="[0-9]*">
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <button type="button" class="btn btn-danger btn-block btn-lg d-flex align-items-center justify-content-center" id="phonePopup_send_<?php echo e($uid); ?>" aria-live="polite" style="border-radius:8px;">
                                <span class="btn-text">Send verification code</span>
                                <span class="btn-spinner" style="display:none;margin-left:10px"><i class="fa fa-spinner fa-spin"></i></span>
                            </button>
                        </div>
                        <div class="col-12">
                            <small class="text-muted">We won't share your phone number. By verifying you agree to our <a href="<?php echo e(URL::to('page/'.\App\Pages::getPageInfo(3,'page_slug'))); ?>">privacy policy</a>.</small>
                        </div>
                    </div>

                    <div id="phonePopup_otp_<?php echo e($uid); ?>" style="display:none;margin-top:18px;">
                        <div class="form-row align-items-center">
                            <div class="col-12 mb-2">
                                <label for="phonePopup_otpInput_<?php echo e($uid); ?>" class="font-weight-600">Enter verification code</label>
                                <div class="d-flex align-items-center otp-row" style="gap:8px;">
                                    <input type="text" inputmode="numeric" pattern="[0-9]*" class="form-control form-control-lg text-center" id="phonePopup_otpInput_<?php echo e($uid); ?>" maxlength="4" placeholder="4‑digit code" aria-label="Enter OTP" style="width:140px;border-radius:8px;letter-spacing:6px;font-size:1.25rem;">
                                    <div class="flex-grow-1 text-right">
                                        <button type="button" class="btn btn-link text-danger p-0 mb-2" id="phonePopup_resend_<?php echo e($uid); ?>">Resend</button>
                                        <div class="d-block">
                                            <button type="button" class="btn btn-outline-danger btn-lg" id="phonePopup_verify_<?php echo e($uid); ?>" style="border-radius:8px;">
                                                <span class="btn-text">Verify</span>
                                                <span class="btn-spinner" style="display:none;margin-left:6px"><i class="fa fa-spinner fa-spin"></i></span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <small class="form-text text-muted">We sent a 6-digit code to your phone. Enter it here to view contact details.</small>
                            </div>
                        </div>
                        <div class="text-center mt-2">
                            <small id="phonePopup_resendCountdown_<?php echo e($uid); ?>" class="text-muted" style="display:none;">Resend available in <span class="countdown">30</span>s</small>
                        </div>
                    </div>

                    <input type="hidden" id="phonePopup_action_<?php echo e($uid); ?>" name="requested_action" value="">
                    <input type="hidden" id="phonePopup_property_<?php echo e($uid); ?>" name="property_id" value="<?php echo e($property_id ?? ''); ?>">
                    <input type="hidden" id="phonePopup_owner_<?php echo e($uid); ?>" name="owner_id" value="<?php echo e($owner_id ?? ''); ?>">
                </form>

                <div id="phonePopup_response_<?php echo e($uid); ?>" class="phone-popup-response mt-3" role="status" aria-live="polite" style="display:none"></div>
            </div>
            <div class="modal-footer border-0 pt-0 bg-white pb-3 px-4">
                <small class="text-muted">Need help? <a href="<?php echo e(URL::to('page/contact')); ?>">Contact support</a></small>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/phone-popup.css')); ?>">
    <style>
        /* Modern red/white theme tweaks (safe inline overrides) */
        .phone-popup-modal .modal-content { background: #fff; }
        .phone-popup-modal .modal-header { border-bottom: 0; }
        .phone-popup-response { min-height: 1.5rem; }
        .font-weight-600 { font-weight: 600; }
        .phone-popup-modal .modal-title { color: #2b2b2b; }
        .phone-popup-modal .phone-icon { box-shadow: 0 2px 6px rgba(0,0,0,0.08); }
        .phone-popup-modal .form-control:focus { box-shadow: 0 0 0 0.12rem rgba(220,53,69,0.12); border-color: #dc3545; }
        .phone-popup-modal .btn-danger { background-color: #dc3545; border-color: #dc3545; }
        .phone-popup-modal .btn-outline-danger { color: #dc3545; border-color: #dc3545; }
        .phone-popup-modal a { color: #dc3545; }
        .phone-popup-modal .close { color: #6c757d; opacity: 1; }
        .phone-popup-modal .close:hover { color: #dc3545; opacity: 1; }

        /* Ensure modal backdrop works properly */
        .phone-popup-modal .modal-backdrop { background-color: rgba(0,0,0,0.5); }
        .phone-popup-modal.show .modal-dialog { transform: translate(0, 0); }

        /* Responsive tweaks */
        @media (max-width: 576px) {
            .phone-popup-modal .modal-dialog { max-width: 95%; margin: 0.5rem; }
            .phone-popup-modal .form-control-lg { font-size: 1rem; }
            .phone-popup-modal .phone-icon { width:40px;height:40px;font-size:0.9rem }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/phone-popup.js')); ?>"></script>
    <script>
        // Ensure initialization for this popup instance (phone-popup.js will pick this up)
        document.addEventListener('DOMContentLoaded', function(){
            if (typeof window.PhonePopup !== 'undefined') {
                window.PhonePopup.registerModal('<?php echo e($uid); ?>');
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/partials/phone-popup.blade.php ENDPATH**/ ?>