

<?php $__env->startSection('head_title', 'Property Map View - Floor Locator'); ?>

<?php $__env->startSection('head_url', Request::url()); ?>

<?php $__env->startPush('head'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<!-- Map View Header -->
<div class="map-view-header">
  <div class="container-fluid">
    <div class="row align-items-center">
      <div class="col-md-6">
        <h6 class="map-view-title">
          <i class="fa fa-map-marker"></i> Property Discovery
          <span id="property-count" class="property-count">0 properties</span>
        </h6>
      </div>
      <div class="col-md-6 text-right">
        <div class="map-view-controls">
          <div class="view-mode-toggle">
            <a href="<?php echo e(URL::to('properties')); ?>" class="view-btn" title="Grid View">
              <i class="fa fa-th"></i>
            </a>
            <a href="<?php echo e(URL::to('properties')); ?>" class="view-btn" title="List View">
              <i class="fa fa-list"></i>
            </a>
            <button id="map-view-btn-active" class="view-btn active" title="Map View">
              <i class="fa fa-map"></i>
            </button>
          </div>
          <button id="toggle-filters" class="btn btn-outline-primary btn-sm">
            <i class="fa fa-filter"></i> <span class="btn-text">Filters</span>
          </button>
          <button id="toggle-3d-mode" class="btn btn-outline-info btn-sm">
            <i class="fa fa-cube"></i> <span class="btn-text">3D</span>
          </button>
          <button id="toggle-dark-mode" class="btn btn-outline-secondary btn-sm">
            <i class="fa fa-moon-o"></i> <span class="btn-text">Dark</span>
          </button>
          <button id="fullscreen-map" class="btn btn-outline-warning btn-sm">
            <i class="fa fa-expand"></i> <span class="btn-text">Fullscreen</span>
          </button>
          <a href="<?php echo e(URL::to('properties')); ?>" class="btn btn-outline-danger btn-sm">
            <i class="fa fa-times"></i> <span class="btn-text">Close</span>
          </a>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Map View Content -->
<div class="map-view-content">
  <!-- Left Panel: Interactive Map -->
  <div id="map-left-panel" class="map-left-panel">
    <!-- Navigation Controls for Map View -->
    <div class="map-navigation-controls">
      <div class="nav-controls">
        <button id="prev-page" class="nav-btn" title="Previous Properties">
          <i class="fa fa-chevron-left"></i> <span class="btn-text">Prev</span>
        </button>
        <button id="next-page" class="nav-btn" title="Next Properties">
          <span class="btn-text">Next</span> <i class="fa fa-chevron-right"></i>
        </button>
      </div>
    </div>

    <div id="advanced-map" class="advanced-map"></div>
    <!-- Map Loading Overlay -->
    <div id="map-loading" class="map-loading-overlay" style="display:none;">
      <div class="loading-spinner">
        <div class="spinner"></div>
        <p>Initializing map...</p>
      </div>
    </div>

    <!-- Map Controls -->
    <?php echo $__env->make('pages.property.partials.map-controls', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Property Drawer Overlay -->
    <?php echo $__env->make('pages.property.partials.property-drawer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </div>

  <!-- Debug Panel (only shown when debug mode is enabled) -->
  <?php if(config('app.debug')): ?>
  <div id="debug-panel" class="debug-panel">
    <div class="debug-section">
      <h4>🗺️ Map Debug Panel</h4>
      <div class="debug-controls">
        <button class="debug-btn" onclick="refreshDebugInfo()">🔄 Refresh</button>
        <button class="debug-btn debug-close" onclick="toggleDebugPanel()">❌ Close</button>
      </div>
    </div>

    <div class="debug-section">
      <h5>📊 Stats</h5>
      <div id="debug-stats">
        <div>Requests: <span id="debug-requests">0</span></div>
        <div>Errors: <span id="debug-errors">0</span></div>
        <div>Elapsed: <span id="debug-elapsed">0ms</span></div>
      </div>
    </div>

    <div class="debug-section">
      <h5>📝 Recent Logs</h5>
      <div id="debug-logs" class="debug-logs"></div>
    </div>
  </div>

  <script>
  // Debug panel functionality
  function toggleDebugPanel() {
    const panel = document.getElementById('debug-panel');
    if (panel) {
      panel.classList.toggle('show');
    }
  }

  function refreshDebugInfo() {
    if (window.mapView && typeof window.mapView.getDebugInfo === 'function') {
      const debugInfo = window.mapView.getDebugInfo();

      // Update stats
      document.getElementById('debug-requests').textContent = debugInfo.requestCount;
      document.getElementById('debug-errors').textContent = debugInfo.errorCount;
      document.getElementById('debug-elapsed').textContent = debugInfo.elapsed + 'ms';

      // Update logs
      const logsContainer = document.getElementById('debug-logs');
      logsContainer.innerHTML = debugInfo.logs.slice(-20).map(log => `
        <div class="debug-log-entry ${log.type}">
          [${log.timestamp.split('T')[1].split('.')[0]}] [${log.type.toUpperCase()}] ${log.message}
          ${log.data ? '<br><small>' + log.data + '</small>' : ''}
        </div>
      `).join('');
    }
  }

  // Auto-refresh debug info every 5 seconds
  setInterval(refreshDebugInfo, 5000);

  document.addEventListener('keydown', function(e) {
    if (e.key === 'F12' || (e.ctrlKey && e.shiftKey && e.key === 'D')) {
      e.preventDefault();
      toggleDebugPanel();
    }
  });
  </script>
  <?php endif; ?>
  <div id="map-right-panel" class="map-right-panel">
    <?php echo $__env->make('pages.property.partials.map-filters', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('pages.property.partials.property-list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </div>
</div>
<?php echo $__env->make('pages.property.partials.map-popup-template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/map-view.css')); ?>">

<style>
/* Hide header and footer on map page */
.site-header,
.site-footer,
.navbar,
.footer,
header,
footer {
    display: none !important;
}

/* Ensure body takes full height */
body {
    height: 100vh;
    overflow: hidden;
}

/* Make map view take full viewport */
.map-view-content {
    height: 100vh;
    position: relative;
}

/* Adjust map panels to use full height */
#map-left-panel,
#map-right-panel {
    height: 100%;
}

/* Hide any breadcrumbs or navigation that might be outside the map */
.breadcrumb:not(.map-breadcrumb),
.navbar-nav,
.site-navigation {
    display: none !important;
}
</style>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/map-view.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Complete Filter Panel JavaScript with Backend Integration
document.addEventListener('DOMContentLoaded', function() {
    // Initialize price range slider
    initializePriceRangeSlider();
    
    // Purpose tabs functionality
    const purposeTabs = document.querySelectorAll('.purpose-tab');
    const purposeInput = document.getElementById('purpose-input');
    
    purposeTabs.forEach(tab => {
        tab.addEventListener('click', function() {
            // Remove active class from all tabs
            purposeTabs.forEach(t => t.classList.remove('active'));
            // Add active class to clicked tab
            this.classList.add('active');
            
            // Update hidden input
            const purpose = this.dataset.purpose;
            if (purposeInput) {
                purposeInput.value = purpose;
            }
            
            // Auto-submit form for real-time filtering
            submitFilterForm();
        });
    });

    // More options toggle
    const moreOptionsBtn = document.getElementById('more-search-options');
    const advancedFilters = document.getElementById('advanced-filters');
    
    if (moreOptionsBtn && advancedFilters) {
        moreOptionsBtn.addEventListener('click', function() {
            const isExpanded = advancedFilters.style.display !== 'none';
            
            if (isExpanded) {
                advancedFilters.style.display = 'none';
                this.classList.remove('expanded');
            } else {
                advancedFilters.style.display = 'block';
                this.classList.add('expanded');
            }
        });
    }

    // GPS button functionality
    const gpsButton = document.getElementById('use-gps');
    const locationInput = document.getElementById('location-search');
    
    if (gpsButton && locationInput) {
        gpsButton.addEventListener('click', function() {
            if (navigator.geolocation) {
                this.innerHTML = '<i class="fa fa-spinner fa-spin"></i>';
                
                navigator.geolocation.getCurrentPosition(
                    function(position) {
                        const lat = position.coords.latitude;
                        const lng = position.coords.longitude;
                        
                        // Use reverse geocoding or coordinates
                        locationInput.value = `${lat.toFixed(4)}, ${lng.toFixed(4)}`;
                        gpsButton.innerHTML = '<i class="fa fa-crosshairs"></i>';
                        
                        // Auto-submit after getting location
                        submitFilterForm();
                    },
                    function(error) {
                        console.error('Geolocation error:', error);
                        gpsButton.innerHTML = '<i class="fa fa-crosshairs"></i>';
                        alert('Unable to get your location. Please enter manually.');
                    }
                );
            } else {
                alert('Geolocation is not supported by this browser.');
            }
        });
    }

    // Filter change handlers with validation
    const filterSelects = document.querySelectorAll('.filter-select');
    filterSelects.forEach(select => {
        select.addEventListener('change', function() {
            // Log filter change
            console.log(`Filter ${this.id} changed to:`, this.value);
            
            // Auto-submit form when filters change
            submitFilterForm();
        });
    });

    // Location search with debounce
    if (locationInput) {
        let searchTimeout;
        locationInput.addEventListener('input', function() {
            clearTimeout(searchTimeout);
            searchTimeout = setTimeout(() => {
                if (this.value.length > 2) {
                    submitFilterForm();
                }
            }, 1000); // 1 second delay
        });
    }

    // Reset filters functionality with complete cleanup
    const resetBtn = document.getElementById('reset-filters');
    if (resetBtn) {
        resetBtn.addEventListener('click', function() {
            // Reset all form elements
            const form = document.getElementById('map-filter-form');
            if (form) {
                // Clear all form fields
                form.reset();
                
                // Clear any hidden inputs
                form.querySelectorAll('input[type="hidden"]').forEach(input => {
                    input.value = '';
                });
            }
            
            // Reset purpose tabs
            purposeTabs.forEach(tab => tab.classList.remove('active'));
            if (purposeTabs[0]) {
                purposeTabs[0].classList.add('active');
                if (purposeInput) purposeInput.value = '';
            }
            
            // Reset price range slider
            if (window.priceRangeSlider) {
                window.priceRangeSlider.noUiSlider.reset();
            }
            
            // Reset location and radius
            const locationInput = document.getElementById('location-search');
            if (locationInput) {
                locationInput.value = '';
            }
            
            // Clear any stored map filters
            if (window.mapView) {
                window.mapView.clearAllFilters?.();
            }
            
            // Submit reset form with clean state
            submitFilterForm();
        });
    }

    // Form submission handler
    const filterForm = document.getElementById('map-filter-form');
    if (filterForm) {
        filterForm.addEventListener('submit', function(e) {
            e.preventDefault();
            submitFilterForm();
        });
    }
});

    // Initialize price range slider using noUiSlider with better error handling
    function initializePriceRangeSlider() {
        const priceSlider = document.getElementById('price_range_slider');
        const priceInput = document.getElementById('price_range');

        if (!priceSlider || !priceInput) {
            console.warn('Price slider elements not found');
            return;
        }

        // Load noUiSlider if not already loaded
        if (typeof noUiSlider === 'undefined') {
            console.log('Loading noUiSlider library...');

            // Load CSS
            if (!document.querySelector('link[href*="nouislider"]')) {
                const link = document.createElement('link');
                link.rel = 'stylesheet';
                link.href = 'https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/15.7.1/nouislider.min.css';
                link.crossOrigin = 'anonymous';
                link.referrerPolicy = 'no-referrer';
                document.head.appendChild(link);
            }

            // Load JS
            const script = document.createElement('script');
            script.src = 'https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/15.7.1/nouislider.min.js';
            script.crossOrigin = 'anonymous';
            script.referrerPolicy = 'no-referrer';

            script.onload = function() {
                console.log('noUiSlider loaded successfully');
                createPriceSlider();
            };

            script.onerror = function() {
                console.error('Failed to load noUiSlider');
                priceSlider.innerHTML = '<div class="alert alert-warning">Price slider temporarily unavailable</div>';
            };

            document.head.appendChild(script);
        } else {
            console.log('noUiSlider already loaded');
            createPriceSlider();
        }

        function createPriceSlider() {
            try {
                // Get current values or set defaults
                const currentRange = priceInput.value || '500000 - 10000000';
                const [minVal, maxVal] = currentRange.split(' - ').map(v => {
                    const num = parseInt(v.replace(/[^\d]/g, '')) || 0;
                    return isNaN(num) ? 0 : num;
                });

                const startValues = [minVal || 500000, maxVal || 10000000];

                console.log('Creating price slider with values:', startValues);

                // Destroy existing slider if any
                if (priceSlider.noUiSlider) {
                    priceSlider.noUiSlider.destroy();
                }

                // Create new slider
                noUiSlider.create(priceSlider, {
                    start: startValues,
                    connect: true,
                    range: {
                        'min': 0,
                        'max': 50000000
                    },
                    step: 100000,
                    format: {
                        to: function(value) {
                            return Math.round(value);
                        },
                        from: function(value) {
                            return Number(value);
                        }
                    }
                });

                // Store reference for reset functionality
                window.priceRangeSlider = priceSlider;

                const priceValueEl = document.getElementById('price_value');
                const currency = '₹';

                // Initialize label immediately
                if (priceValueEl && Array.isArray(startValues)) {
                    priceValueEl.textContent = `${currency}${formatNumber(startValues[0])} - ${currency}${formatNumber(startValues[1])}`;
                }

                priceSlider.noUiSlider.on('update', function(values) {
                    const min = parseInt(values[0]);
                    const max = parseInt(values[1]);
                    priceInput.value = `${currency}${formatNumber(min)} - ${currency}${formatNumber(max)}`;

                    if (priceValueEl) {
                        priceValueEl.textContent = `${currency}${formatNumber(min)} - ${currency}${formatNumber(max)}`;
                    }
                });

                priceSlider.noUiSlider.on('change', function(values, handle) {
                    // Auto-submit when price range changes
                    submitFilterForm();
                });

                console.log('Price slider created successfully');
            } catch (error) {
                console.error('Error creating price slider:', error);
                priceSlider.innerHTML = '<div class="alert alert-warning">Price slider initialization failed</div>';
            }
        }
    }

// Helper functions for property management
// Format number for display
function formatNumber(num) {
    if (num >= 10000000) {
        return (num / 10000000).toFixed(1) + 'Cr';
    } else if (num >= 100000) {
        return (num / 100000).toFixed(1) + 'L';
    } else if (num >= 1000) {
        return (num / 1000).toFixed(1) + 'K';
    }
    return num.toString();
}

// Generate cache key for property data
function getCacheKey(page, filters = null) {
    const key = {
        page,
        filters: filters || window.propertyListState.filters
    };
    return JSON.stringify(key);
}

// Show error message to user
function showError(message, duration = 5000) {
    const container = document.createElement('div');
    container.className = 'map-error-toast';
    container.innerHTML = `
        <div class="error-content">
            <i class="fas fa-exclamation-circle"></i>
            <span>${message}</span>
        </div>
        <button onclick="this.parentElement.remove()">
            <i class="fas fa-times"></i>
        </button>
    `;
    document.body.appendChild(container);
    
    if (duration > 0) {
        setTimeout(() => container.remove(), duration);
    }
}


// Submit filter form and update map with better error handling
function submitFilterForm() {
    try {
        const form = document.getElementById('map-filter-form');
        if (!form) {
            console.warn('Map filter form not found');
            return;
        }

        const formData = new FormData(form);
        const params = new URLSearchParams(formData);
        
        // Log which filters are being applied
        console.log('Active filters:', Object.fromEntries(params));

        // Update map with new filters and ensure markers are refreshed
        if (window.mapView && typeof window.mapView.updateFilters === 'function') {
            // Get current map state
            const currentState = {
                zoom: window.mapView.getZoom?.()
            };

            // Force a complete refresh of map markers
            window.mapView.updateFilters(Object.fromEntries(params), true);

            // Log the current state
            console.log('Map state:', {
                totalMarkers: window.mapView.getMarkersCount?.() || 'unknown',
                zoom: currentState.zoom,
                appliedFilters: Object.fromEntries(params)
            });
        } else {
            console.warn('MapView not ready, storing filters for later');
            window.pendingFilters = Object.fromEntries(params);
        }

        // Trigger a map refresh if needed
        if (window.mapView && typeof window.mapView.refreshMap === 'function') {
            window.mapView.refreshMap();
        }
    } catch (error) {
        console.error('Error submitting filter form:', error);
    }
}

// Simple global state for property list
window.propertyListState = {
    isLoading: false,
    properties: [], // Store all properties
};


    // Update property list HTML
    function updatePropertyListHTML(properties) {
        const listContainer = document.getElementById('property-list-container');
        const emptyState = document.getElementById('empty-state');
        const listCount = document.getElementById('list-count');
        const showingCount = document.getElementById('showing-count');
        const totalCount = document.getElementById('total-count');
        const headerCount = document.getElementById('property-count');

        if (!listContainer) return;

    if (properties.length === 0) {
        listContainer.innerHTML = '';
        if (emptyState) emptyState.style.display = 'block';
        if (listCount) listCount.textContent = '(0)';
        if (showingCount) showingCount.textContent = '0';
        if (totalCount) totalCount.textContent = '0';
        if (headerCount) headerCount.textContent = '0 properties';
        return;
    }

    if (emptyState) emptyState.style.display = 'none';
    
    // Create the property list wrapper
    const listWrapper = document.createElement('div');
    listWrapper.className = 'property-list-wrapper';
    listContainer.innerHTML = '';
    listContainer.appendChild(listWrapper);

    console.log('Rendering properties:', properties.length);
    
    // Sort properties by date or priority if available
    const sortedProperties = properties.sort((a, b) => {
        if (a.created_at && b.created_at) {
            return new Date(b.created_at) - new Date(a.created_at);
        }
        return 0;
    });

    const html = sortedProperties.map(property => {
        if (!property || !property.id) {
            console.warn('Invalid property data:', property);
            return '';
        }

        const isFavorite = window.mapView ? window.mapView.state.favorites.includes(property.id) : false;
        const inCompare = window.mapView ? window.mapView.state.compareList.includes(property.id) : false;
        const price = formatNumber(property.price || 0);
        const image = property.image || '/assets/images/property-placeholder.jpg';

        return `
            <div class="property-list-item" data-property-id="${property.id}">
                <div class="property-image">
                    <img src="${image}" alt="${property.title}" loading="lazy">
                    <div class="property-badges">
                        ${property.purpose ? `<span class="badge badge-primary">${property.purpose}</span>` : ''}
                        ${property.verified ? '<span class="badge badge-success">Verified</span>' : ''}
                    </div>
                </div>
                <div class="property-details">
                    <h6 class="property-title">${property.title}</h6>
                    <p class="property-location">
                        <i class="fa fa-map-marker"></i> ${property.location || property.address}
                    </p>
                    <div class="property-specs">
                        <span><i class="fa fa-bed"></i> ${property.bedrooms || 0}</span>
                        <span><i class="fa fa-bath"></i> ${property.bathrooms || 0}</span>
                        ${property.area ? `<span><i class="fa fa-home"></i> ${property.area} sq ft</span>` : ''}
                    </div>
                    <div class="property-price">
                        <strong>₹ ${price}</strong>
                    </div>
                </div>
                <div class="property-actions">
                    <button class="action-btn favorite-btn ${isFavorite ? 'active' : ''}"
                            data-property-id="${property.id}" title="${isFavorite ? 'Remove from Favorites' : 'Add to Favorites'}">
                        <i class="fa fa-heart${isFavorite ? '' : '-o'}"></i>
                    </button>
                    <button class="action-btn compare-btn ${inCompare ? 'active' : ''}"
                            data-property-id="${property.id}" title="${inCompare ? 'Remove from Compare' : 'Add to Compare'}">
                        <i class="fa fa-balance-scale"></i>
                    </button>
                    <button class="action-btn share-btn"
                            data-property-id="${property.id}" title="Share">
                        <i class="fa fa-share-alt"></i>
                    </button>
                </div>
            </div>
        `;
    }).join('');

    listContainer.innerHTML = html;

    // Update counts
    const total = properties.length;
    if (listCount) listCount.textContent = `(${total})`;
    if (showingCount) showingCount.textContent = String(total);
    if (totalCount) totalCount.textContent = String(total);
    if (headerCount) headerCount.textContent = `${total} ${total === 1 ? 'property' : 'properties'}`;

    // Add event listeners to list items
    listContainer.querySelectorAll('.property-list-item').forEach(item => {
        item.addEventListener('click', (e) => {
            if (e.target.closest('.action-btn')) {
                e.stopPropagation();
                return;
            }

            const propertyId = item.dataset.propertyId;
            const property = properties.find(p => p.id == propertyId);
            if (property && window.mapView) {
                window.mapView.selectProperty(property);
            }
        });
    });

    // Add event listeners to action buttons
    listContainer.querySelectorAll('.favorite-btn').forEach(btn => {
        btn.addEventListener('click', (e) => {
            e.stopPropagation();
            const propertyId = btn.dataset.propertyId;
            if (window.mapView && window.mapView.propertyDetails) {
                window.mapView.propertyDetails.toggleFavorite(propertyId);
            }
        });
    });

    listContainer.querySelectorAll('.compare-btn').forEach(btn => {
        btn.addEventListener('click', (e) => {
            e.stopPropagation();
            const propertyId = btn.dataset.propertyId;
            if (window.mapView && window.mapView.propertyDetails) {
                window.mapView.propertyDetails.addToCompare(propertyId);
                // Reflect state on button
                const inCompare = window.mapView.state.compareList.includes(parseInt(propertyId, 10)) || window.mapView.state.compareList.includes(propertyId);
                btn.classList.toggle('active', inCompare);
                btn.title = inCompare ? 'Remove from Compare' : 'Add to Compare';
            }
        });
    });

    // Sync favorites panel after rendering list
    try { renderFavoritesPanel(properties); } catch (err) { console.warn('renderFavoritesPanel failed', err); }
}

// Render the Favorites panel list, count, and actions
function renderFavoritesPanel(allProperties = []) {
    const favIds = (window.mapView?.state?.favorites) || [];
    const compareIds = (window.mapView?.state?.compareList) || [];

    const panel = document.getElementById('favorites-panel');
    const list = document.getElementById('favorites-list');
    const countEl = document.getElementById('favorites-count');
    const compareBtn = document.getElementById('compare-favorites');
    const clearBtn = document.getElementById('clear-favorites');
    const toggleBtn = document.getElementById('toggle-favorites');

    if (!panel || !list || !countEl) return;

    // Update count
    countEl.textContent = favIds.length;

    // Build small favorites list from current properties cache if possible
    const byId = new Map((allProperties || []).map(p => [p.id, p]));
    const itemsHtml = favIds.map(id => {
        const p = byId.get(id) || { id, title: `Property #${id}`, image: '/assets/images/property-placeholder.jpg', location: '', bedrooms: 0, bathrooms: 0, area: null, price: 0 };
        const price = (typeof p.price === 'number') ? window.mapView?.formatPrice?.(p.price) || `₹${p.price}` : (p.price || '');
        return `
            <div class="fav-item" data-property-id="${id}">
                <div class="fav-thumb">
                    <img src="${p.image || '/assets/images/property-placeholder.jpg'}" alt="${p.title}">
                </div>
                <div class="fav-meta">
                    <div class="fav-title">${p.title || 'Property'}</div>
                    ${p.location ? `<div class="fav-location"><i class="fa fa-map-marker"></i> ${p.location}</div>` : ''}
                    <div class="fav-specs">
                        <span><i class="fa fa-bed"></i> ${p.bedrooms || 0}</span>
                        <span><i class="fa fa-bath"></i> ${p.bathrooms || 0}</span>
                        ${p.area ? `<span><i class=\"fa fa-home\"></i> ${p.area} sq ft</span>` : ''}
                    </div>
                    ${price ? `<div class="fav-price">${price}</div>` : ''}
                    <div class="fav-actions">
                        <button class="btn btn-xs btn-outline-primary fav-compare ${compareIds.includes(id) ? 'active' : ''}" title="${compareIds.includes(id) ? 'Remove from Compare' : 'Add to Compare'}"><i class="fa fa-balance-scale"></i></button>
                        <button class="btn btn-xs btn-outline-danger remove-fav" title="Remove from Favorites"><i class="fa fa-trash"></i></button>
                    </div>
                </div>
            </div>
        `;
    }).join('');
    list.innerHTML = itemsHtml || '<div class="text-muted small">No favorites yet</div>';

    // Enable/disable compare button based on compare list length
    if (compareBtn) {
        const c = compareIds.length;
        compareBtn.disabled = c < 2;
        compareBtn.innerHTML = `<i class="fa fa-balance-scale"></i> Compare Selected (${c})`;
        compareBtn.onclick = (e) => {
            e.preventDefault();
            if (c >= 2) {
                // Navigate to a compare page if exists, else just notify
                window.mapView?.showNotification?.('Opening comparison...', 'info');
                const ids = compareIds.join(',');
                try { window.location.href = `/properties/compare?ids=${encodeURIComponent(ids)}`; } catch(_) {}
            }
        };
    }

    // Clear favorites
    if (clearBtn) {
        clearBtn.onclick = (e) => {
            e.preventDefault();
            if (!window.mapView) return;
            window.mapView.state.favorites = [];
            localStorage.setItem('property_favorites', '[]');
            // Update any favorite buttons
            document.querySelectorAll('.favorite-btn').forEach(btn => {
                btn.classList.remove('active');
                const i = btn.querySelector('i');
                if (i) i.className = 'fa fa-heart-o';
            });
            renderFavoritesPanel(allProperties);
            window.mapView?.showNotification?.('Cleared all favorites', 'success');
        };
    }

    // Toggle favorites panel collapse
    if (toggleBtn) {
        toggleBtn.onclick = (e) => {
            e.preventDefault();
            const content = document.getElementById('favorites-content');
            if (content) {
                content.classList.toggle('collapsed');
                const icon = toggleBtn.querySelector('i');
                if (icon) {
                    const isCollapsed = content.classList.contains('collapsed');
                    icon.className = isCollapsed ? 'fa fa-chevron-down' : 'fa fa-chevron-up';
                }
            }
        };
    }

    // Bind per-item actions
    list.querySelectorAll('.fav-item .remove-fav').forEach(btn => {
        btn.addEventListener('click', (e) => {
            e.stopPropagation();
            const id = btn.closest('.fav-item').dataset.propertyId;
            if (!window.mapView) return;
            const favs = window.mapView.state.favorites;
            const idx = favs.indexOf(parseInt(id, 10));
            const idxStr = favs.indexOf(id);
            const toRemove = idx > -1 ? idx : idxStr;
            if (toRemove > -1) favs.splice(toRemove, 1);
            localStorage.setItem('property_favorites', JSON.stringify(favs));
            renderFavoritesPanel(allProperties);
            // Reflect on list buttons
            document.querySelectorAll(`[data-property-id="${id}"].favorite-btn`).forEach(b => {
                b.classList.remove('active');
                const i = b.querySelector('i');
                if (i) i.className = 'fa fa-heart-o';
            });
        });
    });

    list.querySelectorAll('.fav-item .fav-compare').forEach(btn => {
        btn.addEventListener('click', (e) => {
            e.stopPropagation();
            const id = btn.closest('.fav-item').dataset.propertyId;
            if (window.mapView?.propertyDetails) {
                window.mapView.propertyDetails.addToCompare(id);
                const active = btn.classList.toggle('active');
                btn.title = active ? 'Remove from Compare' : 'Add to Compare';
                // Re-render to update counts
                renderFavoritesPanel(allProperties);
            }
        });
    });
}

// Initialize current location on map startup with enhanced error handling
function initializeCurrentLocation() {
    const locationInput = document.getElementById('location-search');
    
    // Check if geolocation is supported
    if (!navigator.geolocation) {
        console.warn('Geolocation is not supported by this browser');
        showLocationError('Geolocation not supported');
        return;
    }
    
    // Show loading indicator
    showLocationLoading();
    
    // Get current position with options
    const options = {
        enableHighAccuracy: true,
        timeout: 15000, // Increased timeout
        maximumAge: 300000 // 5 minutes cache
    };
    
    navigator.geolocation.getCurrentPosition(
        function(position) {
            try {
                const lat = position.coords.latitude;
                const lng = position.coords.longitude;
                const accuracy = position.coords.accuracy;
                
                console.log('Current location detected:', lat, lng, 'accuracy:', accuracy + 'm');
                
                // Validate coordinates
                if (!isValidCoordinate(lat, lng)) {
                    throw new Error('Invalid coordinates received');
                }
                
                // Store current location globally for map initialization
                window.currentUserLocation = {
                    lat: lat,
                    lng: lng,
                    accuracy: accuracy
                };
                
                // Hide loading indicator
                hideLocationLoading();
                
                // Reverse geocode to get address name with error handling
                reverseGeocode(lat, lng, function(address) {
                    if (locationInput && address) {
                        locationInput.value = address;
                        locationInput.placeholder = address;
                    }
                }, function(error) {
                    console.warn('Reverse geocoding failed:', error);
                });
                
                // Initialize map with current location if map is ready
                if (window.mapView && window.mapView.setCenter) {
                    window.mapView.setCenter(lat, lng);
                    window.mapView.setZoom(12); // Zoom to neighborhood level
                } else {
                    // Store for later use when map initializes
                    window.initialMapCenter = { lat: lat, lng: lng, zoom: 12 };
            }
            
            // Auto-submit filters to load nearby properties
            setTimeout(() => {
                submitFilterForm();
            }, 1000);
            } catch (error) {
                console.error('Error processing location:', error);
                hideLocationLoading();
                showLocationError('Failed to process location data');
            }
        },
        function(error) {
            console.warn('Geolocation error:', error.message);
            hideLocationLoading();
            
            let errorMessage = 'Unable to get your location';
            switch(error.code) {
                case error.PERMISSION_DENIED:
                    errorMessage = 'Location access denied by user';
                    break;
                case error.POSITION_UNAVAILABLE:
                    errorMessage = 'Location information unavailable';
                    break;
                case error.TIMEOUT:
                    errorMessage = 'Location request timed out';
                    break;
            }
            
            showLocationError(errorMessage);
        },
        options
    );
}

// Helper functions for location handling
function isValidCoordinate(lat, lng) {
    return !isNaN(lat) && !isNaN(lng) && 
           lat >= -90 && lat <= 90 && 
           lng >= -180 && lng <= 180;
}

function showLocationLoading() {
    const gpsBtn = document.querySelector('.gps-btn');
    if (gpsBtn) {
        gpsBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i>';
        gpsBtn.disabled = true;
    }
}

function hideLocationLoading() {
    const gpsBtn = document.querySelector('.gps-btn');
    if (gpsBtn) {
        gpsBtn.innerHTML = '<i class="fa fa-location-arrow"></i>';
        gpsBtn.disabled = false;
    }
}

function showLocationError(message) {
    console.error('Location Error:', message);
    // You can add toast notification here if needed
    const gpsBtn = document.querySelector('.gps-btn');
    if (gpsBtn) {
        gpsBtn.style.color = '#dc3545';
        setTimeout(() => {
            gpsBtn.style.color = '';
        }, 3000);
    }
}

// Enhanced reverse geocoding function with error handling
function reverseGeocode(lat, lng, successCallback, errorCallback) {
    // Use Google Maps Geocoding API if available
    if (window.google && window.google.maps && window.google.maps.Geocoder) {
        const geocoder = new google.maps.Geocoder();
        const latlng = { lat: lat, lng: lng };
        
        geocoder.geocode({ location: latlng }, function(results, status) {
            if (status === 'OK' && results[0]) {
                // Get the most relevant address component
                const address = results[0].formatted_address;
                if (successCallback) successCallback(address);
            } else {
                console.warn('Geocoding failed:', status);
                if (errorCallback) errorCallback('Geocoding failed: ' + status);
            }
        });
    } else {
        // Fallback to a simple coordinate display
        const fallbackAddress = `${lat.toFixed(4)}, ${lng.toFixed(4)}`;
        if (successCallback) successCallback(fallbackAddress);
    }
}

// Map initialization manager - handles clean setup and prevents reload issues
class MapInitializer {
    constructor() {
        this.isInitialized = false;
        this.isInitializing = false;
        this.initPromise = null;
        this.retryCount = 0;
        this.maxRetries = 2;
        this.modules = [];
        this.mapView = null;
    }

    async loadScript(src) {
        return new Promise((resolve, reject) => {
            // Check if script already exists
            const existing = document.querySelector(`script[src="${src}"]`);
            if (existing) {
                if (existing.dataset.loaded === 'true') {
                    resolve();
                    return;
                }
                existing.addEventListener('load', resolve);
                existing.addEventListener('error', reject);
                return;
            }

            const script = document.createElement('script');
            script.src = src;
            script.onload = () => {
                script.dataset.loaded = 'true';
                resolve();
            };
            script.onerror = () => reject(new Error(`Failed to load script: ${src}`));
            document.head.appendChild(script);
        });
    }

    async loadModules() {
        const moduleScripts = [
            "<?php echo e(asset('assets/js/map-view/map-utils.js')); ?>",
            "<?php echo e(asset('assets/js/map-view/map-filters.js')); ?>",
            "<?php echo e(asset('assets/js/map-view/map-markers.js')); ?>",
            "<?php echo e(asset('assets/js/map-view/map-interactions.js')); ?>",
            "<?php echo e(asset('assets/js/map-view/property-details.js')); ?>",
            "<?php echo e(asset('assets/js/map-view/map-core.js')); ?>"
        ];

        try {
            for (const src of moduleScripts) {
                await this.loadScript(src);
            }
            console.log('All map modules loaded successfully');
        } catch (error) {
            console.error('Error loading map modules:', error);
            throw new Error('Failed to load required map modules');
        }
    }

    async waitForGoogleMaps(timeout = 15000) {
        const startTime = Date.now();
        
        while (!window.google?.maps?.Map) {
            if (Date.now() - startTime > timeout) {
                throw new Error('Google Maps API failed to load within timeout');
            }
            await new Promise(resolve => setTimeout(resolve, 100));
        }
        
        // Ensure required libraries are loaded
        const requiredLibs = ['drawing', 'geometry'];
        for (const lib of requiredLibs) {
            while (!window.google.maps[lib]) {
                if (Date.now() - startTime > timeout) {
                    console.warn(`Google Maps ${lib} library not loaded, continuing anyway`);
                    break;
                }
                await new Promise(resolve => setTimeout(resolve, 100));
            }
        }
    }

    showLoadingState(message = 'Initializing map...') {
        const overlay = document.getElementById('map-loading');
        if (overlay) {
            overlay.style.display = 'flex';
            const p = overlay.querySelector('p');
            if (p) p.textContent = message;
            
            // Add progress indicator
            if (!overlay.querySelector('.progress-bar')) {
                const progress = document.createElement('div');
                progress.className = 'progress-bar';
                progress.innerHTML = `
                    <div class="progress-indicator"></div>
                `;
                overlay.appendChild(progress);
            }
        }

        // Add loading class to body for global loading state
        document.body.classList.add('map-loading');
    }

    showErrorState(error, canRetry = true) {
        const container = document.getElementById('advanced-map');
        if (!container) return;

        let errorMessage = 'Failed to initialize map';
        if (error.message.includes('Google Maps API')) {
            errorMessage = 'Google Maps failed to load. Please check your internet connection and try again.';
        } else if (error.message.includes('modules')) {
            errorMessage = 'Map components failed to load. Please refresh the page and try again.';
        } else if (error.message.includes('timeout')) {
            errorMessage = 'Map loading timed out. Please check your connection and try again.';
        } else if (error.message.includes('MapView')) {
            errorMessage = 'Map system unavailable. Please refresh the page.';
        }

        container.innerHTML = `
            <div class="map-error-state" style="
                display: flex;
                align-items: center;
                justify-content: center;
                height: 100%;
                min-height: 400px;
                background: #f8f9fa;
                border: 2px dashed #dee2e6;
                border-radius: 8px;
                text-align: center;
                padding: 40px;
            ">
                <div>
                    <div style="font-size: 48px; color: #dc3545; margin-bottom: 20px;">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                    <h4 style="color: #495057; margin-bottom: 12px;">Map Unavailable</h4>
                    <p style="color: #6c757d; margin-bottom: 24px; max-width: 400px;">
                        ${errorMessage}
                    </p>
                    <div>
                        <button class="btn btn-primary me-2" onclick="window.location.reload()">
                            <i class="fa fa-refresh"></i> Refresh Page
                        </button>
                        <a href="<?php echo e(url('properties')); ?>" class="btn btn-outline-secondary">
                            <i class="fa fa-list"></i> View Properties List
                        </a>
                    </div>
                    <details style="margin-top: 20px; text-align: left;">
                        <summary style="cursor: pointer; color: #6c757d;">Technical Details</summary>
                        <pre style="
                            background: #f1f3f4;
                            padding: 12px;
                            border-radius: 4px;
                            font-size: 12px;
                            margin-top: 8px;
                            overflow-x: auto;
                            white-space: pre-wrap;
                        ">${error.stack || error.message}</pre>
                    </details>
                </div>
            </div>
        `;
    }

    async initialize() {
        // Prevent multiple simultaneous initializations
        if (this.isInitialized) {
            return this.initPromise;
        }
        if (this.isInitializing) {
            // Wait for the ongoing initialization
            return this.initPromise;
        }
        this.isInitializing = true;
        this.initPromise = this._doInitialize()
            .then(() => {
                this.isInitialized = true;
                this.isInitializing = false;
                return true;
            })
            .catch((err) => {
                this.isInitialized = false;
                this.isInitializing = false;
                this.initPromise = null;
                throw err;
            });
        return this.initPromise;
    }

    async _doInitialize() {
        try {
            this.showLoadingState();

            // Step 1: Load all required modules
            await this.loadModules();

            // Step 2: Wait for Google Maps API
            await this.waitForGoogleMaps();

            // Step 3: Try to get current location first (with timeout)
            await this.waitForCurrentLocation();

            // Step 4: Verify MapView class is available
            if (typeof MapView === 'undefined') {
                throw new Error('MapView class not available after loading modules');
            }

            // Step 5: Initialize MapView with enhanced configuration
            // Use current location if available, otherwise fallback to default
            const mapCenter = window.currentUserLocation || window.initialMapCenter || { lat: 20.5937, lng: 78.9629 };
            const mapZoom = window.currentUserLocation ? 12 : (window.initialMapCenter ? window.initialMapCenter.zoom : 6);
            
            this.mapInstance = new MapView({
                maxMarkersPerLoad: 1000, // Increase max markers limit
                clusterMarkers: true, // Enable clustering for better performance
                loadAllMarkers: true, // Force loading all markers
                mapContainer: 'advanced-map',
                apiEndpoint: "<?php echo e(url('map/data')); ?>",
                currencySymbol: "₹",
                propertyTypes: <?php echo json_encode(\App\Type::where('status', 1)->orderby('type_name')->get(), 512) ?>,
                defaultCenter: [mapCenter.lat, mapCenter.lng],
                defaultZoom: mapZoom
            });

            // Expose globally for filter form integration
            window.mapView = this.mapInstance;

            // Step 6: Initialize the map view
            await this.mapInstance.init();

            this.isInitialized = true;
            console.log('Map initialized successfully with center:', mapCenter);
            // Hide loading overlay after successful init
            const overlay = document.getElementById('map-loading');
            if (overlay) overlay.style.display = 'none';

        } catch (error) {
            console.error('Map initialization failed:', error);
            this.showErrorState(error, this.retryCount < this.maxRetries);
            throw error;
        }
    }

    async waitForCurrentLocation() {
        return new Promise((resolve) => {
            // If location is already available, resolve immediately
            if (window.currentUserLocation) {
                console.log('Current location already available:', window.currentUserLocation);
                resolve();
                return;
            }

            // Set a timeout to not wait too long for geolocation
            const timeout = setTimeout(() => {
                console.log('Geolocation timeout - proceeding with default location');
                resolve();
            }, 8000); // 8 second timeout

            // Start geolocation if not already started
            if (!window.geolocationStarted) {
                window.geolocationStarted = true;
                this.getCurrentLocation().then(() => {
                    clearTimeout(timeout);
                    resolve();
                }).catch(() => {
                    clearTimeout(timeout);
                    resolve();
                });
            } else {
                // Check periodically if location becomes available
                const checkInterval = setInterval(() => {
                    if (window.currentUserLocation) {
                        clearInterval(checkInterval);
                        clearTimeout(timeout);
                        resolve();
                    }
                }, 500);
            }
        });
    }

    async getCurrentLocation() {
        return new Promise((resolve, reject) => {
            if (!navigator.geolocation) {
                reject(new Error('Geolocation is not supported by your browser'));
                return;
            }

            const options = {
                enableHighAccuracy: true,
                timeout: 10000,
                maximumAge: 300000
            };

            // Show loading state
            this.showLoadingState('Getting your location...');

            navigator.geolocation.getCurrentPosition(
                (position) => {
                    const { latitude, longitude } = position.coords;
                    const location = {
                        lat: latitude,
                        lng: longitude,
                        accuracy: position.coords.accuracy
                    };
                    
                    // Cache the location
                    window.currentUserLocation = location;
                    localStorage.setItem('lastKnownLocation', JSON.stringify({
                        ...location,
                        timestamp: Date.now()
                    }));
                    
                    resolve(location);
                },
                (error) => {
                    let errorMessage;
                    switch (error.code) {
                        case error.PERMISSION_DENIED:
                            errorMessage = 'Location permission denied. Please enable location services to see properties near you.';
                            break;
                        case error.POSITION_UNAVAILABLE:
                            errorMessage = 'Location information is unavailable. Please try again later.';
                            break;
                        case error.TIMEOUT:
                            errorMessage = 'Location request timed out. Please check your connection and try again.';
                            break;
                        default:
                            errorMessage = 'An unknown error occurred while getting your location.';
                    }
                    
                    // Try to use last known location from cache
                    const cachedLocation = localStorage.getItem('lastKnownLocation');
                    if (cachedLocation) {
                        const parsed = JSON.parse(cachedLocation);
                        const age = Date.now() - parsed.timestamp;
                        if (age < 86400000) { // 24 hours
                            resolve({
                                lat: parsed.lat,
                                lng: parsed.lng,
                                accuracy: parsed.accuracy,
                                fromCache: true
                            });
                            return;
                        }
                    }
                    
                    reject(new Error(errorMessage));
                },
                options
            );
        });
    }

    async retry() {
        if (this.retryCount >= this.maxRetries) {
            console.warn('Maximum retry attempts reached');
            return;
        }
        this.retryCount++;
        this.isInitialized = false;
        this.isInitializing = false;
        this.initPromise = null;
        // Clean up previous map instance if any
        if (this.mapInstance && typeof this.mapInstance.destroy === 'function') {
            try { this.mapInstance.destroy(); } catch (_) {}
        }
        this.mapInstance = null;
        console.log(`Retrying map initialization (attempt ${this.retryCount + 1})`);
        await this.initialize();
    }

    // Cleanup method for page unload
    cleanup() {
        if (this.mapView && typeof this.mapView.destroy === 'function') {
            this.mapView.destroy();
        }
        this.mapView = null;
        this.isInitialized = false;
        this.isInitializing = false;
        this.initPromise = null;
    }
}

// Create global initializer instance
window.mapInitializer = new MapInitializer();

// Google Maps callback
window.initMap = function() {
    // Always use the same promise to avoid race conditions
    window.mapInitializer.initialize().catch(error => {
        console.error('Failed to initialize map from callback:', error);
    });
};

// Initialize when DOM is ready
document.addEventListener('DOMContentLoaded', function() {
    // Small delay to ensure all resources are ready
    setTimeout(() => {
        // Only initialize if not already started by Google callback
        if (!window.mapInitializer.isInitialized && !window.mapInitializer.isInitializing) {
            window.mapInitializer.initialize().catch(error => {
                console.error('Failed to initialize map on DOM ready:', error);
            });
        }
    }, 100);
});

// Add global debug function for developers
window.getMapDebugInfo = function() {
    if (window.mapView && typeof window.mapView.getDebugInfo === 'function') {
        const debugInfo = window.mapView.getDebugInfo();
        console.log('=== MAP DEBUG INFO ===');
        console.table(debugInfo.logs.slice(-10)); // Last 10 logs
        console.log('State:', debugInfo.state);
        console.log('Performance:', debugInfo.performance);
        console.log('Total Requests:', debugInfo.requestCount);
        console.log('Total Errors:', debugInfo.errorCount);
        console.log('Elapsed Time:', debugInfo.elapsed + 'ms');
        console.log('======================');
        return debugInfo;
    } else {
        console.error('MapView not available or debug info not accessible');
        return null;
    }
};

// Performance optimizations
const MapOptimizer = {
    // Debounce helper
    debounce(func, wait) {
        let timeout;
        return function executedFunction(...args) {
            const later = () => {
                clearTimeout(timeout);
                func(...args);
            };
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
        };
    },

    // Throttle helper
    throttle(func, limit) {
        let inThrottle;
        return function executedFunction(...args) {
            if (!inThrottle) {
                func(...args);
                inThrottle = true;
                setTimeout(() => inThrottle = false, limit);
            }
        };
    },

    // Lazy load images in property cards
    initializeLazyLoading() {
        if ('IntersectionObserver' in window) {
            const imageObserver = new IntersectionObserver((entries, observer) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const img = entry.target;
                        img.src = img.dataset.src;
                        img.classList.remove('lazy');
                        observer.unobserve(img);
                    }
                });
            });

            document.querySelectorAll('img.lazy').forEach(img => {
                imageObserver.observe(img);
            });
        }
    },

    // Optimize marker creation
    optimizeMarkers(properties) {
        // Batch marker creation
        const markers = [];
        const batch = 50;
        let index = 0;

        const createBatch = () => {
            const end = Math.min(index + batch, properties.length);
            for (let i = index; i < end; i++) {
                const property = properties[i];
                if (property.lat && property.lng) {
                    markers.push(this.createMarker(property));
                }
            }
            index = end;

            if (index < properties.length) {
                requestAnimationFrame(createBatch);
            } else {
                this.finalizeMarkers(markers);
            }
        };

        requestAnimationFrame(createBatch);
    },

    // Cache map tiles
    initializeTileCache() {
        if ('caches' in window) {
            caches.open('map-tiles').then(cache => {
                // Pre-cache commonly used zoom levels
                const tilesToCache = [
                    // Add your most commonly used tile URLs here
                ];
                cache.addAll(tilesToCache);
            });
        }
    },

    // Monitor and optimize memory usage
    monitorMemoryUsage() {
        if ('performance' in window && 'memory' in window.performance) {
            setInterval(() => {
                const memory = window.performance.memory;
                if (memory.usedJSHeapSize > memory.jsHeapSizeLimit * 0.8) {
                    this.cleanupUnusedResources();
                }
            }, 30000);
        }
    },

    // Cleanup unused resources
    cleanupUnusedResources() {
        // Clear old markers
        if (window.mapView) {
            // Note: Bounds-based cleanup removed as bounds feature was disabled
            // This could be enhanced with other cleanup strategies if needed
            console.log('Map cleanup performed (bounds feature disabled)');
        }

        // Clear old property cache entries
        const state = window.propertyListState;
        if (state && state.cache) {
            const now = Date.now();
            for (const [key, value] of state.cache.entries()) {
                if (now - value.timestamp > state.refreshInterval * 2) {
                    state.cache.delete(key);
                }
            }
        }
    }
};

// Initialize optimizations
document.addEventListener('DOMContentLoaded', () => {
    MapOptimizer.initializeLazyLoading();
    MapOptimizer.initializeTileCache();
    MapOptimizer.monitorMemoryUsage();
});

// Make debug info available globally
if (typeof window !== 'undefined') {
    window.mapDebug = window.getMapDebugInfo;
    window.mapOptimizer = MapOptimizer;
}
</script>

<!-- Load Google Maps API -->
<script>
(function() {
    // Prevent multiple script injections
    if (document.querySelector('script[src*="maps.googleapis.com"]')) {
        return;
    }
    
    const script = document.createElement('script');
    script.src = 'https://maps.googleapis.com/maps/api/js?key=<?php echo e(config('services.google.maps_key')); ?>&libraries=drawing,geometry,marker&loading=async&callback=initMap';
    script.async = true;
    script.defer = true;
    script.onerror = function() {
        console.error('Failed to load Google Maps API');
        const mapContainer = document.getElementById('advanced-map');
        if (mapContainer) {
            mapContainer.innerHTML = `
                <div style="display: flex; align-items: center; justify-content: center; height: 100%; background: #f8f9fa; border: 2px dashed #dee2e6; border-radius: 8px; text-align: center; padding: 40px;">
                    <div>
                        <div style="font-size: 48px; color: #dc3545; margin-bottom: 20px;">
                            <i class="fa fa-exclamation-triangle"></i>
                        </div>
                        <h4 style="color: #495057; margin-bottom: 12px;">Google Maps API Error</h4>
                        <p style="color: #6c757d; margin-bottom: 24px; max-width: 400px;">
                            Please check that your Google Maps API key is properly configured and has the required permissions.
                        </p>
                        <button class="btn btn-primary" onclick="location.reload()">
                            <i class="fa fa-refresh"></i> Retry
                        </button>
                    </div>
                </div>
            `;
        }
        if (window.mapInitializer) {
            window.mapInitializer.showErrorState(new Error('Google Maps API failed to load'), true);
        }
    };
    document.head.appendChild(script);
})();
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('site_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/pages/property/map.blade.php ENDPATH**/ ?>